/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.command.FormatCommandAlignBottom;
import it.businesslogic.ireport.gui.command.FormatCommandAlignBottomToBand;
import it.businesslogic.ireport.gui.command.FormatCommandAlignCenter;
import it.businesslogic.ireport.gui.command.FormatCommandAlignCenterHorizontally;
import it.businesslogic.ireport.gui.command.FormatCommandAlignCenterVertically;
import it.businesslogic.ireport.gui.command.FormatCommandAlignHorizontalAxis;
import it.businesslogic.ireport.gui.command.FormatCommandAlignLeft;
import it.businesslogic.ireport.gui.command.FormatCommandAlignRight;
import it.businesslogic.ireport.gui.command.FormatCommandAlignToLeftMargin;
import it.businesslogic.ireport.gui.command.FormatCommandAlignToRightMargin;
import it.businesslogic.ireport.gui.command.FormatCommandAlignTop;
import it.businesslogic.ireport.gui.command.FormatCommandAlignTopToBand;
import it.businesslogic.ireport.gui.command.FormatCommandAlignVerticalAxis;
import it.businesslogic.ireport.gui.command.FormatCommandCenterInBackground;
import it.businesslogic.ireport.gui.command.FormatCommandCenterInBand;
import it.businesslogic.ireport.gui.command.FormatCommandCenterInBandH;
import it.businesslogic.ireport.gui.command.FormatCommandCenterInBandV;
import it.businesslogic.ireport.gui.command.FormatCommandDecreaseSpaceH;
import it.businesslogic.ireport.gui.command.FormatCommandDecreaseSpaceV;
import it.businesslogic.ireport.gui.command.FormatCommandElementMaximize;
import it.businesslogic.ireport.gui.command.FormatCommandElementMaximizeH;
import it.businesslogic.ireport.gui.command.FormatCommandElementMaximizeV;
import it.businesslogic.ireport.gui.command.FormatCommandEqualsSpaceH;
import it.businesslogic.ireport.gui.command.FormatCommandEqualsSpaceV;
import it.businesslogic.ireport.gui.command.FormatCommandIncreaseSpaceH;
import it.businesslogic.ireport.gui.command.FormatCommandIncreaseSpaceV;
import it.businesslogic.ireport.gui.command.FormatCommandJoinLeft;
import it.businesslogic.ireport.gui.command.FormatCommandJoinRight;
import it.businesslogic.ireport.gui.command.FormatCommandMoveToLeftMargin;
import it.businesslogic.ireport.gui.command.FormatCommandMoveToRightMargin;
import it.businesslogic.ireport.gui.command.FormatCommandOrganizeAsATable;
import it.businesslogic.ireport.gui.command.FormatCommandRemoveSpaceV;
import it.businesslogic.ireport.gui.command.FormatCommandSameHeight;
import it.businesslogic.ireport.gui.command.FormatCommandSameHeightMax;
import it.businesslogic.ireport.gui.command.FormatCommandSameHeightMin;
import it.businesslogic.ireport.gui.command.FormatCommandSameSize;
import it.businesslogic.ireport.gui.command.FormatCommandSameWidth;
import it.businesslogic.ireport.gui.command.FormatCommandSameWidthMax;
import it.businesslogic.ireport.gui.command.FormatCommandSameWidthMin;
import it.businesslogic.ireport.gui.command.FormatCommandShrink;
import it.businesslogic.ireport.gui.command.ICommand;
import it.businesslogic.ireport.undo.FormatElementsOperation;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class FormatCommand
implements ICommand {
    static boolean sleepUndo = false;
    private MainFrame mf = null;
    JReportFrame jrf = null;
    Vector oldSelectedElements = null;
    Enumeration e = null;
    boolean treatAllElements = false;
    ReportElement re = null;
    int operationType = 0;
    int currentElementPosition = 0;
    FormatElementsOperation undoOp = null;

    public void execute() {
        this.mf = MainFrame.getMainInstance();
        if (this.mf.getJMDIDesktopPane().getSelectedFrame() != null && this.mf.getJMDIDesktopPane().getSelectedFrame() instanceof JReportFrame) {
            this.jrf = (JReportFrame)this.mf.getJMDIDesktopPane().getSelectedFrame();
            if (this.getTreatAllElements()) {
                this.oldSelectedElements = (Vector)this.jrf.getSelectedElements().clone();
                this.jrf.setSelectedElements((Vector)this.jrf.getReport().getElements().clone());
            }
            if (!this.jrf.getSelectedElements().isEmpty() && this.preCondition()) {
                this.re = null;
                this.undoOp = new FormatElementsOperation(this.jrf, this.operationType);
                this.executeDeeper();
                this.postAction();
            }
            if (this.getTreatAllElements()) {
                this.jrf.setSelectedElements((Vector)this.oldSelectedElements.clone());
            }
        }
    }

    void executeDeeper() {
        this.resetEnumeration();
        this.preparation();
        this.resetEnumeration();
        this.processElements();
    }

    void processElements() {
        this.processElements(this.e);
    }

    void registerElements() {
        Enumeration e = this.jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            this.undoOp.addElement(e.nextElement());
        }
    }

    void processElements(Enumeration e) {
        this.currentElementPosition = -1;
        while (e.hasMoreElements()) {
            ++this.currentElementPosition;
            this.re = (ReportElement)e.nextElement();
            if (!this.getSleepUndo()) {
                this.undoOp.addElement(this.re);
            }
            this.modify();
            this.re.updateBounds();
            if (this.getSleepUndo()) continue;
            this.undoOp.captureUniqueModified(this.re);
        }
    }

    void updateElements() {
        Enumeration e = this.jrf.getSelectedElements().elements();
        while (e.hasMoreElements()) {
            try {
                this.undoOp.captureUniqueModified((ReportElement)e.nextElement());
            }
            catch (Exception exception) {}
        }
    }

    int getCurrentElementPosition() {
        return this.currentElementPosition;
    }

    void preparation() {
    }

    void modify() {
    }

    void resetEnumeration() {
        this.e = this.jrf.getSelectedElements().elements();
    }

    boolean preCondition() {
        return true;
    }

    void postAction() {
        this.jrf.getReportPanel().repaint();
        if (!sleepUndo) {
            this.jrf.addUndoOperation(this.undoOp);
            this.mf.getDocumentStructurePanel().updateDocumentStructureTree(this.jrf);
            this.jrf.getReportPanel().repaint();
        }
    }

    Vector sortYX(Enumeration enum2) {
        Vector<ReportElement> myElements = new Vector<ReportElement>();
        while (enum2.hasMoreElements()) {
            this.re = (ReportElement)enum2.nextElement();
            if (myElements.size() == 0) {
                myElements.add(this.re);
                continue;
            }
            boolean inserted = false;
            for (int i = 0; i < myElements.size(); ++i) {
                ReportElement re2 = (ReportElement)myElements.elementAt(i);
                if (this.re.getPosition().y < re2.getPosition().y) {
                    myElements.insertElementAt(this.re, i);
                    inserted = true;
                    break;
                }
                if (this.re.getPosition().y != re2.getPosition().y || this.re.getPosition().x >= re2.getPosition().x) continue;
                myElements.insertElementAt(this.re, i);
                inserted = true;
                break;
            }
            if (inserted) continue;
            myElements.addElement(this.re);
        }
        return myElements;
    }

    Vector sortXY(Enumeration enum2) {
        Vector<ReportElement> myElements = new Vector<ReportElement>();
        while (enum2.hasMoreElements()) {
            this.re = (ReportElement)enum2.nextElement();
            if (myElements.size() == 0) {
                myElements.add(this.re);
                continue;
            }
            boolean inserted = false;
            for (int i = 0; i < myElements.size(); ++i) {
                ReportElement re2 = (ReportElement)myElements.elementAt(i);
                if (this.re.getPosition().x < re2.getPosition().x) {
                    myElements.insertElementAt(this.re, i);
                    inserted = true;
                    break;
                }
                if (this.re.getPosition().x != re2.getPosition().x || this.re.getPosition().y >= re2.getPosition().y) continue;
                myElements.insertElementAt(this.re, i);
                inserted = true;
                break;
            }
            if (inserted) continue;
            myElements.addElement(this.re);
        }
        return myElements;
    }

    Vector getBandElements(Band b) {
        Vector<ReportElement> bandElements = new Vector<ReportElement>();
        Iterator i = this.jrf.getSelectedElements().iterator();
        while (i.hasNext()) {
            ReportElement re = (ReportElement)i.next();
            if (re.getBand() != b) continue;
            bandElements.add(re);
        }
        return bandElements;
    }

    Vector getBands() {
        Vector<Band> bands = new Vector<Band>();
        Iterator h = this.jrf.getSelectedElements().iterator();
        while (h.hasNext()) {
            ReportElement bandRe = (ReportElement)h.next();
            if (bands.contains(bandRe.getBand())) continue;
            bands.add(bandRe.getBand());
        }
        return bands;
    }

    public static FormatCommand getCommand(int operationType) {
        switch (operationType) {
            case 3: {
                return new FormatCommandAlignTop();
            }
            case 4: {
                return new FormatCommandAlignBottom();
            }
            case 1: {
                return new FormatCommandAlignLeft();
            }
            case 2: {
                return new FormatCommandAlignRight();
            }
            case 9: {
                return new FormatCommandAlignHorizontalAxis();
            }
            case 8: {
                return new FormatCommandAlignVerticalAxis();
            }
            case 6: {
                return new FormatCommandAlignCenterHorizontally();
            }
            case 5: {
                return new FormatCommandAlignCenterVertically();
            }
            case 7: {
                return new FormatCommandAlignCenter();
            }
            case 12: {
                return new FormatCommandSameHeight();
            }
            case 19: {
                return new FormatCommandSameHeightMax();
            }
            case 21: {
                return new FormatCommandSameHeightMin();
            }
            case 11: {
                return new FormatCommandSameWidth();
            }
            case 18: {
                return new FormatCommandSameWidthMax();
            }
            case 20: {
                return new FormatCommandSameWidthMin();
            }
            case 10: {
                return new FormatCommandSameSize();
            }
            case 14: {
                return new FormatCommandAlignTopToBand();
            }
            case 15: {
                return new FormatCommandAlignBottomToBand();
            }
            case 36: {
                return new FormatCommandAlignToLeftMargin();
            }
            case 37: {
                return new FormatCommandAlignToRightMargin();
            }
            case 38: {
                return new FormatCommandMoveToLeftMargin();
            }
            case 39: {
                return new FormatCommandMoveToRightMargin();
            }
            case 26: {
                return new FormatCommandJoinLeft();
            }
            case 27: {
                return new FormatCommandJoinRight();
            }
            case 28: {
                return new FormatCommandEqualsSpaceH();
            }
            case 32: {
                return new FormatCommandEqualsSpaceV();
            }
            case 33: {
                return new FormatCommandIncreaseSpaceV();
            }
            case 34: {
                return new FormatCommandDecreaseSpaceV();
            }
            case 30: {
                return new FormatCommandDecreaseSpaceH();
            }
            case 29: {
                return new FormatCommandIncreaseSpaceH();
            }
            case 35: {
                return new FormatCommandRemoveSpaceV();
            }
            case 40: {
                return new FormatCommandOrganizeAsATable();
            }
            case 41: {
                return new FormatCommandElementMaximize();
            }
            case 42: {
                return new FormatCommandElementMaximizeH();
            }
            case 43: {
                return new FormatCommandElementMaximizeV();
            }
            case 24: {
                return new FormatCommandCenterInBand();
            }
            case 23: {
                return new FormatCommandCenterInBandV();
            }
            case 22: {
                return new FormatCommandCenterInBandH();
            }
            case 44: {
                return new FormatCommandShrink();
            }
            case 45: {
                return new FormatCommandShrink(45);
            }
            case 25: {
                return new FormatCommandCenterInBackground();
            }
        }
        return null;
    }

    public MainFrame getMainFrame() {
        return this.mf;
    }

    void setMainFrame(MainFrame mf) {
        this.mf = mf;
    }

    void setSleepUndo(boolean bool) {
        sleepUndo = bool;
    }

    boolean getSleepUndo() {
        return sleepUndo;
    }

    void setTreatAllElements(boolean bool) {
        this.treatAllElements = bool;
    }

    boolean getTreatAllElements() {
        return this.treatAllElements;
    }
}

