/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.NumberDocument;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyVetoException;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;

public class JNumberField
extends JTextField
implements FocusListener {
    private int decimals = 2;
    private boolean integer = false;
    private double value = 0.0;
    private NumberFormat numberFormat = null;
    private boolean grouping = true;
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public JNumberField() {
        this.addFocusListener(this);
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMaximumFractionDigits(2);
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setGroupingUsed(true);
        this.setText(this.numberFormat.format(0L));
    }

    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    public int getDecimals() {
        return this.decimals;
    }

    public void setDecimals(int decimals) throws PropertyVetoException {
        this.decimals = decimals;
        if (!this.isInteger()) {
            this.numberFormat.setMaximumFractionDigits(decimals);
            this.numberFormat.setMinimumFractionDigits(decimals);
        }
        this.setText(this.numberFormat.format(this.getValue()));
    }

    public boolean isInteger() {
        return this.integer;
    }

    public void setInteger(boolean integer) throws PropertyVetoException {
        if (integer) {
            this.numberFormat.setMaximumFractionDigits(0);
            this.numberFormat.setMinimumFractionDigits(0);
        } else if (this.getDecimals() == -1) {
            this.numberFormat.setMinimumFractionDigits(1);
            this.numberFormat.setMaximumFractionDigits(100);
        } else {
            this.numberFormat.setMinimumFractionDigits(this.getDecimals());
            this.numberFormat.setMaximumFractionDigits(this.getDecimals());
        }
        this.integer = integer;
        this.setText(this.numberFormat.format(this.getValue()));
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) throws PropertyVetoException {
        this.value = value;
        this.setText(this.numberFormat.format(this.getValue()));
    }

    public void setValue(int value) throws PropertyVetoException {
        this.setValue((double)value);
    }

    public void focusGained(FocusEvent e) {
        this.numberFormat.setGroupingUsed(false);
        this.setText(this.numberFormat.format(this.value));
        this.numberFormat.setGroupingUsed(this.isGrouping());
    }

    public void focusLost(FocusEvent e) {
        try {
            double oldValue = this.value;
            this.value = this.numberFormat.parse(this.getText()).doubleValue();
            this.fireActionListenerActionPerformed(new ActionEvent(this, 0, ""));
        }
        catch (ParseException ex) {
            System.out.println("Errore");
            ex.printStackTrace();
        }
        this.setText(this.numberFormat.format(this.value));
    }

    public boolean isGrouping() {
        return this.grouping;
    }

    public void setGrouping(boolean grouping) throws PropertyVetoException {
        this.grouping = grouping;
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JNumberField.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JNumberField.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, listener);
    }

    private void fireActionListenerActionPerformed(ActionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ActionListener == null ? JNumberField.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

