/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.DocumentTreeEntry;
import it.businesslogic.ireport.gui.JMDIFrame;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalIconFactory;

public class JMDIMenuBar
extends JMenuBar
implements ComponentListener,
ActionListener {
    JButton closeButton = new JButton(MetalIconFactory.getInternalFrameCloseIcon(16));
    JButton resizeButton = null;
    JButton iconifyButton = null;
    JMDIFrame activeFrame = null;
    boolean isMaximized = false;
    int closeCount = 0;

    public JMDIMenuBar() {
        this.closeButton.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.resizeButton = new JButton(MetalIconFactory.getInternalFrameAltMaximizeIcon(16));
        this.resizeButton.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.iconifyButton = new JButton(MetalIconFactory.getInternalFrameMinimizeIcon(16));
        this.iconifyButton.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.addComponentListener(this);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (this.getParent() != null && this.closeButton != null) {
            this.closeButton.setBounds(this.getParent().getWidth() - 16 - 2, (this.getHeight() - 16) / 2, 16, 16);
        }
        if (this.getParent() != null && this.closeButton != null) {
            this.resizeButton.setBounds(this.getParent().getWidth() - 32 - 6, (this.getHeight() - 16) / 2, 16, 16);
        }
        if (this.getParent() != null && this.closeButton != null) {
            this.iconifyButton.setBounds(this.getParent().getWidth() - 48 - 6, (this.getHeight() - 16) / 2, 16, 16);
        }
    }

    public void removeFrameButtons() {
        this.isMaximized = false;
        this.activeFrame = null;
        this.closeButton.removeActionListener(this);
        this.resizeButton.removeActionListener(this);
        this.iconifyButton.removeActionListener(this);
        this.remove(this.closeButton);
        this.remove(this.resizeButton);
        this.remove(this.iconifyButton);
        this.update(this.getGraphics());
    }

    public void setMaximizedFrame(JMDIFrame jf) {
        if (jf == null) {
            this.removeFrameButtons();
        } else {
            if (!this.isMaximized) {
                this.resizeButton.addActionListener(this);
                this.iconifyButton.addActionListener(this);
                this.closeButton.addActionListener(this);
                this.add(this.iconifyButton);
                this.add(this.resizeButton);
                this.add(this.closeButton);
                this.restoreButtonsPosition();
                this.update(this.getGraphics());
            }
            this.activeFrame = jf;
            this.isMaximized = true;
        }
    }

    public JMDIFrame getMaximizedFrame() {
        return this.activeFrame;
    }

    public void componentShown(ComponentEvent e) {
    }

    public void paint(Graphics g) {
        this.componentResized(null);
        super.paint(g);
    }

    public void actionPerformed(ActionEvent e) {
        ++this.closeCount;
        if (e.getSource() == this.resizeButton) {
            if (this.activeFrame != null) {
                try {
                    this.activeFrame.setMaximum(false);
                    this.activeFrame.getDesktopPane().getDesktopManager().activateFrame(this.activeFrame);
                }
                catch (Exception ex) {}
            }
        } else if (e.getSource() == this.iconifyButton) {
            if (this.activeFrame != null) {
                try {
                    this.activeFrame.setIcon(true);
                }
                catch (Exception ex) {}
            }
        } else if (e.getSource() == this.closeButton && this.activeFrame != null) {
            if (this.activeFrame instanceof JReportFrame) {
                JReportFrame jrf = (JReportFrame)this.activeFrame;
                String message = "Would you like to save the report before exiting?";
                String caption = "Unsaved file" + (jrf.getReport().isDirty() ? " (Changed)" : " (Unchanged)");
                int ret = JOptionPane.showConfirmDialog(this, message, caption, 1);
                switch (ret) {
                    case 0: {
                        ActionEvent ae = new ActionEvent(this, 0, "");
                        MainFrame.getMainInstance().jMenuItemSaveActionPerformed(ae);
                        if (!jrf.getReport().isDirty()) break;
                        return;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
            try {
                JMDIFrame f = this.activeFrame;
                int frames = this.activeFrame.getDesktopPane().getAllFrames().length;
                f.doDefaultCloseAction();
                if (f.isClosed() && frames <= 1) {
                    this.removeFrameButtons();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void restoreButtonsPosition() {
        this.componentResized(null);
    }

    public void closeFrame(JInternalFrame frameToClose) {
        this.closeFrame(frameToClose, false);
    }

    public void closeFrame(JInternalFrame frameToClose, boolean force) {
        JMDIFrame oldActive = this.activeFrame;
        if (oldActive == frameToClose) {
            oldActive = null;
        }
        if (frameToClose != null) {
            if (frameToClose instanceof JReportFrame && !force) {
                JReportFrame jrf = (JReportFrame)frameToClose;
                MainFrame.getMainInstance().setActiveReportForm(jrf);
                String message = "Would you like to save the report " + new DocumentTreeEntry(jrf, jrf.getReport().getName()) + " before exiting?";
                String caption = "Unsaved file" + (jrf.getReport().isDirty() ? " (Changed)" : " (Unchanged)");
                int ret = JOptionPane.showConfirmDialog(this, message, caption, 1);
                switch (ret) {
                    case 0: {
                        ActionEvent ae = new ActionEvent(this, 0, "");
                        MainFrame.getMainInstance().jMenuItemSaveActionPerformed(ae);
                        if (!jrf.getReport().isDirty()) break;
                        return;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
            try {
                int frames = this.activeFrame.getDesktopPane().getAllFrames().length;
                frameToClose.doDefaultCloseAction();
                if (frameToClose.isClosed() && frames <= 1) {
                    this.removeFrameButtons();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (oldActive != null && oldActive instanceof JReportFrame) {
            MainFrame.getMainInstance().setActiveReportForm((JReportFrame)oldActive);
        }
    }
}

