/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.JRSubreportParameter;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class SubReportElement
extends ReportElement {
    private boolean isUsingCache = true;
    private Vector subreportParameters = null;
    private Vector returnValues = null;
    private String subreportExpression = "";
    private String subreportExpressionClass = "";
    private String connectionExpression = "";
    private String dataSourceExpression = "";
    private String parametersMapExpression = "";
    private boolean useConnection = false;
    public static Image img = null;

    public SubReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setKey("subreport");
        this.subreportParameters = new Vector();
        this.returnValues = new Vector();
        this.subreportExpressionClass = "java.lang.String";
        this.useConnection = false;
        if (img == null) {
            img = Misc.loadBufferedImageFromResources(new Panel(), "it/businesslogic/ireport/icons/subreportTool1.jpg");
        }
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.position.x -= 10;
        this.position.y -= 10;
        this.zoom_factor = zoom_factor;
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(this.getZoomedDim(this.position.x) - (x_shift_origin -= 10), this.getZoomedDim(this.position.y) - (y_shift_origin -= 10), this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        this.position.x += 10;
        this.position.y += 10;
        this.drawGraphicsElement(g, zoom_factor, x_shift_origin += 10, y_shift_origin += 10);
    }

    public void drawGraphicsElement(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.drawGraphicsElement(g, "Thin", zoom_factor, x_shift_origin, y_shift_origin);
        boolean correction = false;
        this.position.x -= 10;
        this.position.y -= 10;
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        if (img != null) {
            int imageWidth = img.getWidth(null);
            int imageHeight = img.getHeight(null);
            if (imageWidth <= this.width && imageHeight <= this.height) {
                Rectangle destination = new Rectangle(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(imageWidth), this.getZoomedDim(imageHeight - 1));
                Rectangle source = new Rectangle(0, 0, imageWidth, imageHeight);
                int elem_height = this.getZoomedDim(this.height);
                elem_height -= this.getZoomedDim(imageHeight);
                int elem_width = this.getZoomedDim(this.width);
                elem_width -= this.getZoomedDim(imageWidth);
                g.drawImage(img, destination.x, destination.y, destination.x + destination.width, destination.y + destination.height, source.x, source.y, source.width, source.height, null, null);
            } else if (this.width > 0 && this.height > 0) {
                if ((double)imageWidth / (double)this.width > (double)imageHeight / (double)this.height) {
                    Rectangle source = new Rectangle(0, 0, imageWidth, imageHeight);
                    Rectangle destination = new Rectangle(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width), this.getZoomedDim(Math.min(imageHeight * this.width / imageWidth, this.height - 1)));
                    int elem_height = this.getZoomedDim(this.height);
                    elem_height -= this.getZoomedDim(Math.min(imageHeight * this.width / imageWidth, this.height));
                    g.drawImage(img, destination.x, destination.y, destination.x + destination.width, destination.y + destination.height, source.x, source.y, source.width, source.height, null, null);
                } else {
                    Rectangle source = new Rectangle(0, 0, imageWidth, imageHeight);
                    Rectangle destination = new Rectangle(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(Math.min(imageWidth * this.height / imageHeight, this.width)), this.getZoomedDim(this.height - 1));
                    int elem_width = this.getZoomedDim(this.width);
                    elem_width -= this.getZoomedDim(Math.min(imageWidth * this.height / imageHeight, this.width));
                    g.drawImage(img, destination.x, destination.y, destination.x + destination.width, destination.y + destination.height, source.x, source.y, source.width, source.height, null, null);
                }
            }
        }
        this.position.x += 10;
        this.position.y += 10;
    }

    public String getConnectionExpression() {
        return this.connectionExpression;
    }

    public void setConnectionExpression(String connectionExpression) {
        this.connectionExpression = connectionExpression;
    }

    public String getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    public void setDataSourceExpression(String dataSourceExpression) {
        this.dataSourceExpression = dataSourceExpression;
    }

    public boolean isIsUsingCache() {
        return this.isUsingCache;
    }

    public void setIsUsingCache(boolean isUsingCache) {
        this.isUsingCache = isUsingCache;
    }

    public String getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public void setParametersMapExpression(String parametersMapExpression) {
        this.parametersMapExpression = parametersMapExpression;
    }

    public String getSubreportExpression() {
        return this.subreportExpression;
    }

    public void setSubreportExpression(String subreportExpression) {
        this.subreportExpression = subreportExpression;
    }

    public String getSubreportExpressionClass() {
        return this.subreportExpressionClass;
    }

    public void setSubreportExpressionClass(String subreportExpressionClass) {
        this.subreportExpressionClass = subreportExpressionClass;
    }

    public Vector getSubreportParameters() {
        return this.subreportParameters;
    }

    public void setSubreportParameters(Vector subreportParameters) {
        this.subreportParameters = subreportParameters;
    }

    public boolean isUseConnection() {
        return this.useConnection;
    }

    public void setUseConnection(boolean useConnection) {
        this.useConnection = useConnection;
    }

    public ReportElement cloneMe() {
        SubReportElement newReportElement = new SubReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof SubReportElement && source instanceof SubReportElement) {
            ((SubReportElement)destination).setIsUsingCache(((SubReportElement)source).isIsUsingCache());
            ((SubReportElement)destination).setParametersMapExpression(new String(((SubReportElement)source).getParametersMapExpression()));
            ((SubReportElement)destination).setSubreportExpression(new String(((SubReportElement)source).getSubreportExpression()));
            ((SubReportElement)destination).setSubreportExpressionClass(new String(((SubReportElement)source).getSubreportExpressionClass()));
            ((SubReportElement)destination).setUseConnection(((SubReportElement)source).isUseConnection());
            if (((SubReportElement)destination).isUseConnection()) {
                ((SubReportElement)destination).setConnectionExpression(new String(((SubReportElement)source).getConnectionExpression()));
            } else {
                ((SubReportElement)destination).setDataSourceExpression(new String(((SubReportElement)source).getDataSourceExpression()));
            }
            Enumeration e = ((SubReportElement)source).getSubreportParameters().elements();
            while (e.hasMoreElements()) {
                JRSubreportParameter jp = (JRSubreportParameter)e.nextElement();
                ((SubReportElement)destination).getSubreportParameters().addElement(jp.cloneMe());
            }
        }
    }

    public Vector getReturnValues() {
        return this.returnValues;
    }

    public void setReturnValues(Vector returnValues) {
        this.returnValues = returnValues;
    }
}

