/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public abstract class JRXlsAbstractExporter
extends JRAbstractExporter {
    protected int pageHeight = 0;
    protected JRFont defaultFont = null;
    protected List loadedFonts = new ArrayList();
    protected boolean isOnePagePerSheet = false;
    protected boolean isRemoveEmptySpace = false;
    protected boolean isWhitePageBackground = true;
    protected boolean isAutoDetectCellType = true;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected JRExportProgressMonitor progressMonitor = null;
    protected int reportIndex = 0;
    protected Map fontMap = null;
    private int skippedRows = 0;

    protected JRFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRBaseFont();
            }
        }
        return this.defaultFont;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportReport() throws JRException {
        block11: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            this.setClassLoader();
            this.setInput();
            if (!this.isModeBatch) {
                this.setPageRange();
            }
            this.setParameters();
            OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
            if (os != null) {
                this.exportReportToStream(os);
            } else {
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName == null) throw new JRException("No output specified for the exporter.");
                    destFile = new File(fileName);
                }
                try {
                    try {
                        os = new FileOutputStream(destFile);
                        this.exportReportToStream(os);
                        os.flush();
                    }
                    catch (IOException e) {
                        throw new JRException("Error trying to export to file : " + destFile, e);
                    }
                    Object var5_5 = null;
                    if (os == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (os == null) throw throwable;
                    try {
                        os.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                os.close();
            }
        }
        this.resetClassLoader();
    }

    protected void setParameters() {
        Boolean isAutoDetectCellTypeParameter;
        Boolean isWhitePageBackgroundParameter;
        Boolean isRemoveEmptySpaceParameter;
        Boolean isOnePagePerSheetParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET);
        if (isOnePagePerSheetParameter != null) {
            this.isOnePagePerSheet = isOnePagePerSheetParameter;
        }
        if ((isRemoveEmptySpaceParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS)) != null) {
            this.isRemoveEmptySpace = isRemoveEmptySpaceParameter;
        }
        if ((isWhitePageBackgroundParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND)) != null) {
            this.isWhitePageBackground = isWhitePageBackgroundParameter;
            this.setBackground();
        }
        if ((isAutoDetectCellTypeParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_AUTO_DETECT_CELL_TYPE)) != null) {
            this.isAutoDetectCellType = isAutoDetectCellTypeParameter;
        }
        this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
    }

    protected abstract void setBackground();

    protected void exportReportToStream(OutputStream os) throws JRException {
        this.openWorkbook(os);
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            this.defaultFont = null;
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                if (this.isOnePagePerSheet) {
                    this.pageHeight = this.jasperPrint.getPageHeight();
                    for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
                        this.createSheet("Page " + (pageIndex + 1));
                        this.exportPage(null, page);
                    }
                } else {
                    this.pageHeight = this.jasperPrint.getPageHeight() * (this.endPageIndex - this.startPageIndex + 1);
                    ArrayList<Integer> alterYs = new ArrayList<Integer>();
                    JRBasePrintPage allPages = new JRBasePrintPage();
                    List elements = null;
                    JRPrintElement element = null;
                    for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
                        elements = page.getElements();
                        if (elements == null || elements.size() <= 0) continue;
                        Iterator it = elements.iterator();
                        while (it.hasNext()) {
                            element = (JRPrintElement)it.next();
                            allPages.addElement(element);
                            alterYs.add(new Integer(element.getY() + this.jasperPrint.getPageHeight() * pageIndex));
                        }
                    }
                    this.createSheet(this.jasperPrint.getName());
                    this.exportPage(alterYs, allPages);
                }
            }
            ++this.reportIndex;
        }
        this.closeWorkbook(os);
    }

    protected void exportPage(List alterYs, JRPrintPage page) throws JRException {
        JRGridLayout layout = new JRGridLayout(page.getElements(), alterYs, this.jasperPrint.getPageWidth(), this.pageHeight, this.globalOffsetX, this.globalOffsetY, this.getExporterElements(), true, true, false, null);
        JRExporterGridCell[][] grid = layout.getGrid();
        boolean[] isRowNotEmpty = layout.getIsRowNotEmpty();
        List xCuts = layout.getXCuts();
        int width = 0;
        for (int i = 1; i < xCuts.size(); ++i) {
            width = (Integer)xCuts.get(i) - (Integer)xCuts.get(i - 1);
            this.setColumnWidth((short)(i - 1), (short)(width * 43));
        }
        this.skippedRows = 0;
        for (int y = 0; y < grid.length; ++y) {
            int rowIndex = y - this.skippedRows;
            if (isRowNotEmpty[y] || !this.isRemoveEmptySpace) {
                int emptyCellColSpan = 0;
                int emptyCellWidth = 0;
                int lastRowHeight = JRGridLayout.getRowHeight(grid, y);
                this.setRowHeight(rowIndex, lastRowHeight);
                for (int x = 0; x < grid[y].length; ++x) {
                    this.setCell(x, rowIndex);
                    if (grid[y][x].element != null) {
                        JRPrintElement element;
                        if (emptyCellColSpan > 0) {
                            if (emptyCellColSpan > 1) {
                                // empty if block
                            }
                            emptyCellColSpan = 0;
                            emptyCellWidth = 0;
                        }
                        if ((element = grid[y][x].element) instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)element, grid[y][x], x, rowIndex);
                        } else if (element instanceof JRPrintRectangle) {
                            this.exportRectangle(element, grid[y][x], x, rowIndex);
                        } else if (element instanceof JRPrintEllipse) {
                            this.exportRectangle(element, grid[y][x], x, rowIndex);
                        } else if (element instanceof JRPrintImage) {
                            this.exportImage((JRPrintImage)element, grid[y][x], x, rowIndex);
                        } else if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, grid[y][x], x, rowIndex);
                        } else if (element instanceof JRPrintFrame) {
                            this.exportFrame((JRPrintFrame)element, grid[y][x], x, y);
                        }
                        x += grid[y][x].colSpan - 1;
                        continue;
                    }
                    ++emptyCellColSpan;
                    emptyCellWidth += grid[y][x].width;
                    this.addBlankCell(grid[y][x], x, rowIndex);
                }
                if (emptyCellColSpan > 0 && emptyCellColSpan <= 1) continue;
            }
            ++this.skippedRows;
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(null, text);
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(null, 0, text.length()));
            }
        }
        return styledText;
    }

    protected static TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        short horizontalAlignment;
        short verticalAlignment;
        short rotation = textElement.getRotation();
        block0 : switch (textElement.getRotation()) {
            case 1: {
                switch (textElement.getHorizontalAlignment()) {
                    case 1: {
                        verticalAlignment = 3;
                        break;
                    }
                    case 2: {
                        verticalAlignment = 2;
                        break;
                    }
                    case 3: {
                        verticalAlignment = 1;
                        break;
                    }
                    case 4: {
                        verticalAlignment = 4;
                        break;
                    }
                    default: {
                        verticalAlignment = 3;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        horizontalAlignment = 1;
                        break block0;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break block0;
                    }
                    case 3: {
                        horizontalAlignment = 3;
                        break block0;
                    }
                }
                horizontalAlignment = 1;
                break;
            }
            case 2: {
                switch (textElement.getHorizontalAlignment()) {
                    case 1: {
                        verticalAlignment = 1;
                        break;
                    }
                    case 2: {
                        verticalAlignment = 2;
                        break;
                    }
                    case 3: {
                        verticalAlignment = 3;
                        break;
                    }
                    case 4: {
                        verticalAlignment = 4;
                        break;
                    }
                    default: {
                        verticalAlignment = 1;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        horizontalAlignment = 3;
                        break block0;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break block0;
                    }
                    case 3: {
                        horizontalAlignment = 1;
                        break block0;
                    }
                }
                horizontalAlignment = 3;
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalAlignment();
                verticalAlignment = textElement.getVerticalAlignment();
            }
        }
        return new TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    protected abstract JRGridLayout.ExporterElements getExporterElements();

    protected abstract void openWorkbook(OutputStream var1) throws JRException;

    protected abstract void createSheet(String var1);

    protected abstract void closeWorkbook(OutputStream var1) throws JRException;

    protected abstract void setColumnWidth(short var1, short var2);

    protected abstract void setRowHeight(int var1, int var2) throws JRException;

    protected abstract void setCell(int var1, int var2);

    protected abstract void addBlankCell(JRExporterGridCell var1, int var2, int var3) throws JRException;

    protected abstract void exportText(JRPrintText var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportImage(JRPrintImage var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportRectangle(JRPrintElement var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportLine(JRPrintLine var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportFrame(JRPrintFrame var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    static class TextAlignHolder {
        final short horizontalAlignment;
        final short verticalAlignment;
        final short rotation;

        public TextAlignHolder(short horizontalAlignment, short verticalAlignment, short rotation) {
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
        }
    }
}

