/*
 * FormatCommandIncreaseSpaceH.java
 *
 * Created on 9 mei 2005, 21:36
 * Original code: Giulio
 * Redesigned code: Robert Lamping
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;


/**
 *
 *
 */
public class FormatCommandIncreaseSpaceH extends FormatCommand {
    {
        operationType = OperationType.INCREASE_SPACE_H;
    }
    
    boolean preCondition(){
        return ( jrf.getSelectedElements().size() > 1);
    }
    
    void executeDeeper(){
        Vector bands = getBands();  // bands with selected elements
        for (Iterator h = bands.iterator(); h.hasNext(); ) {
            Band b = (Band) h.next();
            Vector bandElements = getBandElements( b );
            bandElements = sortXY( bandElements.elements());
            // first element in each band will not be moved.
            bandElements.remove(0);
            processElements(bandElements.elements());
        }
    }
    
    public void modify() {
        // first element is the second in the band 
        re.setPosition(new Point(re.getPosition().x+5*(getCurrentElementPosition()+1), re.getPosition().y) );
    }
    
}
