/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizer;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFileVirtualizer
implements JRVirtualizer {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRBaseFiller == null ? (class$net$sf$jasperreports$engine$fill$JRBaseFiller = JRFileVirtualizer.class$("net.sf.jasperreports.engine.fill.JRBaseFiller")) : class$net$sf$jasperreports$engine$fill$JRBaseFiller));
    private final Cache pagedIn;
    private final HashMap pagedOut;
    private final String directory;
    private JRVirtualizable lastObject;
    private boolean readOnly;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRBaseFiller;

    public JRFileVirtualizer(int maxSize) {
        this(maxSize, null);
    }

    public JRFileVirtualizer(int maxSize, String directory) {
        this.pagedIn = new Cache(maxSize, this);
        this.pagedOut = new HashMap();
        this.directory = directory;
        this.lastObject = null;
        this.readOnly = false;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void registerObject(JRVirtualizable o) {
        Object old = this.pagedIn.put(o.getUID(), o);
        if (old != null) {
            this.pagedIn.put(o.getUID(), old);
            throw new IllegalStateException("Wrong object stored with UID \"" + o.getUID() + "\"");
        }
        this.lastObject = o;
    }

    public void deregisterObject(JRVirtualizable o) {
        String uid = o.getUID();
        Object old = this.pagedIn.remove(uid);
        if (old != null) {
            if (old != o) {
                this.pagedIn.put(uid, old);
                throw new IllegalStateException("Wrong object stored with UID \"" + o.getUID() + "\"");
            }
        } else {
            old = this.pagedOut.remove(uid);
            if (old != o) {
                this.pagedIn.put(uid, old);
                throw new IllegalStateException("Wrong object stored with UID \"" + o.getUID() + "\"");
            }
        }
    }

    public void touch(JRVirtualizable o) {
        if (this.lastObject != o) {
            this.lastObject = (JRVirtualizable)this.pagedIn.get(o.getUID());
        }
    }

    public void requestData(JRVirtualizable o) {
        String uid = o.getUID();
        if (this.pagedOut.containsKey(uid)) {
            try {
                this.filePageIn(o);
            }
            catch (IOException ioe) {
                throw new JRRuntimeException(ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new JRRuntimeException(cnfe);
            }
            this.pagedOut.remove(uid);
            this.pagedIn.put(uid, o);
            this.lastObject = o;
        }
    }

    public void clearData(JRVirtualizable o) {
        String uid = o.getUID();
        if (this.pagedOut.containsKey(uid)) {
            this.fileDispose(o);
            this.pagedOut.remove(uid);
        }
    }

    public void virtualizeData(JRVirtualizable o) {
        String uid = o.getUID();
        if (!this.pagedOut.containsKey(uid)) {
            try {
                this.filePageOut(o);
            }
            catch (IOException ioe) {
                throw new JRRuntimeException(ioe);
            }
            this.pagedOut.put(uid, o);
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    private String makeFilename(JRVirtualizable o) {
        String uid = o.getUID();
        return "virt" + uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filePageOut(JRVirtualizable o) throws IOException {
        String filename = this.makeFilename(o);
        File file = new File(this.directory, filename);
        if (file.createNewFile()) {
            file.deleteOnExit();
            ObjectOutputStream oos = null;
            try {
                FileOutputStream fos = new FileOutputStream(file);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(o.getIdentityData());
                oos.writeObject(o.getVirtualData());
                oos.flush();
            }
            finally {
                if (oos != null) {
                    oos.close();
                }
            }
        } else if (!this.readOnly) {
            throw new IllegalStateException("Cannot virtualize data because the file \"" + filename + "\" already exists.");
        }
        o.removeVirtualData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filePageIn(JRVirtualizable o) throws IOException, ClassNotFoundException {
        String filename = this.makeFilename(o);
        File file = new File(this.directory, filename);
        ObjectInputStream ois = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            o.setIdentityData(ois.readObject());
            o.setVirtualData(ois.readObject());
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
        if (!this.readOnly) {
            file.delete();
        }
    }

    private void fileDispose(JRVirtualizable o) {
        String filename = this.makeFilename(o);
        File file = new File(this.directory, filename);
        file.delete();
    }

    public void cleanup() {
        Map.Entry entry;
        Iterator it = this.pagedOut.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            try {
                this.fileDispose((JRVirtualizable)entry.getValue());
                it.remove();
            }
            catch (Exception e) {
                log.error((Object)"Error cleaning up virtualizer.", (Throwable)e);
            }
        }
        it = this.pagedIn.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            try {
                this.fileDispose((JRVirtualizable)entry.getValue());
                it.remove();
            }
            catch (Exception e) {
                log.error((Object)"Error cleaning up virtualizer.", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Cache
    extends LRUMap {
        private static final long serialVersionUID = 10101L;
        private final JRFileVirtualizer virt;

        Cache(int maxSize, JRFileVirtualizer virt) {
            super(maxSize);
            this.virt = virt;
        }

        protected void processRemovedLRU(Object key, Object value) {
            this.virt.virtualizeData((JRVirtualizable)value);
        }
    }
}

