/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public class TinyToolBarUI
extends MetalToolBarUI {
    private Border toolButtonBorder = new EmptyBorder(4, 4, 4, 4);
    private static final TinyToolBarUI toolBarUI = new TinyToolBarUI();
    private Insets insets = new Insets(2, 2, 2, 2);
    protected static Color bgColor = new Color(236, 236, 236);
    protected static Color lightBgColor = new Color(236, 236, 236);
    protected static Color darkBgColor = new Color(236, 236, 236);

    public static ComponentUI createUI(JComponent c) {
        return toolBarUI;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
    }

    public void paint(Graphics g, JComponent c) {
        g.setColor(Theme.toolBarColor[Theme.style].getColor());
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
        if (c.getBorder() == null) {
            return;
        }
        JToolBar tb = (JToolBar)c;
        if (!tb.isBorderPainted()) {
            return;
        }
        g.setColor(Theme.toolBarLightColor[Theme.style].getColor());
        g.drawLine(0, 0, c.getWidth() - 1, 0);
        g.setColor(Theme.toolBarDarkColor[Theme.style].getColor());
        g.drawLine(0, c.getHeight() - 1, c.getWidth() - 1, c.getHeight() - 1);
    }

    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            b.setBorder(this.toolButtonBorder);
            b.putClientProperty("JToolBar.isToolbarButton", Boolean.TRUE);
        }
    }

    protected void setBorderToNormal(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            b.setBorder(this.toolButtonBorder);
            b.putClientProperty("JToolBar.isToolbarButton", Boolean.TRUE);
        }
    }
}

