/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Vector;
import org.hsqldb.Channel;
import org.hsqldb.Column;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.Function;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;

class Parser {
    private Database dDatabase;
    private Tokenizer tTokenizer;
    private Channel cChannel;
    private String sTable;
    private String sToken;
    private Object oData;
    private int iType;
    private int iToken;

    Parser(Database database, Tokenizer tokenizer, Channel channel) {
        this.dDatabase = database;
        this.tTokenizer = tokenizer;
        this.cChannel = channel;
    }

    Result processSelect() throws SQLException {
        Select select = this.parseSelect();
        if (select.sIntoTable == null) {
            return select.getResult(select.limitStart, select.limitCount);
        }
        Result result = select.getResult(0);
        Table table = new Table(this.dDatabase, true, select.sIntoTable, false);
        table.addColumns(result);
        table.createPrimaryKey();
        table.insert(result, this.cChannel);
        this.dDatabase.linkTable(table);
        int n = result.getSize();
        result = new Result();
        result.iUpdateCount = n;
        return result;
    }

    Result processCall() throws SQLException {
        Expression expression = this.parseExpression();
        expression.resolve(null);
        int n = expression.getDataType();
        Object object = expression.getValue();
        Result result = new Result(1);
        result.sTable[0] = "";
        result.iType[0] = n;
        result.sLabel[0] = "";
        result.sName[0] = "";
        Object[] objectArray = new Object[]{object};
        result.add(objectArray);
        return result;
    }

    Result processUpdate() throws SQLException {
        Result result;
        Object[] objectArray;
        String string = this.tTokenizer.getString();
        this.cChannel.checkReadWrite();
        this.cChannel.check(string, 8);
        Table table = this.dDatabase.getTable(string, this.cChannel);
        TableFilter tableFilter = new TableFilter(table, null, false);
        this.tTokenizer.getThis("SET");
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        int n = 0;
        string = null;
        do {
            ++n;
            int n2 = table.getColumnNr(this.tTokenizer.getString());
            vector.addElement(new Integer(n2));
            this.tTokenizer.getThis("=");
            objectArray = this.parseExpression();
            objectArray.resolve(tableFilter);
            vector2.addElement(objectArray);
        } while ((string = this.tTokenizer.getString()).equals(","));
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
            expression.resolve(tableFilter);
            tableFilter.setCondition(expression);
        } else {
            this.tTokenizer.back();
        }
        table.fireAll(5);
        objectArray = new Expression[n];
        vector2.copyInto(objectArray);
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = (Integer)vector.elementAt(n3);
            nArray2[n3] = table.getType(nArray[n3]);
            ++n3;
        }
        int n4 = 0;
        if (tableFilter.findFirst()) {
            Object object;
            Object object2;
            result = new Result();
            Result result2 = new Result();
            int n5 = table.getColumnCount();
            do {
                if (expression != null && !expression.test()) continue;
                object2 = tableFilter.oCurrentData;
                result.add((Object[])object2);
                object = table.getNewRow();
                int n6 = 0;
                while (n6 < n5) {
                    object[n6] = object2[n6];
                    ++n6;
                }
                int n7 = 0;
                while (n7 < n) {
                    object[nArray[n7]] = ((Expression)objectArray[n7]).getValue(nArray2[n7]);
                    ++n7;
                }
                result2.add((Object[])object);
            } while (tableFilter.next());
            this.cChannel.beginNestedTransaction();
            try {
                object2 = result.rRoot;
                while (object2 != null) {
                    table.fireAll(11, object2.data);
                    table.deleteNoCheck(object2.data, this.cChannel);
                    object2 = object2.next;
                }
                object = result2.rRoot;
                while (object != null) {
                    table.insertNoCheck(object.data, this.cChannel);
                    object = object.next;
                    ++n4;
                }
                table.checkUpdate(nArray, result, result2);
                object = result2.rRoot;
                while (object != null) {
                    table.fireAll(8, object.data);
                    object = object.next;
                }
                this.cChannel.endNestedTransaction(false);
            }
            catch (SQLException sQLException) {
                this.cChannel.endNestedTransaction(true);
                throw sQLException;
            }
        }
        table.fireAll(2);
        result = new Result();
        result.iUpdateCount = n4;
        return result;
    }

    Result processDelete() throws SQLException {
        Result result;
        this.tTokenizer.getThis("FROM");
        String string = this.tTokenizer.getString();
        this.cChannel.checkReadWrite();
        this.cChannel.check(string, 2);
        Table table = this.dDatabase.getTable(string, this.cChannel);
        TableFilter tableFilter = new TableFilter(table, null, false);
        string = this.tTokenizer.getString();
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
            expression.resolve(tableFilter);
            tableFilter.setCondition(expression);
        } else {
            this.tTokenizer.back();
        }
        table.fireAll(4);
        int n = 0;
        if (tableFilter.findFirst()) {
            result = new Result();
            do {
                if (expression != null && !expression.test()) continue;
                result.add(tableFilter.oCurrentData);
            } while (tableFilter.next());
            Record record = result.rRoot;
            while (record != null) {
                table.delete(record.data, this.cChannel);
                ++n;
                record = record.next;
            }
        }
        table.fireAll(1);
        result = new Result();
        result.iUpdateCount = n;
        return result;
    }

    Result processInsert() throws SQLException {
        Object object;
        int n;
        this.tTokenizer.getThis("INTO");
        String string = this.tTokenizer.getString();
        this.cChannel.checkReadWrite();
        this.cChannel.check(string, 4);
        Table table = this.dDatabase.getTable(string, this.cChannel);
        string = this.tTokenizer.getString();
        Vector<String> vector = null;
        if (string.equals("(")) {
            block15: {
                vector = new Vector<String>();
                n = 0;
                do {
                    vector.addElement(this.tTokenizer.getString());
                    ++n;
                    string = this.tTokenizer.getString();
                    if (string.equals(")")) break block15;
                } while (string.equals(","));
                throw Trace.error(10, string);
            }
            string = this.tTokenizer.getString();
        }
        n = 0;
        int n2 = vector == null ? table.getColumnCount() : vector.size();
        if (string.equals("VALUES")) {
            block16: {
                this.tTokenizer.getThis("(");
                object = table.getNewRow();
                int n3 = 0;
                do {
                    int n4;
                    if (vector == null) {
                        n4 = n3;
                        if (n3 > n2) {
                            throw Trace.error(4);
                        }
                    } else {
                        n4 = table.getColumnNr((String)vector.elementAt(n3));
                    }
                    object[n4] = this.getValue(table.getType(n4));
                    ++n3;
                    string = this.tTokenizer.getString();
                    if (string.equals(")")) break block16;
                } while (string.equals(","));
                throw Trace.error(10, string);
            }
            table.insert((Object[])object, this.cChannel);
            n = 1;
        } else if (string.equals("SELECT")) {
            object = this.processSelect();
            Record record = ((Result)object).rRoot;
            Trace.check(n2 == ((Result)object).getColumnCount(), 4);
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            int n5 = 0;
            while (n5 < n2) {
                int n6 = vector == null ? n5 : table.getColumnNr((String)vector.elementAt(n5));
                nArray[n5] = n6;
                nArray2[n5] = table.getType(n6);
                ++n5;
            }
            this.cChannel.beginNestedTransaction();
            try {
                while (record != null) {
                    Object[] objectArray = table.getNewRow();
                    int n7 = 0;
                    while (n7 < n2) {
                        objectArray[nArray[n7]] = Column.convertObject(record.data[n7], nArray2[n7]);
                        ++n7;
                    }
                    table.insert(objectArray, this.cChannel);
                    ++n;
                    record = record.next;
                }
                this.cChannel.endNestedTransaction(false);
            }
            catch (SQLException sQLException) {
                this.cChannel.endNestedTransaction(true);
                throw sQLException;
            }
        } else {
            throw Trace.error(10, string);
        }
        object = new Result();
        ((Result)object).iUpdateCount = n;
        return object;
    }

    private Select parseSelect() throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Select select = new Select();
        select.limitStart = 0;
        select.limitCount = this.cChannel.getMaxRows();
        String string = this.tTokenizer.getString();
        if (string.equals("DISTINCT")) {
            select.bDistinct = true;
        } else if (string.equals("LIMIT")) {
            object4 = this.tTokenizer.getString();
            object3 = this.tTokenizer.getString();
            select.limitStart = new Integer((String)object4);
            select.limitCount = new Integer((String)object3);
        } else {
            this.tTokenizer.back();
        }
        object4 = new Vector();
        do {
            object3 = this.parseExpression();
            string = this.tTokenizer.getString();
            if (string.equals("AS")) {
                ((Expression)object3).setAlias(this.tTokenizer.getName());
                string = this.tTokenizer.getString();
            } else if (this.tTokenizer.wasName()) {
                ((Expression)object3).setAlias(string);
                string = this.tTokenizer.getString();
            }
            ((Vector)object4).addElement(object3);
        } while (string.equals(","));
        if (string.equals("INTO")) {
            select.sIntoTable = this.tTokenizer.getString();
            string = this.tTokenizer.getString();
        }
        if (!string.equals("FROM")) {
            throw Trace.error(10, string);
        }
        object3 = null;
        Vector<TableFilter> vector = new Vector<TableFilter>();
        vector.addElement(this.parseTableFilter(false));
        while (true) {
            if ((string = this.tTokenizer.getString()).equals("LEFT")) {
                string = this.tTokenizer.getString();
                if (string.equals("OUTER")) {
                    string = this.tTokenizer.getString();
                }
                Trace.check(string.equals("JOIN"), 10, string);
                vector.addElement(this.parseTableFilter(true));
                this.tTokenizer.getThis("ON");
                object3 = this.addCondition((Expression)object3, this.parseExpression());
                continue;
            }
            if (string.equals("INNER")) {
                this.tTokenizer.getThis("JOIN");
                vector.addElement(this.parseTableFilter(false));
                this.tTokenizer.getThis("ON");
                object3 = this.addCondition((Expression)object3, this.parseExpression());
                continue;
            }
            if (!string.equals(",")) break;
            vector.addElement(this.parseTableFilter(false));
        }
        this.tTokenizer.back();
        int n = vector.size();
        Object[] objectArray = new TableFilter[n];
        vector.copyInto(objectArray);
        select.tFilter = objectArray;
        n = ((Vector)object4).size();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            object2 = (Expression)((Vector)object4).elementAt(n2);
            if (((Expression)object2).getType() == 6) {
                n3 = n2;
                Table table = null;
                object = ((Expression)object2).getTableName();
                int n4 = 0;
                while (n4 < objectArray.length) {
                    Object object5 = objectArray[n4];
                    ((Expression)object2).resolve((TableFilter)object5);
                    if (object == null || ((String)object).equals(((TableFilter)object5).getName())) {
                        table = ((TableFilter)object5).getTable();
                        int n5 = table.getColumnCount();
                        int n6 = 0;
                        while (n6 < n5) {
                            Expression expression = new Expression(((TableFilter)object5).getName(), table.getColumnName(n6));
                            ((Vector)object4).insertElementAt(expression, n3++);
                            ++n;
                            ++n6;
                        }
                    }
                    ++n4;
                }
                Trace.check(table != null, 21, (String)object);
                --n;
                ((Vector)object4).removeElementAt(n3);
            } else if (((Expression)object2).getType() == 2 && ((Expression)object2).getTableName() == null) {
                n3 = 0;
                while (n3 < objectArray.length) {
                    ((Expression)object2).resolve((TableFilter)objectArray[n3]);
                    ++n3;
                }
            }
            ++n2;
        }
        select.iResultLen = n;
        string = this.tTokenizer.getString();
        if (string.equals("WHERE")) {
            object3 = this.addCondition((Expression)object3, this.parseExpression());
            string = this.tTokenizer.getString();
        }
        select.eCondition = object3;
        if (string.equals("GROUP")) {
            this.tTokenizer.getThis("BY");
            n = 0;
            do {
                ((Vector)object4).addElement(this.parseExpression());
                string = this.tTokenizer.getString();
                ++n;
            } while (string.equals(","));
            select.iGroupLen = n;
        }
        if (string.equals("ORDER")) {
            this.tTokenizer.getThis("BY");
            n = 0;
            do {
                if (((Expression)(object2 = this.parseExpression())).getType() == 1) {
                    if (((Expression)object2).getDataType() == 4) {
                        int n7 = (Integer)((Expression)object2).getValue();
                        object2 = (Expression)((Vector)object4).elementAt(n7 - 1);
                    }
                } else if (((Expression)object2).getType() == 2 && ((Expression)object2).getTableName() == null) {
                    String string2 = ((Expression)object2).getColumnName();
                    int n8 = 0;
                    while (n8 < ((Vector)object4).size()) {
                        object = (Expression)((Vector)object4).elementAt(n8);
                        if (string2.equals(((Expression)object).getAlias())) {
                            object2 = object;
                            break;
                        }
                        ++n8;
                    }
                }
                if ((string = this.tTokenizer.getString()).equals("DESC")) {
                    ((Expression)object2).setDescending();
                    string = this.tTokenizer.getString();
                } else if (string.equals("ASC")) {
                    string = this.tTokenizer.getString();
                }
                ((Vector)object4).addElement(object2);
                ++n;
            } while (string.equals(","));
            select.iOrderLen = n;
        }
        n = ((Vector)object4).size();
        select.eColumn = new Expression[n];
        ((Vector)object4).copyInto(select.eColumn);
        if (string.equals("UNION")) {
            string = this.tTokenizer.getString();
            if (string.equals("ALL")) {
                select.iUnionType = 2;
            } else {
                select.iUnionType = 1;
                this.tTokenizer.back();
            }
            this.tTokenizer.getThis("SELECT");
            select.sUnion = this.parseSelect();
        } else if (string.equals("INTERSECT")) {
            this.tTokenizer.getThis("SELECT");
            select.iUnionType = 3;
            select.sUnion = this.parseSelect();
        } else if (string.equals("EXCEPT") || string.equals("MINUS")) {
            this.tTokenizer.getThis("SELECT");
            select.iUnionType = 4;
            select.sUnion = this.parseSelect();
        } else {
            this.tTokenizer.back();
        }
        return select;
    }

    private TableFilter parseTableFilter(boolean bl) throws SQLException {
        Object object;
        String string = this.tTokenizer.getString();
        Table table = null;
        if (string.equals("(")) {
            this.tTokenizer.getThis("SELECT");
            object = this.parseSelect();
            Result result = ((Select)object).getResult(0);
            table = new Table(this.dDatabase, false, "SYSTEM_SUBQUERY", false);
            this.tTokenizer.getThis(")");
            table.addColumns(result);
            table.createPrimaryKey();
            table.insert(result, this.cChannel);
        } else {
            this.cChannel.check(string, 1);
            table = this.dDatabase.getTable(string, this.cChannel);
        }
        object = null;
        string = this.tTokenizer.getString();
        if (string.equals("AS")) {
            object = this.tTokenizer.getName();
        } else if (this.tTokenizer.wasName()) {
            object = string;
        } else {
            this.tTokenizer.back();
        }
        return new TableFilter(table, (String)object, bl);
    }

    private Expression addCondition(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        return new Expression(28, expression, expression2);
    }

    private Object getValue(int n) throws SQLException {
        Expression expression = this.parseExpression();
        expression.resolve(null);
        return expression.getValue(n);
    }

    private Expression parseExpression() throws SQLException {
        this.read();
        if (this.iToken == 42 || this.iToken == 43 || this.iToken == 40 || this.iToken == 41 || this.iToken == 44) {
            int n = this.iToken;
            this.read();
            Expression expression = new Expression(n, this.readOr(), null);
            this.tTokenizer.back();
            return expression;
        }
        Expression expression = this.readOr();
        this.tTokenizer.back();
        return expression;
    }

    private Expression readOr() throws SQLException {
        Expression expression = this.readAnd();
        while (this.iToken == 29) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readAnd());
        }
        return expression;
    }

    private Expression readAnd() throws SQLException {
        Expression expression = this.readCondition();
        while (this.iToken == 28) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readCondition());
        }
        return expression;
    }

    private Expression readCondition() throws SQLException {
        if (this.iToken == 20) {
            int n = this.iToken;
            this.read();
            return new Expression(n, this.readCondition(), null);
        }
        if (this.iToken == 31) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            Trace.check(this.iToken == 103, 10);
            Expression expression = new Expression(this.parseSelect());
            this.read();
            this.readThis(102);
            return new Expression(n, expression, null);
        }
        Expression expression = this.readConcat();
        boolean bl = false;
        if (this.iToken == 20) {
            bl = true;
            this.read();
        }
        if (this.iToken == 27) {
            this.read();
            Expression expression2 = this.readConcat();
            char c = '\u0000';
            if (this.sToken.equals("ESCAPE")) {
                this.read();
                Expression expression3 = this.readTerm();
                Trace.check(expression3.getType() == 1, 6);
                String string = (String)expression3.getValue(12);
                if (string == null || string.length() < 1) {
                    throw Trace.error(6, string);
                }
                c = string.charAt(0);
            }
            expression = new Expression(27, expression, expression2);
            expression.setLikeEscape(c);
        } else if (this.iToken == 106) {
            this.read();
            Expression expression4 = new Expression(22, expression, this.readConcat());
            this.readThis(28);
            Expression expression5 = new Expression(25, expression, this.readConcat());
            expression = new Expression(28, expression4, expression5);
        } else if (this.iToken == 30) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            Expression expression6 = null;
            if (this.iToken == 103) {
                expression6 = new Expression(this.parseSelect());
                this.read();
            } else {
                this.tTokenizer.back();
                Vector<Object> vector = new Vector<Object>();
                do {
                    vector.addElement(this.getValue(12));
                    this.read();
                } while (this.iToken == 104);
                expression6 = new Expression(vector);
            }
            this.readThis(102);
            expression = new Expression(n, expression, expression6);
        } else {
            Trace.check(!bl, 10);
            if (Expression.isCompare(this.iToken)) {
                int n = this.iToken;
                this.read();
                return new Expression(n, expression, this.readConcat());
            }
            return expression;
        }
        if (bl) {
            expression = new Expression(20, expression, null);
        }
        return expression;
    }

    private void readThis(int n) throws SQLException {
        Trace.check(this.iToken == n, 10);
        this.read();
    }

    private Expression readConcat() throws SQLException {
        Expression expression = this.readSum();
        while (this.iToken == 105) {
            int n = 15;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readSum());
        }
        return expression;
    }

    private Expression readSum() throws SQLException {
        Expression expression = this.readFactor();
        while (true) {
            int n;
            if (this.iToken == 100) {
                n = 10;
            } else {
                if (this.iToken != 9) break;
                n = 11;
            }
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readFactor());
        }
        return expression;
    }

    private Expression readFactor() throws SQLException {
        Expression expression = this.readTerm();
        while (this.iToken == 12 || this.iToken == 14) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readTerm());
        }
        return expression;
    }

    private Expression readTerm() throws SQLException {
        Expression expression = null;
        if (this.iToken == 2) {
            String string = this.sToken;
            expression = new Expression(this.sTable, this.sToken);
            this.read();
            if (this.iToken == 101) {
                Function function = new Function(this.dDatabase.getAlias(string), this.cChannel);
                int n = function.getArgCount();
                int n2 = 0;
                this.read();
                if (this.iToken != 102) {
                    while (true) {
                        function.setArgument(n2++, this.readOr());
                        if (this.iToken != 104) break;
                        this.read();
                    }
                }
                this.readThis(102);
                expression = new Expression(function);
            }
        } else if (this.iToken == 9) {
            int n = this.iToken;
            this.read();
            expression = new Expression(n, this.readTerm(), null);
        } else if (this.iToken == 100) {
            this.read();
            expression = this.readTerm();
        } else if (this.iToken == 101) {
            this.read();
            expression = this.readOr();
            if (this.iToken != 102) {
                throw Trace.error(10, this.sToken);
            }
            this.read();
        } else if (this.iToken == 1) {
            expression = new Expression(this.iType, this.oData);
            this.read();
        } else if (this.iToken == 103) {
            expression = new Expression(this.parseSelect());
            this.read();
        } else if (this.iToken == 12) {
            expression = new Expression(this.sTable, null);
            this.read();
        } else if (this.iToken == 60 || this.iToken == 15) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            expression = new Expression(n, expression, this.readOr());
            this.readThis(102);
        } else if (this.iToken == 62) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            Expression expression2 = this.readOr();
            this.readThis(104);
            expression2 = new Expression(n, expression2, this.readOr());
            expression = new Expression(n, expression, expression2);
            this.readThis(102);
        } else if (this.iToken == 61) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            int n3 = Column.getTypeNr(this.sToken);
            expression = new Expression(n, expression, null);
            expression.setDataType(n3);
            this.read();
            this.readThis(102);
        } else if (this.iToken == 107) {
            this.read();
            this.readThis(101);
            expression = this.readOr();
            Trace.check(this.sToken.equals("AS"), 10, this.sToken);
            this.read();
            int n = Column.getTypeNr(this.sToken);
            expression = new Expression(61, expression, null);
            expression.setDataType(n);
            this.read();
            this.readThis(102);
        } else {
            throw Trace.error(10, this.sToken);
        }
        return expression;
    }

    private void read() throws SQLException {
        this.sToken = this.tTokenizer.getString();
        if (this.tTokenizer.wasValue()) {
            this.iToken = 1;
            this.oData = this.tTokenizer.getAsValue();
            this.iType = this.tTokenizer.getType();
        } else if (this.tTokenizer.wasName()) {
            this.iToken = 2;
            this.sTable = null;
        } else if (this.tTokenizer.wasLongName()) {
            this.sTable = this.tTokenizer.getLongNameFirst();
            this.sToken = this.tTokenizer.getLongNameLast();
            this.iToken = this.sToken.equals("*") ? 12 : 2;
        } else if (this.sToken.equals("")) {
            this.iToken = 108;
        } else if (this.sToken.equals("AND")) {
            this.iToken = 28;
        } else if (this.sToken.equals("OR")) {
            this.iToken = 29;
        } else if (this.sToken.equals("NOT")) {
            this.iToken = 20;
        } else if (this.sToken.equals("IN")) {
            this.iToken = 30;
        } else if (this.sToken.equals("EXISTS")) {
            this.iToken = 31;
        } else if (this.sToken.equals("BETWEEN")) {
            this.iToken = 106;
        } else if (this.sToken.equals("+")) {
            this.iToken = 100;
        } else if (this.sToken.equals("-")) {
            this.iToken = 9;
        } else if (this.sToken.equals("*")) {
            this.iToken = 12;
            this.sTable = null;
        } else if (this.sToken.equals("/")) {
            this.iToken = 14;
        } else if (this.sToken.equals("||")) {
            this.iToken = 105;
        } else if (this.sToken.equals("(")) {
            this.iToken = 101;
        } else if (this.sToken.equals(")")) {
            this.iToken = 102;
        } else if (this.sToken.equals("SELECT")) {
            this.iToken = 103;
        } else if (this.sToken.equals("<")) {
            this.iToken = 24;
        } else if (this.sToken.equals("<=")) {
            this.iToken = 25;
        } else if (this.sToken.equals(">=")) {
            this.iToken = 22;
        } else if (this.sToken.equals(">")) {
            this.iToken = 23;
        } else if (this.sToken.equals("=")) {
            this.iToken = 21;
        } else if (this.sToken.equals("IS")) {
            this.sToken = this.tTokenizer.getString();
            if (this.sToken.equals("NOT")) {
                this.iToken = 26;
            } else {
                this.iToken = 21;
                this.tTokenizer.back();
            }
        } else {
            this.iToken = this.sToken.equals("<>") || this.sToken.equals("!=") ? 26 : (this.sToken.equals("LIKE") ? 27 : (this.sToken.equals("COUNT") ? 40 : (this.sToken.equals("SUM") ? 41 : (this.sToken.equals("MIN") ? 42 : (this.sToken.equals("MAX") ? 43 : (this.sToken.equals("AVG") ? 44 : (this.sToken.equals("IFNULL") ? 60 : (this.sToken.equals("CONVERT") ? 61 : (this.sToken.equals("CAST") ? 107 : (this.sToken.equals("CASEWHEN") ? 62 : (this.sToken.equals(",") ? 104 : 108)))))))))));
        }
    }
}

