/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRShortIncrementerFactory;

class JRShortCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRShortCountIncrementer mainInstance = new JRShortCountIncrementer();

    private JRShortCountIncrementer() {
    }

    public static JRShortCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        if (expressionValue == null) {
            if (variable.isInitialized()) {
                return JRShortIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRShortIncrementerFactory.ZERO;
        }
        return new Short((short)(value.shortValue() + 1));
    }

    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) throws JRException {
        Number value = (Number)calculable.getIncrementedValue();
        Number combineValue = (Number)calculableValue.getValue();
        if (combineValue == null) {
            if (calculable.isInitialized()) {
                return JRShortIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || calculable.isInitialized()) {
            value = JRShortIncrementerFactory.ZERO;
        }
        return new Short((short)(value.shortValue() + combineValue.shortValue()));
    }

    public Object initialValue() {
        return JRShortIncrementerFactory.ZERO;
    }
}

