/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementContainer;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCrosstab;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRYComparator;

public abstract class JRFillElementContainer
extends JRFillElementGroup {
    protected JRBaseFiller filler;
    private JRFillElement[] ySortedElements = null;
    private JRFillElement[] stretchElements = null;
    private JRFillElement[] bandBottomElements = null;
    private JRFillElement[] removableElements = null;
    private boolean willOverflow = false;
    protected boolean isOverflow = false;
    private int stretchHeight = 0;
    private int firstY = 0;
    private boolean isFirstYFound = false;

    protected JRFillElementContainer(JRBaseFiller filler, JRElementGroup elementGrp, JRFillObjectFactory factory) {
        super(elementGrp, factory);
        this.filler = filler;
    }

    protected final void initElements() {
        if (this.elements != null && this.elements.length > 0) {
            ArrayList<JRFillElement> sortedElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> stretchElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> bandBottomElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> removableElemsList = new ArrayList<JRFillElement>();
            for (int i = 0; i < this.elements.length; ++i) {
                sortedElemsList.add(this.elements[i]);
                if (this.elements[i].getPositionType() == 3) {
                    bandBottomElemsList.add(this.elements[i]);
                }
                if (this.elements[i].getStretchType() != 0) {
                    stretchElemsList.add(this.elements[i]);
                }
                if (!this.elements[i].isRemoveLineWhenBlank()) continue;
                removableElemsList.add(this.elements[i]);
            }
            Collections.sort(sortedElemsList, new JRYComparator());
            this.ySortedElements = new JRFillElement[this.elements.length];
            sortedElemsList.toArray(this.ySortedElements);
            this.stretchElements = new JRFillElement[stretchElemsList.size()];
            stretchElemsList.toArray(this.stretchElements);
            this.bandBottomElements = new JRFillElement[bandBottomElemsList.size()];
            bandBottomElemsList.toArray(this.bandBottomElements);
            this.removableElements = new JRFillElement[removableElemsList.size()];
            removableElemsList.toArray(this.removableElements);
        }
        this.setDependentElements();
        this.setElementsBandBottomY();
    }

    protected final void setElementsBandBottomY() {
        if (this.elements != null && this.elements.length > 0) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i].setBandBottomY(this.getContainerHeight() - this.elements[i].getY() - this.elements[i].getHeight());
            }
        }
    }

    private void setDependentElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            JRFillElement iElem = null;
            JRFillElement jElem = null;
            int left = 0;
            int right = 0;
            for (int i = 0; i < this.ySortedElements.length - 1; ++i) {
                iElem = this.ySortedElements[i];
                for (int j = i + 1; j < this.ySortedElements.length; ++j) {
                    jElem = this.ySortedElements[j];
                    left = Math.min(iElem.getX(), jElem.getX());
                    right = Math.max(iElem.getX() + iElem.getWidth(), jElem.getX() + jElem.getWidth());
                    if (jElem.getPositionType() != 1 || iElem.getY() + iElem.getHeight() > jElem.getY() || iElem.getWidth() + jElem.getWidth() <= right - left) continue;
                    iElem.addDependantElement(jElem);
                }
            }
        }
    }

    protected void evaluate(byte evaluation) throws JRException {
        JRElement[] allElements = this.getElements();
        if (allElements != null && allElements.length > 0) {
            for (int i = 0; i < allElements.length; ++i) {
                ((JRFillElement)allElements[i]).evaluate(evaluation);
            }
        }
    }

    protected void resetElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length; ++i) {
                JRFillElement element = this.ySortedElements[i];
                element.reset();
                if (this.isOverflow) continue;
                element.setAlreadyPrinted(false);
            }
        }
    }

    protected boolean willOverflow() {
        return this.willOverflow;
    }

    protected void initFill() {
        this.isOverflow = this.willOverflow;
        this.firstY = 0;
        this.isFirstYFound = false;
    }

    protected void prepareElements(int availableStretchHeight, boolean isOverflowAllowed) throws JRException {
        boolean tmpWillOverflow = false;
        int maxBandStretch = 0;
        int bandStretch = 0;
        int n = this.firstY = this.isOverflow ? this.getContainerHeight() : 0;
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length; ++i) {
                JRFillElement element = this.ySortedElements[i];
                tmpWillOverflow = element.prepare(availableStretchHeight, this.isOverflow) || tmpWillOverflow;
                element.moveDependantElements();
                if (!element.isToPrint()) continue;
                if (this.isOverflow) {
                    if (element.isReprinted()) {
                        this.firstY = 0;
                    } else if (!this.isFirstYFound) {
                        this.firstY = element.getY();
                    }
                    this.isFirstYFound = true;
                }
                if ((bandStretch = element.getRelativeY() + element.getStretchHeight() - this.getContainerHeight() + element.getBandBottomY()) <= maxBandStretch) continue;
                maxBandStretch = bandStretch;
            }
        }
        if (maxBandStretch > availableStretchHeight) {
            tmpWillOverflow = true;
        }
        this.stretchHeight = tmpWillOverflow ? this.getContainerHeight() + availableStretchHeight : this.getContainerHeight() + maxBandStretch;
        this.willOverflow = tmpWillOverflow && isOverflowAllowed;
    }

    protected void stretchElements() {
        if (this.stretchElements != null && this.stretchElements.length > 0) {
            for (int i = 0; i < this.stretchElements.length; ++i) {
                JRFillElement element = this.stretchElements[i];
                element.stretchElement(this.stretchHeight - this.getContainerHeight());
                element.moveDependantElements();
            }
        }
    }

    protected int getStretchHeight() {
        return this.stretchHeight;
    }

    protected void moveBandBottomElements() {
        if (this.bandBottomElements != null && this.bandBottomElements.length > 0) {
            for (int i = 0; i < this.bandBottomElements.length; ++i) {
                JRFillElement element = this.bandBottomElements[i];
                element.setRelativeY(element.getY() + this.stretchHeight - this.getContainerHeight());
                element.setToPrint(element.isToPrint() && !this.willOverflow);
            }
        }
    }

    protected void removeBlankElements() {
        JRFillElement[] remElems = this.removableElements;
        if (remElems != null && remElems.length > 0) {
            JRFillElement[] elems = this.ySortedElements;
            JRFillElement iElem = null;
            JRFillElement jElem = null;
            int top = 0;
            int bottom = 0;
            boolean isToRemove = true;
            for (int i = 0; i < remElems.length; ++i) {
                int j;
                iElem = remElems[i];
                if (iElem.isToPrint() || iElem.getRelativeY() + iElem.getStretchHeight() > this.stretchHeight || iElem.getRelativeY() < this.firstY) continue;
                isToRemove = true;
                for (j = 0; j < elems.length; ++j) {
                    jElem = elems[j];
                    if (iElem == jElem || !jElem.isToPrint()) continue;
                    top = Math.min(iElem.getRelativeY(), jElem.getRelativeY());
                    bottom = Math.max(iElem.getRelativeY() + iElem.getHeight(), jElem.getRelativeY() + jElem.getStretchHeight());
                    if (iElem.getHeight() + jElem.getStretchHeight() <= bottom - top) continue;
                    isToRemove = false;
                    break;
                }
                if (!isToRemove) continue;
                for (j = 0; j < elems.length; ++j) {
                    jElem = elems[j];
                    if (jElem.getRelativeY() < iElem.getRelativeY() + iElem.getHeight()) continue;
                    jElem.setRelativeY(jElem.getRelativeY() - iElem.getHeight());
                }
                this.stretchHeight -= iElem.getHeight();
            }
        }
    }

    protected void fillElements(JRPrintElementContainer printContainer) throws JRException {
        JRElement[] allElements = this.getElements();
        if (allElements != null && allElements.length > 0) {
            for (int i = 0; i < allElements.length; ++i) {
                JRPrintElement printElement;
                JRFillElement element = (JRFillElement)allElements[i];
                element.setRelativeY(element.getRelativeY() - this.firstY);
                if (element.getRelativeY() + element.getStretchHeight() > this.stretchHeight) {
                    element.setToPrint(false);
                }
                element.setAlreadyPrinted(element.isToPrint() || element.isAlreadyPrinted());
                if (!element.isToPrint() || (printElement = element.fill()) == null) continue;
                printContainer.addElement(printElement);
                if (element instanceof JRFillSubreport) {
                    JRStyle[] styles;
                    JRFillSubreport subreport = (JRFillSubreport)element;
                    JRReportFont[] fonts = subreport.getFonts();
                    if (fonts != null) {
                        for (int j = 0; j < fonts.length; ++j) {
                            try {
                                this.filler.getJasperPrint().addFont(fonts[j]);
                                continue;
                            }
                            catch (JRException e) {
                                // empty catch block
                            }
                        }
                    }
                    if ((styles = subreport.getStyles()) != null) {
                        for (int j = 0; j < styles.length; ++j) {
                            try {
                                this.filler.getJasperPrint().addStyle(styles[j]);
                                continue;
                            }
                            catch (JRException e) {
                                // empty catch block
                            }
                        }
                    }
                    Collection printElements = subreport.getPrintElements();
                    this.addSubElements(printContainer, element, printElements);
                    continue;
                }
                if (!(element instanceof JRFillCrosstab)) continue;
                List printElements = ((JRFillCrosstab)element).getPrintElements();
                this.addSubElements(printContainer, element, printElements);
            }
        }
        printContainer.setHeight(this.stretchHeight - this.firstY);
    }

    protected void addSubElements(JRPrintElementContainer printContainer, JRFillElement element, Collection printElements) {
        if (printElements != null && printElements.size() > 0) {
            Iterator it = printElements.iterator();
            while (it.hasNext()) {
                JRPrintElement printElement = (JRPrintElement)it.next();
                printElement.setX(element.getX() + printElement.getX());
                printElement.setY(element.getRelativeY() + printElement.getY());
                printContainer.addElement(printElement);
            }
        }
    }

    protected void rewind() throws JRException {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length; ++i) {
                JRFillElement element = this.ySortedElements[i];
                element.rewind();
                element.setAlreadyPrinted(false);
            }
        }
        this.willOverflow = false;
    }

    protected int getFirstY() {
        return this.firstY;
    }

    protected abstract int getContainerHeight();
}

