/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateElement;

public abstract class JRFillElement
implements JRElement {
    protected JRElement parent = null;
    protected JRTemplateElement template = null;
    protected JRBaseFiller filler = null;
    protected JRFillExpressionEvaluator expressionEvaluator = null;
    protected JRGroup printWhenGroupChanges = null;
    protected JRFillElementGroup elementGroup = null;
    protected JRFillBand band = null;
    private boolean isPrintWhenExpressionNull = true;
    private boolean isPrintWhenTrue = true;
    private boolean isToPrint = true;
    private boolean isReprinted = false;
    private boolean isAlreadyPrinted = false;
    private Collection dependantElements = new ArrayList();
    private int relativeY = 0;
    private int stretchHeight = 0;
    private int bandBottomY = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean isValueRepeating = true;

    protected JRFillElement(JRBaseFiller filler, JRElement element, JRFillObjectFactory factory) {
        factory.put(element, this);
        this.parent = element;
        this.filler = filler;
        this.expressionEvaluator = factory.getExpressionEvaluator();
        this.printWhenGroupChanges = factory.getGroup(element.getPrintWhenGroupChanges());
        this.elementGroup = (JRFillElementGroup)factory.getElementGroup(element.getElementGroup());
        this.x = element.getX();
        this.y = element.getY();
        this.width = element.getWidth();
        this.height = element.getHeight();
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.parent.getDefaultStyleProvider();
    }

    public String getKey() {
        return this.parent.getKey();
    }

    public byte getPositionType() {
        return this.parent.getPositionType();
    }

    public void setPositionType(byte positionType) {
    }

    public byte getStretchType() {
        return this.parent.getStretchType();
    }

    public void setStretchType(byte stretchType) {
    }

    public boolean isPrintRepeatedValues() {
        return this.parent.isPrintRepeatedValues();
    }

    public void setPrintRepeatedValues(boolean isPrintRepeatedValues) {
    }

    public byte getMode() {
        return this.parent.getMode();
    }

    public Byte getOwnMode() {
        return this.parent.getOwnMode();
    }

    public void setMode(byte mode) {
    }

    public void setMode(Byte mode) {
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isRemoveLineWhenBlank() {
        return this.parent.isRemoveLineWhenBlank();
    }

    public void setRemoveLineWhenBlank(boolean isRemoveLine) {
    }

    public boolean isPrintInFirstWholeBand() {
        return this.parent.isPrintInFirstWholeBand();
    }

    public void setPrintInFirstWholeBand(boolean isPrint) {
    }

    public boolean isPrintWhenDetailOverflows() {
        return this.parent.isPrintWhenDetailOverflows();
    }

    public void setPrintWhenDetailOverflows(boolean isPrint) {
    }

    public Color getForecolor() {
        return this.parent.getForecolor();
    }

    public Color getOwnForecolor() {
        return this.parent.getOwnForecolor();
    }

    public void setForecolor(Color forecolor) {
    }

    public Color getBackcolor() {
        return this.parent.getBackcolor();
    }

    public Color getOwnBackcolor() {
        return this.parent.getOwnBackcolor();
    }

    public void setBackcolor(Color backcolor) {
    }

    public JRExpression getPrintWhenExpression() {
        return this.parent.getPrintWhenExpression();
    }

    public JRGroup getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    protected boolean isPrintWhenExpressionNull() {
        return this.isPrintWhenExpressionNull;
    }

    protected void setPrintWhenExpressionNull(boolean isPrintWhenExpressionNull) {
        this.isPrintWhenExpressionNull = isPrintWhenExpressionNull;
    }

    protected boolean isPrintWhenTrue() {
        return this.isPrintWhenTrue;
    }

    protected void setPrintWhenTrue(boolean isPrintWhenTrue) {
        this.isPrintWhenTrue = isPrintWhenTrue;
    }

    protected boolean isToPrint() {
        return this.isToPrint;
    }

    protected void setToPrint(boolean isToPrint) {
        this.isToPrint = isToPrint;
    }

    protected boolean isReprinted() {
        return this.isReprinted;
    }

    protected void setReprinted(boolean isReprinted) {
        this.isReprinted = isReprinted;
    }

    protected boolean isAlreadyPrinted() {
        return this.isAlreadyPrinted;
    }

    protected void setAlreadyPrinted(boolean isAlreadyPrinted) {
        this.isAlreadyPrinted = isAlreadyPrinted;
    }

    protected JRElement[] getGroupElements() {
        JRElement[] groupElements = null;
        if (this.elementGroup != null) {
            groupElements = this.elementGroup.getElements();
        }
        return groupElements;
    }

    protected Collection getDependantElements() {
        return this.dependantElements;
    }

    protected void addDependantElement(JRElement element) {
        this.dependantElements.add(element);
    }

    protected int getRelativeY() {
        return this.relativeY;
    }

    protected void setRelativeY(int relativeY) {
        this.relativeY = relativeY;
    }

    protected int getStretchHeight() {
        return this.stretchHeight;
    }

    protected void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight > this.getHeight() ? stretchHeight : this.getHeight();
    }

    protected int getBandBottomY() {
        return this.bandBottomY;
    }

    protected void setBandBottomY(int bandBottomY) {
        this.bandBottomY = bandBottomY;
    }

    protected JRFillBand getBand() {
        return this.band;
    }

    protected void setBand(JRFillBand band) {
        this.band = band;
    }

    protected void reset() {
        this.relativeY = this.y;
        this.stretchHeight = this.height;
        if (this.elementGroup != null) {
            this.elementGroup.reset();
        }
    }

    protected abstract void evaluate(byte var1) throws JRException;

    protected void evaluatePrintWhenExpression(byte evaluation) throws JRException {
        boolean isExprNull = true;
        boolean isExprTrue = false;
        JRExpression expression = this.getPrintWhenExpression();
        if (expression != null) {
            isExprNull = false;
            Boolean printWhenExpressionValue = (Boolean)this.evaluateExpression(expression, evaluation);
            isExprTrue = printWhenExpressionValue == null ? false : printWhenExpressionValue;
        }
        this.setPrintWhenExpressionNull(isExprNull);
        this.setPrintWhenTrue(isExprTrue);
    }

    protected abstract void rewind() throws JRException;

    protected abstract JRPrintElement fill() throws JRException;

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        this.setReprinted(false);
        return false;
    }

    protected void stretchElement(int bandStretch) {
        switch (this.getStretchType()) {
            case 2: {
                this.setStretchHeight(this.getHeight() + bandStretch);
                break;
            }
            case 1: {
                if (this.elementGroup == null) break;
                this.setStretchHeight(this.getHeight() + this.elementGroup.getStretchHeightDiff());
                break;
            }
        }
    }

    protected void moveDependantElements() {
        Collection elements = this.getDependantElements();
        if (elements != null && elements.size() > 0) {
            JRFillElement element = null;
            int diffY = 0;
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRFillElement)it.next();
                diffY = element.getY() - this.getY() - this.getHeight() - (element.getRelativeY() - this.getRelativeY() - this.getStretchHeight());
                if (diffY < 0) {
                    diffY = 0;
                }
                element.setRelativeY(element.getRelativeY() + diffY);
            }
        }
    }

    public JRStyle getStyle() {
        return this.parent.getStyle();
    }

    protected abstract void resolveElement(JRPrintElement var1, byte var2) throws JRException;

    protected final Object evaluateExpression(JRExpression expression, byte evaluation) throws JRException {
        return this.expressionEvaluator.evaluate(expression, evaluation);
    }

    protected boolean isValueRepeating() {
        return this.isValueRepeating;
    }

    protected void setValueRepeating(boolean isValueRepeating) {
        this.isValueRepeating = isValueRepeating;
    }
}

