/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDefaultCompiler;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRQueryExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillDataset
implements JRDataset {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRBaseFiller == null ? (class$net$sf$jasperreports$engine$fill$JRBaseFiller = JRFillDataset.class$("net.sf.jasperreports.engine.fill.JRBaseFiller")) : class$net$sf$jasperreports$engine$fill$JRBaseFiller));
    private final JRBaseFiller filler;
    private final JRDataset parent;
    private final boolean isMain;
    protected JRQuery query = null;
    protected JRFillParameter[] parameters = null;
    protected Map parametersMap = null;
    protected JRFillField[] fields = null;
    protected Map fieldsMap = null;
    protected JRFillVariable[] variables = null;
    protected Map variablesMap = null;
    protected Set variableCalculationReqs;
    protected JRFillElementDataset[] elementDatasets;
    protected JRFillElementDataset[] origElementDatasets;
    protected JRFillGroup[] groups = null;
    protected String resourceBundleBaseName = null;
    protected byte whenResourceMissingType;
    protected String scriptletClassName = null;
    protected Class scriptletClass = null;
    protected Integer reportMaxCount = null;
    protected JRDataSource dataSource = null;
    protected Locale locale = null;
    protected ResourceBundle resourceBundle = null;
    protected int reportCount = 0;
    protected JRCalculator calculator = null;
    protected JRAbstractScriptlet scriptlet = null;
    protected PreparedStatement dataSourceStatement;
    private ResultSet dataSourceResultSet;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRBaseFiller;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$util$JRClassLoader;

    protected JRFillDataset(JRBaseFiller filler, JRDataset dataset, JRFillObjectFactory factory) {
        factory.put(dataset, this);
        this.filler = filler;
        this.parent = dataset;
        this.isMain = dataset.isMainDataset();
        this.scriptletClassName = dataset.getScriptletClass();
        this.resourceBundleBaseName = dataset.getResourceBundle();
        this.whenResourceMissingType = dataset.getWhenResourceMissingType();
        this.query = dataset.getQuery();
        this.setParameters(dataset, factory);
        this.setFields(dataset, factory);
        this.setVariables(dataset, factory);
        this.setGroups(dataset, factory);
    }

    private void setParameters(JRDataset dataset, JRFillObjectFactory factory) {
        JRParameter[] jrParameters = dataset.getParameters();
        if (jrParameters != null && jrParameters.length > 0) {
            this.parameters = new JRFillParameter[jrParameters.length];
            this.parametersMap = new HashMap();
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = factory.getParameter(jrParameters[i]);
                this.parametersMap.put(this.parameters[i].getName(), this.parameters[i]);
            }
        }
    }

    private void setGroups(JRDataset dataset, JRFillObjectFactory factory) {
        JRGroup[] jrGroups = dataset.getGroups();
        if (jrGroups != null && jrGroups.length > 0) {
            this.groups = new JRFillGroup[jrGroups.length];
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = factory.getGroup(jrGroups[i]);
            }
        }
    }

    private void setVariables(JRDataset dataset, JRFillObjectFactory factory) {
        JRVariable[] jrVariables = dataset.getVariables();
        if (jrVariables != null && jrVariables.length > 0) {
            ArrayList variableList = new ArrayList(jrVariables.length * 3);
            this.variablesMap = new HashMap();
            for (int i = 0; i < jrVariables.length; ++i) {
                this.addVariable(jrVariables[i], variableList, factory);
            }
            this.setVariables(variableList);
        }
    }

    private JRFillVariable addVariable(JRVariable parentVariable, List variableList, JRFillObjectFactory factory) {
        JRFillVariable variable = factory.getVariable(parentVariable);
        byte calculation = variable.getCalculation();
        switch (calculation) {
            case 3: 
            case 7: {
                JRVariable countVar = this.createHelperVariable(parentVariable, "_COUNT", (byte)1);
                JRFillVariable fillCountVar = this.addVariable(countVar, variableList, factory);
                variable.setHelperVariable(fillCountVar, (byte)0);
                JRVariable sumVar = this.createHelperVariable(parentVariable, "_SUM", (byte)2);
                JRFillVariable fillSumVar = this.addVariable(sumVar, variableList, factory);
                variable.setHelperVariable(fillSumVar, (byte)1);
                break;
            }
            case 6: {
                JRVariable varianceVar = this.createHelperVariable(parentVariable, "_VARIANCE", (byte)7);
                JRFillVariable fillVarianceVar = this.addVariable(varianceVar, variableList, factory);
                variable.setHelperVariable(fillVarianceVar, (byte)2);
                break;
            }
        }
        variableList.add(variable);
        return variable;
    }

    private JRVariable createHelperVariable(JRVariable variable, String nameSuffix, byte calculation) {
        JRDesignVariable helper = new JRDesignVariable();
        helper.setName(variable.getName() + nameSuffix);
        helper.setValueClassName(variable.getValueClassName());
        helper.setIncrementerFactoryClassName(variable.getIncrementerFactoryClassName());
        helper.setResetType(variable.getResetType());
        helper.setResetGroup(variable.getResetGroup());
        helper.setIncrementType(variable.getIncrementType());
        helper.setIncrementGroup(variable.getIncrementGroup());
        helper.setCalculation(calculation);
        helper.setSystemDefined(true);
        helper.setExpression(variable.getExpression());
        return helper;
    }

    private void setVariables(List variableList) {
        this.variables = new JRFillVariable[variableList.size()];
        this.variables = variableList.toArray(this.variables);
        for (int i = 0; i < this.variables.length; ++i) {
            this.variablesMap.put(this.variables[i].getName(), this.variables[i]);
        }
    }

    private void setFields(JRDataset dataset, JRFillObjectFactory factory) {
        JRField[] jrFields = dataset.getFields();
        if (jrFields != null && jrFields.length > 0) {
            this.fields = new JRFillField[jrFields.length];
            this.fieldsMap = new HashMap();
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = factory.getField(jrFields[i]);
                this.fieldsMap.put(this.fields[i].getName(), this.fields[i]);
            }
        }
    }

    protected void createCalculator(JasperReport jasperReport) throws JRException {
        this.setCalculator(JRFillDataset.createCalculator(jasperReport, this));
    }

    protected void setCalculator(JRCalculator calculator) {
        this.calculator = calculator;
    }

    protected static JRCalculator createCalculator(JasperReport jasperReport, JRDataset dataset) throws JRException {
        JREvaluator evaluator = JRDefaultCompiler.getInstance().loadEvaluator(jasperReport, dataset);
        return new JRCalculator(evaluator);
    }

    protected void initCalculator() throws JRException {
        this.calculator.init(this);
    }

    protected void inheritFromMain() {
        if (this.resourceBundleBaseName == null && !this.isMain) {
            this.resourceBundleBaseName = this.filler.mainDataset.resourceBundleBaseName;
            this.whenResourceMissingType = this.filler.mainDataset.whenResourceMissingType;
        }
    }

    protected JRAbstractScriptlet initScriptlet() throws JRException {
        this.scriptlet = this.createScriptlet();
        this.scriptlet.setData(this.parametersMap, this.fieldsMap, this.variablesMap, this.groups);
        return this.scriptlet;
    }

    protected JRAbstractScriptlet createScriptlet() throws JRException {
        JRAbstractScriptlet tmpScriptlet = null;
        if (this.scriptletClassName != null) {
            if (this.scriptletClass == null) {
                try {
                    this.scriptletClass = JRClassLoader.loadClassForName(this.scriptletClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new JRException("Error loading scriptlet class : " + this.scriptletClassName, e);
                }
            }
            try {
                tmpScriptlet = (JRAbstractScriptlet)this.scriptletClass.newInstance();
            }
            catch (Exception e) {
                throw new JRException("Error creating scriptlet class instance : " + this.scriptletClassName, e);
            }
        }
        if (tmpScriptlet == null) {
            tmpScriptlet = new JRDefaultScriptlet();
        }
        return tmpScriptlet;
    }

    protected void initElementDatasets(JRFillObjectFactory factory) {
        this.elementDatasets = factory.getElementDatasets(this);
    }

    protected void filterElementDatasets(JRFillElementDataset elementDataset) {
        this.origElementDatasets = this.elementDatasets;
        this.elementDatasets = new JRFillElementDataset[]{elementDataset};
    }

    protected void restoreElementDatasets() {
        if (this.origElementDatasets != null) {
            this.elementDatasets = this.origElementDatasets;
            this.origElementDatasets = null;
        }
    }

    protected ResourceBundle loadResourceBundle() {
        ResourceBundle tmpResourceBundle = null;
        if (this.resourceBundleBaseName != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    tmpResourceBundle = ResourceBundle.getBundle(this.resourceBundleBaseName, this.locale, classLoader);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (tmpResourceBundle == null) {
                classLoader = (class$net$sf$jasperreports$engine$util$JRClassLoader == null ? (class$net$sf$jasperreports$engine$util$JRClassLoader = JRFillDataset.class$("net.sf.jasperreports.engine.util.JRClassLoader")) : class$net$sf$jasperreports$engine$util$JRClassLoader).getClassLoader();
                tmpResourceBundle = classLoader == null ? ResourceBundle.getBundle(this.resourceBundleBaseName, this.locale) : ResourceBundle.getBundle(this.resourceBundleBaseName, this.locale, classLoader);
            }
        }
        return tmpResourceBundle;
    }

    protected void setParameters(Map parameterValues) throws JRException {
        this.reportMaxCount = (Integer)parameterValues.get("REPORT_MAX_COUNT");
        this.locale = (Locale)parameterValues.get("REPORT_LOCALE");
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.locale == null) {
            parameterValues.remove("REPORT_LOCALE");
        } else {
            parameterValues.put("REPORT_LOCALE", this.locale);
        }
        this.setParameter("REPORT_LOCALE", (Object)this.locale);
        this.resourceBundle = (ResourceBundle)parameterValues.get("REPORT_RESOURCE_BUNDLE");
        if (this.resourceBundle == null) {
            this.resourceBundle = this.loadResourceBundle();
        }
        if (this.resourceBundle == null) {
            parameterValues.remove("REPORT_RESOURCE_BUNDLE");
        } else {
            parameterValues.put("REPORT_RESOURCE_BUNDLE", this.resourceBundle);
        }
        this.setParameter("REPORT_RESOURCE_BUNDLE", (Object)this.resourceBundle);
    }

    protected void setParameterValues(Map parameterValues) throws JRException {
        if (this.parameters != null && this.parameters.length > 0) {
            for (int i = 0; i < this.parameters.length; ++i) {
                if (parameterValues.containsKey(this.parameters[i].getName())) {
                    this.setParameter(this.parameters[i], parameterValues.get(this.parameters[i].getName()));
                    continue;
                }
                if (this.parameters[i].isSystemDefined()) continue;
                Object value = this.calculator.evaluate(this.parameters[i].getDefaultValueExpression(), (byte)3);
                if (value != null) {
                    parameterValues.put(this.parameters[i].getName(), value);
                }
                this.setParameter(this.parameters[i], value);
            }
        }
    }

    protected JRDataSource createDataSource(Map parameterValues, Connection conn) throws JRException {
        if (conn == null) {
            conn = (Connection)parameterValues.get("REPORT_CONNECTION");
        }
        if (conn == null) {
            parameterValues.remove("REPORT_CONNECTION");
        } else {
            parameterValues.put("REPORT_CONNECTION", conn);
        }
        this.setParameter("REPORT_CONNECTION", (Object)conn);
        if (conn == null && log.isWarnEnabled()) {
            log.warn((Object)"The supplied java.sql.Connection object is null.");
        }
        PreparedStatement pstmt = null;
        try {
            JRResultSetDataSource ds = null;
            pstmt = JRQueryExecuter.getStatement(this.query, this.parametersMap, parameterValues, conn);
            if (pstmt != null) {
                if (this.reportMaxCount != null) {
                    pstmt.setMaxRows(this.reportMaxCount);
                }
                this.dataSourceStatement = pstmt;
                this.filler.fillContext.setRunningStatement(this.dataSourceStatement);
                this.dataSourceResultSet = pstmt.executeQuery();
                ds = new JRResultSetDataSource(this.dataSourceResultSet);
            }
            JRResultSetDataSource jRResultSetDataSource = ds;
            return jRResultSetDataSource;
        }
        catch (SQLException e) {
            throw new JRException("Error executing SQL statement for report : " + this.filler.name, e);
        }
        finally {
            this.filler.fillContext.clearRunningStatement();
        }
    }

    protected void setDatasource(Map parameterValues, JRDataSource ds) throws JRException {
        this.dataSource = ds;
        if (this.dataSource == null) {
            this.dataSource = (JRDataSource)parameterValues.get("REPORT_DATA_SOURCE");
        }
        if (this.dataSource == null) {
            parameterValues.remove("REPORT_DATA_SOURCE");
        } else {
            parameterValues.put("REPORT_DATA_SOURCE", this.dataSource);
        }
        this.setParameter("REPORT_DATA_SOURCE", (Object)this.dataSource);
        parameterValues.put("REPORT_SCRIPTLET", this.scriptlet);
        this.setParameter("REPORT_SCRIPTLET", (Object)this.scriptlet);
        parameterValues.put("REPORT_PARAMETERS_MAP", parameterValues);
        this.setParameter("REPORT_PARAMETERS_MAP", (Object)parameterValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeStatement() {
        if (this.dataSourceResultSet != null) {
            try {
                this.dataSourceResultSet.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing result set.", (Throwable)e);
            }
            finally {
                this.dataSourceResultSet = null;
            }
        }
        if (this.dataSourceStatement != null) {
            try {
                this.dataSourceStatement.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing statement.", (Throwable)e);
            }
            finally {
                this.dataSourceStatement = null;
            }
        }
    }

    protected void start() {
        this.reportCount = 0;
    }

    protected boolean next() throws JRException {
        boolean hasNext = false;
        if (this.dataSource != null) {
            boolean bl = hasNext = (this.reportMaxCount == null || this.reportMaxCount > this.reportCount++) && this.dataSource.next();
            if (hasNext) {
                int i;
                if (this.fields != null && this.fields.length > 0) {
                    JRFillField field = null;
                    for (i = 0; i < this.fields.length; ++i) {
                        field = this.fields[i];
                        field.setOldValue(field.getValue());
                        field.setValue(this.dataSource.getFieldValue(field));
                    }
                }
                if (this.variables != null && this.variables.length > 0) {
                    JRFillVariable variable = null;
                    for (i = 0; i < this.variables.length; ++i) {
                        variable = this.variables[i];
                        variable.setOldValue(variable.getValue());
                    }
                }
            }
        }
        return hasNext;
    }

    protected void setParameter(String parameterName, Object value) throws JRException {
        JRFillParameter parameter = (JRFillParameter)this.parametersMap.get(parameterName);
        if (parameter != null) {
            this.setParameter(parameter, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setParameter(JRFillParameter parameter, Object value) throws JRException {
        if (value != null) {
            if (!parameter.getValueClass().isInstance(value)) throw new JRException("Incompatible " + value.getClass().getName() + " value assigned to parameter " + parameter.getName() + " in the " + this.getName() + " dataset.");
            parameter.setValue(value);
            return;
        } else {
            parameter.setValue(value);
        }
    }

    protected Object getVariableValue(String variableName) throws JRException {
        JRFillVariable var = (JRFillVariable)this.variablesMap.get(variableName);
        if (var == null) {
            throw new JRException("No such variable " + variableName);
        }
        return var.getValue();
    }

    protected void addVariableCalculationReq(String variableName, byte calculation) {
        if (this.variableCalculationReqs == null) {
            this.variableCalculationReqs = new HashSet();
        }
        this.variableCalculationReqs.add(new VariableCalculationReq(variableName, calculation));
    }

    protected void checkVariableCalculationReqs(JRFillObjectFactory factory) {
        if (this.variableCalculationReqs != null && !this.variableCalculationReqs.isEmpty()) {
            ArrayList variableList = new ArrayList(this.variables.length * 2);
            for (int i = 0; i < this.variables.length; ++i) {
                JRFillVariable variable = this.variables[i];
                this.checkVariableCalculationReq(variable, variableList, factory);
            }
            this.setVariables(variableList);
        }
    }

    private void checkVariableCalculationReq(JRFillVariable variable, List variableList, JRFillObjectFactory factory) {
        if (this.hasVariableCalculationReq(variable, (byte)3) || this.hasVariableCalculationReq(variable, (byte)7)) {
            if (variable.getHelperVariable((byte)0) == null) {
                JRVariable countVar = this.createHelperVariable(variable, "_COUNT", (byte)1);
                JRFillVariable fillCountVar = factory.getVariable(countVar);
                this.checkVariableCalculationReq(fillCountVar, variableList, factory);
                variable.setHelperVariable(fillCountVar, (byte)0);
            }
            if (variable.getHelperVariable((byte)1) == null) {
                JRVariable sumVar = this.createHelperVariable(variable, "_SUM", (byte)2);
                JRFillVariable fillSumVar = factory.getVariable(sumVar);
                this.checkVariableCalculationReq(fillSumVar, variableList, factory);
                variable.setHelperVariable(fillSumVar, (byte)1);
            }
        }
        if (this.hasVariableCalculationReq(variable, (byte)6) && variable.getHelperVariable((byte)2) == null) {
            JRVariable varianceVar = this.createHelperVariable(variable, "_VARIANCE", (byte)7);
            JRFillVariable fillVarianceVar = factory.getVariable(varianceVar);
            this.checkVariableCalculationReq(fillVarianceVar, variableList, factory);
            variable.setHelperVariable(fillVarianceVar, (byte)2);
        }
        variableList.add(variable);
    }

    private boolean hasVariableCalculationReq(JRVariable var, byte calculation) {
        return this.variableCalculationReqs.contains(new VariableCalculationReq(var.getName(), calculation));
    }

    public String getName() {
        return this.parent.getName();
    }

    public String getScriptletClass() {
        return this.parent.getScriptletClass();
    }

    public JRParameter[] getParameters() {
        return this.parameters;
    }

    public JRQuery getQuery() {
        return this.query;
    }

    public JRField[] getFields() {
        return this.fields;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public JRGroup[] getGroups() {
        return this.groups;
    }

    public boolean isMainDataset() {
        return this.isMain;
    }

    public String getResourceBundle() {
        return this.resourceBundleBaseName;
    }

    public byte getWhenResourceMissingType() {
        return this.whenResourceMissingType;
    }

    public void setWhenResourceMissingType(byte whenResourceMissingType) {
        this.whenResourceMissingType = whenResourceMissingType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class VariableCalculationReq {
        String variableName;
        byte calculation;

        VariableCalculationReq(String variableName, byte calculation) {
            this.variableName = variableName;
            this.calculation = calculation;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof VariableCalculationReq)) {
                return false;
            }
            VariableCalculationReq r = (VariableCalculationReq)o;
            return this.variableName.equals(r.variableName) && this.calculation == r.calculation;
        }

        public int hashCode() {
            return 31 * this.calculation + this.variableName.hashCode();
        }
    }
}

