/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.File;
import java.io.Serializable;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRClassGenerator;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRMultiClassCompiler;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;

public abstract class JRAbstractClassCompiler
extends JRAbstractJavaCompiler
implements JRMultiClassCompiler {
    protected JRAbstractClassCompiler() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        String string;
        File[] sources = new File[units.length];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = units[i].getSourceFile();
        }
        File[] classFiles = new File[units.length];
        for (int i = 0; i < classFiles.length; ++i) {
            classFiles[i] = new File(tempDirFile, units[i].getName() + ".class");
        }
        try {
            String errors = this.compileClasses(sources, classpath);
            if (errors == null) {
                for (int i = 0; i < units.length; ++i) {
                    byte[] classBytes = JRLoader.loadBytes(classFiles[i]);
                    units[i].setCompileData((Serializable)classBytes);
                }
            }
            string = errors;
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            for (int i = 0; i < classFiles.length; ++i) {
                if (!classFiles[i].exists()) continue;
                classFiles[i].delete();
            }
            throw throwable;
        }
        for (int i = 0; i < classFiles.length; ++i) {
            if (!classFiles[i].exists()) continue;
            classFiles[i].delete();
        }
        return string;
    }

    protected void checkLanguage(String language) throws JRException {
        if (!"java".equals(language)) {
            throw new JRException("Language \"" + language + "\" not supported by this report compiler.\n" + "Expecting \"java\" instead.");
        }
    }

    protected String generateSourceCode(JasperDesign jasperDesign, JRDesignDataset dataset, JRExpressionCollector expressionCollector) throws JRException {
        return JRClassGenerator.generateClass(jasperDesign, dataset, expressionCollector);
    }

    protected String generateSourceCode(JasperDesign jasperDesign, JRDesignCrosstab crosstab, JRExpressionCollector expressionCollector) throws JRException {
        return JRClassGenerator.generateClass(jasperDesign, crosstab, expressionCollector);
    }

    protected String getSourceFileName(String unitName) {
        return unitName + ".java";
    }
}

