/*
 * SheetProperty.java
 *
 * Created on 4 ottobre 2004, 22.08
 */

package it.businesslogic.ireport.gui.sheet;
import java.util.*;
import javax.swing.*;
import it.businesslogic.ireport.gui.event.*;
/**
 *
 * @author  Administrator
 */
public class SheetProperty implements java.awt.event.ActionListener {
    
    public static final int STRING = 0;
    public static final int NUMBER = 1;
    public static final int INTEGER = 6;
    public static final int COMBOBOX = 2;
    public static final int COLOR = 3;
    public static final int BOOLEAN = 4;
    public static final int COMBOBOX_NK = 5; // Combobox number key
    public static final int PASSWORD = 7;
    public static final int CATEGORY_LABEL = 99;
        
    protected String name = "";
    protected String keyName = "";
    protected String group = "";
    protected int type;
    private java.util.Vector tags = null;
    protected String defaultValue = null;
    protected Object value = null;
    
    protected boolean setting = false;
    
    protected JComponent component = null;

    /**
     * Utility field used by event firing mechanism.
     */
    private javax.swing.event.EventListenerList listenerList =  null;
    
    public SheetProperty(String keyName, String name, int type) {
       this(keyName,name,type,null);
    }
    /** Creates a new instance of SheetProperty */
    public SheetProperty(String keyName, String name, int type, String defaultValue) {
        this.setName( name );
        this.setKeyName( keyName );
        this.setDefaultValue( defaultValue );
        setType(type);
        tags =  new Vector();
    }
    
    public SheetProperty(String keyName, String name,String groupname, int type, String defaultValue) {
        this.setName( name );
        this.setKeyName( keyName );
        this.setDefaultValue( defaultValue );
        setType(type);
        tags =  new Vector();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public java.util.Vector getTags() {
        return tags;
    }

    public void setTags(java.util.Vector tags) {
        this.tags = tags;
    }
    
    public void setTags(Tag[] tags_array) {
         
        this.tags = new Vector();
        
        for (int i=0; i<tags_array.length; ++i)
        {
            tags.add(tags_array[i]);
        }
    }
    
    public JComponent getEditor()
    {
        
        if (component != null) return component;
        
        if (this.getType() == NUMBER)
        {
            component = new it.businesslogic.ireport.gui.JNumberField();
            component.setBorder(null);
            
            ((it.businesslogic.ireport.gui.JNumberField)component).setFont( new java.awt.Font("Dialog", 0, 11));
            ((it.businesslogic.ireport.gui.JNumberField)component).addActionListener( this );
        
        }
        else if (this.getType() == INTEGER)
        {
            component = new it.businesslogic.ireport.gui.JNumberField();
            component.setBorder(null);
            try {
            ((it.businesslogic.ireport.gui.JNumberField)component).setInteger(true);
            } catch (Exception ex){}
            ((it.businesslogic.ireport.gui.JNumberField)component).setFont( new java.awt.Font("Dialog", 0, 11));
            
            ((it.businesslogic.ireport.gui.JNumberField)component).addActionListener( this );
        
        }
        else if (this.getType() == COMBOBOX || this.getType() == COMBOBOX_NK)
        {
            component = new JComboBox(this.getTags());
            component.setBorder(null);
            
            ((JComboBox)component).setEditor(new SimpleComboBoxEditor() );
            for (int i=0; i< component.getComponentCount(); ++i)
            {
                try {
                        Object obj = component.getComponent(i);
                        //System.out.println( obj );                    
                        if (obj != null && obj.getClass().getMethod("setBorder", new Class[]{javax.swing.border.Border.class}) != null)
                        {
                            java.lang.reflect.Method mtd = obj.getClass().getMethod("setBorder", new Class[]{javax.swing.border.Border.class});
                            mtd.invoke(obj, new Object[]{null});
                        }
                } catch (Exception ex) { /*ex.printStackTrace();*/}
            }
            ((JComboBox)component).setFont( new java.awt.Font("Dialog", 0, 11));
            ((JComboBox)component).addActionListener( this );            
        }
        else if (this.getType() == BOOLEAN)
        {
            component = new JCheckBox("");
            ((JCheckBox)component).addActionListener( this );
        }
        else if (this.getType() == COLOR)
        {
            component = new ColorSelectorPanel();
            ((ColorSelectorPanel)component).addActionListener( this );
        }
        else if (this.getType() == CATEGORY_LABEL)
        {
            component = new JPanel();
            component.setBackground( java.awt.Color.LIGHT_GRAY);
        }
        else if (this.getType() == PASSWORD)
        {
            component = new JPasswordField();
            component.setBorder(null);
            ((JTextField)component).setFont( new java.awt.Font("Dialog", 0, 11));
            ((JTextField)component).getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                actionPerformed(null);
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                actionPerformed(null);
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                actionPerformed(null);
            }
        });
        }
        else
        {
            // default (STRING)
            component = new JTextField();
            component.setBorder(null);
            ((JTextField)component).setFont( new java.awt.Font("Dialog", 0, 11));
            ((JTextField)component).getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                actionPerformed(null);
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                actionPerformed(null);
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                actionPerformed(null);
            }
        });
        }
        
        
        return  component;
        
    }
    
    public Object getEditorValue(JComponent component)
    {
       if (this.getType() == NUMBER)
        {
            return new Double(((it.businesslogic.ireport.gui.JNumberField)component).getValue());
        }
       else if (this.getType() == INTEGER)
        {
            return new Integer( (int)((it.businesslogic.ireport.gui.JNumberField)component).getValue());
        }
        else if (this.getType() == COMBOBOX)
        {
           Object obj = ((JComboBox)component).getSelectedItem();
           if (obj != null)
           {
               return ((Tag)obj).getValue();
           }
           return null;
        }
       else if (this.getType() == COMBOBOX_NK)
        {
           Object obj = ((JComboBox)component).getSelectedItem();
           if (obj != null)
           {
               return new Integer(((Tag)obj).getValue());
           }
           return null;
        }
        else if (this.getType() == BOOLEAN)
        {
            return  new Boolean(((JCheckBox)component).isSelected());
        }
        else if (this.getType() == BOOLEAN)
        {
            return  new String( ((JPasswordField)component).getPassword() );
        }
        else if (this.getType() == COLOR)
        {
            return ((ColorSelectorPanel)component).getValue();
        }
       
        return ((JTextField)component).getText();
    }
    
    public synchronized void  setEditorValue(JComponent component, Object obj)
    {
        if (obj == null) return;
        String str = ""+obj;
        
        try {
            
       setting = true;
            if (this.getType() == NUMBER)
        {
            ((it.businesslogic.ireport.gui.JNumberField)component).setValue(Double.parseDouble(str) );
        }
       else if (this.getType() == INTEGER)
        {
            ((it.businesslogic.ireport.gui.JNumberField)component).setValue(Integer.parseInt(str) );
        }
        else if (this.getType() == COMBOBOX)
        {
            for (int i=0; i<getTags().size(); ++i)
            {
                Tag t = (Tag)getTags().elementAt(i);
                if (t.getValue().equals(str))
                {
                    ((JComboBox)component).setSelectedIndex(i);
                    break;
                }
            }
        }
        else if (this.getType() == COMBOBOX_NK)
        {
            for (int i=0; i<getTags().size(); ++i)
            {
                Tag t = (Tag)getTags().elementAt(i);
                if ((t.getValue()+"").equals(str))
                {
                    ((JComboBox)component).setSelectedIndex(i);
                    break;
                }
            }
        }
        else if (this.getType() == BOOLEAN)
        {
            ((JCheckBox)component).setSelected(str.equals("true"));
        }
        else if (this.getType() == COLOR)
        {
            ((ColorSelectorPanel)component).setValue(obj);
        }
        else if (this.getType() == PASSWORD)
        {
            ((JPasswordField)component).setText(str);
        }
        else
        {
            ((JTextField)component).setText(str);
        }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        setting = false;
    }

    public String getKeyName() {
        return keyName; 
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }
    
    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
        
        this.setEditorValue(getEditor(), value);
    }
    
    public void actionPerformed(java.awt.event.ActionEvent event)
    {
                
        if (setting) return;
        Object new_value = getEditorValue( this.getEditor() );
        if (new_value != null && new_value.equals(value)) return;
        
        Object oldValue = value;
        value = new_value;
        
        fireSheetPropertyValueChangedListenerSheetPropertyValueChanged(
            new SheetPropertyValueChangedEvent(getKeyName(),oldValue,new_value, this));
    }

    /**
     * Registers SheetPropertyValueChangedListener to receive events.
     * @param listener The listener to register.
     */
    public synchronized void addSheetPropertyValueChangedListener(it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener listener) {

        if (listenerList == null ) {
            listenerList = new javax.swing.event.EventListenerList();
        }
        listenerList.add (it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener.class, listener);
    }

    /**
     * Removes SheetPropertyValueChangedListener from the list of listeners.
     * @param listener The listener to remove.
     */
    public synchronized void removeSheetPropertyValueChangedListener(it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener listener) {

        listenerList.remove (it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener.class, listener);
    }

    /**
     * Notifies all registered listeners about the event.
     * 
     * @param event The event to be fired
     */
    private void fireSheetPropertyValueChangedListenerSheetPropertyValueChanged(it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent event) {

        if (listenerList == null) return;
        Object[] listeners = listenerList.getListenerList ();
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener.class) {
                ((it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener)listeners[i+1]).sheetPropertyValueChanged (event);
            }
        }
    }
    
}
