/*
 * AbstractLibraryObject.java
 *
 * Created on 17 settembre 2004, 18.08
 */

package it.businesslogic.ireport.gui.library;
import it.businesslogic.ireport.gui.*;
import it.businesslogic.ireport.*;
/**
 *
 * @author  Administrator
 */
abstract public class AbstractLibraryObject {
    
    private static javax.swing.ImageIcon defaultIcon;
    
    static {
        
        defaultIcon = new javax.swing.ImageIcon(AbstractLibraryObject.class.getResource("/it/businesslogic/ireport/icons/library/default.png"));
    }
    
    
    /** Creates a new instance of AbstractLibraryObject */
    public AbstractLibraryObject() {
    }
    
    protected JReportFrame getReportFrame()
    {
        MainFrame mf = MainFrame.getMainInstance();
        return mf.getActiveReportFrame();
    }
    
    protected Report getReport()
    {
        return getReportFrame().getReport();
    }
    
    protected void updateAllUI()
    {
        MainFrame mf = MainFrame.getMainInstance();
        mf.setActiveReportForm( mf.getActiveReportFrame() );
    }
    
    protected void addVariable(JRVariable variable)
    {
        getReport().addVariable(variable);
    }
    
    protected void addParameter(JRVariable variable)
    {
        getReport().addVariable(variable);

    }
    
    protected void addField(JRVariable variable)
    {
        getReport().addVariable(variable);
    }
    
    public abstract void drop(java.awt.dnd.DropTargetDropEvent dtde);
    
    public javax.swing.ImageIcon getIcon()
    {
        return defaultIcon;
    }
    
    public abstract String getName();
    
    public String toString()
    {
        return getName();
    }
}
