/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class JRBaseExpression
implements JRExpression,
Serializable {
    private static final long serialVersionUID = 10100L;
    protected String valueClassName = null;
    protected int id = 0;
    protected transient Class valueClass = null;
    private JRExpressionChunk[] chunks = null;
    private static int lastId = 0;

    protected JRBaseExpression() {
    }

    protected JRBaseExpression(JRExpression expression, JRBaseObjectFactory factory, Integer expressionId) {
        factory.put(expression, this);
        this.valueClassName = expression.getValueClassName();
        this.id = expressionId == null ? expression.getId() : expressionId.intValue();
        JRExpressionChunk[] jrChunks = expression.getChunks();
        if (jrChunks != null && jrChunks.length > 0) {
            this.chunks = new JRExpressionChunk[jrChunks.length];
            for (int i = 0; i < this.chunks.length; ++i) {
                this.chunks[i] = factory.getExpressionChunk(jrChunks[i]);
            }
        }
    }

    protected JRBaseExpression(JRExpression expression, JRBaseObjectFactory factory) {
        this(expression, factory, null);
    }

    private static synchronized int getNextId() {
        return lastId++;
    }

    public void regenerateId() {
        this.id = JRBaseExpression.getNextId();
    }

    public Class getValueClass() {
        if (this.valueClass == null && this.valueClassName != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(this.valueClassName);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(e);
            }
        }
        return this.valueClass;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    public int getId() {
        return this.id;
    }

    public JRExpressionChunk[] getChunks() {
        return this.chunks;
    }

    public String getText() {
        String text = "";
        this.chunks = this.getChunks();
        if (this.chunks != null && this.chunks.length > 0) {
            StringBuffer sbuffer = new StringBuffer();
            block6: for (int i = 0; i < this.chunks.length; ++i) {
                switch (this.chunks[i].getType()) {
                    case 2: {
                        sbuffer.append("$P{");
                        sbuffer.append(this.chunks[i].getText());
                        sbuffer.append("}");
                        continue block6;
                    }
                    case 3: {
                        sbuffer.append("$F{");
                        sbuffer.append(this.chunks[i].getText());
                        sbuffer.append("}");
                        continue block6;
                    }
                    case 4: {
                        sbuffer.append("$V{");
                        sbuffer.append(this.chunks[i].getText());
                        sbuffer.append("}");
                        continue block6;
                    }
                    case 5: {
                        sbuffer.append("$R{");
                        sbuffer.append(this.chunks[i].getText());
                        sbuffer.append("}");
                        continue block6;
                    }
                    default: {
                        sbuffer.append(this.chunks[i].getText());
                    }
                }
            }
            text = sbuffer.toString();
        }
        return text;
    }
}

