/*
 * JRCVSDataSource.java
 *
 * Created on 4 luglio 2003, 12.10
 */

package it.businesslogic.ireport.connection;

import java.io.*;
import java.util.*;
/**
 *
 * @author  Administrator
 */
public class JRCSVDataSource implements net.sf.jasperreports.engine.JRDataSource {
    
    String row = "";
    LineNumberReader lineNumberReader;
    
    /** Creates a new instance of JRCVSDataSource */
    public JRCSVDataSource(String cvsFile) {
        try {
            lineNumberReader = new LineNumberReader( new FileReader(cvsFile));
        } catch (Exception ex) { ex.printStackTrace();}
    }
    
    public Object getFieldValue(net.sf.jasperreports.engine.JRField jRField) throws net.sf.jasperreports.engine.JRException {
        String field = jRField.getName();
        int fieldPosition = Integer.parseInt(field.substring(7)); // Strip COLUMN_ 
        StringTokenizer st = new StringTokenizer(row,";");
        while (st.hasMoreTokens())
        {
            fieldPosition--; // The column is not 0 indexed.
            String token = st.nextToken();
            if (fieldPosition == 0) return token;
        }
        return null; // Column not found...
    }
    
    public boolean next() throws net.sf.jasperreports.engine.JRException {
        try {
            row = lineNumberReader.readLine();
            if (row.length()>0) return true;
        } catch (Exception ex) { }
        return false;
    }
    
}
