/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hsqldb.Library;
import org.hsqldb.jdbcConnection;

public class jdbcDatabaseMetaData
implements DatabaseMetaData {
    private jdbcConnection cConnection;

    jdbcDatabaseMetaData(jdbcConnection jdbcConnection2) {
        this.cConnection = jdbcConnection2;
    }

    public boolean allProceduresAreCallable() {
        return true;
    }

    public boolean allTablesAreSelectable() {
        return true;
    }

    public String getURL() {
        return "jdbc:hsqldb:" + this.cConnection.getName();
    }

    public String getUserName() throws SQLException {
        ResultSet resultSet = this.executeSelect("SYSTEM_CONNECTIONINFO", "KEY='USER'");
        resultSet.next();
        return resultSet.getString(2);
    }

    public boolean isReadOnly() throws SQLException {
        return this.cConnection.isReadOnly();
    }

    public boolean nullsAreSortedHigh() {
        return false;
    }

    public boolean nullsAreSortedLow() {
        return true;
    }

    public boolean nullsAreSortedAtStart() {
        return false;
    }

    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    public String getDatabaseProductName() {
        return "HSQL Database Engine";
    }

    public String getDatabaseProductVersion() {
        return "1.6";
    }

    public String getDriverName() {
        return "HSQL Database Engine Driver";
    }

    public String getDriverVersion() {
        return "1.6";
    }

    public int getDriverMajorVersion() {
        return 1;
    }

    public int getDriverMinorVersion() {
        return 6;
    }

    public boolean usesLocalFiles() {
        return this.cConnection.usesLocalFiles();
    }

    public boolean usesLocalFilePerTable() {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public String getSQLKeywords() {
        return "";
    }

    public String getNumericFunctions() {
        return jdbcDatabaseMetaData.getList(Library.sNumeric);
    }

    public String getStringFunctions() {
        return jdbcDatabaseMetaData.getList(Library.sString);
    }

    public String getSystemFunctions() {
        return jdbcDatabaseMetaData.getList(Library.sSystem);
    }

    public String getTimeDateFunctions() {
        return jdbcDatabaseMetaData.getList(Library.sTimeDate);
    }

    public String getSearchStringEscape() {
        return "\\";
    }

    public String getExtraNameCharacters() {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    public boolean supportsColumnAliasing() {
        return true;
    }

    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    public boolean supportsConvert() {
        return true;
    }

    public boolean supportsConvert(int n, int n2) {
        return true;
    }

    public boolean supportsTableCorrelationNames() {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsGroupByUnrelated() {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    public boolean supportsLikeEscapeClause() {
        return true;
    }

    public boolean supportsMultipleResultSets() {
        return false;
    }

    public boolean supportsMultipleTransactions() {
        return true;
    }

    public boolean supportsNonNullableColumns() {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() {
        return false;
    }

    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    public boolean supportsANSI92FullSQL() {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    public boolean supportsOuterJoins() {
        return true;
    }

    public boolean supportsFullOuterJoins() {
        return false;
    }

    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    public String getSchemaTerm() {
        return "";
    }

    public String getProcedureTerm() {
        return "";
    }

    public String getCatalogTerm() {
        return "";
    }

    public boolean isCatalogAtStart() {
        return false;
    }

    public String getCatalogSeparator() {
        return "";
    }

    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    public boolean supportsPositionedDelete() {
        return false;
    }

    public boolean supportsPositionedUpdate() {
        return false;
    }

    public boolean supportsSelectForUpdate() {
        return false;
    }

    public boolean supportsStoredProcedures() {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    public boolean supportsSubqueriesInExists() {
        return true;
    }

    public boolean supportsSubqueriesInIns() {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    public boolean supportsUnion() {
        return true;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    public int getMaxCharLiteralLength() {
        return 0;
    }

    public int getMaxColumnNameLength() {
        return 0;
    }

    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    public int getMaxColumnsInIndex() {
        return 0;
    }

    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    public int getMaxColumnsInSelect() {
        return 0;
    }

    public int getMaxColumnsInTable() {
        return 0;
    }

    public int getMaxConnections() {
        return 0;
    }

    public int getMaxCursorNameLength() {
        return 0;
    }

    public int getMaxIndexLength() {
        return 0;
    }

    public int getMaxSchemaNameLength() {
        return 0;
    }

    public int getMaxProcedureNameLength() {
        return 0;
    }

    public int getMaxCatalogNameLength() {
        return 0;
    }

    public int getMaxRowSize() {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    public int getMaxStatementLength() {
        return 0;
    }

    public int getMaxStatements() {
        return 0;
    }

    public int getMaxTableNameLength() {
        return 0;
    }

    public int getMaxTablesInSelect() {
        return 0;
    }

    public int getMaxUserNameLength() {
        return 0;
    }

    public int getDefaultTransactionIsolation() {
        return 1;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) {
        return n == 1;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() {
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        return this.executeSelect("SYSTEM_PROCEDURES", null);
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        return this.executeSelect("SYSTEM_PROCEDURECOLUMNS", null);
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4 = "SYSTEM_TABLES";
        String string5 = null;
        if (string3 != null) {
            string5 = "TABLE_NAME LIKE '" + string3.toUpperCase() + "'";
        }
        return this.executeSelect(string4, string5);
    }

    public ResultSet getSchemas() throws SQLException {
        return this.executeSelect("SYSTEM_SCHEMAS", null);
    }

    public ResultSet getCatalogs() throws SQLException {
        return this.executeSelect("SYSTEM_CATALOGS", null);
    }

    public ResultSet getTableTypes() throws SQLException {
        return this.executeSelect("SYSTEM_TABLETYPES", null);
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "SYSTEM_COLUMNS";
        String string6 = null;
        if (string3 != null) {
            string6 = "TABLE_NAME LIKE '" + string3.toUpperCase() + "'";
        }
        if (string4 != null) {
            string6 = this.addWhere(string6, "COLUMN_NAME LIKE '" + string4.toUpperCase() + "'");
        }
        return this.executeSelect(string5, string6);
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "SYSTEM_COLUMNPRIVILEGES";
        String string6 = null;
        if (string3 != null) {
            string6 = "TABLE_NAME LIKE '" + string3.toUpperCase() + "'";
        }
        if (string4 != null) {
            string6 = this.addWhere(string6, "COLUMN_NAME LIKE '" + string4.toUpperCase() + "'");
        }
        return this.executeSelect(string5, string6);
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        String string4 = "SYSTEM_TABLEPRIVILEGES";
        String string5 = null;
        if (string3 != null) {
            string5 = "TABLE_NAME LIKE '" + string3.toUpperCase() + "'";
        }
        return this.executeSelect(string4, string5);
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        return this.executeSelect("SYSTEM_BESTROWIDENTIFIER", null);
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        return this.executeSelect("SYSTEM_VERSIONCOLUMNS", null);
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        String string4 = "SYSTEM_PRIMARYKEYS";
        String string5 = null;
        if (string3 != null) {
            string5 = "TABLE_NAME LIKE '" + string3.toUpperCase() + "'";
        }
        return this.executeSelect(string4, string5);
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.executeSelect("SYSTEM_IMPORTEDKEYS", null);
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return this.executeSelect("SYSTEM_EXPORTEDKEYS", null);
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        return this.executeSelect("SYSTEM_CROSSREFERENCE", null);
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.executeSelect("SYSTEM_TYPEINFO", null);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        String string4 = "SYSTEM_INDEXINFO";
        String string5 = null;
        if (string3 != null) {
            string5 = "TABLE_NAME LIKE '" + string3.toUpperCase() + "'";
        }
        return this.executeSelect(string4, string5);
    }

    public boolean supportsResultSetType(int n) {
        return n == 1003;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) {
        return n == 1003 && n2 == 1007;
    }

    public boolean ownUpdatesAreVisible(int n) {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) {
        return false;
    }

    public boolean updatesAreDetected(int n) {
        return false;
    }

    public boolean deletesAreDetected(int n) {
        return false;
    }

    public boolean insertsAreDetected(int n) {
        return false;
    }

    public boolean supportsBatchUpdates() {
        return false;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        return this.executeSelect("SYSTEM_UDTS", null);
    }

    public Connection getConnection() {
        return this.cConnection;
    }

    private String addWhere(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string + " AND " + string2;
    }

    private ResultSet executeSelect(String string, String string2) throws SQLException {
        if (string2 != null) {
            string = string + " WHERE " + string2;
        }
        return this.cConnection.execute("SELECT * FROM " + string);
    }

    private static String getList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }
}

