/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.prompt;

import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.prompt.PromptDialog;
import java.awt.Frame;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class Prompter {
    public static HashMap promptForParameters(Report report) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        for (int i = 0; i < report.getParameters().size(); ++i) {
            Date time;
            Date d;
            SimpleDateFormat sdf;
            JRParameter param = (JRParameter)report.getParameters().elementAt(i);
            if (!param.isIsForPrompting() || param.getClassType() == null || param.isBuiltin()) continue;
            PromptDialog pd = new PromptDialog((Frame)MainFrame.getMainInstance(), true);
            pd.setParameter(param);
            pd.setVisible(true);
            if (pd.getDialogResult() != 0) continue;
            Object value = pd.getValue();
            if (param.getClassType().equals("java.lang.String")) {
                hm.put(param.getName(), value);
            } else if (param.getClassType().equals("java.lang.Integer")) {
                try {
                    hm.put(param.getName(), new Integer("" + value));
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.lang.Long")) {
                try {
                    hm.put(param.getName(), new Long("" + value));
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.lang.Double")) {
                try {
                    hm.put(param.getName(), new Double("" + value));
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.lang.Float")) {
                try {
                    hm.put(param.getName(), new Float("" + value));
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.lang.Boolean")) {
                try {
                    hm.put(param.getName(), new Boolean("" + value));
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.util.Date")) {
                try {
                    sdf = new SimpleDateFormat(MainFrame.getMainInstance().getProperties().getProperty("dateformat", "d/M/y"));
                    hm.put(param.getName(), sdf.parse("" + value));
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.sql.Time")) {
                try {
                    sdf = new SimpleDateFormat(MainFrame.getMainInstance().getProperties().getProperty("timeformat", "d/M/y H:m:s"));
                    d = sdf.parse("" + value);
                    time = new Time(d.getTime());
                    hm.put(param.getName(), time);
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            } else if (param.getClassType().equals("java.sql.Timestamp")) {
                try {
                    sdf = new SimpleDateFormat(MainFrame.getMainInstance().getProperties().getProperty("timeformat", "d/M/y H:m:s"));
                    d = sdf.parse("" + value);
                    time = new Timestamp(d.getTime());
                    hm.put(param.getName(), time);
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
            if (value == null) continue;
            param.setLastDefaultValue("" + value);
        }
        return hm;
    }
}

