/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;

public class XYShapeAnnotation
implements XYAnnotation,
Serializable {
    private Shape shape;
    private Stroke stroke;
    private Paint paint;

    public XYShapeAnnotation(Shape shape) {
        this(shape, new BasicStroke(1.0f), Color.black);
    }

    public XYShapeAnnotation(Shape shape, Stroke stroke, Paint paint) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.shape = shape;
        this.stroke = stroke;
        this.paint = paint;
    }

    public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis) {
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(plot.getDomainAxisLocation(), orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation(plot.getRangeAxisLocation(), orientation);
        double m02 = domainAxis.valueToJava2D(0.0, dataArea, domainEdge);
        double m12 = rangeAxis.valueToJava2D(0.0, dataArea, rangeEdge);
        double m00 = domainAxis.valueToJava2D(1.0, dataArea, domainEdge) - m02;
        double m11 = rangeAxis.valueToJava2D(1.0, dataArea, rangeEdge) - m12;
        Shape s = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            AffineTransform t1 = new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
            AffineTransform t2 = new AffineTransform(m11, 0.0, 0.0, m00, m12, m02);
            s = t1.createTransformedShape(this.shape);
            s = t2.createTransformedShape(s);
        } else if (orientation == PlotOrientation.VERTICAL) {
            AffineTransform t = new AffineTransform(m00, 0.0, 0.0, m11, m02, m12);
            s = t.createTransformedShape(this.shape);
        }
        g2.setPaint(this.paint);
        g2.setStroke(this.stroke);
        g2.draw(s);
    }
}

