/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRIncrementer;
import net.sf.jasperreports.engine.fill.JRLongIncrementerFactory;

class JRLongSumIncrementer
implements JRIncrementer {
    private static JRLongSumIncrementer mainInstance = new JRLongSumIncrementer();

    private JRLongSumIncrementer() {
    }

    public static JRLongSumIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRFillVariable variable, Object expressionValue, AbstractValueProvider valueProvider) throws JRException {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRLongIncrementerFactory.ZERO;
        }
        return new Long(value.longValue() + newValue.longValue());
    }
}

