/*
 * SheetPanel.java
 *
 * Created on 4 ottobre 2004, 23.21
 */

package it.businesslogic.ireport.gui.sheet;
import  java.util.*;
import java.util.HashMap;
import javax.swing.*;
import it.businesslogic.ireport.gui.event.*;
/**
 *
 * @author  Administrator
 */
public class CategorySheetPanel extends javax.swing.JPanel implements SheetPropertyValueChangedListener {
    
    public static int zzz = 0;
    public static final int VIEW_BY_CATEGORY = 1;
    public static final int VIEW_SORTED = 2;
    public static final int VIEW_UNSORTED = 3;
    
    public static final javax.swing.ImageIcon opened_icon = new javax.swing.ImageIcon( CategorySheetPanel.class.getResource("/it/businesslogic/ireport/icons/sheet/opened.png"));
    public static final javax.swing.ImageIcon closed_icon =new javax.swing.ImageIcon( CategorySheetPanel.class.getResource("/it/businesslogic/ireport/icons/sheet/closed.png"));
    
    
    protected java.util.Vector properties;
    protected java.util.Vector categories;
    protected java.util.HashMap propCategories;
    protected java.util.Vector compressedCategories;
    private int viewMode = 1; 
    private int current_position = 0;
    
    /** Creates new form SheetPanel */
    public CategorySheetPanel() {
        initComponents();
        jPanel1.setBackground(new java.awt.Color(234,234,234) );
        properties = new Vector();
        categories = new Vector();
        propCategories = new HashMap();
        compressedCategories = new Vector();
        recreateSheet();
        
    }
    
    public java.util.Properties getPropertiesValues()
    {
         java.util.Properties prop = new  java.util.Properties();
         
         for (int i=0; i<getProperties().size(); ++i)
         {
            SheetProperty sp = (SheetProperty)getProperties().elementAt(i);
            Object value = "";
            value = getPropertyValue(i);
            if (value != null)
            {
                prop.setProperty(sp.getKeyName(), value+"");
            }
         }
         return prop;
    } 
    
    public void setPropertiesValues(java.util.Properties prop)
    {
         Enumeration enum_keys = prop.keys();
         while (enum_keys.hasMoreElements())
         {
             String key = (String)enum_keys.nextElement();
             // Looking for this property...
             for (int i=0; i<getProperties().size(); ++i)
             {
                SheetProperty sp = (SheetProperty)getProperties().elementAt(i);
                if (sp.getKeyName().equals(key) )
                {
                    String value = prop.getProperty(key);
                    sp.setEditorValue( (javax.swing.JComponent)jPanelEditors.getComponent((2*i) +1 ), value  );
                }
             }
         }    
    }
    
    public void setPropertyValue(String propertyName, Object value)
    {
        for (int i=0; i<getProperties().size(); ++i)
             {
                SheetProperty sp = (SheetProperty)getProperties().elementAt(i);
                if (sp.getKeyName().equals(propertyName) )
                {
                    //(javax.swing.JComponent)jPanelEditors.getComponent((2*i) +1 )
                    sp.setValue(value); // EditorValue( sp.getEditor() , value  );
                }
             }
    }
    
    public Object getPropertyValue(String propertyName)
    {
        for (int i=0; i<getProperties().size(); ++i)
             {
                SheetProperty sp = (SheetProperty)getProperties().elementAt(i);
                if (sp.getKeyName().equals(propertyName) )
                {
                    //(javax.swing.JComponent)jPanelEditors.getComponent((2*i) +1 )
                    return sp.getValue(); // getEditorValue( sp.getEditor() );
                }
             }
        return null;
    }
    
    public Object getSheetProperty(String propertyName)
    {
        for (int i=0; i<getProperties().size(); ++i)
             {
                SheetProperty sp = (SheetProperty)getProperties().elementAt(i);
                if (sp != null && sp.getKeyName().equals(propertyName) )
                {
                    return sp; // getEditorValue( sp.getEditor() );
                }
             }
        return null;
    }
    
    public Object getPropertyValue(int index)
    {
         SheetProperty sp = (SheetProperty)getProperties().elementAt(index);
         return sp.getEditorValue( (javax.swing.JComponent)jPanelEditors.getComponent((2*index) +1 ) );
    } 
    
    public void removeAllProperties()
    {
         for (int i=0; i<getProperties().size(); ++i)
         {
                SheetProperty sp = (SheetProperty)getProperties().elementAt(i);
                sp.removeSheetPropertyValueChangedListener(this);
         }
         
         getProperties().removeAllElements();
         categories.removeAllElements();
         propCategories.clear();
         //recreateSheet();
    }
    
    public void addSheetProperty(String category, SheetProperty sp)
    {
        properties.add(sp);
        
        Vector v_category = (Vector)propCategories.get(category);
        if (v_category == null)
        {
            v_category = new Vector();
            categories.add(category);
            propCategories.put(category, v_category);
        }
        v_category.add(sp);
        //recreateSheet();
    }
    
    public void recreateSheet()
    {
        //System.out.println((zzz++) + "RecreateSheet!!!!");
        current_position = 0;
        
        jPanelLabels.removeAll();
        jPanel1.removeAll();
        jPanelEditors.removeAll();
        
        //System.out.println("Labels: " + jPanelLabels.getComponentCount() + " prps:" + this.getProperties().size());
        jPanelLabels.setLayout(new java.awt.GridBagLayout());
        jPanel1.setLayout(new java.awt.GridBagLayout());
        jPanelEditors.setLayout(new java.awt.GridBagLayout());
        
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 400;
        gridBagConstraints.weighty = 1.0;
         
        jPanelEditors.add(jPanelFillerEditors, gridBagConstraints);
        jPanelLabels.add(jPanelFillerLabels, gridBagConstraints);
        jPanel1.add(jPanelFiller, gridBagConstraints);
         
        jPanelEditors.setMinimumSize( new java.awt.Dimension(50,0) );
        jPanelLabels.setMinimumSize(new java.awt.Dimension(50,0));
         
        if (getViewMode() == VIEW_BY_CATEGORY)
        {
            for (int i=0; i<categories.size(); ++i)
            {
                // Add the category....
                addCategory( ""+categories.elementAt(i) );
            }
        }
        else if (getViewMode() == VIEW_UNSORTED )
        {
            addItems( properties );
        }
        else
        {
            Vector items = getSortedProperties( properties );
            addItems( items );
        }
        
        jPanelSheet.setMinimumSize(new java.awt.Dimension(16,19*current_position));
        jPanelSheet.setPreferredSize(new java.awt.Dimension(16,19*current_position));
        
        //System.out.println("Labels: " + jPanelLabels.getComponentCount() + "  " + current_position);
    
        jPanelLabels.updateUI();
        jPanelEditors.updateUI();
        jScrollPane1.updateUI();
    }
    
    protected void addItem( SheetProperty sp )
    {
        sp.addSheetPropertyValueChangedListener( this );
        JLabel jLabel = new JLabel(sp.getName());
        
        if (sp.getType() != sp.CATEGORY_LABEL)
        {
            jLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        }
        else
        {
            jLabel.setFont(new java.awt.Font("Dialog", java.awt.Font.BOLD, 11));
        }
        jLabel.setMaximumSize(new java.awt.Dimension(41, 18));
        jLabel.setMinimumSize(new java.awt.Dimension(41, 18));
        jLabel.setPreferredSize(new java.awt.Dimension(41, 18));
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = (current_position)*2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        if (sp.getType() != sp.CATEGORY_LABEL)
        {
            gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        }
        else
        {
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 0);
            jLabel.setBackground(new java.awt.Color(234,234,234) );
            jLabel.setOpaque(true);
        }
        
        jPanelLabels.add(jLabel, gridBagConstraints);
 
        /* Set pulsante category... */
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = (current_position)*2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 0);
        
        if (sp.getType() == sp.CATEGORY_LABEL)
        {
            JLabel b = new JLabel( (!compressedCategories.contains( sp.getName()) ) ? opened_icon : closed_icon);
            b.setName(sp.getName());
            //jLabel.addMouseListener(  );
            b.setMinimumSize(new java.awt.Dimension(16,19));
            b.setMaximumSize(new java.awt.Dimension(16,19));
            b.setPreferredSize(new java.awt.Dimension(16,19));
            b.setBorder(new javax.swing.border.EmptyBorder(0,0,0,0));
            b.setOpaque(false);
            jPanel1.add(b, gridBagConstraints);
            b.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    categoryClicked(evt);
                }
            });
        }
        else
        {
            JPanel p = new JPanel();
            p.setMinimumSize(new java.awt.Dimension(16,19));
            p.setMaximumSize(new java.awt.Dimension(16,19));
            p.setPreferredSize(new java.awt.Dimension(16,19));
            p.setBorder(new javax.swing.border.EmptyBorder(0,0,0,0));
            p.setOpaque(false);
            jPanel1.add(p, gridBagConstraints);
        }
        
        
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        
        
        /******** Set editor *******/
        javax.swing.JComponent editor = sp.getEditor();
        if (sp.getType() != sp.CATEGORY_LABEL)
        {
            editor.setOpaque(false);
            editor.setBackground( java.awt.Color.WHITE);
        }
        else
        {
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 0);
            editor.setBackground(new java.awt.Color(234,234,234) );
            editor.setOpaque(true);
        }
        
        editor.setMaximumSize(new java.awt.Dimension(41, 18));
        editor.setMinimumSize(new java.awt.Dimension(41, 18));
        editor.setPreferredSize(new java.awt.Dimension(41, 18));
        
        if (editor instanceof JComboBox)
        {
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 0);
        }
        jPanelEditors.add(editor, gridBagConstraints);
        
        
        JSeparator jSeparator1 = new JSeparator(JSeparator.HORIZONTAL);
        jSeparator1.setPreferredSize(new java.awt.Dimension(0, 1));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = (current_position*2)+1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        
        jPanelEditors.add(jSeparator1, gridBagConstraints);
        
        JSeparator jSeparator = new JSeparator(JSeparator.HORIZONTAL);
        jSeparator.setPreferredSize(new java.awt.Dimension(0, 1));
        jPanelLabels.add(jSeparator, gridBagConstraints);
        
        jPanelLabels.setMinimumSize(new java.awt.Dimension(30, 20*properties.size()));
        jPanelLabels.setPreferredSize(new java.awt.Dimension(30, 20*properties.size()));
        jPanelEditors.setMinimumSize(new java.awt.Dimension(30, 20*properties.size()));
        jPanelEditors.setPreferredSize(new java.awt.Dimension(30, 20*properties.size()));

        //jPanelLabels.updateUI();
        //jPanelEditors.updateUI();
        //jScrollPane1.updateUI();
        
        current_position++;
    }
    
    protected Vector getSortedProperties(Vector props)
    {
        SheetProperty[] names = new SheetProperty[props.size()];
        HashMap unsorted_hm = new HashMap();
        for (int i=0; i< props.size(); ++i)
        {
            SheetProperty sp = (SheetProperty)props.elementAt(i);
            names[i] = sp;
        }
        
        java.util.Arrays.sort(names, new Comparator()
            {
                public int compare(Object o1,Object o2 )
                {
                    return ((SheetProperty)o1).getName().compareTo( ((SheetProperty)o2).getName() );
                }
            });
        Vector v = new Vector();
        for (int i=0; i< names.length; ++i)
        {
            v.add(i,names[i]);
        }
        
        return v;
    }
    
    protected void addItems( Vector sheetProperties)
    {
        for (int i=0; i< sheetProperties.size(); ++i)
        {
            addItem( (SheetProperty)sheetProperties.elementAt(i));
        }
    }
    
    protected void addCategory(String name)
    {
        SheetProperty sp = new SheetProperty(name,name,SheetProperty.CATEGORY_LABEL);
        addItem( sp );
        if (!compressedCategories.contains( sp.getName()) )
        {
            addItems( (Vector)propCategories.get( name )  );
        }
    }
    
    public java.util.Vector getProperties() {
        return properties;
    }

    public void setProperties(java.util.Vector properties) {
        this.properties = properties;
    }

    public int getViewMode() {
        return viewMode;
    }

    public void setViewMode(int viewMode) {
        this.viewMode = viewMode;
        recreateSheet();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroupToolbar = new javax.swing.ButtonGroup();
        jScrollPane1 = new javax.swing.JScrollPane();
        jPanelSheet = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jPanelFiller = new javax.swing.JPanel();
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanelLabels = new javax.swing.JPanel();
        jPanelFillerLabels = new javax.swing.JPanel();
        jPanelEditors = new javax.swing.JPanel();
        jPanelFillerEditors = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jButtonOrderByCategory = new javax.swing.JButton();
        jButtonOrderByAlpha = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane1.setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane1.setMinimumSize(new java.awt.Dimension(22, 0));
        jScrollPane1.setOpaque(false);
        jPanelSheet.setLayout(new java.awt.GridBagLayout());

        jPanelSheet.setBackground(new java.awt.Color(255, 255, 255));
        jPanelSheet.setMinimumSize(new java.awt.Dimension(126, 0));
        jPanelSheet.setPreferredSize(new java.awt.Dimension(126, 0));
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jPanel1.setMaximumSize(new java.awt.Dimension(16, 2147483647));
        jPanel1.setMinimumSize(new java.awt.Dimension(16, 20));
        jPanel1.setPreferredSize(new java.awt.Dimension(16, 0));
        jPanelFiller.setMinimumSize(new java.awt.Dimension(10, 0));
        jPanelFiller.setPreferredSize(new java.awt.Dimension(10, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 400;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jPanelFiller, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelSheet.add(jPanel1, gridBagConstraints);

        jSplitPane1.setBackground(new java.awt.Color(255, 255, 255));
        jSplitPane1.setBorder(null);
        jSplitPane1.setDividerSize(1);
        jSplitPane1.setResizeWeight(0.5);
        jSplitPane1.setContinuousLayout(true);
        jSplitPane1.setOneTouchExpandable(true);
        jSplitPane1.setOpaque(false);
        jSplitPane1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jSplitPane1MouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jSplitPane1MouseExited(evt);
            }
        });

        jPanelLabels.setLayout(new java.awt.GridBagLayout());

        jPanelLabels.setBackground(new java.awt.Color(255, 255, 255));
        jPanelLabels.setMinimumSize(new java.awt.Dimension(100, 10));
        jPanelLabels.setPreferredSize(new java.awt.Dimension(100, 10));
        jPanelFillerLabels.setMinimumSize(new java.awt.Dimension(10, 0));
        jPanelFillerLabels.setPreferredSize(new java.awt.Dimension(10, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 400;
        gridBagConstraints.weighty = 1.0;
        jPanelLabels.add(jPanelFillerLabels, gridBagConstraints);

        jSplitPane1.setLeftComponent(jPanelLabels);

        jPanelEditors.setLayout(new java.awt.GridBagLayout());

        jPanelEditors.setBackground(new java.awt.Color(255, 255, 255));
        jPanelFillerEditors.setMinimumSize(new java.awt.Dimension(10, 0));
        jPanelFillerEditors.setPreferredSize(new java.awt.Dimension(10, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 400;
        gridBagConstraints.weighty = 1.0;
        jPanelEditors.add(jPanelFillerEditors, gridBagConstraints);

        jSplitPane1.setRightComponent(jPanelEditors);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelSheet.add(jSplitPane1, gridBagConstraints);

        jScrollPane1.setViewportView(jPanelSheet);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setMinimumSize(new java.awt.Dimension(10, 20));
        jPanel2.setPreferredSize(new java.awt.Dimension(10, 24));
        jButtonOrderByCategory.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/sheet/tree.png")));
        buttonGroupToolbar.add(jButtonOrderByCategory);
        jButtonOrderByCategory.setSelected(true);
        jButtonOrderByCategory.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOrderByCategoryActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 2, 2);
        jPanel2.add(jButtonOrderByCategory, gridBagConstraints);

        jButtonOrderByAlpha.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/sheet/az.png")));
        buttonGroupToolbar.add(jButtonOrderByAlpha);
        jButtonOrderByAlpha.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOrderByAlphaActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 2, 0);
        jPanel2.add(jButtonOrderByAlpha, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jPanel3, gridBagConstraints);

        add(jPanel2, java.awt.BorderLayout.NORTH);

    }//GEN-END:initComponents

    private void jButtonOrderByAlphaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOrderByAlphaActionPerformed
       this.setViewMode( VIEW_SORTED );
    }//GEN-LAST:event_jButtonOrderByAlphaActionPerformed

    private void jButtonOrderByCategoryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOrderByCategoryActionPerformed
        this.setViewMode( VIEW_BY_CATEGORY );
    }//GEN-LAST:event_jButtonOrderByCategoryActionPerformed

    private void jSplitPane1MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSplitPane1MouseExited
        //System.out.println("exited");
        //this.setCursor( new java.awt.Cursor(java.awt.Cursor.W_RESIZE_CURSOR));
        
        
    }//GEN-LAST:event_jSplitPane1MouseExited

    private void jSplitPane1MouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSplitPane1MouseEntered
        
        //System.out.println("entered");
        //this.setCursor( new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        
        
    }//GEN-LAST:event_jSplitPane1MouseEntered
 
    public void categoryClicked(java.awt.event.MouseEvent evt){
        
        String category = "";
        try {
            JLabel jlabel = (JLabel)(evt.getSource());
            if (compressedCategories.contains( jlabel.getName()) )
            {
                jlabel.setIcon(opened_icon);
                compressedCategories.removeElement(jlabel.getName());
                recreateSheet();
            }
            else
            {
                jlabel.setIcon(closed_icon);
                
                compressedCategories.add(jlabel.getName());
                recreateSheet();
            }
        
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        
    }

    /**
     * Registers SheetPropertyValueChangedListener to receive events.
     * @param listener The listener to register.
     */
    public synchronized void addSheetPropertyValueChangedListener(it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener listener) {

        if (listenerList == null ) {
            listenerList = new javax.swing.event.EventListenerList();
        }
        listenerList.add (it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener.class, listener);
    }

    /**
     * Removes SheetPropertyValueChangedListener from the list of listeners.
     * @param listener The listener to remove.
     */
    public synchronized void removeSheetPropertyValueChangedListener(it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener listener) {

        listenerList.remove (it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener.class, listener);
    }

    /**
     * Notifies all registered listeners about the event.
     * 
     * @param event The event to be fired
     */
    private void fireSheetPropertyValueChangedListenerSheetPropertyValueChanged(it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent event) {

        if (listenerList == null) return;
        Object[] listeners = listenerList.getListenerList ();
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener.class) {
                ((it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener)listeners[i+1]).sheetPropertyValueChanged (event);
            }
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupToolbar;
    private javax.swing.JButton jButtonOrderByAlpha;
    private javax.swing.JButton jButtonOrderByCategory;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanelEditors;
    private javax.swing.JPanel jPanelFiller;
    private javax.swing.JPanel jPanelFillerEditors;
    private javax.swing.JPanel jPanelFillerLabels;
    private javax.swing.JPanel jPanelLabels;
    private javax.swing.JPanel jPanelSheet;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSplitPane jSplitPane1;
    // End of variables declaration//GEN-END:variables
 
    public void sheetPropertyValueChanged(SheetPropertyValueChangedEvent evt)
    {
        evt.setSource( this );
        fireSheetPropertyValueChangedListenerSheetPropertyValueChanged(evt);
    }
}
