/*
 * FormatCommandEqualsSpaceH.java
 *
 * Created on 9 mei 2005, 21:36
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;

import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;


/**
 *
 *
 */
public class FormatCommandEqualsSpaceH extends FormatCommand {
    int actual_x;
    int available_width;
    Vector myElements = null;
    
    {
        operationType = OperationType.EQUALS_SPACE_H;
    }
    
    boolean preCondition(){
        return ( jrf.getSelectedElements().size() > 2 );
    }
    
    void executeDeeper(){
        resetEnumeration();
        preparation(); // <========= method in subclass is called if present
        
        resetEnumeration();
        processElements( myElements.elements() ) ;
    }
    
    void preparation() {
        
        // 1. Use an ordered array...
        Vector myElements = SortX( jrf.getSelectedElements().elements() ); 

        // Find the most right element and calculate available width
        int total_width=0;
        int min_x = 0;
        int max_x = 0;
        available_width=0;
        
        re = (ReportElement)myElements.firstElement();
        min_x = re.getPosition().x;
        max_x = re.getPosition().x+re.getWidth();
        
        Enumeration enum2 = myElements.elements();
        ReportElement leftElement = re;
        ReportElement rightElement = re;
        while (enum2.hasMoreElements()) {
            re = (ReportElement)enum2.nextElement();
            if (min_x > re.getPosition().x) {
                min_x =re.getPosition().x;
            }
            if (max_x < re.getPosition().x + re.getWidth()) {
                max_x =re.getPosition().x + re.getWidth();
                rightElement = re;
            }
            available_width += re.getWidth();
        }
        
        available_width = max_x - min_x - available_width;
        available_width /= myElements.size()-1;
        // System.out.println("Space: " + available_width);
        
        actual_x = leftElement.getPosition().x + leftElement.getWidth() + available_width;
        
        // delete leftElement and rightElement as they will remain on the same location.
        myElements.remove(myElements.indexOf(leftElement));
        myElements.remove(myElements.indexOf(rightElement));
        
    }
    
    public void modify() {
        re.setPosition(new Point(actual_x, re.getPosition().y) );
        actual_x += re.getWidth() + available_width;
    }

    Vector SortX( Enumeration enum2 ) {
        //Enumeration enum2 = jrf.getSelectedElements().elements();
        Vector myElements = new Vector();
        
        while (enum2.hasMoreElements()) {
            re = (ReportElement) enum2.nextElement();
            // insert this element in the right position...
            if (myElements.size() == 0) {
                myElements.add(re);
            } else {
                boolean inserted=false;
                for (int i=0; i<myElements.size(); ++i) {
                    ReportElement re2 = (ReportElement)myElements.elementAt(i);
                    if (re.getPosition().x < re2.getPosition().x) {
                        myElements.insertElementAt(re, i);
                        inserted = true;
                        break;
                    }
                }
                if (!inserted)
                    myElements.addElement(re);
            }
        }
        return myElements;
    }
    
    
    
}
