/*
 * JRulePane.java
 *
 * iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 12 febbraio 2003, 22.52
 */

package it.businesslogic.ireport.gui;

import javax.swing.*;
import java.awt.*;
import it.businesslogic.ireport.util.*;
/**
 *
 * @author  Administrator
 */
public class JRulePanel extends JPanel {
    
    private double unit;
    
    private int cursorPosition;    

    
    /** Creates a new instance of JRulePane */
    public JRulePanel() {
        cursorPosition = -1;
        unit = Unit.PIXEL;
    }
    
    /**
     * Paints the container. This forwards the paint to any lightweight
     * components that are children of this container. If this method is
     * reimplemented, super.paint(g) should be called so that lightweight
     * components are properly rendered. If a child component is entirely
     * clipped by the current clipping setting in g, paint() will not be
     * forwarded to that child.
     *
     * @param g the specified Graphics window
     * @see   Component#update(Graphics)
     *
     */
    public void paint(Graphics g) {
        cursorPosition = -1;
        g.setColor(new Color( 255,255,255));
        g.fillRect(0,0, this.getWidth(), this.getHeight());
        g.setColor(new Color(0,0,0));
        g.drawLine(0,this.getHeight()-1, this.getWidth()-1, this.getHeight()-1);
        
	double k=0;
	int line=0;
        int i=10;
	//int i = 10-HScrollBar1.getValue();
	int oldi=-100;
	while (i< this.getWidth())
	{
        	if (i>=0)
		{
			if ((line%2)==0)
			{
				if (i-oldi > 12)
				{
                                        int w = g.getFontMetrics().stringWidth(((int)k)+"");
					g.drawString(((int)k)+"" ,i - (w/2), (g.getFontMetrics().getHeight()/2)+2);
					oldi= i;
				}
				g.drawLine(i,16,i,11);
				//if (k==2)
					//e.graphics.drawLines(new Point[]{new Point(i-50,1),new Point(i+50,1), new Point(i+50,5),new Point(i-50,5) });
				}
				else //if ((k%5)==0)
				{
					//if (i-oldi > 7)
					{
						g.drawLine(i,16,i,12);
						//oldi= i;
					}
				}
			}
			//else //if ((k%1)==0.5)
			//	e.graphics.drawLine(i,16,i,13,RasterOp.BLACK);

			line++;
			k = line*0.5;
                        /*
			if ( ((MainForm)this.getParentForm()).ireportProperties.getProperty("DEFAULT_UNITS") != null &&
				 ((MainForm)this.getParentForm()).ireportProperties.getProperty("DEFAULT_UNITS").equals("inches"))
				i = getZoomedDim((int)UnitConverter.convertInchesToPixels(k))+10-HScrollBar1.getValue();
			else if ( ((MainForm)this.getParentForm()).ireportProperties.getProperty("DEFAULT_UNITS") != null &&
				 ((MainForm)this.getParentForm()).ireportProperties.getProperty("DEFAULT_UNITS").equals("pixels"))
				i = getZoomedDim((int)(10*k))+10-HScrollBar1.getValue();
			else
                         */ 
			//	i = getZoomedDim((int)UnitConverter.convertCentimetersToPixels(k))+10-HScrollBar1.getValue();
                        i = (int)Unit.convertCentimetersToPixels(k)+10;
			//label1.setText(label1.getText() +" "+k);
			
		}
                
    }
    
    /** Getter for property unit.
     * @return Value of property unit.
     *
     */
    public double getUnit() {
        return unit;
    }
    
    /** Setter for property unit.
     * @param unit New value of property unit.
     *
     */
    public void setUnit(double unit) {
        this.unit = unit;
    }
    
    /** Getter for property cursorPosition.
     * @return Value of property cursorPosition.
     *
     */
    public int getCursorPosition() {
        return cursorPosition;
    }
    
    /** Setter for property cursorPosition.
     * @param cursorPosition New value of property cursorPosition.
     *
     */
    public void setCursorPosition(int cursorPosition) {
        Graphics g = this.getGraphics();
        g.setXORMode(Color.WHITE);
        g.drawLine(this.cursorPosition, 0,this.cursorPosition, this.getHeight());
        this.cursorPosition = cursorPosition;
        g.drawLine(this.cursorPosition, 0,this.cursorPosition, this.getHeight());
        g.setPaintMode();
   }
    
}
