/*
 * CompatibilityDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 2 giugno 2003, 22.30
 * Updated August 9, Robert Lamping
 * - Activated Ok and Cancel button
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.Misc;
import it.businesslogic.ireport.*;
/**
 *
 * @author  Administrator
 */
public class CompatibilityDialog extends javax.swing.JDialog {
    
    MainFrame mf = null;
    
    
    public CompatibilityDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        this.mf = (MainFrame)parent;
        initComponents();
        this.setSize(330, 253);
        load();
        Misc.centerFrame(this);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jPanel9 = new javax.swing.JPanel();
        jRadioButtonJR060 = new javax.swing.JRadioButton();
        jRadioButtonJR061 = new javax.swing.JRadioButton();
        jRadioButtonJR062 = new javax.swing.JRadioButton();
        jRadioButtonJR063 = new javax.swing.JRadioButton();
        jRadioButtonJR064 = new javax.swing.JRadioButton();
        jRadioButtonJR066 = new javax.swing.JRadioButton();
        jRadioButtonJR067 = new javax.swing.JRadioButton();
        jRadioButtonMostrecent = new javax.swing.JRadioButton();
        jPanel2 = new javax.swing.JPanel();
        jButtonOk = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();

        setTitle("Compatibility options");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel9.setLayout(new java.awt.GridBagLayout());

        jPanel9.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "JasperReports Version Compatibility", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
        jPanel9.setMinimumSize(new java.awt.Dimension(250, 150));
        jPanel9.setPreferredSize(new java.awt.Dimension(250, 150));
        buttonGroup1.add(jRadioButtonJR060);
        jRadioButtonJR060.setFont(new java.awt.Font("Arial", 0, 11));
        jRadioButtonJR060.setText("JasperReports 0.6.0");
        jRadioButtonJR060.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jRadioButtonJR060ItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel9.add(jRadioButtonJR060, gridBagConstraints);

        buttonGroup1.add(jRadioButtonJR061);
        jRadioButtonJR061.setFont(new java.awt.Font("Arial", 0, 11));
        jRadioButtonJR061.setText("JasperReports 0.6.1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel9.add(jRadioButtonJR061, gridBagConstraints);

        buttonGroup1.add(jRadioButtonJR062);
        jRadioButtonJR062.setFont(new java.awt.Font("Arial", 0, 11));
        jRadioButtonJR062.setText("JasperReports 0.6.2");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel9.add(jRadioButtonJR062, gridBagConstraints);

        buttonGroup1.add(jRadioButtonJR063);
        jRadioButtonJR063.setFont(new java.awt.Font("Arial", 0, 11));
        jRadioButtonJR063.setText("JasperReports 0.6.3");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel9.add(jRadioButtonJR063, gridBagConstraints);

        buttonGroup1.add(jRadioButtonJR064);
        jRadioButtonJR064.setFont(new java.awt.Font("Arial", 0, 11));
        jRadioButtonJR064.setText("JasperReports 0.6.4");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel9.add(jRadioButtonJR064, gridBagConstraints);

        buttonGroup1.add(jRadioButtonJR066);
        jRadioButtonJR066.setFont(new java.awt.Font("Arial", 0, 11));
        jRadioButtonJR066.setText("JasperReports 0.6.6");
        jRadioButtonJR066.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonJR066ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel9.add(jRadioButtonJR066, gridBagConstraints);

        buttonGroup1.add(jRadioButtonJR067);
        jRadioButtonJR067.setFont(new java.awt.Font("Arial", 0, 11));
        jRadioButtonJR067.setText("JasperReports 0.6.7");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel9.add(jRadioButtonJR067, gridBagConstraints);

        buttonGroup1.add(jRadioButtonMostrecent);
        jRadioButtonMostrecent.setFont(new java.awt.Font("Arial", 0, 11));
        jRadioButtonMostrecent.setSelected(true);
        jRadioButtonMostrecent.setText("Use the most recent version available");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel9.add(jRadioButtonMostrecent, gridBagConstraints);

        jPanel1.add(jPanel9, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        jPanel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        jButtonOk.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonOk.setMnemonic('o');
        jButtonOk.setText("Ok");
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        jPanel2.add(jButtonOk);

        jButtonCancel.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCancel.setText("Cancel");
        jButtonCancel.setMnemonic('c');
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        jPanel2.add(jButtonCancel);

        getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents

    private void jRadioButtonJR066ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonJR066ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jRadioButtonJR066ActionPerformed

    private void jRadioButtonJR060ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jRadioButtonJR060ItemStateChanged

    }//GEN-LAST:event_jRadioButtonJR060ItemStateChanged
    
    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        close();
    }//GEN-LAST:event_jButtonCancelActionPerformed
    
    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed
        save();
        close();
    }//GEN-LAST:event_jButtonOkActionPerformed
    
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        // Add your handling code here:
    }//GEN-LAST:event_closeDialog
    
    private void load(){
        if (mf == null || mf.getProperties() == null) {
            return;
        }
        java.util.Properties prop = mf.getProperties();
        try {
            
            jRadioButtonMostrecent.setSelected( CompatibilitySupport.version == CompatibilitySupport.LAST_AVAILABLE_VERSION  );
            jRadioButtonJR060.setSelected( CompatibilitySupport.version == CompatibilitySupport.JR060  );
            jRadioButtonJR061.setSelected( CompatibilitySupport.version == CompatibilitySupport.JR061  );
            jRadioButtonJR062.setSelected( CompatibilitySupport.version == CompatibilitySupport.JR062  );
            jRadioButtonJR063.setSelected( CompatibilitySupport.version == CompatibilitySupport.JR063  );
            jRadioButtonJR064.setSelected( CompatibilitySupport.version == CompatibilitySupport.JR064  );
            jRadioButtonJR066.setSelected( CompatibilitySupport.version == CompatibilitySupport.JR066  );
            jRadioButtonJR067.setSelected( CompatibilitySupport.version == CompatibilitySupport.JR067  );
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void save(){
        if (mf == null || mf.getProperties() == null) {
            return;
        }
        java.util.Properties prop = mf.getProperties();
        
        try {
            int compatibility = CompatibilitySupport.LAST_AVAILABLE_VERSION;
            if (jRadioButtonJR060.isSelected()) compatibility = CompatibilitySupport.JR060;
            if (jRadioButtonJR061.isSelected()) compatibility = CompatibilitySupport.JR061;
            if (jRadioButtonJR062.isSelected()) compatibility = CompatibilitySupport.JR062;
            if (jRadioButtonJR063.isSelected()) compatibility = CompatibilitySupport.JR063;
            if (jRadioButtonJR064.isSelected()) compatibility = CompatibilitySupport.JR064;
            if (jRadioButtonJR066.isSelected()) compatibility = CompatibilitySupport.JR066;
            if (jRadioButtonJR067.isSelected()) compatibility = CompatibilitySupport.JR067;
            
           CompatibilitySupport.version = compatibility;
            prop.put("Compatibility", ""+compatibility);

        } catch (Exception ex) {
            ex.printStackTrace(); 
        }
    }
    private void close(){
        setVisible(false);
        dispose();
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new CompatibilityDialog(new javax.swing.JFrame(), true).show();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JRadioButton jRadioButtonJR060;
    private javax.swing.JRadioButton jRadioButtonJR061;
    private javax.swing.JRadioButton jRadioButtonJR062;
    private javax.swing.JRadioButton jRadioButtonJR063;
    private javax.swing.JRadioButton jRadioButtonJR064;
    private javax.swing.JRadioButton jRadioButtonJR066;
    private javax.swing.JRadioButton jRadioButtonJR067;
    private javax.swing.JRadioButton jRadioButtonMostrecent;
    // End of variables declaration//GEN-END:variables

}
