/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRFloatIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRIncrementer;

class JRFloatVarianceIncrementer
implements JRIncrementer {
    private static JRFloatVarianceIncrementer mainInstance = new JRFloatVarianceIncrementer();

    private JRFloatVarianceIncrementer() {
    }

    public static JRFloatVarianceIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRFillVariable variable, Object expressionValue, AbstractValueProvider valueProvider) throws JRException {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            return JRFloatIncrementerFactory.ZERO;
        }
        Number countValue = (Number)valueProvider.getValue((JRFillVariable)variable.getCountVariable());
        Number sumValue = (Number)valueProvider.getValue((JRFillVariable)variable.getSumVariable());
        return new Float((countValue.floatValue() - 1.0f) * value.floatValue() / countValue.floatValue() + (sumValue.floatValue() / countValue.floatValue() - newValue.floatValue()) * (sumValue.floatValue() / countValue.floatValue() - newValue.floatValue()) / (countValue.floatValue() - 1.0f));
    }
}

