/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.TextMeasurer;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public abstract class JRFillTextElement
extends JRFillElement
implements JRTextElement {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRFillTextElement == null ? (class$net$sf$jasperreports$engine$fill$JRFillTextElement = JRFillTextElement.class$("net.sf.jasperreports.engine.fill.JRFillTextElement")) : class$net$sf$jasperreports$engine$fill$JRFillTextElement));
    private JRFont font = null;
    private boolean isLeftToRight = true;
    private TextMeasurer textMeasurer = null;
    private float lineSpacingFactor = 0.0f;
    private float leadingOffset = 0.0f;
    private float textHeight = 0.0f;
    private int textStart = 0;
    private int textEnd = 0;
    private String rawText = null;
    private JRStyledText styledText = null;
    private Map styledTextAttributes = null;
    protected TextChopper textChopper = null;
    private static TextChopper simpleTextChopper = new TextChopper(){

        public String chop(JRFillTextElement textElement, int startIndex, int endIndex) {
            return textElement.getStyledText().getText().substring(startIndex, endIndex);
        }
    };
    private static TextChopper styledTextChopper = new TextChopper(){

        public String chop(JRFillTextElement textElement, int startIndex, int endIndex) {
            return textElement.filler.getStyledTextParser().write(textElement.getStyledTextAttributes(), new AttributedString(textElement.getStyledText().getAttributedString().getIterator(), startIndex, endIndex).getIterator(), textElement.getText().substring(startIndex, endIndex));
        }
    };
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRFillTextElement;

    protected JRFillTextElement(JRBaseFiller filler, JRTextElement textElement, JRFillObjectFactory factory) {
        super(filler, textElement, factory);
        this.font = factory.getFont(textElement.getFont());
        this.textMeasurer = new TextMeasurer(this);
        this.textChopper = this.isStyledText() ? styledTextChopper : simpleTextChopper;
    }

    public byte getTextAlignment() {
        return ((JRTextElement)this.parent).getTextAlignment();
    }

    public void setTextAlignment(byte horizontalAlignment) {
    }

    public byte getVerticalAlignment() {
        return ((JRTextElement)this.parent).getVerticalAlignment();
    }

    public void setVerticalAlignment(byte verticalAlignment) {
    }

    public byte getRotation() {
        return ((JRTextElement)this.parent).getRotation();
    }

    public void setRotation(byte rotation) {
    }

    public byte getLineSpacing() {
        return ((JRTextElement)this.parent).getLineSpacing();
    }

    public void setLineSpacing(byte lineSpacing) {
    }

    public boolean isStyledText() {
        return ((JRTextElement)this.parent).isStyledText();
    }

    public void setStyledText(boolean isStyledText) {
    }

    public JRBox getBox() {
        return ((JRTextElement)this.parent).getBox();
    }

    public JRFont getFont() {
        return this.font;
    }

    protected Map getStyledTextAttributes() {
        if (this.styledTextAttributes == null) {
            this.styledTextAttributes = new HashMap();
            this.styledTextAttributes.putAll(this.getFont().getAttributes());
            this.styledTextAttributes.put(TextAttribute.FOREGROUND, this.getForecolor());
            if (this.getMode() == 1) {
                this.styledTextAttributes.put(TextAttribute.BACKGROUND, this.getBackcolor());
            }
        }
        return this.styledTextAttributes;
    }

    protected float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    protected void setLineSpacingFactor(float lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    protected float getLeadingOffset() {
        return this.leadingOffset;
    }

    protected void setLeadingOffset(float leadingOffset) {
        this.leadingOffset = leadingOffset;
    }

    protected byte getRunDirection() {
        return this.isLeftToRight ? (byte)0 : 1;
    }

    protected float getTextHeight() {
        return this.textHeight;
    }

    protected void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int textStart) {
        this.textStart = textStart;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int textEnd) {
        this.textEnd = textEnd;
    }

    protected String getRawText() {
        return this.rawText;
    }

    protected void setRawText(String rawText) {
        this.rawText = rawText;
        this.styledText = null;
    }

    protected void reset() {
        super.reset();
        this.isLeftToRight = true;
        this.lineSpacingFactor = 0.0f;
        this.leadingOffset = 0.0f;
        this.textHeight = 0.0f;
    }

    protected void rewind() throws JRException {
        this.textStart = 0;
        this.textEnd = 0;
    }

    protected JRStyledText getStyledText() {
        String text;
        if (this.styledText == null && (text = this.getRawText()) != null) {
            block5: {
                if (this.isStyledText()) {
                    try {
                        this.styledText = this.filler.getStyledTextParser().parse(this.getStyledTextAttributes(), text);
                    }
                    catch (SAXException e) {
                        if (!log.isWarnEnabled()) break block5;
                        log.warn((Object)"Invalid styled text.", (Throwable)e);
                    }
                }
            }
            if (this.styledText == null) {
                this.styledText = new JRStyledText();
                this.styledText.append(text);
                this.styledText.addRun(new JRStyledText.Run(this.getStyledTextAttributes(), 0, text.length()));
            }
        }
        return this.styledText;
    }

    public String getText() {
        JRStyledText styledText = this.getStyledText();
        if (styledText == null) {
            return null;
        }
        return styledText.getText();
    }

    protected void chopTextElement(int availableStretchHeight) {
        JRStyledText styledText = this.getStyledText();
        if (styledText == null) {
            return;
        }
        String allText = this.getText().substring(this.getTextEnd());
        if (allText.length() == 0) {
            return;
        }
        this.textMeasurer.measure(styledText, allText, availableStretchHeight);
        this.isLeftToRight = this.textMeasurer.isLeftToRight();
        this.setTextHeight(this.textMeasurer.getTextHeight());
        if (this.getRotation() == 0) {
            if (this.getBox() == null) {
                this.setStretchHeight((int)this.getTextHeight());
            } else {
                this.setStretchHeight((int)this.getTextHeight() + this.getBox().getTopPadding() + this.getBox().getBottomPadding());
            }
        } else {
            this.setStretchHeight(this.getHeight());
        }
        this.setTextStart(this.getTextEnd());
        this.setTextEnd(this.getTextStart() + this.textMeasurer.getTextOffset());
        this.setLineSpacingFactor(this.textMeasurer.getLineSpacingFactor());
        this.setLeadingOffset(this.textMeasurer.getLeadingOffset());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static interface TextChopper {
        public String chop(JRFillTextElement var1, int var2, int var3);
    }
}

