/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePrintElement;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;
import org.xml.sax.SAXException;

public class JRXlsExporter
extends JRAbstractExporter {
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected int pageHeight = 0;
    protected HSSFWorkbook workbook = null;
    protected HSSFSheet sheet = null;
    protected HSSFRow row = null;
    protected HSSFCell cell = null;
    protected HSSFCellStyle emptyCellStyle = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected int reportIndex = 0;
    protected JRFont defaultFont = null;
    protected List loadedFonts = new ArrayList();
    protected List loadedCellStyles = new ArrayList();
    protected boolean isOnePagePerSheet = false;
    protected boolean isRemoveEmptySpace = false;
    protected boolean isAutoDetectCellType = true;
    protected short whiteIndex = new HSSFColor.WHITE().getIndex();
    protected short backgroundMode = 1;
    protected JRExporterGridCell[][] grid = null;
    protected boolean[] isRowNotEmpty = null;
    protected List xCuts = null;
    protected List yCuts = null;

    protected JRFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRBaseFont();
            }
        }
        return this.defaultFont;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportReport() throws JRException {
        OutputStream os;
        Boolean isAutoDetectCellTypeParameter;
        Boolean isWhitePageBackgroundParameter;
        Boolean isRemoveEmptySpaceParameter;
        Boolean isOnePagePerSheetParameter;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        if (!this.isModeBatch) {
            this.setPageRange();
        }
        if ((isOnePagePerSheetParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET)) != null) {
            this.isOnePagePerSheet = isOnePagePerSheetParameter;
        }
        if ((isRemoveEmptySpaceParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS)) != null) {
            this.isRemoveEmptySpace = isRemoveEmptySpaceParameter;
        }
        if ((isWhitePageBackgroundParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND)) != null && !isWhitePageBackgroundParameter.booleanValue()) {
            this.backgroundMode = 0;
        }
        if ((isAutoDetectCellTypeParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_AUTO_DETECT_CELL_TYPE)) != null) {
            this.isAutoDetectCellType = isAutoDetectCellTypeParameter;
        }
        if ((os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM)) != null) {
            this.exportReportToStream(os);
            return;
        }
        File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (fileName == null) throw new JRException("No output specified for the exporter.");
            destFile = new File(fileName);
        }
        try {
            try {
                os = new FileOutputStream(destFile);
                this.exportReportToStream(os);
                os.flush();
            }
            catch (IOException e) {
                throw new JRException("Error trying to export to file : " + destFile, e);
            }
            Object var9_9 = null;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        os.close();
        return;
    }

    protected void exportReportToStream(OutputStream os) throws JRException {
        this.workbook = new HSSFWorkbook();
        this.emptyCellStyle = this.workbook.createCellStyle();
        this.emptyCellStyle.setFillForegroundColor(new HSSFColor.WHITE().getIndex());
        this.emptyCellStyle.setFillPattern(this.backgroundMode);
        try {
            this.reportIndex = 0;
            while (this.reportIndex < this.jasperPrintList.size()) {
                this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
                this.defaultFont = null;
                List pages = this.jasperPrint.getPages();
                if (pages != null && pages.size() > 0) {
                    if (this.isModeBatch) {
                        this.startPageIndex = 0;
                        this.endPageIndex = pages.size() - 1;
                    }
                    if (this.isOnePagePerSheet) {
                        this.pageHeight = this.jasperPrint.getPageHeight();
                        for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new JRException("Current thread interrupted.");
                            }
                            JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
                            this.sheet = this.workbook.createSheet("Page " + (pageIndex + 1));
                            this.exportPage(page, page);
                        }
                    } else {
                        this.pageHeight = this.jasperPrint.getPageHeight() * (this.endPageIndex - this.startPageIndex + 1);
                        JRBasePrintPage alterYAllPages = new JRBasePrintPage();
                        JRBasePrintPage allPages = new JRBasePrintPage();
                        List elements = null;
                        JRBasePrintElement alterYElement = null;
                        JRPrintElement element = null;
                        for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new JRException("Current thread interrupted.");
                            }
                            JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
                            elements = page.getElements();
                            if (elements == null || elements.size() <= 0) continue;
                            Iterator it = elements.iterator();
                            while (it.hasNext()) {
                                element = (JRPrintElement)it.next();
                                allPages.addElement(element);
                                alterYElement = new JRBasePrintElement();
                                alterYElement.setY(element.getY() + this.globalOffsetY + this.jasperPrint.getPageHeight() * pageIndex);
                                alterYAllPages.addElement(alterYElement);
                            }
                        }
                        this.sheet = this.workbook.createSheet(this.jasperPrint.getName());
                        this.exportPage(alterYAllPages, allPages);
                    }
                }
                ++this.reportIndex;
            }
            this.workbook.write(os);
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void exportPage(JRPrintPage alterYPage, JRPrintPage page) throws JRException {
        this.layoutGrid(alterYPage, page);
        int width = 0;
        for (int i = 1; i < this.xCuts.size(); ++i) {
            width = (Integer)this.xCuts.get(i) - (Integer)this.xCuts.get(i - 1);
            this.sheet.setColumnWidth((short)(i - 1), (short)(width * 43));
        }
        JRPrintElement element = null;
        HSSFCell emptyCell = null;
        for (int y = 0; y < this.grid.length; ++y) {
            if (this.isRowNotEmpty[y] || !this.isRemoveEmptySpace) {
                this.row = this.sheet.getRow((int)((short)y));
                if (this.row == null) {
                    this.row = this.sheet.createRow((int)((short)y));
                }
                int emptyCellColSpan = 0;
                int emptyCellWidth = 0;
                int lastRowHeight = this.grid[y][0].height;
                this.row.setHeightInPoints((float)((short)lastRowHeight));
                int x = 0;
                for (x = 0; x < this.grid[y].length; ++x) {
                    emptyCell = this.row.getCell((short)x);
                    if (emptyCell == null) {
                        emptyCell = this.row.createCell((short)x);
                        emptyCell.setCellStyle(this.emptyCellStyle);
                    }
                    if (this.grid[y][x].element != null) {
                        if (emptyCellColSpan > 0) {
                            if (emptyCellColSpan > 1) {
                                // empty if block
                            }
                            emptyCellColSpan = 0;
                            emptyCellWidth = 0;
                        }
                        if ((element = this.grid[y][x].element) instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)element, this.grid[y][x], x, y);
                        } else if (element instanceof JRPrintRectangle) {
                            this.exportRectangle(element, this.grid[y][x], x, y);
                        } else if (element instanceof JRPrintEllipse) {
                            this.exportRectangle(element, this.grid[y][x], x, y);
                        } else if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, this.grid[y][x], x, y);
                        }
                        x += this.grid[y][x].colSpan - 1;
                        continue;
                    }
                    ++emptyCellColSpan;
                    emptyCellWidth += this.grid[y][x].width;
                }
                if (emptyCellColSpan > 0 && emptyCellColSpan <= 1) continue;
            }
            this.row = this.sheet.getRow((int)((short)y));
            if (this.row == null) {
                this.row = this.sheet.createRow((int)((short)y));
            }
            this.row.setHeight((short)0);
            for (int x = 0; x < this.grid[y].length; ++x) {
                emptyCell = this.row.getCell((short)x);
                if (emptyCell != null) continue;
                emptyCell = this.row.createCell((short)x);
                emptyCell.setCellStyle(this.emptyCellStyle);
            }
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int x, int y) {
        if (gridCell.colSpan > 1 || gridCell.rowSpan > 1) {
            this.sheet.addMergedRegion(new Region(y, (short)x, y + gridCell.rowSpan - 1, (short)(x + gridCell.colSpan - 1)));
        }
        short forecolor = JRXlsExporter.getNearestColor(line.getForecolor()).getIndex();
        HSSFFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor);
        HSSFCellStyle cellStyle = this.getLoadedCellStyle((short)1, forecolor, (short)1, (short)0, (short)0, cellFont, (short)0, forecolor, (short)0, forecolor, (short)0, forecolor, (short)0, forecolor);
        this.cell = this.row.createCell((short)x);
        this.cell.setEncoding((short)1);
        this.cell.setCellValue("");
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportRectangle(JRPrintElement element, JRExporterGridCell gridCell, int x, int y) {
        if (gridCell.colSpan > 1 || gridCell.rowSpan > 1) {
            this.sheet.addMergedRegion(new Region(y, (short)x, y + gridCell.rowSpan - 1, (short)(x + gridCell.colSpan - 1)));
        }
        short forecolor = JRXlsExporter.getNearestColor(element.getForecolor()).getIndex();
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (element.getMode() == 1) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(element.getBackcolor()).getIndex();
        }
        HSSFFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor);
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, cellFont, (short)0, backcolor, (short)0, backcolor, (short)0, backcolor, (short)0, backcolor);
        this.cell = this.row.createCell((short)x);
        this.cell.setEncoding((short)1);
        this.cell.setCellValue("");
        this.cell.setCellStyle(cellStyle);
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(null, text);
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(null, 0, text.length()));
            }
        }
        return styledText;
    }

    protected void exportText(JRPrintText textElement, JRExporterGridCell gridCell, int x, int y) {
        JRStyledText styledText = this.getStyledText(textElement);
        if (styledText == null) {
            return;
        }
        JRFont font = textElement.getFont();
        if (font == null) {
            font = this.getDefaultFont();
        }
        short forecolor = JRXlsExporter.getNearestColor(textElement.getForecolor()).getIndex();
        HSSFFont cellFont = this.getLoadedFont(font, forecolor);
        short horizontalAlignment = 1;
        short verticalAlignment = 1;
        short rotation = 0;
        block1 : switch (textElement.getRotation()) {
            case 1: {
                rotation = 90;
                switch (textElement.getTextAlignment()) {
                    case 1: {
                        verticalAlignment = 2;
                        break;
                    }
                    case 2: {
                        verticalAlignment = 1;
                        break;
                    }
                    case 3: {
                        verticalAlignment = 0;
                        break;
                    }
                    case 4: {
                        verticalAlignment = 3;
                        break;
                    }
                    default: {
                        verticalAlignment = 2;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        horizontalAlignment = 1;
                        break block1;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break block1;
                    }
                    case 3: {
                        horizontalAlignment = 3;
                        break block1;
                    }
                }
                horizontalAlignment = 1;
                break;
            }
            case 2: {
                rotation = -90;
                switch (textElement.getTextAlignment()) {
                    case 1: {
                        verticalAlignment = 0;
                        break;
                    }
                    case 2: {
                        verticalAlignment = 1;
                        break;
                    }
                    case 3: {
                        verticalAlignment = 2;
                        break;
                    }
                    case 4: {
                        verticalAlignment = 3;
                        break;
                    }
                    default: {
                        verticalAlignment = 0;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        horizontalAlignment = 3;
                        break block1;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break block1;
                    }
                    case 3: {
                        horizontalAlignment = 1;
                        break block1;
                    }
                }
                horizontalAlignment = 3;
                break;
            }
            default: {
                rotation = 0;
                switch (textElement.getTextAlignment()) {
                    case 1: {
                        horizontalAlignment = 1;
                        break;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break;
                    }
                    case 3: {
                        horizontalAlignment = 3;
                        break;
                    }
                    case 4: {
                        horizontalAlignment = 5;
                        break;
                    }
                    default: {
                        horizontalAlignment = 1;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        verticalAlignment = 0;
                        break block1;
                    }
                    case 2: {
                        verticalAlignment = 1;
                        break block1;
                    }
                    case 3: {
                        verticalAlignment = 2;
                        break block1;
                    }
                }
                verticalAlignment = 0;
            }
        }
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (textElement.getMode() == 1) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(textElement.getBackcolor()).getIndex();
        }
        short topBorder = 0;
        short topBorderColor = backcolor;
        short leftBorder = 0;
        short leftBorderColor = backcolor;
        short bottomBorder = 0;
        short bottomBorderColor = backcolor;
        short rightBorder = 0;
        short rightBorderColor = backcolor;
        if (textElement.getBox() != null) {
            topBorder = JRXlsExporter.getBorder(textElement.getBox().getTopBorder());
            topBorderColor = JRXlsExporter.getNearestColor(textElement.getBox().getTopBorderColor() == null ? textElement.getForecolor() : textElement.getBox().getTopBorderColor()).getIndex();
            leftBorder = JRXlsExporter.getBorder(textElement.getBox().getLeftBorder());
            leftBorderColor = JRXlsExporter.getNearestColor(textElement.getBox().getLeftBorderColor() == null ? textElement.getForecolor() : textElement.getBox().getLeftBorderColor()).getIndex();
            bottomBorder = JRXlsExporter.getBorder(textElement.getBox().getBottomBorder());
            bottomBorderColor = JRXlsExporter.getNearestColor(textElement.getBox().getBottomBorderColor() == null ? textElement.getForecolor() : textElement.getBox().getBottomBorderColor()).getIndex();
            rightBorder = JRXlsExporter.getBorder(textElement.getBox().getRightBorder());
            rightBorderColor = JRXlsExporter.getNearestColor(textElement.getBox().getRightBorderColor() == null ? textElement.getForecolor() : textElement.getBox().getRightBorderColor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, cellFont, topBorder, topBorderColor, leftBorder, leftBorderColor, bottomBorder, bottomBorderColor, rightBorder, rightBorderColor);
        if (gridCell.colSpan > 1 || gridCell.rowSpan > 1) {
            this.sheet.addMergedRegion(new Region(y, (short)x, y + gridCell.rowSpan - 1, (short)(x + gridCell.colSpan - 1)));
            for (int i = 0; i < gridCell.rowSpan; ++i) {
                HSSFRow spanRow = this.sheet.getRow(y + i);
                if (spanRow == null) {
                    spanRow = this.sheet.createRow(y + i);
                }
                for (int j = 0; j < gridCell.colSpan; ++j) {
                    HSSFCell spanCell = spanRow.getCell((short)(x + j));
                    if (spanCell == null) {
                        spanCell = spanRow.createCell((short)(x + j));
                    }
                    spanCell.setCellStyle(cellStyle);
                }
            }
        }
        this.cell = this.row.createCell((short)x);
        this.cell.setEncoding((short)1);
        if (this.isAutoDetectCellType) {
            try {
                this.cell.setCellValue(Double.parseDouble(styledText.getText()));
            }
            catch (NumberFormatException e) {
                this.cell.setCellValue(styledText.getText());
            }
        } else {
            this.cell.setCellValue(styledText.getText());
        }
        this.cell.setCellStyle(cellStyle);
    }

    protected void layoutGrid(JRPrintPage alterYPage, JRPrintPage page) {
        this.xCuts = new ArrayList();
        this.yCuts = new ArrayList();
        this.xCuts.add(new Integer(0));
        this.xCuts.add(new Integer(this.jasperPrint.getPageWidth()));
        this.yCuts.add(new Integer(0));
        this.yCuts.add(new Integer(this.pageHeight));
        Integer x = null;
        Integer y = null;
        JRPrintElement alterYElement = null;
        JRPrintElement element = null;
        List alterYElems = alterYPage.getElements();
        List elems = page.getElements();
        for (int i = 0; i < elems.size(); ++i) {
            alterYElement = (JRPrintElement)alterYElems.get(i);
            element = (JRPrintElement)elems.get(i);
            if (element instanceof JRPrintImage) continue;
            x = new Integer(element.getX() + this.globalOffsetX);
            if (!this.xCuts.contains(x)) {
                this.xCuts.add(x);
            }
            if (!this.xCuts.contains(x = new Integer(element.getX() + this.globalOffsetX + element.getWidth()))) {
                this.xCuts.add(x);
            }
            if (!this.yCuts.contains(y = new Integer(alterYElement.getY()))) {
                this.yCuts.add(y);
            }
            if (this.yCuts.contains(y = new Integer(alterYElement.getY() + element.getHeight()))) continue;
            this.yCuts.add(y);
        }
        Collections.sort(this.xCuts);
        Collections.sort(this.yCuts);
        int xCellCount = this.xCuts.size() - 1;
        int yCellCount = this.yCuts.size() - 1;
        this.grid = new JRExporterGridCell[yCellCount][xCellCount];
        this.isRowNotEmpty = new boolean[yCellCount];
        for (int j = 0; j < yCellCount; ++j) {
            for (int i = 0; i < xCellCount; ++i) {
                this.grid[j][i] = new JRExporterGridCell(null, (Integer)this.xCuts.get(i + 1) - (Integer)this.xCuts.get(i), (Integer)this.yCuts.get(j + 1) - (Integer)this.yCuts.get(j), 1, 1);
            }
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int xi = 0;
        int yi = 0;
        boolean isOverlap = false;
        for (int i = elems.size() - 1; i >= 0; --i) {
            alterYElement = (JRPrintElement)alterYElems.get(i);
            element = (JRPrintElement)elems.get(i);
            if (element instanceof JRPrintImage) continue;
            x1 = this.xCuts.indexOf(new Integer(element.getX() + this.globalOffsetX));
            y1 = this.yCuts.indexOf(new Integer(alterYElement.getY()));
            x2 = this.xCuts.indexOf(new Integer(element.getX() + this.globalOffsetX + element.getWidth()));
            y2 = this.yCuts.indexOf(new Integer(alterYElement.getY() + element.getHeight()));
            isOverlap = false;
            for (yi = y1; yi < y2 && !isOverlap; ++yi) {
                for (xi = x1; xi < x2 && !isOverlap; ++xi) {
                    if (this.grid[yi][xi].element == null) continue;
                    isOverlap = true;
                }
            }
            if (isOverlap) continue;
            for (yi = y1; yi < y2; ++yi) {
                for (xi = x1; xi < x2; ++xi) {
                    this.grid[yi][xi] = JRExporterGridCell.OCCUPIED_CELL;
                }
                this.isRowNotEmpty[yi] = true;
            }
            if (x2 - x1 == 0 || y2 - y1 == 0) continue;
            this.grid[y1][x1] = new JRExporterGridCell(element, element.getWidth(), element.getHeight(), x2 - x1, y2 - y1);
        }
    }

    protected static HSSFColor getNearestColor(Color awtColor) {
        Set keys;
        HSSFColor color = null;
        Hashtable triplets = HSSFColor.getTripletHash();
        if (triplets != null && (keys = triplets.keySet()) != null && keys.size() > 0) {
            Object key = null;
            HSSFColor crtColor = null;
            short[] rgb = null;
            int diff = 0;
            int minDiff = 999;
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                key = it.next();
                crtColor = (HSSFColor)triplets.get(key);
                rgb = crtColor.getTriplet();
                diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                if (diff >= minDiff) continue;
                minDiff = diff;
                color = crtColor;
            }
        }
        return color;
    }

    protected HSSFFont getLoadedFont(JRFont font, short forecolor) {
        HSSFFont cellFont = null;
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            HSSFFont cf = null;
            for (int i = 0; i < this.loadedFonts.size(); ++i) {
                cf = (HSSFFont)this.loadedFonts.get(i);
                if (!cf.getFontName().equals(font.getFontName()) || cf.getColor() != forecolor || cf.getFontHeightInPoints() != (short)font.getSize() || !(cf.getUnderline() == 1 ? font.isUnderline() : !font.isUnderline()) || cf.getStrikeout() != font.isStrikeThrough() || !(cf.getBoldweight() == 700 ? font.isBold() : !font.isBold()) || cf.getItalic() != font.isItalic()) continue;
                cellFont = cf;
                break;
            }
        }
        if (cellFont == null) {
            cellFont = this.workbook.createFont();
            cellFont.setFontName(font.getFontName());
            cellFont.setColor(forecolor);
            cellFont.setFontHeightInPoints((short)font.getSize());
            if (font.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (font.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (font.isBold()) {
                cellFont.setBoldweight((short)700);
            }
            if (font.isItalic()) {
                cellFont.setItalic(true);
            }
            this.loadedFonts.add(cellFont);
        }
        return cellFont;
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, short topBorder, short topBorderColor, short leftBorder, short leftBorderColor, short bottomBorder, short bottomBorderColor, short rightBorder, short rightBorderColor) {
        HSSFCellStyle cellStyle = null;
        if (this.loadedCellStyles != null && this.loadedCellStyles.size() > 0) {
            HSSFCellStyle cs = null;
            for (int i = 0; i < this.loadedCellStyles.size(); ++i) {
                cs = (HSSFCellStyle)this.loadedCellStyles.get(i);
                if (cs.getFillPattern() != mode || cs.getFillForegroundColor() != backcolor || cs.getAlignment() != horizontalAlignment || cs.getVerticalAlignment() != verticalAlignment || cs.getRotation() != rotation || cs.getFontIndex() != font.getIndex() || cs.getBorderTop() != topBorder || cs.getTopBorderColor() != topBorderColor || cs.getBorderLeft() != leftBorder || cs.getLeftBorderColor() != leftBorderColor || cs.getBorderBottom() != bottomBorder || cs.getBottomBorderColor() != bottomBorderColor || cs.getBorderRight() != rightBorder || cs.getRightBorderColor() != rightBorderColor) continue;
                cellStyle = cs;
                break;
            }
        }
        if (cellStyle == null) {
            cellStyle = this.workbook.createCellStyle();
            cellStyle.setFillForegroundColor(backcolor);
            cellStyle.setFillPattern(mode);
            cellStyle.setAlignment(horizontalAlignment);
            cellStyle.setVerticalAlignment(verticalAlignment);
            cellStyle.setRotation(rotation);
            cellStyle.setFont(font);
            cellStyle.setWrapText(true);
            cellStyle.setBorderTop(topBorder);
            cellStyle.setTopBorderColor(topBorderColor);
            cellStyle.setBorderLeft(leftBorder);
            cellStyle.setLeftBorderColor(leftBorderColor);
            cellStyle.setBorderBottom(bottomBorder);
            cellStyle.setBottomBorderColor(bottomBorderColor);
            cellStyle.setBorderRight(rightBorder);
            cellStyle.setRightBorderColor(rightBorderColor);
            this.loadedCellStyles.add(cellStyle);
        }
        return cellStyle;
    }

    private static short getBorder(byte pen) {
        short border = 0;
        switch (pen) {
            case 4: {
                border = 3;
                break;
            }
            case 3: {
                border = 5;
                break;
            }
            case 2: {
                border = 5;
                break;
            }
            case 5: {
                border = 1;
                break;
            }
            case 0: {
                border = 0;
                break;
            }
            default: {
                border = 2;
            }
        }
        return border;
    }
}

