/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class JRCsvExporter
extends JRAbstractExporter {
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected String delimiter = null;
    protected String recordDelimiter = null;
    protected Writer writer = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected JRExporterGridCell[][] grid = null;
    protected boolean[] isRowUsed = null;
    protected boolean[] isColUsed = null;
    protected List xCuts = null;
    protected List yCuts = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportReport() throws JRException {
        StringBuffer sb;
        String encoding;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        if (!this.isModeBatch) {
            this.setPageRange();
        }
        if ((encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING)) == null) {
            encoding = "ISO-8859-1";
        }
        this.delimiter = (String)this.parameters.get(JRCsvExporterParameter.FIELD_DELIMITER);
        if (this.delimiter == null) {
            this.delimiter = ",";
        }
        this.recordDelimiter = (String)this.parameters.get(JRCsvExporterParameter.RECORD_DELIMITER);
        if (this.recordDelimiter == null) {
            this.recordDelimiter = "\n";
        }
        if ((sb = (StringBuffer)this.parameters.get(JRXmlExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
            try {
                try {
                    this.writer = new StringWriter();
                    this.exportReportToWriter();
                    sb.append(this.writer.toString());
                }
                catch (IOException e) {
                    throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), e);
                }
                Object var5_3 = null;
                if (this.writer == null) return;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (this.writer == null) throw throwable;
                try {
                    this.writer.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            this.writer.close();
            return;
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
                return;
            }
            catch (IOException e) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
            }
        }
        OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            try {
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportReportToWriter();
                return;
            }
            catch (IOException e) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), e);
            }
        }
        File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (fileName == null) throw new JRException("No output specified for the exporter.");
            destFile = new File(fileName);
        }
        try {
            try {
                os = new FileOutputStream(destFile);
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), e);
            }
            Object var8_15 = null;
            if (this.writer == null) return;
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            if (this.writer == null) throw throwable;
            try {
                this.writer.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        this.writer.close();
        return;
    }

    protected void exportReportToWriter() throws JRException, IOException {
        for (int reportIndex = 0; reportIndex < this.jasperPrintList.size(); ++reportIndex) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(reportIndex);
            List pages = this.jasperPrint.getPages();
            if (pages == null || pages.size() <= 0) continue;
            if (this.isModeBatch) {
                this.startPageIndex = 0;
                this.endPageIndex = pages.size() - 1;
            }
            for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                JRPrintPage page = (JRPrintPage)pages.get(i);
                this.exportPage(page);
            }
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.layoutGrid(page);
        StringBuffer rowbuffer = null;
        JRPrintElement element = null;
        String text = null;
        boolean isFirstColumn = true;
        for (int y = 0; y < this.grid.length; ++y) {
            rowbuffer = new StringBuffer();
            if (!this.isRowUsed[y]) continue;
            isFirstColumn = true;
            for (int x = 0; x < this.grid[y].length; ++x) {
                if (this.grid[y][x].element != null) {
                    element = this.grid[y][x].element;
                    if (!(element instanceof JRPrintText)) continue;
                    JRStyledText styledText = this.getStyledText((JRPrintText)element);
                    text = styledText == null ? "" : styledText.getText();
                    if (!isFirstColumn) {
                        rowbuffer.append(this.delimiter);
                    }
                    rowbuffer.append(this.prepareText(text));
                    isFirstColumn = false;
                    continue;
                }
                if (!this.isColUsed[x]) continue;
                if (!isFirstColumn) {
                    rowbuffer.append(this.delimiter);
                }
                isFirstColumn = false;
            }
            if (rowbuffer.length() <= 0) continue;
            this.writer.write(rowbuffer.toString());
            this.writer.write(this.recordDelimiter);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void layoutGrid(JRPrintPage page) {
        this.xCuts = new ArrayList();
        this.yCuts = new ArrayList();
        this.xCuts.add(new Integer(0));
        this.xCuts.add(new Integer(this.jasperPrint.getPageWidth()));
        this.yCuts.add(new Integer(0));
        this.yCuts.add(new Integer(this.jasperPrint.getPageHeight()));
        Integer x = null;
        Integer y = null;
        List elems = page.getElements();
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            JRPrintElement element = (JRPrintElement)it.next();
            if (!(element instanceof JRPrintText)) continue;
            x = new Integer(element.getX() + this.globalOffsetX);
            if (!this.xCuts.contains(x)) {
                this.xCuts.add(x);
            }
            if (!this.xCuts.contains(x = new Integer(element.getX() + this.globalOffsetX + element.getWidth()))) {
                this.xCuts.add(x);
            }
            if (!this.yCuts.contains(y = new Integer(element.getY() + this.globalOffsetY))) {
                this.yCuts.add(y);
            }
            if (this.yCuts.contains(y = new Integer(element.getY() + this.globalOffsetY + element.getHeight()))) continue;
            this.yCuts.add(y);
        }
        Collections.sort(this.xCuts);
        Collections.sort(this.yCuts);
        int xCellCount = this.xCuts.size() - 1;
        int yCellCount = this.yCuts.size() - 1;
        this.grid = new JRExporterGridCell[yCellCount][xCellCount];
        this.isRowUsed = new boolean[yCellCount];
        this.isColUsed = new boolean[xCellCount];
        for (int j = 0; j < yCellCount; ++j) {
            for (int i = 0; i < xCellCount; ++i) {
                this.grid[j][i] = new JRExporterGridCell(null, (Integer)this.xCuts.get(i + 1) - (Integer)this.xCuts.get(i), (Integer)this.yCuts.get(j + 1) - (Integer)this.yCuts.get(j), 1, 1);
            }
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        Iterator it2 = elems.iterator();
        while (it2.hasNext()) {
            JRPrintElement element = (JRPrintElement)it2.next();
            if (!(element instanceof JRPrintText)) continue;
            x1 = this.xCuts.indexOf(new Integer(element.getX() + this.globalOffsetX));
            y1 = this.yCuts.indexOf(new Integer(element.getY() + this.globalOffsetY));
            x2 = this.xCuts.indexOf(new Integer(element.getX() + this.globalOffsetX + element.getWidth()));
            y2 = this.yCuts.indexOf(new Integer(element.getY() + this.globalOffsetY + element.getHeight()));
            this.grid[y1][x1].element = element;
            this.grid[y1][x1].width = element.getWidth();
            this.grid[y1][x1].height = element.getHeight();
            this.grid[y1][x1].colSpan = x2 - x1;
            this.grid[y1][x1].rowSpan = y2 - y1;
            this.isRowUsed[y1] = true;
            this.isColUsed[x1] = true;
        }
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(null, text);
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(null, 0, text.length()));
            }
        }
        return styledText;
    }

    protected String prepareText(String source) {
        String str = null;
        if (source != null) {
            boolean putQuotes = false;
            if (source.indexOf(this.delimiter) >= 0) {
                putQuotes = true;
            }
            StringBuffer sbuffer = new StringBuffer();
            StringTokenizer tkzer = new StringTokenizer(source, ",\"\n", true);
            String token = null;
            while (tkzer.hasMoreTokens()) {
                token = tkzer.nextToken();
                if (",".equals(token)) {
                    putQuotes = true;
                    sbuffer.append(",");
                    continue;
                }
                if ("\"".equals(token)) {
                    putQuotes = true;
                    sbuffer.append("\"\"");
                    continue;
                }
                if ("\n".equals(token)) {
                    sbuffer.append(" ");
                    continue;
                }
                sbuffer.append(token);
            }
            str = sbuffer.toString();
            if (putQuotes) {
                str = "\"" + str + "\"";
            }
        }
        return str;
    }
}

