/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

class PdfCopyFieldsImp
extends PdfWriter {
    ArrayList readers = new ArrayList();
    HashMap readers2intrefs = new HashMap();
    HashMap pages2intrefs = new HashMap();
    HashMap visited = new HashMap();
    ArrayList fields = new ArrayList();
    RandomAccessFileOrArray file;
    HashMap fieldTree = new HashMap();
    ArrayList pageRefs = new ArrayList();
    ArrayList pageDics = new ArrayList();
    PdfDictionary resources = new PdfDictionary();
    PdfDictionary form;
    boolean closing = false;
    protected static final HashMap widgetKeys = new HashMap();
    protected static final HashMap fieldKeys = new HashMap();

    PdfCopyFieldsImp(OutputStream outputStream) throws DocumentException, IOException {
        this(outputStream, '\u0000');
    }

    PdfCopyFieldsImp(OutputStream outputStream, char c) throws DocumentException, IOException {
        super(new PdfDocument(), outputStream);
        this.pdf.addWriter(this);
        if (c != '\u0000') {
            super.setPdfVersion(c);
        }
        Document document = new Document();
        document.addDocListener(this.pdf);
        document.open();
    }

    void addDocument(PdfReader pdfReader) throws DocumentException {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            pdfReader = new PdfReader(pdfReader);
        } else {
            if (pdfReader.isTampered()) {
                throw new DocumentException("The document was reused.");
            }
            pdfReader.consolidateNamedDestinations();
            pdfReader.setTampered(true);
        }
        this.readers2intrefs.put(pdfReader, new IntHashtable());
        this.readers.add(pdfReader);
        int n = pdfReader.getNumberOfPages();
        IntHashtable intHashtable = new IntHashtable();
        for (int i = 1; i <= n; ++i) {
            intHashtable.put(pdfReader.getPageOrigRef(i).getNumber(), 1);
        }
        this.pages2intrefs.put(pdfReader, intHashtable);
        this.visited.put(pdfReader, new IntHashtable());
        this.fields.add(pdfReader.getAcroFields());
    }

    void propagate(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference, boolean bl) throws IOException {
        if (pdfObject == null) {
            return;
        }
        if (pdfObject instanceof PdfIndirectReference) {
            return;
        }
        switch (pdfObject.type()) {
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    PdfName pdfName = (PdfName)iterator.next();
                    if (bl && (pdfName.equals(PdfName.PARENT) || pdfName.equals(PdfName.KIDS))) continue;
                    PdfObject pdfObject2 = pdfDictionary.get(pdfName);
                    if (pdfObject2 != null && pdfObject2.isIndirect()) {
                        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject2;
                        if (this.setVisited(pRIndirectReference) || this.isPage(pRIndirectReference)) continue;
                        PdfIndirectReference pdfIndirectReference2 = this.getNewReference(pRIndirectReference);
                        this.propagate(PdfReader.getPdfObject(pRIndirectReference), pdfIndirectReference2, bl);
                        continue;
                    }
                    this.propagate(pdfObject2, null, bl);
                }
                break;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                PdfArray pdfArray = new PdfArray();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    PdfObject pdfObject3 = (PdfObject)iterator.next();
                    if (pdfObject3 != null && pdfObject3.isIndirect()) {
                        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject3;
                        if (this.isVisited(pRIndirectReference) || this.isPage(pRIndirectReference)) continue;
                        PdfIndirectReference pdfIndirectReference3 = this.getNewReference(pRIndirectReference);
                        this.propagate(PdfReader.getPdfObject(pRIndirectReference), pdfIndirectReference3, bl);
                        continue;
                    }
                    this.propagate(pdfObject3, null, bl);
                }
                break;
            }
            case 10: {
                throw new RuntimeException("Reference pointing to reference.");
            }
        }
    }

    protected PdfArray branchForm(HashMap hashMap, PdfIndirectReference pdfIndirectReference) throws IOException {
        PdfArray pdfArray = new PdfArray();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = hashMap.get(string);
            PdfIndirectReference pdfIndirectReference2 = this.getPdfIndirectReference();
            PdfDictionary pdfDictionary = new PdfDictionary();
            if (pdfIndirectReference != null) {
                pdfDictionary.put(PdfName.PARENT, pdfIndirectReference);
            }
            pdfDictionary.put(PdfName.T, new PdfString(string, "UnicodeBig"));
            if (v instanceof HashMap) {
                pdfDictionary.put(PdfName.KIDS, this.branchForm((HashMap)v, pdfIndirectReference2));
                pdfArray.add(pdfIndirectReference2);
                this.addToBody((PdfObject)pdfDictionary, pdfIndirectReference2);
                continue;
            }
            ArrayList arrayList = (ArrayList)v;
            pdfDictionary.mergeDifferent((PdfDictionary)arrayList.get(0));
            if (arrayList.size() == 3) {
                pdfDictionary.mergeDifferent((PdfDictionary)arrayList.get(2));
                int n = (Integer)arrayList.get(1);
                PdfDictionary pdfDictionary2 = (PdfDictionary)this.pageDics.get(n - 1);
                PdfArray pdfArray2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ANNOTS));
                if (pdfArray2 == null) {
                    pdfArray2 = new PdfArray();
                    pdfDictionary2.put(PdfName.ANNOTS, pdfArray2);
                }
                pdfArray2.add(pdfIndirectReference2);
            } else {
                PdfArray pdfArray3 = new PdfArray();
                for (int i = 1; i < arrayList.size(); i += 2) {
                    int n = (Integer)arrayList.get(i);
                    PdfDictionary pdfDictionary3 = (PdfDictionary)this.pageDics.get(n - 1);
                    PdfArray pdfArray4 = (PdfArray)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.ANNOTS));
                    if (pdfArray4 == null) {
                        pdfArray4 = new PdfArray();
                        pdfDictionary3.put(PdfName.ANNOTS, pdfArray4);
                    }
                    PdfDictionary pdfDictionary4 = new PdfDictionary();
                    pdfDictionary4.merge((PdfDictionary)arrayList.get(i + 1));
                    pdfDictionary4.put(PdfName.PARENT, pdfIndirectReference2);
                    PdfIndirectReference pdfIndirectReference3 = this.addToBody(pdfDictionary4).getIndirectReference();
                    pdfArray4.add(pdfIndirectReference3);
                    pdfArray3.add(pdfIndirectReference3);
                    this.propagate(pdfDictionary4, null, false);
                }
                pdfDictionary.put(PdfName.KIDS, pdfArray3);
            }
            pdfArray.add(pdfIndirectReference2);
            this.addToBody((PdfObject)pdfDictionary, pdfIndirectReference2);
            this.propagate(pdfDictionary, null, false);
        }
        return pdfArray;
    }

    protected void createAcroForms() throws IOException {
        if (this.fieldTree.size() == 0) {
            return;
        }
        this.form = new PdfDictionary();
        this.form.put(PdfName.DR, this.resources);
        this.form.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        this.form.put(PdfName.FIELDS, this.branchForm(this.fieldTree, null));
    }

    public void close() {
        if (this.closing) {
            super.close();
            return;
        }
        this.closing = true;
        try {
            this.closeIt();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeIt() throws DocumentException, IOException {
        PdfIndirectReference pdfIndirectReference;
        Object object;
        int n;
        PdfReader pdfReader;
        int n2;
        for (n2 = 0; n2 < this.readers.size(); ++n2) {
            ((PdfReader)this.readers.get(n2)).removeFields();
        }
        for (n2 = 0; n2 < this.readers.size(); ++n2) {
            pdfReader = (PdfReader)this.readers.get(n2);
            for (n = 1; n <= pdfReader.getNumberOfPages(); ++n) {
                this.pageRefs.add(this.getNewReference(pdfReader.getPageOrigRef(n)));
                this.pageDics.add(pdfReader.getPageN(n));
            }
        }
        this.mergeFields();
        this.createAcroForms();
        for (n2 = 0; n2 < this.readers.size(); ++n2) {
            pdfReader = (PdfReader)this.readers.get(n2);
            for (n = 1; n <= pdfReader.getNumberOfPages(); ++n) {
                object = pdfReader.getPageN(n);
                PdfIndirectReference pdfIndirectReference2 = this.getNewReference(pdfReader.getPageOrigRef(n));
                pdfIndirectReference = this.root.addPageRef(pdfIndirectReference2);
                ((PdfDictionary)object).put(PdfName.PARENT, pdfIndirectReference);
                this.propagate((PdfObject)object, pdfIndirectReference2, false);
            }
        }
        Iterator iterator = this.readers2intrefs.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                pdfReader = (PdfReader)iterator.next();
                this.file = pdfReader.getSafeFile();
                this.file.reOpen();
                IntHashtable intHashtable = (IntHashtable)this.readers2intrefs.get(pdfReader);
                object = intHashtable.toOrderedKeys();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    pdfIndirectReference = new PRIndirectReference(pdfReader, (int)object[i]);
                    this.addToBody(PdfReader.getPdfObject(pdfIndirectReference), intHashtable.get((int)object[i]));
                }
                this.file.close();
            }
            finally {
                try {
                    this.file.close();
                }
                catch (Exception exception) {}
            }
        }
        this.pdf.close();
    }

    void addPageOffsetToField(HashMap hashMap, int n) {
        if (n == 0) {
            return;
        }
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList = ((AcroFields.Item)iterator.next()).page;
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.set(i, new Integer((Integer)arrayList.get(i) + n));
            }
        }
    }

    void createWidgets(ArrayList arrayList, AcroFields.Item item) {
        for (int i = 0; i < item.merged.size(); ++i) {
            arrayList.add(item.page.get(i));
            PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(i);
            PdfObject pdfObject = pdfDictionary.get(PdfName.DR);
            if (pdfObject != null) {
                PdfFormField.mergeResources(this.resources, (PdfDictionary)pdfObject);
            }
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            Iterator iterator = pdfDictionary.getKeys().iterator();
            while (iterator.hasNext()) {
                PdfName pdfName = (PdfName)iterator.next();
                if (!widgetKeys.containsKey(pdfName)) continue;
                pdfDictionary2.put(pdfName, pdfDictionary.get(pdfName));
            }
            arrayList.add(pdfDictionary2);
        }
    }

    void mergeField(String string, AcroFields.Item item) {
        Object object;
        String string2;
        HashMap hashMap;
        block15: {
            hashMap = this.fieldTree;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            while (true) {
                string2 = stringTokenizer.nextToken();
                object = hashMap.get(string2);
                if (!stringTokenizer.hasMoreTokens()) break block15;
                if (object == null) {
                    object = new HashMap();
                    hashMap.put(string2, object);
                    hashMap = (HashMap)object;
                    continue;
                }
                if (!(object instanceof HashMap)) break;
                hashMap = (HashMap)object;
            }
            return;
        }
        if (object instanceof HashMap) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(0);
        if (object == null) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            Object object2 = pdfDictionary.getKeys().iterator();
            while (object2.hasNext()) {
                PdfName pdfName = (PdfName)object2.next();
                if (!fieldKeys.containsKey(pdfName)) continue;
                pdfDictionary2.put(pdfName, pdfDictionary.get(pdfName));
            }
            object2 = new ArrayList();
            ((ArrayList)object2).add(pdfDictionary2);
            this.createWidgets((ArrayList)object2, item);
            hashMap.put(string2, object2);
        } else {
            ArrayList arrayList = (ArrayList)object;
            PdfDictionary pdfDictionary3 = (PdfDictionary)arrayList.get(0);
            PdfName pdfName = (PdfName)pdfDictionary3.get(PdfName.FT);
            PdfName pdfName2 = (PdfName)pdfDictionary.get(PdfName.FT);
            if (pdfName == null || !pdfName.equals(pdfName2)) {
                return;
            }
            int n = 0;
            PdfObject pdfObject = pdfDictionary3.get(PdfName.FF);
            if (pdfObject != null && pdfObject.isNumber()) {
                n = ((PdfNumber)pdfObject).intValue();
            }
            int n2 = 0;
            PdfObject pdfObject2 = pdfDictionary.get(PdfName.FF);
            if (pdfObject2 != null && pdfObject2.isNumber()) {
                n2 = ((PdfNumber)pdfObject2).intValue();
            }
            if (pdfName.equals(PdfName.BTN)) {
                if (((n ^ n2) & 0x10000) != 0) {
                    return;
                }
                if ((n & 0x10000) == 0 && ((n ^ n2) & 0x8000) != 0) {
                    return;
                }
            } else if (pdfName.equals(PdfName.CH) && ((n ^ n2) & 0x20000) != 0) {
                return;
            }
            this.createWidgets(arrayList, item);
        }
    }

    void mergeWithMaster(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.mergeField(string, (AcroFields.Item)hashMap.get(string));
        }
    }

    void mergeFields() {
        int n = 0;
        for (int i = 0; i < this.fields.size(); ++i) {
            HashMap hashMap = ((AcroFields)this.fields.get(i)).getFields();
            this.addPageOffsetToField(hashMap, n);
            this.mergeWithMaster(hashMap);
            n += ((PdfReader)this.readers.get(i)).getNumberOfPages();
        }
    }

    public PdfIndirectReference getPageReference(int n) {
        return (PdfIndirectReference)this.pageRefs.get(n - 1);
    }

    protected PdfDictionary getCatalog(PdfIndirectReference pdfIndirectReference) {
        try {
            PdfDocument.PdfCatalog pdfCatalog = ((PdfDocument)this.document).getCatalog(pdfIndirectReference);
            if (this.form != null) {
                PdfIndirectReference pdfIndirectReference2 = this.addToBody(this.form).getIndirectReference();
                pdfCatalog.put(PdfName.ACROFORM, pdfIndirectReference2);
            }
            return pdfCatalog;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    protected PdfIndirectReference getNewReference(PRIndirectReference pRIndirectReference) {
        return new PdfIndirectReference(0, this.getNewObjectNumber(pRIndirectReference.getReader(), pRIndirectReference.getNumber(), 0));
    }

    protected int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        IntHashtable intHashtable = (IntHashtable)this.readers2intrefs.get(pdfReader);
        int n3 = intHashtable.get(n);
        if (n3 == 0) {
            n3 = this.getIndirectReferenceNumber();
            intHashtable.put(n, n3);
        }
        return n3;
    }

    protected boolean isVisited(PdfReader pdfReader, int n, int n2) {
        IntHashtable intHashtable = (IntHashtable)this.readers2intrefs.get(pdfReader);
        return intHashtable.containsKey(n);
    }

    protected boolean isVisited(PRIndirectReference pRIndirectReference) {
        IntHashtable intHashtable = (IntHashtable)this.visited.get(pRIndirectReference.getReader());
        return intHashtable.containsKey(pRIndirectReference.getNumber());
    }

    protected boolean setVisited(PRIndirectReference pRIndirectReference) {
        IntHashtable intHashtable = (IntHashtable)this.visited.get(pRIndirectReference.getReader());
        return intHashtable.put(pRIndirectReference.getNumber(), 1) != 0;
    }

    protected boolean isPage(PRIndirectReference pRIndirectReference) {
        IntHashtable intHashtable = (IntHashtable)this.pages2intrefs.get(pRIndirectReference.getReader());
        return intHashtable.containsKey(pRIndirectReference.getNumber());
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        return this.file;
    }

    static {
        Integer n = new Integer(1);
        widgetKeys.put(PdfName.SUBTYPE, n);
        widgetKeys.put(PdfName.CONTENTS, n);
        widgetKeys.put(PdfName.RECT, n);
        widgetKeys.put(PdfName.NM, n);
        widgetKeys.put(PdfName.M, n);
        widgetKeys.put(PdfName.F, n);
        widgetKeys.put(PdfName.BS, n);
        widgetKeys.put(PdfName.BORDER, n);
        widgetKeys.put(PdfName.AP, n);
        widgetKeys.put(PdfName.AS, n);
        widgetKeys.put(PdfName.C, n);
        widgetKeys.put(PdfName.A, n);
        widgetKeys.put(PdfName.STRUCTPARENT, n);
        widgetKeys.put(PdfName.OC, n);
        widgetKeys.put(PdfName.H, n);
        widgetKeys.put(PdfName.MK, n);
        widgetKeys.put(PdfName.DA, n);
        widgetKeys.put(PdfName.Q, n);
        fieldKeys.put(PdfName.AA, n);
        fieldKeys.put(PdfName.FT, n);
        fieldKeys.put(PdfName.TU, n);
        fieldKeys.put(PdfName.TM, n);
        fieldKeys.put(PdfName.FF, n);
        fieldKeys.put(PdfName.V, n);
        fieldKeys.put(PdfName.DV, n);
        fieldKeys.put(PdfName.DS, n);
        fieldKeys.put(PdfName.RV, n);
        fieldKeys.put(PdfName.OPT, n);
        fieldKeys.put(PdfName.MAXLEN, n);
        fieldKeys.put(PdfName.TI, n);
        fieldKeys.put(PdfName.I, n);
        fieldKeys.put(PdfName.LOCK, n);
        fieldKeys.put(PdfName.SV, n);
    }
}

