/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.library;

import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.library.AbstractLibraryObject;
import it.businesslogic.ireport.gui.library.LibraryTreeCellRenderer;
import it.businesslogic.ireport.gui.library.TreeTransfertHandler;
import it.businesslogic.ireport.gui.library.objects.PageNumberObject;
import it.businesslogic.ireport.gui.library.objects.PageXYObject;
import it.businesslogic.ireport.gui.library.objects.TotalObject;
import it.businesslogic.ireport.gui.library.objects.TotalPagesObject;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LibraryPanel
extends JPanel
implements LanguageChangedListener {
    DefaultMutableTreeNode fieldsNode = null;
    DefaultMutableTreeNode variablesNode = null;
    DefaultMutableTreeNode parametersNode = null;
    DefaultMutableTreeNode systemObjectsNode = null;
    JReportFrame jrf;
    private JTree jLibraryTree;
    private JScrollPane jScrollPane1;

    public LibraryPanel() {
        this.initComponents();
        this.jLibraryTree.setCellRenderer(new LibraryTreeCellRenderer());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Libs");
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        this.jLibraryTree.setModel(dtm);
        this.jLibraryTree.setDragEnabled(true);
        this.jLibraryTree.setRootVisible(false);
        this.jLibraryTree.setTransferHandler(new TreeTransfertHandler());
        this.jLibraryTree.expandPath(new TreePath(root));
        this.fieldsNode = new DefaultMutableTreeNode("Fields", true);
        root.add(this.fieldsNode);
        this.variablesNode = new DefaultMutableTreeNode("Variables", true);
        root.add(this.variablesNode);
        this.parametersNode = new DefaultMutableTreeNode("Parameters", true);
        root.add(this.parametersNode);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F5"), "refresh");
        this.getActionMap().put("refresh", new AbstractAction("refresh"){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.setJReportFrame(LibraryPanel.this.jrf);
            }
        });
        I18n.addOnLanguageChangedListener(this);
        this.loadSystemObjects();
        this.loadCustomObjects();
        this.updateLibraryObjects();
        this.languageChanged(null);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jLibraryTree = new JTree();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.jLibraryTree);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.fieldsNode.setUserObject(I18n.getString("gui.library.fields", "Fields"));
        this.variablesNode.setUserObject(I18n.getString("gui.library.variables", "Variables"));
        this.parametersNode.setUserObject(I18n.getString("gui.library.parameters", "Parameters"));
        this.jLibraryTree.updateUI();
    }

    public void setJReportFrame(JReportFrame jrf) {
        this.jrf = jrf;
        this.fieldsNode.removeAllChildren();
        this.parametersNode.removeAllChildren();
        this.variablesNode.removeAllChildren();
        if (jrf == null) {
            this.jLibraryTree.updateUI();
            return;
        }
        Enumeration e = jrf.getReport().getFields().elements();
        while (e.hasMoreElements()) {
            this.fieldsNode.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        e = jrf.getReport().getParameters().elements();
        while (e.hasMoreElements()) {
            this.parametersNode.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        e = jrf.getReport().getVariables().elements();
        while (e.hasMoreElements()) {
            this.variablesNode.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        this.jLibraryTree.updateUI();
    }

    private void loadCustomObjects() {
    }

    private void loadSystemObjects() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jLibraryTree.getModel().getRoot();
        root.add(new DefaultMutableTreeNode(new PageNumberObject()));
        root.add(new DefaultMutableTreeNode(new TotalPagesObject()));
        root.add(new DefaultMutableTreeNode(new PageXYObject()));
        root.add(new DefaultMutableTreeNode(new TotalObject()));
    }

    private void addLibraryObject(String folder, AbstractLibraryObject obj) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jLibraryTree.getModel().getRoot();
        if (folder == null || folder.length() == 0) {
            root.add(new DefaultMutableTreeNode(new PageNumberObject()));
        } else {
            Enumeration<TreeNode> enum_childrens = root.children();
            while (enum_childrens.hasMoreElements()) {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)enum_childrens.nextElement();
                if (!("" + dmtn.getUserObject()).equalsIgnoreCase(folder)) continue;
                dmtn.add(new DefaultMutableTreeNode(obj));
            }
        }
    }

    public void updateLibraryObjects() {
    }
}

