/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.CompatibilitySupport;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class CompatibilityDialog
extends JDialog {
    MainFrame mf = null;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel9;
    private JRadioButton jRadioButtonJR060;
    private JRadioButton jRadioButtonJR061;
    private JRadioButton jRadioButtonJR062;
    private JRadioButton jRadioButtonJR063;
    private JRadioButton jRadioButtonJR064;
    private JRadioButton jRadioButtonMostrecent;

    public CompatibilityDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.mf = (MainFrame)parent;
        this.initComponents();
        this.setSize(330, 253);
        this.load();
        Misc.centerFrame(this);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jRadioButtonJR060 = new JRadioButton();
        this.jRadioButtonJR061 = new JRadioButton();
        this.jRadioButtonJR062 = new JRadioButton();
        this.jRadioButtonJR063 = new JRadioButton();
        this.jRadioButtonJR064 = new JRadioButton();
        this.jRadioButtonMostrecent = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle("Compatibility options");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CompatibilityDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel9.setLayout(new GridBagLayout());
        this.jPanel9.setBorder(new TitledBorder(new EtchedBorder(), "JasperReports Version Compatibility", 0, 0, new Font("Dialog", 0, 11)));
        this.jPanel9.setMinimumSize(new Dimension(250, 150));
        this.jPanel9.setPreferredSize(new Dimension(250, 150));
        this.buttonGroup1.add(this.jRadioButtonJR060);
        this.jRadioButtonJR060.setFont(new Font("Arial", 0, 11));
        this.jRadioButtonJR060.setText("JasperReports 0.6.0");
        this.jRadioButtonJR060.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CompatibilityDialog.this.jRadioButtonJR060ItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel9.add((Component)this.jRadioButtonJR060, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonJR061);
        this.jRadioButtonJR061.setFont(new Font("Arial", 0, 11));
        this.jRadioButtonJR061.setText("JasperReports 0.6.1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel9.add((Component)this.jRadioButtonJR061, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonJR062);
        this.jRadioButtonJR062.setFont(new Font("Arial", 0, 11));
        this.jRadioButtonJR062.setText("JasperReports 0.6.2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel9.add((Component)this.jRadioButtonJR062, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonJR063);
        this.jRadioButtonJR063.setFont(new Font("Arial", 0, 11));
        this.jRadioButtonJR063.setText("JasperReports 0.6.3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel9.add((Component)this.jRadioButtonJR063, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonJR064);
        this.jRadioButtonJR064.setFont(new Font("Arial", 0, 11));
        this.jRadioButtonJR064.setText("JasperReports 0.6.4");
        this.jRadioButtonJR064.setActionCommand("JasperReports 0.6.4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel9.add((Component)this.jRadioButtonJR064, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonMostrecent);
        this.jRadioButtonMostrecent.setFont(new Font("Arial", 0, 11));
        this.jRadioButtonMostrecent.setSelected(true);
        this.jRadioButtonMostrecent.setText("Use the most recent version available");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel9.add((Component)this.jRadioButtonMostrecent, gridBagConstraints);
        this.jPanel1.add((Component)this.jPanel9, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(2));
        this.jButtonOk.setFont(new Font("Dialog", 0, 11));
        this.jButtonOk.setMnemonic('o');
        this.jButtonOk.setText("Ok");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CompatibilityDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButtonOk);
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CompatibilityDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void jRadioButtonJR060ItemStateChanged(ItemEvent evt) {
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.save();
        this.close();
    }

    private void closeDialog(WindowEvent evt) {
    }

    private void load() {
        if (this.mf == null || this.mf.getProperties() == null) {
            return;
        }
        Properties prop = this.mf.getProperties();
        try {
            this.jRadioButtonMostrecent.setSelected(CompatibilitySupport.version == 999999);
            this.jRadioButtonJR060.setSelected(CompatibilitySupport.version == 60);
            this.jRadioButtonJR061.setSelected(CompatibilitySupport.version == 61);
            this.jRadioButtonJR062.setSelected(CompatibilitySupport.version == 62);
            this.jRadioButtonJR063.setSelected(CompatibilitySupport.version == 63);
            this.jRadioButtonJR064.setSelected(CompatibilitySupport.version == 63);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void save() {
        if (this.mf == null || this.mf.getProperties() == null) {
            return;
        }
        Properties prop = this.mf.getProperties();
        try {
            int compatibility = 999999;
            if (this.jRadioButtonJR060.isSelected()) {
                compatibility = 60;
            }
            if (this.jRadioButtonJR061.isSelected()) {
                compatibility = 61;
            }
            if (this.jRadioButtonJR062.isSelected()) {
                compatibility = 62;
            }
            if (this.jRadioButtonJR063.isSelected()) {
                compatibility = 63;
            }
            if (this.jRadioButtonJR064.isSelected()) {
                compatibility = 63;
            }
            CompatibilitySupport.version = compatibility;
            prop.put("Compatibility", "" + compatibility);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new CompatibilityDialog((Frame)new JFrame(), true).show();
    }
}

