/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.IRFont;
import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.PdfEncoding;
import it.businesslogic.ireport.gui.JNumberComboBox;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.util.Misc;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class JRFontDialog
extends JDialog {
    private IReportFont iReportFont = null;
    private boolean init = false;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxBold;
    private JCheckBox jCheckBoxDefaultFont;
    private JCheckBox jCheckBoxItalic;
    private JCheckBox jCheckBoxPDFEmbedded;
    private JCheckBox jCheckBoxStrokeTrough;
    private JCheckBox jCheckBoxUnderline;
    private JComboBox jComboBoxFontName;
    private JComboBox jComboBoxPDFFontName;
    private JComboBox jComboBoxPdfEncoding;
    private JComboBox jComboBoxTTFFont;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel27;
    private JLabel jLabel32;
    private JLabel jLabelTTF;
    private JNumberComboBox jNumberComboBoxSize;
    private JPanel jPanelFont;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTextField jTextFieldReportFont;
    private int dialogResult;

    public JRFontDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(320, 344);
        Misc.centerFrame(this);
        this.jNumberComboBoxSize.addEntry("3", 3.0);
        this.jNumberComboBoxSize.addEntry("5", 5.0);
        this.jNumberComboBoxSize.addEntry("8", 8.0);
        this.jNumberComboBoxSize.addEntry("10", 10.0);
        this.jNumberComboBoxSize.addEntry("12", 12.0);
        this.jNumberComboBoxSize.addEntry("14", 14.0);
        this.jNumberComboBoxSize.addEntry("18", 18.0);
        this.jNumberComboBoxSize.addEntry("24", 24.0);
        this.jNumberComboBoxSize.addEntry("36", 36.0);
        this.jNumberComboBoxSize.addEntry("48", 48.0);
        this.jNumberComboBoxSize.setSelectedIndex(3);
        this.jComboBoxPDFFontName.addItem("Helvetica");
        this.jComboBoxPDFFontName.addItem("Helvetica-Bold");
        this.jComboBoxPDFFontName.addItem("Helvetica-BoldOblique");
        this.jComboBoxPDFFontName.addItem("Helvetica-Oblique");
        this.jComboBoxPDFFontName.addItem("Courier");
        this.jComboBoxPDFFontName.addItem("Courier-Bold");
        this.jComboBoxPDFFontName.addItem("Courier-BoldOblique");
        this.jComboBoxPDFFontName.addItem("Courier-Oblique");
        this.jComboBoxPDFFontName.addItem("Symbol");
        this.jComboBoxPDFFontName.addItem("Times-Roman");
        this.jComboBoxPDFFontName.addItem("Times-Bold");
        this.jComboBoxPDFFontName.addItem("Times-BoldItalic");
        this.jComboBoxPDFFontName.addItem("Times-Italic");
        this.jComboBoxPDFFontName.addItem("ZapfDingbats");
        this.jComboBoxPDFFontName.addItem("STSong-Light");
        this.jComboBoxPDFFontName.addItem("MHei-Medium");
        this.jComboBoxPDFFontName.addItem("MSung-Light");
        this.jComboBoxPDFFontName.addItem("HeiseiKakuGo-W5");
        this.jComboBoxPDFFontName.addItem("HeiseiMin-W3");
        this.jComboBoxPDFFontName.addItem("HYGoThic-Medium");
        this.jComboBoxPDFFontName.addItem("HYSMyeongJo-Medium");
        this.jComboBoxPDFFontName.addItem("External TTF font...");
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1250", "CP1250 (Central European)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1251", "CP1251 (Cyrillic)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1252", "CP1252 (Western European ANSI aka WinAnsi)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1253", "CP1253 (Greek)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1254", "CP1254 (Turkish)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1255", "CP1255 (Hebrew)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1256", "CP1256 (Arabic)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1257", "CP1257 (Baltic)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1258", "CP1258 (Vietnamese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-H", "UniGB-UCS2-H (Chinese Simplified)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-V", "UniGB-UCS2-V (Chinese Simplified)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-H", "UniCNS-UCS2-H (Chinese traditional)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-V", "UniCNS-UCS2-V (Chinese traditional)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-H", "UniJIS-UCS2-H (Japanese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-V", "UniJIS-UCS2-V (Japanese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-H (Japanese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-V", "UniJIS-UCS2-HW-V (Japanese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-H", "UniKS-UCS2-H (Korean)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-V", "UniKS-UCS2-V (Korean)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-H", "Identity-H (Unicode with horizontal writing)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-V", "Identity-V (Unicode with vertical writing)"));
        String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fontFamilies.length; ++i) {
            this.jComboBoxFontName.addItem(fontFamilies[i]);
        }
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanelFont = new JPanel();
        this.jLabel23 = new JLabel();
        this.jComboBoxPDFFontName = new JComboBox();
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jComboBoxFontName = new JComboBox();
        this.jNumberComboBoxSize = new JNumberComboBox();
        this.jLabel27 = new JLabel();
        this.jLabelTTF = new JLabel();
        this.jComboBoxTTFFont = new JComboBox();
        this.jCheckBoxBold = new JCheckBox();
        this.jCheckBoxItalic = new JCheckBox();
        this.jCheckBoxUnderline = new JCheckBox();
        this.jCheckBoxStrokeTrough = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.jCheckBoxPDFEmbedded = new JCheckBox();
        this.jComboBoxPdfEncoding = new JComboBox();
        this.jLabel32 = new JLabel();
        this.jTextFieldReportFont = new JTextField();
        this.jCheckBoxDefaultFont = new JCheckBox();
        this.jSeparator3 = new JSeparator();
        this.getContentPane().setLayout(null);
        this.setTitle("Add/modify parameter");
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRFontDialog.this.closeDialog(evt);
            }
        });
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonCancel);
        this.jButtonCancel.setBounds(232, 274, 70, 25);
        this.jButtonOK.setFont(new Font("Dialog", 0, 11));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonOK);
        this.jButtonOK.setBounds(152, 274, 70, 25);
        this.jPanelFont.setLayout(null);
        this.jLabel23.setFont(new Font("Dialog", 0, 11));
        this.jLabel23.setText("Report font");
        this.jPanelFont.add(this.jLabel23);
        this.jLabel23.setBounds(8, 8, 142, 15);
        this.jComboBoxPDFFontName.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxPDFFontName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jComboBoxPDFFontNameActionPerformed(evt);
            }
        });
        this.jPanelFont.add(this.jComboBoxPDFFontName);
        this.jComboBoxPDFFontName.setBounds(6, 106, 300, 22);
        this.jLabel24.setFont(new Font("Dialog", 0, 11));
        this.jLabel24.setText("Font name");
        this.jPanelFont.add(this.jLabel24);
        this.jLabel24.setBounds(8, 48, 220, 15);
        this.jLabel25.setFont(new Font("Dialog", 0, 11));
        this.jLabel25.setText("PDF font name");
        this.jPanelFont.add(this.jLabel25);
        this.jLabel25.setBounds(8, 90, 74, 15);
        this.jComboBoxFontName.setFont(new Font("Dialog", 0, 11));
        this.jPanelFont.add(this.jComboBoxFontName);
        this.jComboBoxFontName.setBounds(6, 64, 232, 22);
        this.jNumberComboBoxSize.setFont(new Font("Dialog", 0, 12));
        this.jPanelFont.add(this.jNumberComboBoxSize);
        this.jNumberComboBoxSize.setBounds(242, 64, 62, 22);
        this.jLabel27.setFont(new Font("Dialog", 0, 11));
        this.jLabel27.setText("Size");
        this.jPanelFont.add(this.jLabel27);
        this.jLabel27.setBounds(242, 48, 60, 15);
        this.jLabelTTF.setFont(new Font("Dialog", 0, 11));
        this.jLabelTTF.setText("TrueType font");
        this.jLabelTTF.setEnabled(false);
        this.jPanelFont.add(this.jLabelTTF);
        this.jLabelTTF.setBounds(8, 134, 142, 15);
        this.jComboBoxTTFFont.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxTTFFont.setEnabled(false);
        this.jPanelFont.add(this.jComboBoxTTFFont);
        this.jComboBoxTTFFont.setBounds(6, 150, 298, 22);
        this.jCheckBoxBold.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxBold.setText("Bold");
        this.jPanelFont.add(this.jCheckBoxBold);
        this.jCheckBoxBold.setBounds(8, 172, 100, 23);
        this.jCheckBoxItalic.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxItalic.setText("Italic");
        this.jPanelFont.add(this.jCheckBoxItalic);
        this.jCheckBoxItalic.setBounds(8, 192, 100, 23);
        this.jCheckBoxUnderline.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxUnderline.setText("Underline");
        this.jPanelFont.add(this.jCheckBoxUnderline);
        this.jCheckBoxUnderline.setBounds(120, 172, 100, 23);
        this.jCheckBoxStrokeTrough.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxStrokeTrough.setText("Strike Trough");
        this.jPanelFont.add(this.jCheckBoxStrokeTrough);
        this.jCheckBoxStrokeTrough.setBounds(120, 192, 100, 23);
        this.jPanelFont.add(this.jSeparator2);
        this.jSeparator2.setBounds(8, 220, 294, 4);
        this.jCheckBoxPDFEmbedded.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxPDFEmbedded.setText("PDF Embedded");
        this.jPanelFont.add(this.jCheckBoxPDFEmbedded);
        this.jCheckBoxPDFEmbedded.setBounds(8, 222, 100, 23);
        this.jComboBoxPdfEncoding.setEditable(true);
        this.jComboBoxPdfEncoding.setFont(new Font("Dialog", 0, 11));
        this.jPanelFont.add(this.jComboBoxPdfEncoding);
        this.jComboBoxPdfEncoding.setBounds(126, 238, 178, 22);
        this.jLabel32.setFont(new Font("Dialog", 0, 11));
        this.jLabel32.setText("PDF Encoding");
        this.jPanelFont.add(this.jLabel32);
        this.jLabel32.setBounds(126, 222, 110, 15);
        this.jPanelFont.add(this.jTextFieldReportFont);
        this.jTextFieldReportFont.setBounds(6, 24, 298, 20);
        this.jCheckBoxDefaultFont.setLabel("Default");
        this.jPanelFont.add(this.jCheckBoxDefaultFont);
        this.jCheckBoxDefaultFont.setBounds(8, 242, 59, 23);
        this.getContentPane().add(this.jPanelFont);
        this.jPanelFont.setBounds(0, 0, 312, 264);
        this.getContentPane().add(this.jSeparator3);
        this.jSeparator3.setBounds(8, 266, 294, 2);
        this.pack();
    }

    private void jComboBoxPDFFontNameActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        if (this.jComboBoxPDFFontName.getSelectedItem() == null || (this.jComboBoxPDFFontName.getSelectedItem() + "").equals("")) {
            return;
        }
        String fontName = "" + this.jComboBoxPDFFontName.getSelectedItem();
        if (fontName != null && fontName.equals("External TTF font...")) {
            this.jComboBoxTTFFont.setEnabled(true);
            this.jLabelTTF.setEnabled(true);
        } else {
            this.jComboBoxTTFFont.setEnabled(false);
            this.jLabelTTF.setEnabled(false);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldReportFont.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid report font name!", "Invalid report font name!", 2);
            return;
        }
        this.iReportFont = new IReportFont();
        this.iReportFont.setReportFont(this.jTextFieldReportFont.getText());
        this.iReportFont.setBold(this.jCheckBoxBold.isSelected());
        this.iReportFont.setDefaultFont(this.jCheckBoxDefaultFont.isSelected());
        this.iReportFont.setFontName("" + this.jComboBoxFontName.getSelectedItem());
        this.iReportFont.setFontSize((int)this.jNumberComboBoxSize.getValue());
        this.iReportFont.setItalic(this.jCheckBoxItalic.isSelected());
        this.iReportFont.setPDFFontName(this.jComboBoxFontName.getSelectedItem() + "");
        this.iReportFont.setPDFFontName(this.jComboBoxPDFFontName.getSelectedItem() + "");
        if (this.iReportFont.getPDFFontName().equals("External TTF font...") && this.jComboBoxTTFFont.getSelectedItem() != null && this.jComboBoxTTFFont.getSelectedItem() instanceof IRFont) {
            this.iReportFont.setPDFFontName(((IRFont)this.jComboBoxTTFFont.getSelectedItem()).getFile().getName() + "");
        }
        this.iReportFont.setPdfEmbedded(this.jCheckBoxPDFEmbedded.isSelected());
        if (this.jComboBoxPdfEncoding.getSelectedItem() instanceof PdfEncoding) {
            this.iReportFont.setPdfEncoding(((PdfEncoding)this.jComboBoxPdfEncoding.getSelectedItem()).getEncoding());
        } else {
            this.iReportFont.setPdfEncoding(Misc.nvl(this.jComboBoxPdfEncoding.getSelectedItem(), "CP1251"));
        }
        this.iReportFont.setStrikeTrought(this.jCheckBoxStrokeTrough.isSelected());
        this.iReportFont.setTTFFont(Misc.nvl(this.jComboBoxTTFFont.getSelectedItem(), ""));
        this.iReportFont.setUnderline(this.jCheckBoxUnderline.isSelected());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).show();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public IReportFont getIReportFont() {
        return this.iReportFont;
    }

    public void setIReportFont(IReportFont iReportFont) {
        this.init = true;
        this.jTextFieldReportFont.setText(new String(iReportFont.getReportFont()));
        this.jCheckBoxBold.setSelected(iReportFont.isBold());
        this.jCheckBoxItalic.setSelected(iReportFont.isItalic());
        this.jCheckBoxStrokeTrough.setSelected(iReportFont.isStrikeTrought());
        this.jCheckBoxPDFEmbedded.setSelected(iReportFont.isPdfEmbedded());
        this.jCheckBoxUnderline.setSelected(iReportFont.isUnderline());
        this.jCheckBoxDefaultFont.setSelected(iReportFont.isDefaultFont());
        this.setComboBoxText(true, iReportFont.getFontName(), this.jComboBoxFontName);
        if (iReportFont.getPDFFontName().toUpperCase().endsWith(".TTF")) {
            this.setComboBoxText(true, "External TTF font...", this.jComboBoxPDFFontName);
            this.jComboBoxTTFFont.setEnabled(true);
            this.jLabelTTF.setEnabled(true);
        } else {
            this.setComboBoxText(true, iReportFont.getPDFFontName(), this.jComboBoxPDFFontName);
        }
        if (iReportFont.getPDFFontName().toUpperCase().endsWith(".TTF")) {
            this.jComboBoxTTFFont.setEnabled(true);
            this.jLabelTTF.setEnabled(true);
            this.setFontComboBox(true, iReportFont.getPDFFontName(), this.jComboBoxTTFFont);
        } else {
            this.jComboBoxTTFFont.setEnabled(false);
            this.jLabelTTF.setEnabled(false);
        }
        this.setElementComboNumber(true, iReportFont.getFontSize(), this.jNumberComboBoxSize);
        this.setPdfEncodingComboBox(true, iReportFont.getPdfEncoding(), this.jComboBoxPdfEncoding);
        this.init = false;
    }

    public void updateFonts(Vector iRFonts) {
        Misc.updateComboBox(this.jComboBoxTTFFont, iRFonts, false);
    }

    protected boolean setComboBoxText(boolean firstTime, String value, JComboBox comboField) {
        if (!firstTime && !Misc.nvl(comboField.getSelectedItem(), "").equalsIgnoreCase(value)) {
            comboField.setSelectedIndex(0);
            return false;
        }
        try {
            comboField.setSelectedItem(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setFontComboBox(boolean firstTime, String value, JComboBox comboField) {
        if (!(firstTime || comboField.getSelectedItem() != null && comboField.getSelectedItem() instanceof IRFont && ((IRFont)comboField.getSelectedItem()).getFile().equals(value))) {
            if (comboField.getItemCount() > 0) {
                comboField.setSelectedIndex(0);
            }
            return false;
        }
        try {
            for (int i = 0; i < comboField.getItemCount(); ++i) {
                if (!(comboField.getItemAt(i) instanceof IRFont) || !((IRFont)comboField.getItemAt(i)).getFile().getName().equals(value)) continue;
                comboField.setSelectedIndex(i);
                return true;
            }
            if (comboField.getItemCount() > 0) {
                comboField.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setPdfEncodingComboBox(boolean firstTime, String value, JComboBox comboField) {
        if (!(firstTime || comboField.getSelectedItem() != null && (comboField.getSelectedItem() instanceof PdfEncoding && ((PdfEncoding)comboField.getSelectedItem()).getEncoding().equalsIgnoreCase(value) || (comboField.getSelectedItem() + "").equals(value)))) {
            if (comboField.getItemCount() > 0) {
                comboField.setSelectedIndex(0);
            }
            return false;
        }
        try {
            for (int i = 0; i < comboField.getItemCount(); ++i) {
                if (!(comboField.getItemAt(i) instanceof PdfEncoding) || !((PdfEncoding)comboField.getItemAt(i)).getEncoding().equals(value)) continue;
                comboField.setSelectedIndex(i);
                return true;
            }
            comboField.setSelectedItem(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setElementComboNumber(boolean firstTime, double value, JNumberComboBox numberField) {
        if (!firstTime && numberField.getValue() != value) {
            numberField.setSelectedItem("");
            return false;
        }
        try {
            numberField.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }
}

