/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRClassCompiler;
import net.sf.jasperreports.engine.design.JRClassGenerator;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;

public abstract class JRAbstractJavaCompiler
implements JRCompiler,
JRClassCompiler {
    private static ThreadLocal classFromBytesRef = new ThreadLocal();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        File classFile;
        JasperReport jasperReport;
        block14: {
            File tempDirFile;
            jasperReport = null;
            Collection brokenRules = JRVerifier.verifyDesign(jasperDesign);
            if (brokenRules != null && brokenRules.size() > 0) {
                StringBuffer sbuffer = new StringBuffer();
                sbuffer.append("Report design not valid : ");
                int i = 1;
                Iterator it = brokenRules.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        throw new JRException(sbuffer.toString());
                    }
                    sbuffer.append("\n\t " + i + ". " + (String)it.next());
                    ++i;
                }
            }
            String tempDirStr = System.getProperty("jasper.reports.compile.temp");
            if (tempDirStr == null || tempDirStr.length() == 0) {
                tempDirStr = System.getProperty("user.dir");
            }
            if (!(tempDirFile = new File(tempDirStr)).exists()) throw new JRException("Temporary directory not found : " + tempDirStr);
            if (!tempDirFile.isDirectory()) {
                throw new JRException("Temporary directory not found : " + tempDirStr);
            }
            boolean isKeepJavaFile = Boolean.valueOf(System.getProperty("jasper.reports.compile.keep.java.file"));
            File javaFile = new File(tempDirFile, jasperDesign.getName() + ".java");
            classFile = new File(tempDirFile, jasperDesign.getName() + ".class");
            String sourceCode = JRClassGenerator.generateClass(jasperDesign);
            JRSaver.saveClassSource(sourceCode, javaFile);
            String classpath = System.getProperty("jasper.reports.compile.class.path");
            if (classpath == null || classpath.length() == 0) {
                classpath = System.getProperty("java.class.path");
            }
            try {
                try {
                    String compileErrors = this.compileClass(javaFile, classpath);
                    if (compileErrors != null) {
                        throw new JRException("Errors were encountered when compiling report expressions class file:\n" + compileErrors);
                    }
                    jasperReport = new JasperReport(jasperDesign, this.getClass().getName(), JRLoader.loadBytes(classFile));
                }
                catch (JRException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new JRException("Error compiling report design.", e);
                }
                Object var14_16 = null;
                if (isKeepJavaFile) break block14;
                javaFile.delete();
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                if (!isKeepJavaFile) {
                    javaFile.delete();
                }
                classFile.delete();
                throw throwable;
            }
        }
        classFile.delete();
        return jasperReport;
    }

    public JRCalculator loadCalculator(JasperReport jasperReport) throws JRException {
        JRCalculator calculator = null;
        try {
            Class clazz = JRClassLoader.loadClassFromBytes(jasperReport.getName(), (byte[])jasperReport.getCompileData());
            classFromBytesRef.set(clazz);
            calculator = (JRCalculator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JRException("Error loading expression class : " + jasperReport.getName(), e);
        }
        return calculator;
    }
}

