/*
 * OptionsDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 1 giugno 2003, 14.22
 */

package it.businesslogic.ireport.gui;
import it.businesslogic.ireport.util.*;
import javax.swing.*;

import java.util.Locale;
/**
 *
 * @author  Administrator
 */
public class OptionsDialog extends javax.swing.JDialog implements LanguageChangedListener {
	
	MainFrame mf = null;
	it.businesslogic.ireport.util.Unit[] units;
	java.util.List listOfLanguages;
	java.util.List listOfPLAF;
	/** Creates new form OptionsDialog */
	public OptionsDialog(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		this.mf = (MainFrame)parent;
		initComponents();
		javax.swing.event.DocumentListener listener =  new javax.swing.event.DocumentListener() {
			public void changedUpdate(javax.swing.event.DocumentEvent evt) {
				enableApplyAndOk();
			}
			public void insertUpdate(javax.swing.event.DocumentEvent evt) {
				enableApplyAndOk();
			}
			public void removeUpdate(javax.swing.event.DocumentEvent evt) {
				enableApplyAndOk();
			}
		};
		
		this.jTextFieldBackupDirectory.getDocument().addDocumentListener(listener);
		this.jTextFieldCSVViewer.getDocument().addDocumentListener(listener);
		this.jTextFieldCompilationDir.getDocument().addDocumentListener(listener);
		this.jTextFieldEditor.getDocument().addDocumentListener(listener);
		this.jTextFieldHTMLViewer.getDocument().addDocumentListener(listener);
		this.jTextFieldPDFViewer.getDocument().addDocumentListener(listener);
		this.jTextFieldTemplate.getDocument().addDocumentListener(listener);
		this.jTextFieldXLSViewer.getDocument().addDocumentListener(listener);
		
		units = it.businesslogic.ireport.util.Unit.getStandardUnits();
		for (int i=0; i< units.length; ++i) {
			jComboBoxDefaultRulesUnit.addItem( units[i]+"" );
		}
		//Fill choosable Languages and select last selected language
		listOfLanguages = it.businesslogic.ireport.util.I18n.getListOfAvailLanguages();
		it.businesslogic.ireport.Language languageModel = null;
		
		String selectedLanguage = mf.getProperties().getProperty("Language");
		String selectedCountry = mf.getProperties().getProperty("Country");
		
		for (int i=0; i< listOfLanguages.size(); ++i) {
			Locale lang = (Locale)listOfLanguages.get(i);
			
			LocaleAdapter adapter = new LocaleAdapter(lang);
			jComboBoxLanguage.addItem( adapter );
			if( lang.getCountry().equals(selectedCountry) && lang.getLanguage().equals(selectedLanguage) ) {
				jComboBoxLanguage.setSelectedItem(adapter);
			}
		}
		
		
		listOfPLAF = it.businesslogic.ireport.util.Misc.getAvailablePLAF();
		String selectedPAF = mf.getProperties().getProperty("LookAndFeel");
		for (int i=0; i< listOfPLAF.size(); ++i) {
			String pnf = (String)listOfPLAF.get(i);
			jComboBoxLookAndFeel.addItem( pnf );
			if ( pnf.equals( selectedPAF ) ) {
				jComboBoxLookAndFeel.setSelectedItem(pnf);
			}
		}
                
                // Apply locale....
                //System.out.println("Apply i18n cc...");
                //applyI18n();
		I18n.addOnLanguageChangedListener( this );
                applyI18n();
		pack();
	}
        
        
        /**
         *
         */
        public void applyI18n(){
		//jMenuFile.setText(it.businesslogic.ireport.util.I18n.getString("file","File"));               
                jLabelRecentFileListLength.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.LabelRecentFileListLength","Num of recent files in file menu"));
                jLabelDefaultUnit.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.LabelDefaultUnit","Default unit"));
                jLabelViewRules.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.LabelViewRules","View rules"));
                jLabelViewGrid.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.LabelViewGrid","View grid"));
                jLabelGridSize.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.LabelGridSize","Grid size"));
                jLabelViewBorderForTextElements.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.LabelViewBorderForTextElements","View border for text elements"));
                jLabelTextBorderColor.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.LabelTextBorderColor","Text border color"));
                jLabelLookAndFeel.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.LabelLookAndFeel","Look & Feel"));
                jLabelLanguage.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.LabelLanguage","Language"));
                jLabelAutoRegisterFields.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.LabelAutoRegisterFields","Auto register SQL fields"));
                jLabelTemplateForNewDocs.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.LabelTemplateForNewDocs","Use this file as template for new documents"));
                jButtonTemplate.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.Browse","Browse"));
                jButtonOK.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.ButtonSave","Save"));
                jButtonApply.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.ButtonApply","Apply"));
                jButtonCancel.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.ButtonCancel","Cancel"));
                jTabbedPane1.setTitleAt(0, it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.TabGeneral","General"));
                jTabbedPane1.setTitleAt(1, it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.TabCompiler","Compiler"));
                ((javax.swing.border.TitledBorder)jPanelCompileDir.getBorder()).setTitle(it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.DefaultCompileDir","Default compilation directory"));
                jCheckBoxUseCurrentFilesDirectoryForCompiles.setText( it.businesslogic.ireport.util.I18n.getString( "gui.OptionsDialog.UseCurrentFilesDirectoryForCompiles","Use the reports directory for compiles"));
                jCheckBoxAutosave.setText(it.businesslogic.ireport.util.I18n.getString( "gui.OptionsDialog.Autosave","Autosave before compiling"));
                jButtonCompilationDir.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.Browse","Browse"));
                jTabbedPane1.setTitleAt(2, it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.TabBackup","Backup"));
                jTabbedPane1.setTitleAt(3, it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.TabExternalPrograms","External programs"));
                ((javax.swing.border.TitledBorder)jPanel6.getBorder()).setTitle(it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.BackupFilesOnSave","Backup files on save"));
                jRadioButton1_NoBackup.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.NoBackup","No backup"));
                jRadioButton2_ReplaceExtension.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.ReplaceExtension","Replace extension with .bak"));
                jRadioButton3_AppendExtension.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.AppendExtension","Append .bak to existing extension"));
                jLabelDefaultBackupDir.setText( it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.LabelDefaultBackupDir","Default backup directory"));
                jButtonBackupDirectory.setText(  it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.Browse","Browse"));
                jButtonBrowseEditor.setText(  it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.Browse","Browse"));
                jButtonBrowseEditor1.setText(  it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.Browse","Browse"));
                jButtonBrowseEditor2.setText(  it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.Browse","Browse"));
                jButtonBrowseEditor3.setText(  it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.Browse","Browse"));
                jButtonBrowseEditor4.setText(  it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.Browse","Browse"));
                ((javax.swing.border.TitledBorder)jPanelExternalEditor.getBorder()).setTitle(it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.ExternalEditor","External editor"));
                ((javax.swing.border.TitledBorder)jPanelViewers.getBorder()).setTitle(it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.Viewers","Viewers"));
                jLabelPDFViewer.setText(  it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.PDFViewer","PDF Viewer"));
                jLabelCSVViewer.setText(  it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.CSVViewer","CSV Viewer"));
                jLabelHTMLViewer.setText(  it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.HTMLViewer","HTML Viewer"));
                jLabelXLSViewer.setText(  it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.XLSViewer","XLS Viewer"));
                
                this.setTitle("iReport - " + it.businesslogic.ireport.util.I18n.getString("gui.OptionsDialog.title","Options"));
                this.getRootPane().updateUI();
                
        }
	
	/**
	 * A simple class to enable locales to be placed in a combo box.
	 *
	 */
	class LocaleAdapter {
		Locale l;
		public LocaleAdapter( Locale locale ) {
			l = locale;
		}
		
		public Locale getLocale() {
			return l;
		}
		
		public String toString() {
			if( l.getCountry()==null || l.getCountry().length()==0 ) {
				return l.getDisplayLanguage();
			} else {
				return l.getDisplayLanguage() + " - " + l.getDisplayCountry();
			}
		}
	}
	
	
	/**
	 *This method populate the frame element according with iReport properties...
	 */
	public void loadConfiguration() {
		if (mf == null || mf.getProperties() == null) {
			return;
		}
		try {
			this.jNumberFieldRecentFilesListLenght.setValue(Integer.parseInt( Misc.nvl(mf.getProperties().getProperty("RecentFilesLength"),"10")));
			this.jNumberFieldGridSize.setValue( Integer.parseInt(Misc.nvl(mf.getProperties().getProperty("GridSize"),"10") ) );
			this.jTextFieldBackupDirectory.setText( Misc.nvl(mf.getProperties().getProperty("DefaultBackupDirectory"),""));
			this.jTextFieldCSVViewer.setText( Misc.nvl(mf.getProperties().getProperty("ExternalCSVViewer"),""));
			this.jTextFieldPDFViewer.setText( Misc.nvl(mf.getProperties().getProperty("ExternalPDFViewer"),""));
			this.jTextFieldXLSViewer.setText( Misc.nvl(mf.getProperties().getProperty("ExternalXLSViewer"),""));
			this.jTextFieldHTMLViewer.setText( Misc.nvl(mf.getProperties().getProperty("ExternalHTMLViewer"),""));
			this.jTextFieldEditor.setText( Misc.nvl(mf.getProperties().getProperty("ExternalEditor"),""));
			this.jCheckBoxViewRules.setSelected( Misc.nvl(mf.getProperties().getProperty("ViewRules"),"true").equals("true"));
			this.jCheckBoxViewGrid.setSelected( Misc.nvl(mf.getProperties().getProperty("ViewGrid"),"false").equals("true"));
			this.jCheckBoxViewBorderText.setSelected( Misc.nvl(mf.getProperties().getProperty("ViewBorderForTextElements"),"true").equals("true"));
			this.jTextFieldCompilationDir.setText( mf.getDefaultCompilationDirectory() );
			this.jRadioButton1_NoBackup.setSelected( Misc.nvl(mf.getProperties().getProperty("BackupPolicy"),"3").equals("1"));
			this.jRadioButton2_ReplaceExtension.setSelected( Misc.nvl(mf.getProperties().getProperty("BackupPolicy"),"3").equals("2"));
			this.jRadioButton3_AppendExtension.setSelected( Misc.nvl(mf.getProperties().getProperty("BackupPolicy"),"3").equals("3"));
			this.jButtonBorderTextColor.setBackground(new java.awt.Color(Integer.parseInt( Misc.nvl(mf.getProperties().getProperty("ViewBorderColor"),"1") )));
			this.jTextFieldTemplate.setText( Misc.nvl(mf.getProperties().getProperty("DefaultTemplate"),"") );
			this.jCheckBoxAutosave.setSelected(Misc.nvl(mf.getProperties().getProperty("SaveBeforeCompiling"),"true").equals("true"));
			//this.jCheckBoxUseMultiLineScripts.setSelected( mf.isUsingMultiLineExpressions() );
			this.jCheckBoxUseCurrentFilesDirectoryForCompiles.setSelected(mf.isUsingCurrentFilesDirectoryForCompiles());
			//         this.jComboBoxLanguage.setSelectedItem( it.businesslogic.ireport.util.I18n.getLanguage(mf.getProperties().getProperty("Language")) );
			if(mf.isUsingCurrentFilesDirectoryForCompiles()) {
				this.disableCompileDirectoryBrowse();
			}
			// Set default unit...
			for (int i=0; i< jComboBoxDefaultRulesUnit.getItemCount(); ++i) {
				if ( (jComboBoxDefaultRulesUnit.getItemAt(i)+"").equals( Misc.nvl(mf.getProperties().getProperty("DefaultUnit"),"cm") ) ) {
					jComboBoxDefaultRulesUnit.setSelectedIndex( i);
					break;
				}
			}
                        
                        this.jCheckBoxAutoRegisterFields.setSelected(Misc.nvl(mf.getProperties().getProperty("UseAutoRegiesterFields"),"true").equals("true"));
			
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		
		this.disableApplyAndOk();
		pack();
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
        private void initComponents() {//GEN-BEGIN:initComponents
                java.awt.GridBagConstraints gridBagConstraints;

                buttonGroup1 = new javax.swing.ButtonGroup();
                jTabbedPane1 = new javax.swing.JTabbedPane();
                jPanelGeneral = new javax.swing.JPanel();
                jPanel8 = new javax.swing.JPanel();
                jNumberFieldRecentFilesListLenght = new it.businesslogic.ireport.gui.JNumberField();
                jLabelRecentFileListLength = new javax.swing.JLabel();
                jCheckBoxViewRules = new javax.swing.JCheckBox();
                jCheckBoxViewGrid = new javax.swing.JCheckBox();
                jNumberFieldGridSize = new it.businesslogic.ireport.gui.JNumberField();
                jLabelGridSize = new javax.swing.JLabel();
                jLabelDefaultUnit = new javax.swing.JLabel();
                jComboBoxDefaultRulesUnit = new javax.swing.JComboBox();
                jCheckBoxViewBorderText = new javax.swing.JCheckBox();
                jLabelTextBorderColor = new javax.swing.JLabel();
                jButtonBorderTextColor = new javax.swing.JButton();
                jLabelLookAndFeel = new javax.swing.JLabel();
                jLabelLanguage = new javax.swing.JLabel();
                jComboBoxLookAndFeel = new javax.swing.JComboBox();
                jComboBoxLanguage = new javax.swing.JComboBox();
                jLabelViewBorderForTextElements = new javax.swing.JLabel();
                jLabelViewRules = new javax.swing.JLabel();
                jLabelViewGrid = new javax.swing.JLabel();
                jCheckBoxAutoRegisterFields = new javax.swing.JCheckBox();
                jPanel3 = new javax.swing.JPanel();
                jLabelAutoRegisterFields = new javax.swing.JLabel();
                jPanel2 = new javax.swing.JPanel();
                jLabelTemplateForNewDocs = new javax.swing.JLabel();
                jTextFieldTemplate = new javax.swing.JTextField();
                jButtonTemplate = new javax.swing.JButton();
                jPanelComper = new javax.swing.JPanel();
                jPanelCompileDir = new javax.swing.JPanel();
                jTextFieldCompilationDir = new javax.swing.JTextField();
                jButtonCompilationDir = new javax.swing.JButton();
                jCheckBoxAutosave = new javax.swing.JCheckBox();
                jCheckBoxUseCurrentFilesDirectoryForCompiles = new javax.swing.JCheckBox();
                jPanelBackup = new javax.swing.JPanel();
                jPanel6 = new javax.swing.JPanel();
                jTextFieldBackupDirectory = new javax.swing.JTextField();
                jButtonBackupDirectory = new javax.swing.JButton();
                jRadioButton1_NoBackup = new javax.swing.JRadioButton();
                jRadioButton2_ReplaceExtension = new javax.swing.JRadioButton();
                jRadioButton3_AppendExtension = new javax.swing.JRadioButton();
                jLabelDefaultBackupDir = new javax.swing.JLabel();
                jPanelExternalPrograms = new javax.swing.JPanel();
                jPanelExternalEditor = new javax.swing.JPanel();
                jTextFieldEditor = new javax.swing.JTextField();
                jButtonBrowseEditor = new javax.swing.JButton();
                jPanelViewers = new javax.swing.JPanel();
                jTextFieldPDFViewer = new javax.swing.JTextField();
                jButtonBrowseEditor1 = new javax.swing.JButton();
                jTextFieldHTMLViewer = new javax.swing.JTextField();
                jButtonBrowseEditor2 = new javax.swing.JButton();
                jTextFieldXLSViewer = new javax.swing.JTextField();
                jButtonBrowseEditor3 = new javax.swing.JButton();
                jLabelPDFViewer = new javax.swing.JLabel();
                jLabelHTMLViewer = new javax.swing.JLabel();
                jLabelXLSViewer = new javax.swing.JLabel();
                jLabelCSVViewer = new javax.swing.JLabel();
                jTextFieldCSVViewer = new javax.swing.JTextField();
                jButtonBrowseEditor4 = new javax.swing.JButton();
                jPanel1 = new javax.swing.JPanel();
                jButtonOK = new javax.swing.JButton();
                jButtonApply = new javax.swing.JButton();
                jButtonCancel = new javax.swing.JButton();

                setTitle("iReport Options");
                setResizable(false);
                addWindowListener(new java.awt.event.WindowAdapter() {
                        public void windowClosing(java.awt.event.WindowEvent evt) {
                                closeDialog(evt);
                        }
                });

                jPanelGeneral.setLayout(new java.awt.BorderLayout());

                jPanel8.setLayout(new java.awt.GridBagLayout());

                jPanel8.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "General", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
                jPanel8.setFont(new java.awt.Font("Dialog", 0, 11));
                jNumberFieldRecentFilesListLenght.setColumns(4);
                jNumberFieldRecentFilesListLenght.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
                try {
                        jNumberFieldRecentFilesListLenght.setDecimals(0);
                } catch (java.beans.PropertyVetoException e1) {
                        e1.printStackTrace();
                }
                try {
                        jNumberFieldRecentFilesListLenght.setValue(10.0);
                } catch (java.beans.PropertyVetoException e1) {
                        e1.printStackTrace();
                }
                jNumberFieldRecentFilesListLenght.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jNumberFieldRecentFilesListLenghtActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel8.add(jNumberFieldRecentFilesListLenght, gridBagConstraints);

                jLabelRecentFileListLength.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jLabelRecentFileListLength.setText("Num of recent files in file menu");
                jLabelRecentFileListLength.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel8.add(jLabelRecentFileListLength, gridBagConstraints);

                jCheckBoxViewRules.setSelected(true);
                jCheckBoxViewRules.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jCheckBoxViewRules.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                jCheckBoxViewRules.setMargin(new java.awt.Insets(2, 0, 2, 2));
                jCheckBoxViewRules.addItemListener(new java.awt.event.ItemListener() {
                        public void itemStateChanged(java.awt.event.ItemEvent evt) {
                                jCheckBoxViewRulesItemStateChanged(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
                jPanel8.add(jCheckBoxViewRules, gridBagConstraints);

                jCheckBoxViewGrid.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jCheckBoxViewGrid.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                jCheckBoxViewGrid.setMargin(new java.awt.Insets(2, 0, 2, 2));
                jCheckBoxViewGrid.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jCheckBoxViewGridActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
                jPanel8.add(jCheckBoxViewGrid, gridBagConstraints);

                jNumberFieldGridSize.setColumns(4);
                jNumberFieldGridSize.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
                try {
                        jNumberFieldGridSize.setDecimals(0);
                } catch (java.beans.PropertyVetoException e1) {
                        e1.printStackTrace();
                }
                try {
                        jNumberFieldGridSize.setValue(10.0);
                } catch (java.beans.PropertyVetoException e1) {
                        e1.printStackTrace();
                }
                jNumberFieldGridSize.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jNumberFieldGridSizeActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel8.add(jNumberFieldGridSize, gridBagConstraints);

                jLabelGridSize.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jLabelGridSize.setText("Grid size");
                jLabelGridSize.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel8.add(jLabelGridSize, gridBagConstraints);

                jLabelDefaultUnit.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jLabelDefaultUnit.setText("Default unit");
                jLabelDefaultUnit.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel8.add(jLabelDefaultUnit, gridBagConstraints);

                jComboBoxDefaultRulesUnit.setFont(new java.awt.Font("Dialog", 0, 11));
                jComboBoxDefaultRulesUnit.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jComboBoxDefaultRulesUnitActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 14);
                jPanel8.add(jComboBoxDefaultRulesUnit, gridBagConstraints);

                jCheckBoxViewBorderText.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jCheckBoxViewBorderText.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                jCheckBoxViewBorderText.setMargin(new java.awt.Insets(2, 0, 2, 2));
                jCheckBoxViewBorderText.addItemListener(new java.awt.event.ItemListener() {
                        public void itemStateChanged(java.awt.event.ItemEvent evt) {
                                jCheckBoxViewBorderTextItemStateChanged(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
                jPanel8.add(jCheckBoxViewBorderText, gridBagConstraints);

                jLabelTextBorderColor.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jLabelTextBorderColor.setText("Text border color");
                jLabelTextBorderColor.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel8.add(jLabelTextBorderColor, gridBagConstraints);

                jButtonBorderTextColor.setFont(new java.awt.Font("Dialog", 0, 11));
                jButtonBorderTextColor.setBackground(new java.awt.Color(128, 128, 128));
                jButtonBorderTextColor.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonBorderTextColorActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanel8.add(jButtonBorderTextColor, gridBagConstraints);

                jLabelLookAndFeel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jLabelLookAndFeel.setText("Look&Feel");
                jLabelLookAndFeel.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 7;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel8.add(jLabelLookAndFeel, gridBagConstraints);

                jLabelLanguage.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jLabelLanguage.setText("Language");
                jLabelLanguage.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 8;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel8.add(jLabelLanguage, gridBagConstraints);

                jComboBoxLookAndFeel.addItemListener(new java.awt.event.ItemListener() {
                        public void itemStateChanged(java.awt.event.ItemEvent evt) {
                                jComboBoxLookAndFeelItemStateChanged(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 7;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 14);
                jPanel8.add(jComboBoxLookAndFeel, gridBagConstraints);

                jComboBoxLanguage.addItemListener(new java.awt.event.ItemListener() {
                        public void itemStateChanged(java.awt.event.ItemEvent evt) {
                                jComboBoxLanguageItemStateChanged(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 8;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 14);
                jPanel8.add(jComboBoxLanguage, gridBagConstraints);

                jLabelViewBorderForTextElements.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jLabelViewBorderForTextElements.setText("View border for text elements");
                jLabelViewBorderForTextElements.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel8.add(jLabelViewBorderForTextElements, gridBagConstraints);

                jLabelViewRules.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jLabelViewRules.setText("View rules");
                jLabelViewRules.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel8.add(jLabelViewRules, gridBagConstraints);

                jLabelViewGrid.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jLabelViewGrid.setText("View grid");
                jLabelViewGrid.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel8.add(jLabelViewGrid, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 9;
                gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
                gridBagConstraints.gridheight = 9;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                jPanel8.add(jCheckBoxAutoRegisterFields, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 10;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                jPanel8.add(jPanel3, gridBagConstraints);

                jLabelAutoRegisterFields.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
                jLabelAutoRegisterFields.setText("Auto register SQL fields");
                jLabelAutoRegisterFields.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 9;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel8.add(jLabelAutoRegisterFields, gridBagConstraints);

                jPanelGeneral.add(jPanel8, java.awt.BorderLayout.CENTER);

                jPanel2.setLayout(new java.awt.GridBagLayout());

                jLabelTemplateForNewDocs.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
                jLabelTemplateForNewDocs.setText("Use this file as template for new documents");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.insets = new java.awt.Insets(0, 7, 0, 0);
                jPanel2.add(jLabelTemplateForNewDocs, gridBagConstraints);

                jTextFieldTemplate.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jTextFieldTemplateActionPerformed(evt);
                        }
                });
                jTextFieldTemplate.addInputMethodListener(new java.awt.event.InputMethodListener() {
                        public void caretPositionChanged(java.awt.event.InputMethodEvent evt) {
                        }
                        public void inputMethodTextChanged(java.awt.event.InputMethodEvent evt) {
                                jTextFieldTemplateInputMethodTextChanged(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1000.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 7, 3, 0);
                jPanel2.add(jTextFieldTemplate, gridBagConstraints);

                jButtonTemplate.setText("Browse");
                jButtonTemplate.setMargin(new java.awt.Insets(2, 2, 2, 2));
                jButtonTemplate.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonTemplateActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 6);
                jPanel2.add(jButtonTemplate, gridBagConstraints);

                jPanelGeneral.add(jPanel2, java.awt.BorderLayout.SOUTH);

                jTabbedPane1.addTab("General", jPanelGeneral);

                jPanelComper.setLayout(new java.awt.GridBagLayout());

                jPanelCompileDir.setLayout(new java.awt.GridBagLayout());

                jPanelCompileDir.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "Default compilation directory", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1000.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelCompileDir.add(jTextFieldCompilationDir, gridBagConstraints);

                jButtonCompilationDir.setText("Browse");
                jButtonCompilationDir.setMargin(new java.awt.Insets(2, 2, 2, 2));
                jButtonCompilationDir.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonCompilationDirActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelCompileDir.add(jButtonCompilationDir, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanelComper.add(jPanelCompileDir, gridBagConstraints);

                jCheckBoxAutosave.setText("Autosave before compiling");
                jCheckBoxAutosave.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jCheckBoxAutosaveActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
                jPanelComper.add(jCheckBoxAutosave, gridBagConstraints);

                jCheckBoxUseCurrentFilesDirectoryForCompiles.setText("Use the reports directory for compiles");
                jCheckBoxUseCurrentFilesDirectoryForCompiles.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
                jPanelComper.add(jCheckBoxUseCurrentFilesDirectoryForCompiles, gridBagConstraints);

                jTabbedPane1.addTab("Compiler", jPanelComper);

                jPanelBackup.setLayout(new java.awt.GridBagLayout());

                jPanel6.setLayout(new java.awt.GridBagLayout());

                jPanel6.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "Backup files on save", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel6.add(jTextFieldBackupDirectory, gridBagConstraints);

                jButtonBackupDirectory.setText("Browse");
                jButtonBackupDirectory.setMargin(new java.awt.Insets(2, 2, 2, 2));
                jButtonBackupDirectory.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonBackupDirectoryActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanel6.add(jButtonBackupDirectory, gridBagConstraints);

                jRadioButton1_NoBackup.setText("No backup");
                buttonGroup1.add(jRadioButton1_NoBackup);
                jRadioButton1_NoBackup.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jRadioButton1_NoBackupActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
                jPanel6.add(jRadioButton1_NoBackup, gridBagConstraints);

                jRadioButton2_ReplaceExtension.setText("Replace extension with .bak");
                buttonGroup1.add(jRadioButton2_ReplaceExtension);
                jRadioButton2_ReplaceExtension.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jRadioButton2_ReplaceExtensionActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanel6.add(jRadioButton2_ReplaceExtension, gridBagConstraints);

                jRadioButton3_AppendExtension.setSelected(true);
                jRadioButton3_AppendExtension.setText("Append .bak to existing extension");
                buttonGroup1.add(jRadioButton3_AppendExtension);
                jRadioButton3_AppendExtension.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jRadioButton3_AppendExtensionActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 3);
                jPanel6.add(jRadioButton3_AppendExtension, gridBagConstraints);

                jLabelDefaultBackupDir.setText("Default backup directory");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanel6.add(jLabelDefaultBackupDir, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanelBackup.add(jPanel6, gridBagConstraints);

                jTabbedPane1.addTab("Backup", jPanelBackup);

                jPanelExternalPrograms.setLayout(new java.awt.GridBagLayout());

                jPanelExternalEditor.setLayout(new java.awt.GridBagLayout());

                jPanelExternalEditor.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "External editor", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1000.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelExternalEditor.add(jTextFieldEditor, gridBagConstraints);

                jButtonBrowseEditor.setText("Browse");
                jButtonBrowseEditor.setMargin(new java.awt.Insets(2, 2, 2, 2));
                jButtonBrowseEditor.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonBrowseEditorActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelExternalEditor.add(jButtonBrowseEditor, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                jPanelExternalPrograms.add(jPanelExternalEditor, gridBagConstraints);

                jPanelViewers.setLayout(new java.awt.GridBagLayout());

                jPanelViewers.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "Viewers", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.weightx = 1000.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelViewers.add(jTextFieldPDFViewer, gridBagConstraints);

                jButtonBrowseEditor1.setText("Browse");
                jButtonBrowseEditor1.setMargin(new java.awt.Insets(2, 2, 2, 2));
                jButtonBrowseEditor1.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonBrowseEditor1ActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelViewers.add(jButtonBrowseEditor1, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelViewers.add(jTextFieldHTMLViewer, gridBagConstraints);

                jButtonBrowseEditor2.setText("Browse");
                jButtonBrowseEditor2.setMargin(new java.awt.Insets(2, 2, 2, 2));
                jButtonBrowseEditor2.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonBrowseEditor2ActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelViewers.add(jButtonBrowseEditor2, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelViewers.add(jTextFieldXLSViewer, gridBagConstraints);

                jButtonBrowseEditor3.setText("Browse");
                jButtonBrowseEditor3.setMargin(new java.awt.Insets(2, 2, 2, 2));
                jButtonBrowseEditor3.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonBrowseEditor3ActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelViewers.add(jButtonBrowseEditor3, gridBagConstraints);

                jLabelPDFViewer.setText("PDF viewer");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelViewers.add(jLabelPDFViewer, gridBagConstraints);

                jLabelHTMLViewer.setText("HTML viewer");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelViewers.add(jLabelHTMLViewer, gridBagConstraints);

                jLabelXLSViewer.setText("XLS viewer");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelViewers.add(jLabelXLSViewer, gridBagConstraints);

                jLabelCSVViewer.setText("CSV viewer");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelViewers.add(jLabelCSVViewer, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 7;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelViewers.add(jTextFieldCSVViewer, gridBagConstraints);

                jButtonBrowseEditor4.setText("Browse");
                jButtonBrowseEditor4.setMargin(new java.awt.Insets(2, 2, 2, 2));
                jButtonBrowseEditor4.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonBrowseEditor4ActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 7;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
                jPanelViewers.add(jButtonBrowseEditor4, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 6, 3);
                jPanelExternalPrograms.add(jPanelViewers, gridBagConstraints);

                jTabbedPane1.addTab("External programs", jPanelExternalPrograms);

                getContentPane().add(jTabbedPane1, java.awt.BorderLayout.CENTER);

                jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

                jPanel1.setMinimumSize(new java.awt.Dimension(10, 30));
                jButtonOK.setText("Save");
                jButtonOK.setMnemonic('s');
                jButtonOK.setEnabled(false);
                jButtonOK.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonOKActionPerformed(evt);
                        }
                });

                jPanel1.add(jButtonOK);

                jButtonApply.setText("Apply");
                jButtonApply.setMnemonic('a');
                jButtonApply.setEnabled(false);
                jButtonApply.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonApplyActionPerformed(evt);
                        }
                });

                jPanel1.add(jButtonApply);

                jButtonCancel.setText("Cancel");
                jButtonCancel.setMnemonic('c');
                jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonCancelActionPerformed(evt);
                        }
                });

                jPanel1.add(jButtonCancel);

                getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

                pack();
                java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
                java.awt.Dimension dialogSize = getSize();
                setLocation((screenSize.width-dialogSize.width)/2,(screenSize.height-dialogSize.height)/2);
        }//GEN-END:initComponents
	
    private void jComboBoxLookAndFeelItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBoxLookAndFeelItemStateChanged
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jComboBoxLookAndFeelItemStateChanged
    
    private void jComboBoxLanguageItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBoxLanguageItemStateChanged
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jComboBoxLanguageItemStateChanged
    
    private void jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed
    {//GEN-HEADEREND:event_jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed
	    if(this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected()) {
		    this.disableCompileDirectoryBrowse();
	    }
	    else {
		    this.enableCompileDirectoryBrowse();
	    }
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed
        
    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
	    if  ( jButtonApply.isEnabled())
		    jButtonApplyActionPerformed(evt);
	    
	    if (mf != null) mf.saveiReportConfiguration();
	    this.jButtonOK.setEnabled(false);
	    this.setVisible(false);
	    this.dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    private void jButtonApplyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonApplyActionPerformed
	    applyConfiguration();
	    jButtonApply.setEnabled(false);
    }//GEN-LAST:event_jButtonApplyActionPerformed
    
    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
	    this.setVisible(false);
	    this.dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed
    
    private void jButtonBrowseEditor4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseEditor4ActionPerformed
	    javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
	    
	    jfc.setDialogTitle("Choose an CSV viewer...");
	    jfc.setMultiSelectionEnabled(false);
	    if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
		    jTextFieldCSVViewer.setText( jfc.getSelectedFile().getPath());
	    }
    }//GEN-LAST:event_jButtonBrowseEditor4ActionPerformed
    
    private void jButtonBrowseEditor3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseEditor3ActionPerformed
	    javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
	    
	    jfc.setDialogTitle("Choose an XLS viewer...");
	    jfc.setMultiSelectionEnabled(false);
	    if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
		    jTextFieldXLSViewer.setText( jfc.getSelectedFile().getPath());
	    }
    }//GEN-LAST:event_jButtonBrowseEditor3ActionPerformed
    
    private void jButtonBrowseEditor2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseEditor2ActionPerformed
	    javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
	    
	    jfc.setDialogTitle("Choose an HTML viewer...");
	    jfc.setMultiSelectionEnabled(false);
	    if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
		    jTextFieldHTMLViewer.setText( jfc.getSelectedFile().getPath());
	    }
    }//GEN-LAST:event_jButtonBrowseEditor2ActionPerformed
    
    private void jButtonBrowseEditor1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseEditor1ActionPerformed
	    javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
	    
	    jfc.setDialogTitle("Choose an PDF viewer...");
	    jfc.setMultiSelectionEnabled(false);
	    if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
		    jTextFieldPDFViewer.setText( jfc.getSelectedFile().getPath());
	    }
    }//GEN-LAST:event_jButtonBrowseEditor1ActionPerformed
    
    private void jButtonBrowseEditorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseEditorActionPerformed
	    javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
	    
	    jfc.setDialogTitle("Choose an editor...");
	    jfc.setMultiSelectionEnabled(false);
	    if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
		    jTextFieldEditor.setText( jfc.getSelectedFile().getPath());
	    }
	    
    }//GEN-LAST:event_jButtonBrowseEditorActionPerformed
    
    private void jButtonBackupDirectoryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBackupDirectoryActionPerformed
	    JFileChooser jfc = new JFileChooser();
	    jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
	    if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
		    jTextFieldBackupDirectory.setText( jfc.getSelectedFile().getPath());
	    }
    }//GEN-LAST:event_jButtonBackupDirectoryActionPerformed
    
    private void jButtonCompilationDirActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCompilationDirActionPerformed
	    
	    JFileChooser jfc = new JFileChooser();
	    jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
	    if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
		    jTextFieldCompilationDir.setText( jfc.getSelectedFile().getPath());
	    }
    }//GEN-LAST:event_jButtonCompilationDirActionPerformed
    
    private void jButtonTemplateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonTemplateActionPerformed
	    // jfilechooser...
	    JFileChooser jfc = new JFileChooser();
	    jfc.setFileFilter( new javax.swing.filechooser.FileFilter() {
		    public boolean accept(java.io.File file) {
			    String filename = file.getName();
			    return (filename.endsWith(".xml") || file.isDirectory()) ;
		    }
		    public String getDescription() {
			    return "JasperReports XML *.xml";
		    }
	    });
	    if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
		    jTextFieldTemplate.setText( jfc.getSelectedFile().getPath());
	    }
    }//GEN-LAST:event_jButtonTemplateActionPerformed
    
    private void jRadioButton3_AppendExtensionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton3_AppendExtensionActionPerformed
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jRadioButton3_AppendExtensionActionPerformed
    
    private void jRadioButton2_ReplaceExtensionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton2_ReplaceExtensionActionPerformed
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jRadioButton2_ReplaceExtensionActionPerformed
    
    private void jRadioButton1_NoBackupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton1_NoBackupActionPerformed
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jRadioButton1_NoBackupActionPerformed
    
    private void jCheckBoxAutosaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxAutosaveActionPerformed
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jCheckBoxAutosaveActionPerformed
    
    private void jTextFieldTemplateInputMethodTextChanged(java.awt.event.InputMethodEvent evt) {//GEN-FIRST:event_jTextFieldTemplateInputMethodTextChanged
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jTextFieldTemplateInputMethodTextChanged
    
    private void jTextFieldTemplateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldTemplateActionPerformed
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jTextFieldTemplateActionPerformed
    
    private void jButtonBorderTextColorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBorderTextColorActionPerformed
	    JColorChooser jcc = new JColorChooser();
	    java.awt.Color c = jcc.showDialog(null,"Select a color...", jButtonBorderTextColor.getBackground());
	    if (c != null) {
		    this.enableApplyAndOk();
		    jButtonBorderTextColor.setBackground(c);
		    jButtonBorderTextColor.updateUI();
	    }
    }//GEN-LAST:event_jButtonBorderTextColorActionPerformed
    
    private void jCheckBoxViewBorderTextItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckBoxViewBorderTextItemStateChanged
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jCheckBoxViewBorderTextItemStateChanged
    
    private void jNumberFieldGridSizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldGridSizeActionPerformed
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jNumberFieldGridSizeActionPerformed
    
    private void jCheckBoxViewRulesItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckBoxViewRulesItemStateChanged
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jCheckBoxViewRulesItemStateChanged
    
    private void jComboBoxDefaultRulesUnitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxDefaultRulesUnitActionPerformed
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jComboBoxDefaultRulesUnitActionPerformed
    
    private void jNumberFieldRecentFilesListLenghtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldRecentFilesListLenghtActionPerformed
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jNumberFieldRecentFilesListLenghtActionPerformed
    
    private void jCheckBoxViewGridActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxViewGridActionPerformed
	    this.enableApplyAndOk();
    }//GEN-LAST:event_jCheckBoxViewGridActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
	    setVisible(false);
	    dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
	    new OptionsDialog(new javax.swing.JFrame(), true).show();
    }
    
    
        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.ButtonGroup buttonGroup1;
        private javax.swing.JButton jButtonApply;
        private javax.swing.JButton jButtonBackupDirectory;
        private javax.swing.JButton jButtonBorderTextColor;
        private javax.swing.JButton jButtonBrowseEditor;
        private javax.swing.JButton jButtonBrowseEditor1;
        private javax.swing.JButton jButtonBrowseEditor2;
        private javax.swing.JButton jButtonBrowseEditor3;
        private javax.swing.JButton jButtonBrowseEditor4;
        private javax.swing.JButton jButtonCancel;
        private javax.swing.JButton jButtonCompilationDir;
        private javax.swing.JButton jButtonOK;
        private javax.swing.JButton jButtonTemplate;
        private javax.swing.JCheckBox jCheckBoxAutoRegisterFields;
        private javax.swing.JCheckBox jCheckBoxAutosave;
        private javax.swing.JCheckBox jCheckBoxUseCurrentFilesDirectoryForCompiles;
        private javax.swing.JCheckBox jCheckBoxViewBorderText;
        private javax.swing.JCheckBox jCheckBoxViewGrid;
        private javax.swing.JCheckBox jCheckBoxViewRules;
        private javax.swing.JComboBox jComboBoxDefaultRulesUnit;
        private javax.swing.JComboBox jComboBoxLanguage;
        private javax.swing.JComboBox jComboBoxLookAndFeel;
        private javax.swing.JLabel jLabelAutoRegisterFields;
        private javax.swing.JLabel jLabelCSVViewer;
        private javax.swing.JLabel jLabelDefaultBackupDir;
        private javax.swing.JLabel jLabelDefaultUnit;
        private javax.swing.JLabel jLabelGridSize;
        private javax.swing.JLabel jLabelHTMLViewer;
        private javax.swing.JLabel jLabelLanguage;
        private javax.swing.JLabel jLabelLookAndFeel;
        private javax.swing.JLabel jLabelPDFViewer;
        private javax.swing.JLabel jLabelRecentFileListLength;
        private javax.swing.JLabel jLabelTemplateForNewDocs;
        private javax.swing.JLabel jLabelTextBorderColor;
        private javax.swing.JLabel jLabelViewBorderForTextElements;
        private javax.swing.JLabel jLabelViewGrid;
        private javax.swing.JLabel jLabelViewRules;
        private javax.swing.JLabel jLabelXLSViewer;
        private it.businesslogic.ireport.gui.JNumberField jNumberFieldGridSize;
        private it.businesslogic.ireport.gui.JNumberField jNumberFieldRecentFilesListLenght;
        private javax.swing.JPanel jPanel1;
        private javax.swing.JPanel jPanel2;
        private javax.swing.JPanel jPanel3;
        private javax.swing.JPanel jPanel6;
        private javax.swing.JPanel jPanel8;
        private javax.swing.JPanel jPanelBackup;
        private javax.swing.JPanel jPanelComper;
        private javax.swing.JPanel jPanelCompileDir;
        private javax.swing.JPanel jPanelExternalEditor;
        private javax.swing.JPanel jPanelExternalPrograms;
        private javax.swing.JPanel jPanelGeneral;
        private javax.swing.JPanel jPanelViewers;
        private javax.swing.JRadioButton jRadioButton1_NoBackup;
        private javax.swing.JRadioButton jRadioButton2_ReplaceExtension;
        private javax.swing.JRadioButton jRadioButton3_AppendExtension;
        private javax.swing.JTabbedPane jTabbedPane1;
        private javax.swing.JTextField jTextFieldBackupDirectory;
        private javax.swing.JTextField jTextFieldCSVViewer;
        private javax.swing.JTextField jTextFieldCompilationDir;
        private javax.swing.JTextField jTextFieldEditor;
        private javax.swing.JTextField jTextFieldHTMLViewer;
        private javax.swing.JTextField jTextFieldPDFViewer;
        private javax.swing.JTextField jTextFieldTemplate;
        private javax.swing.JTextField jTextFieldXLSViewer;
        // End of variables declaration//GEN-END:variables
   /*
    public void setVisible(boolean visible)
    {
	if (visible == true && visible != this.isVisible()) loadConfiguration();
	super.setVisible( visible);
    }
    */
	
	public void applyConfiguration() {
		if (mf == null || mf.getProperties() == null) {
			return;
		}
		java.util.Properties prop = mf.getProperties();
		try {
			prop.put("RecentFilesLength", ""+(int)this.jNumberFieldRecentFilesListLenght.getValue());
			prop.put("GridSize",""+(int)this.jNumberFieldGridSize.getValue());
			prop.put("DefaultBackupDirectory",""+this.jTextFieldBackupDirectory.getText());
			prop.put("ExternalCSVViewer",""+this.jTextFieldCSVViewer.getText());
			prop.put("ExternalPDFViewer",""+this.jTextFieldPDFViewer.getText());
			prop.put("ExternalXLSViewer",""+this.jTextFieldXLSViewer.getText());
			prop.put("ExternalHTMLViewer",""+this.jTextFieldHTMLViewer.getText());
			prop.put("ExternalEditor",""+this.jTextFieldEditor.getText());
			prop.put("ViewRules",""+this.jCheckBoxViewRules.isSelected());
			prop.put("ViewGrid",""+this.jCheckBoxViewGrid.isSelected());
			prop.put("ViewBorderForTextElements",""+this.jCheckBoxViewBorderText.isSelected());
                        prop.put("UseAutoRegiesterFields",""+this.jCheckBoxAutoRegisterFields.isSelected());
			prop.put("ViewRules",""+this.jCheckBoxViewRules.isSelected());
			prop.put("DefaultTemplate",""+this.jTextFieldTemplate.getText());
			prop.put("SaveBeforeCompiling",""+this.jCheckBoxAutosave.isSelected());
			prop.put("DefaultUnit",""+this.jComboBoxDefaultRulesUnit.getSelectedItem()+"" );
			prop.put("LookAndFeel", (String)jComboBoxLookAndFeel.getSelectedItem() );
			//MainFrame and this code need to implement and use an object that houses the properties
			//object and have methods for these options.
			mf.setUsingMultiLineExpressions(false); // this.jCheckBoxUseMultiLineScripts.isSelected());
			mf.setUsingCurrentFilesDirectoryForCompiles(this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected());
			prop.put("useCurrentFilesDirectoryForCompiles", this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected()+"" );
			
			mf.setDefaultCompilationDirectory(this.jTextFieldCompilationDir.getText());
			prop.put("DefaultCompilationDirectory", this.jTextFieldCompilationDir.getText() );
			
			String policy = "3";
			if (this.jRadioButton1_NoBackup.isSelected())  policy = "1";
			if (this.jRadioButton2_ReplaceExtension.isSelected())  policy = "2";
			if (this.jRadioButton3_AppendExtension.isSelected())  policy = "3";
			
			prop.put("BackupPolicy", policy );
			prop.put("ViewBorderColor",""+this.jButtonBorderTextColor.getBackground().getRGB() );
			
			LocaleAdapter adapter = (LocaleAdapter)jComboBoxLanguage.getSelectedItem();
			Locale selectedLang = adapter.getLocale();
			prop.put("Language", selectedLang.getLanguage() );
			prop.put("Country", selectedLang.getCountry() );
			
			I18n.setCurrentLocale( selectedLang );
			
			//  TODO Fire Language changed event to make all the existing
			// forms/dialogs etc, reload their static strings.
			
		} catch (Exception ex)
		{ ex.printStackTrace(); }
		
		this.jButtonApply.setEnabled(false);
		
	}
	
	protected void enableCompileDirectoryBrowse() {
		this.jTextFieldCompilationDir.setEnabled(true);
		this.jButtonCompilationDir.setEnabled(true);
	}
	
	protected void disableCompileDirectoryBrowse() {
		this.jTextFieldCompilationDir.setEnabled(false);
		this.jButtonCompilationDir.setEnabled(false);
	}
	
	protected void disableApplyAndOk() {
		this.jButtonApply.setEnabled(false);
		this.jButtonOK.setEnabled(false);
	}
	
	protected void disableApply() {
		this.jButtonOK.setEnabled(false);
	}
	
	protected void enableApplyAndOk() {
		this.jButtonApply.setEnabled(true);
		this.jButtonOK.setEnabled(true);
	}
	
	protected void enableApply() {
		this.jButtonOK.setEnabled(true);
	}
	
        public void languageChanged(LanguageChangedEvent evt) {
            this.applyI18n();
        }
        
}//end class OptionsDialog
