/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class JRHtmlExporter
extends JRAbstractExporter {
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static final String CSS_TEXT_ALIGN_LEFT = "left";
    protected static final String CSS_TEXT_ALIGN_RIGHT = "right";
    protected static final String CSS_TEXT_ALIGN_CENTER = "center";
    protected static final String CSS_TEXT_ALIGN_JUSTIFY = "justify";
    protected static final String HTML_VERTICAL_ALIGN_TOP = "top";
    protected static final String HTML_VERTICAL_ALIGN_MIDDLE = "middle";
    protected static final String HTML_VERTICAL_ALIGN_BOTTOM = "bottom";
    protected Writer writer = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImageNameMap = null;
    protected Map imageNameToImageDataMap = null;
    protected int reportIndex = 0;
    protected JRFont defaultFont = null;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected File imagesDir = null;
    protected String imagesURI = null;
    protected boolean isOutputImagesToDir = false;
    protected boolean isRemoveEmptySpace = false;
    protected boolean isWhitePageBackground = true;
    protected String encoding = null;
    protected String htmlHeader = null;
    protected String betweenPagesHtml = null;
    protected String htmlFooter = null;
    protected StringProvider emptyCellStringProvider = null;
    protected static final int colorMask = Integer.parseInt("FFFFFF", 16);
    protected JRExporterGridCell[][] grid = null;
    protected boolean[] isRowNotEmpty = null;
    protected List xCuts = null;
    protected List yCuts = null;

    protected JRFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRBaseFont();
            }
        }
        return this.defaultFont;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportReport() throws JRException {
        block50: {
            Boolean isUsingImagesToAlignParameter;
            String uri;
            Boolean isOutputImagesToDirParameter;
            Boolean isWhitePageBackgroundParameter;
            Boolean isRemoveEmptySpaceParameter;
            String dir;
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setInput();
            if (!this.isModeBatch) {
                this.setPageRange();
            }
            this.htmlHeader = (String)this.parameters.get(JRHtmlExporterParameter.HTML_HEADER);
            this.betweenPagesHtml = (String)this.parameters.get(JRHtmlExporterParameter.BETWEEN_PAGES_HTML);
            this.htmlFooter = (String)this.parameters.get(JRHtmlExporterParameter.HTML_FOOTER);
            this.imagesDir = (File)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR);
            if (this.imagesDir == null && (dir = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR_NAME)) != null) {
                this.imagesDir = new File(dir);
            }
            if ((isRemoveEmptySpaceParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS)) != null) {
                this.isRemoveEmptySpace = isRemoveEmptySpaceParameter;
            }
            if ((isWhitePageBackgroundParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND)) != null) {
                this.isWhitePageBackground = isWhitePageBackgroundParameter;
            }
            if ((isOutputImagesToDirParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR)) != null) {
                this.isOutputImagesToDir = isOutputImagesToDirParameter;
            }
            if ((uri = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_URI)) != null) {
                this.imagesURI = uri;
            }
            this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
            if (this.encoding == null) {
                this.encoding = "UTF-8";
            }
            this.rendererToImageNameMap = new HashMap();
            this.imageNameToImageDataMap = (Map)this.parameters.get(JRHtmlExporterParameter.IMAGES_MAP);
            if (this.imageNameToImageDataMap == null) {
                this.imageNameToImageDataMap = new HashMap();
            }
            if ((isUsingImagesToAlignParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN)) == null) {
                isUsingImagesToAlignParameter = Boolean.TRUE;
            }
            if (isUsingImagesToAlignParameter.booleanValue()) {
                this.emptyCellStringProvider = new StringProvider(){

                    public String getStringForCollapsedTD(Object value) {
                        return "><img src=\"" + value + "px\"";
                    }

                    public String getStringForEmptyTD(Object value) {
                        return "<img src=\"" + value + "px\" border=0>";
                    }
                };
                this.loadPxImage();
            } else {
                this.emptyCellStringProvider = new StringProvider(){

                    public String getStringForCollapsedTD(Object value) {
                        return "";
                    }

                    public String getStringForEmptyTD(Object value) {
                        return "";
                    }
                };
            }
            StringBuffer sb = (StringBuffer)this.parameters.get(JRXmlExporterParameter.OUTPUT_STRING_BUFFER);
            if (sb != null) {
                try {
                    try {
                        this.writer = new StringWriter();
                        this.exportReportToWriter();
                        sb.append(this.writer.toString());
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), e);
                    }
                    Object var9_7 = null;
                    if (this.writer == null) break block50;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    if (this.writer == null) throw throwable;
                    try {
                        this.writer.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                this.writer.close();
            } else {
                this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (this.writer != null) {
                    try {
                        this.exportReportToWriter();
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.writer = new OutputStreamWriter(os, this.encoding);
                        this.exportReportToWriter();
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), e);
                    }
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName == null) throw new JRException("No output specified for the exporter.");
                    destFile = new File(fileName);
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.writer = new OutputStreamWriter(os, this.encoding);
                }
                catch (IOException e) {
                    throw new JRException("Error creating to file writer : " + this.jasperPrint.getName(), e);
                }
                if (this.imagesDir == null) {
                    this.imagesDir = new File(destFile.getParent(), destFile.getName() + "_files");
                }
                if (isOutputImagesToDirParameter == null) {
                    this.isOutputImagesToDir = true;
                }
                if (this.imagesURI == null) {
                    this.imagesURI = this.imagesDir.getName() + "/";
                }
                try {
                    try {
                        this.exportReportToWriter();
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), e);
                    }
                    Object var12_19 = null;
                    if (this.writer == null) break block50;
                }
                catch (Throwable throwable) {
                    Object var12_20 = null;
                    if (this.writer == null) throw throwable;
                    try {
                        this.writer.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                this.writer.close();
            }
        }
        if (!this.isOutputImagesToDir) return;
        if (this.imagesDir == null) {
            throw new JRException("The images directory was not specified for the exporter.");
        }
        Set imageNames = this.imageNameToImageDataMap.keySet();
        if (imageNames == null) return;
        if (imageNames.size() <= 0) return;
        if (!this.imagesDir.exists()) {
            this.imagesDir.mkdir();
        }
        Iterator it = imageNames.iterator();
        while (it.hasNext()) {
            IOException e3;
            Object var15_26;
            String imageName = (String)it.next();
            byte[] imageData = (byte[])this.imageNameToImageDataMap.get(imageName);
            File imageFile = new File(this.imagesDir, imageName);
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(imageFile);
                    fos.write(imageData, 0, imageData.length);
                }
                catch (Exception e2) {
                    throw new JRException("Error writing to image file : " + imageFile, e2);
                }
                var15_26 = null;
                if (fos == null) continue;
                {
                }
            }
            catch (Throwable throwable) {
                var15_26 = null;
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e3) {}
            fos.close();
        }
        return;
    }

    protected void exportReportToWriter() throws JRException, IOException {
        if (this.htmlHeader == null) {
            this.writer.write("<html>\n");
            this.writer.write("<head>\n");
            this.writer.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.encoding + "\">\n");
            this.writer.write("  <style type=\"text/css\">\n");
            this.writer.write("    a {text-decoration: none}\n");
            this.writer.write("  </style>\n");
            this.writer.write("</head>\n");
            this.writer.write("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.writer.write("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.writer.write("\n");
        } else {
            this.writer.write(this.htmlHeader);
        }
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            this.defaultFont = null;
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                int pageIndex = this.startPageIndex;
                while (pageIndex <= this.endPageIndex) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = (JRPrintPage)pages.get(pageIndex);
                    this.writer.write("<a name=\"JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (pageIndex + 1) + "\">\n");
                    this.exportPage(page);
                    if (this.betweenPagesHtml == null) {
                        this.writer.write("<br>\n<br>\n");
                    } else {
                        this.writer.write(this.betweenPagesHtml);
                    }
                    this.writer.write("\n");
                    ++pageIndex;
                }
            }
            ++this.reportIndex;
        }
        if (this.htmlFooter == null) {
            this.writer.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.writer.write("</table>\n");
            this.writer.write("</body>\n");
            this.writer.write("</html>\n");
        } else {
            this.writer.write(this.htmlFooter);
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.writer.write("<table width=" + this.jasperPrint.getPageWidth() + " cellpadding=0 cellspacing=0 border=0\n");
        if (this.isWhitePageBackground) {
            this.writer.write(" bgcolor=white");
        }
        this.writer.write(">\n");
        this.layoutGrid(page);
        this.writer.write("<tr>\n");
        int width = 0;
        int i = 1;
        while (i < this.xCuts.size()) {
            width = (Integer)this.xCuts.get(i) - (Integer)this.xCuts.get(i - 1);
            this.writer.write("  <td" + this.emptyCellStringProvider.getStringForCollapsedTD(this.imagesURI) + " width=" + width + " height=1></td>\n");
            ++i;
        }
        this.writer.write("</tr>\n");
        JRPrintElement element = null;
        int y = 0;
        while (y < this.grid.length) {
            if (this.isRowNotEmpty[y] || !this.isRemoveEmptySpace) {
                this.writer.write("<tr valign=top>\n");
                int emptyCellColSpan = 0;
                int emptyCellWidth = 0;
                int lastRowHeight = this.grid[y][0].height;
                int x = 0;
                while (x < this.grid[y].length) {
                    if (this.grid[y][x].element != null) {
                        if (emptyCellColSpan > 0) {
                            this.writer.write("  <td");
                            if (emptyCellColSpan > 1) {
                                this.writer.write(" colspan=" + emptyCellColSpan);
                            }
                            this.writer.write(this.emptyCellStringProvider.getStringForCollapsedTD(this.imagesURI) + " width=" + emptyCellWidth + " height=" + lastRowHeight + "></td>\n");
                            emptyCellColSpan = 0;
                            emptyCellWidth = 0;
                        }
                        if ((element = this.grid[y][x].element) instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)element, this.grid[y][x]);
                        } else if (element instanceof JRPrintRectangle) {
                            this.exportRectangle(element, this.grid[y][x]);
                        } else if (element instanceof JRPrintEllipse) {
                            this.exportRectangle(element, this.grid[y][x]);
                        } else if (element instanceof JRPrintImage) {
                            this.exportImage((JRPrintImage)element, this.grid[y][x]);
                        } else if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, this.grid[y][x]);
                        }
                        x += this.grid[y][x].colSpan - 1;
                    } else {
                        ++emptyCellColSpan;
                        emptyCellWidth += this.grid[y][x].width;
                    }
                    ++x;
                }
                if (emptyCellColSpan > 0) {
                    this.writer.write("  <td");
                    if (emptyCellColSpan > 1) {
                        this.writer.write(" colspan=" + emptyCellColSpan);
                    }
                    this.writer.write(this.emptyCellStringProvider.getStringForCollapsedTD(this.imagesURI) + " width=" + emptyCellWidth + " height=" + lastRowHeight + "></td>\n");
                }
                this.writer.write("</tr>\n");
            }
            ++y;
        }
        this.writer.write("</table>\n");
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell) throws IOException {
        this.writer.write("  <td");
        if (gridCell.colSpan > 1) {
            this.writer.write(" colspan=" + gridCell.colSpan);
        }
        if (gridCell.rowSpan > 1) {
            this.writer.write(" rowspan=" + gridCell.rowSpan);
        }
        if (line.getForecolor().getRGB() != Color.white.getRGB()) {
            this.writer.write(" bgcolor=#");
            String hexa = Integer.toHexString(line.getForecolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.writer.write(hexa);
        }
        this.writer.write(">");
        this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        this.writer.write("</td>\n");
    }

    protected void exportRectangle(JRPrintElement element, JRExporterGridCell gridCell) throws IOException {
        this.writer.write("  <td");
        if (gridCell.colSpan > 1) {
            this.writer.write(" colspan=" + gridCell.colSpan);
        }
        if (gridCell.rowSpan > 1) {
            this.writer.write(" rowspan=" + gridCell.rowSpan);
        }
        if (element.getBackcolor().getRGB() != Color.white.getRGB() && element.getMode() == 1) {
            this.writer.write(" bgcolor=#");
            String hexa = Integer.toHexString(element.getBackcolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.writer.write(hexa);
        }
        this.writer.write(">");
        this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        this.writer.write("</td>\n");
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            JRFont font = textElement.getFont();
            if (font == null) {
                font = this.getDefaultFont();
            }
            HashMap<TextAttribute, Color> attributes = new HashMap<TextAttribute, Color>();
            attributes.putAll(font.getAttributes());
            attributes.put(TextAttribute.FOREGROUND, textElement.getForecolor());
            if (textElement.getMode() == 1) {
                attributes.put(TextAttribute.BACKGROUND, textElement.getBackcolor());
            }
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(attributes, text);
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(attributes, 0, text.length()));
            }
        }
        return styledText;
    }

    protected void exportStyledText(JRStyledText styledText) throws IOException {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit));
            iterator.setIndex(runLimit);
        }
    }

    protected void exportStyledTextRun(Map attributes, String text) throws IOException {
        Color backcolor;
        this.writer.write("<span style=\"font-family: ");
        this.writer.write((String)attributes.get(TextAttribute.FAMILY));
        this.writer.write("; ");
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        if (!Color.black.equals(forecolor)) {
            this.writer.write("color: #");
            String hexa = Integer.toHexString(forecolor.getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.writer.write(hexa);
            this.writer.write("; ");
        }
        if ((backcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null) {
            this.writer.write("background-color: #");
            String hexa = Integer.toHexString(backcolor.getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.writer.write(hexa);
            this.writer.write("; ");
        }
        this.writer.write("font-size: ");
        this.writer.write(String.valueOf(attributes.get(TextAttribute.SIZE)));
        this.writer.write("px;");
        if (TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT))) {
            this.writer.write(" font-weight: bold;");
        }
        if (TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE))) {
            this.writer.write(" font-style: italic;");
        }
        if (TextAttribute.UNDERLINE_ON.equals(attributes.get(TextAttribute.UNDERLINE))) {
            this.writer.write(" text-decoration: underline;");
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(attributes.get(TextAttribute.STRIKETHROUGH))) {
            this.writer.write(" text-decoration: line-through;");
        }
        this.writer.write("\">");
        this.writer.write(JRHtmlExporter.replaceNewLineWithBR(JRStringUtil.xmlEncode(text)));
        this.writer.write("</span>");
    }

    protected void exportText(JRPrintText text, JRExporterGridCell gridCell) throws IOException {
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        this.writer.write("  <td");
        if (gridCell.colSpan > 1) {
            this.writer.write(" colspan=" + gridCell.colSpan);
        }
        if (gridCell.rowSpan > 1) {
            this.writer.write(" rowspan=" + gridCell.rowSpan);
        }
        String verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
        switch (text.getVerticalAlignment()) {
            case 3: {
                verticalAlignment = HTML_VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case 2: {
                verticalAlignment = HTML_VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
            }
        }
        if (!verticalAlignment.equals(HTML_VERTICAL_ALIGN_TOP)) {
            this.writer.write(" valign=\"");
            this.writer.write(verticalAlignment);
            this.writer.write("\"");
        }
        StringBuffer styleBuffer = new StringBuffer();
        if (text.getBackcolor().getRGB() != Color.white.getRGB() && text.getMode() == 1) {
            styleBuffer.append("background-color: #");
            String hexa = Integer.toHexString(text.getBackcolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            styleBuffer.append(hexa);
            styleBuffer.append("; ");
        }
        String horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
        if (textLength > 0) {
            switch (text.getTextAlignment()) {
                case 3: {
                    horizontalAlignment = CSS_TEXT_ALIGN_RIGHT;
                    break;
                }
                case 2: {
                    horizontalAlignment = CSS_TEXT_ALIGN_CENTER;
                    break;
                }
                case 4: {
                    horizontalAlignment = CSS_TEXT_ALIGN_JUSTIFY;
                    break;
                }
                default: {
                    horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
                }
            }
            if (!horizontalAlignment.equals(CSS_TEXT_ALIGN_LEFT)) {
                styleBuffer.append("text-align: ");
                styleBuffer.append(horizontalAlignment);
                styleBuffer.append(";");
            }
        }
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (text.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(text.getAnchorName());
            this.writer.write("\">");
        }
        String href = null;
        switch (text.getHyperlinkType()) {
            case 2: {
                if (text.getHyperlinkReference() == null) break;
                href = text.getHyperlinkReference();
                break;
            }
            case 3: {
                if (text.getHyperlinkAnchor() == null) break;
                href = "#" + text.getHyperlinkAnchor();
                break;
            }
            case 4: {
                if (text.getHyperlinkPage() == null) break;
                href = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + text.getHyperlinkPage().toString();
                break;
            }
            case 5: {
                if (text.getHyperlinkReference() == null || text.getHyperlinkAnchor() == null) break;
                href = text.getHyperlinkReference() + "#" + text.getHyperlinkAnchor();
                break;
            }
            case 6: {
                if (text.getHyperlinkReference() == null || text.getHyperlinkPage() == null) break;
                href = text.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + text.getHyperlinkPage().toString();
                break;
            }
        }
        if (href != null) {
            this.writer.write("<a href=\"");
            this.writer.write(href);
            this.writer.write("\">");
        }
        if (textLength > 0) {
            this.exportStyledText(styledText);
        } else {
            this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        }
        if (href != null) {
            this.writer.write("</a>");
        }
        this.writer.write("</td>\n");
    }

    protected void exportImage(JRPrintImage image, JRExporterGridCell gridCell) throws JRException, IOException {
        this.writer.write("  <td");
        if (gridCell.colSpan > 1) {
            this.writer.write(" colspan=" + gridCell.colSpan);
        }
        if (gridCell.rowSpan > 1) {
            this.writer.write(" rowspan=" + gridCell.rowSpan);
        }
        if (image.getBackcolor().getRGB() != Color.white.getRGB() && image.getMode() == 1) {
            this.writer.write(" bgcolor=#");
            String hexa = Integer.toHexString(image.getBackcolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.writer.write(hexa);
        }
        String horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
        switch (image.getHorizontalAlignment()) {
            case 3: {
                horizontalAlignment = CSS_TEXT_ALIGN_RIGHT;
                break;
            }
            case 2: {
                horizontalAlignment = CSS_TEXT_ALIGN_CENTER;
                break;
            }
            default: {
                horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
            }
        }
        if (!horizontalAlignment.equals(CSS_TEXT_ALIGN_LEFT)) {
            this.writer.write(" align=\"");
            this.writer.write(horizontalAlignment);
            this.writer.write("\"");
        }
        String verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
        switch (image.getVerticalAlignment()) {
            case 3: {
                verticalAlignment = HTML_VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case 2: {
                verticalAlignment = HTML_VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
            }
        }
        if (!verticalAlignment.equals(HTML_VERTICAL_ALIGN_TOP)) {
            this.writer.write(" valign=\"");
            this.writer.write(verticalAlignment);
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (image.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(image.getAnchorName());
            this.writer.write("\">");
        }
        String href = null;
        switch (image.getHyperlinkType()) {
            case 2: {
                if (image.getHyperlinkReference() == null) break;
                href = image.getHyperlinkReference();
                break;
            }
            case 3: {
                if (image.getHyperlinkAnchor() == null) break;
                href = "#" + image.getHyperlinkAnchor();
                break;
            }
            case 4: {
                if (image.getHyperlinkPage() == null) break;
                href = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + image.getHyperlinkPage().toString();
                break;
            }
            case 5: {
                if (image.getHyperlinkReference() == null || image.getHyperlinkAnchor() == null) break;
                href = image.getHyperlinkReference() + "#" + image.getHyperlinkAnchor();
                break;
            }
            case 6: {
                if (image.getHyperlinkReference() == null || image.getHyperlinkPage() == null) break;
                href = image.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + image.getHyperlinkPage().toString();
                break;
            }
        }
        if (href != null) {
            this.writer.write("<a href=\"");
            this.writer.write(href);
            this.writer.write("\">");
        }
        this.writer.write("<img");
        String imagePath = "";
        int scaleImage = image.getScaleImage();
        JRRenderable renderer = image.getRenderer();
        if (renderer != null) {
            if (renderer.getType() == 0 && this.rendererToImageNameMap.containsKey(renderer)) {
                imagePath = this.imagesURI + (String)this.rendererToImageNameMap.get(renderer);
            } else {
                if (renderer.getType() == 1) {
                    renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), image.getBackcolor());
                }
                String imageName = "img_" + String.valueOf(this.rendererToImageNameMap.size());
                this.rendererToImageNameMap.put(renderer, imageName);
                this.imageNameToImageDataMap.put(imageName, renderer.getImageData());
                imagePath = this.imagesURI + imageName;
            }
        } else {
            this.loadPxImage();
            imagePath = this.imagesURI + "px";
            scaleImage = 2;
        }
        this.writer.write(" src=\"");
        this.writer.write(imagePath);
        this.writer.write("\"");
        int borderWidth = 0;
        switch (image.getPen()) {
            case 4: {
                borderWidth = 1;
                break;
            }
            case 3: {
                borderWidth = 4;
                break;
            }
            case 2: {
                borderWidth = 2;
                break;
            }
            case 0: {
                borderWidth = 0;
                break;
            }
            case 5: {
                borderWidth = 1;
                break;
            }
            default: {
                borderWidth = 1;
            }
        }
        this.writer.write(" border=");
        this.writer.write(String.valueOf(borderWidth));
        switch (scaleImage) {
            case 2: {
                this.writer.write(" width=");
                this.writer.write(String.valueOf(image.getWidth()));
                this.writer.write(" height=");
                this.writer.write(String.valueOf(image.getHeight()));
                break;
            }
            default: {
                double normalWidth = image.getWidth();
                double normalHeight = image.getHeight();
                Dimension2D dimension = renderer.getDimension();
                if (dimension != null) {
                    normalWidth = dimension.getWidth();
                    normalHeight = dimension.getHeight();
                }
                if (image.getHeight() <= 0) break;
                double ratio = normalWidth / normalHeight;
                if (ratio > (double)image.getWidth() / (double)image.getHeight()) {
                    this.writer.write(" width=");
                    this.writer.write(String.valueOf(image.getWidth()));
                    break;
                }
                this.writer.write(" height=");
                this.writer.write(String.valueOf(image.getHeight()));
            }
        }
        this.writer.write(">");
        if (href != null) {
            this.writer.write("</a>");
        }
        this.writer.write("</td>\n");
    }

    protected void layoutGrid(JRPrintPage page) {
        this.xCuts = new ArrayList();
        this.yCuts = new ArrayList();
        this.xCuts.add(new Integer(0));
        this.xCuts.add(new Integer(this.jasperPrint.getPageWidth()));
        this.yCuts.add(new Integer(0));
        this.yCuts.add(new Integer(this.jasperPrint.getPageHeight()));
        Integer x = null;
        Integer y = null;
        JRPrintElement element = null;
        List elems = page.getElements();
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            element = (JRPrintElement)it.next();
            x = new Integer(element.getX());
            if (!this.xCuts.contains(x)) {
                this.xCuts.add(x);
            }
            if (!this.xCuts.contains(x = new Integer(element.getX() + element.getWidth()))) {
                this.xCuts.add(x);
            }
            if (!this.yCuts.contains(y = new Integer(element.getY()))) {
                this.yCuts.add(y);
            }
            if (this.yCuts.contains(y = new Integer(element.getY() + element.getHeight()))) continue;
            this.yCuts.add(y);
        }
        Collections.sort(this.xCuts);
        Collections.sort(this.yCuts);
        int xCellCount = this.xCuts.size() - 1;
        int yCellCount = this.yCuts.size() - 1;
        this.grid = new JRExporterGridCell[yCellCount][xCellCount];
        this.isRowNotEmpty = new boolean[yCellCount];
        int j = 0;
        while (j < yCellCount) {
            int i = 0;
            while (i < xCellCount) {
                this.grid[j][i] = new JRExporterGridCell(null, (Integer)this.xCuts.get(i + 1) - (Integer)this.xCuts.get(i), (Integer)this.yCuts.get(j + 1) - (Integer)this.yCuts.get(j), 1, 1);
                ++i;
            }
            ++j;
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int xi = 0;
        int yi = 0;
        boolean isOverlap = false;
        int i = elems.size() - 1;
        while (i >= 0) {
            element = (JRPrintElement)elems.get(i);
            x1 = this.xCuts.indexOf(new Integer(element.getX()));
            y1 = this.yCuts.indexOf(new Integer(element.getY()));
            x2 = this.xCuts.indexOf(new Integer(element.getX() + element.getWidth()));
            y2 = this.yCuts.indexOf(new Integer(element.getY() + element.getHeight()));
            isOverlap = false;
            yi = y1;
            while (yi < y2 && !isOverlap) {
                xi = x1;
                while (xi < x2 && !isOverlap) {
                    if (this.grid[yi][xi].element != null) {
                        isOverlap = true;
                    }
                    ++xi;
                }
                ++yi;
            }
            if (!isOverlap) {
                yi = y1;
                while (yi < y2) {
                    xi = x1;
                    while (xi < x2) {
                        this.grid[yi][xi] = JRExporterGridCell.OCCUPIED_CELL;
                        ++xi;
                    }
                    this.isRowNotEmpty[yi] = true;
                    ++yi;
                }
                if (x2 - x1 != 0 && y2 - y1 != 0) {
                    this.grid[y1][x1] = new JRExporterGridCell(element, element.getWidth(), element.getHeight(), x2 - x1, y2 - y1);
                }
            }
            --i;
        }
    }

    protected static String replaceNewLineWithBR(String source) {
        String str = null;
        if (source != null) {
            StringBuffer sbuffer = new StringBuffer();
            StringTokenizer tkzer = new StringTokenizer(source, "\n", true);
            String token = null;
            while (tkzer.hasMoreTokens()) {
                token = tkzer.nextToken();
                if ("\n".equals(token)) {
                    sbuffer.append("<br>");
                    continue;
                }
                sbuffer.append(token);
            }
            str = sbuffer.toString();
        }
        return str;
    }

    protected void loadPxImage() throws JRException {
        if (!this.imageNameToImageDataMap.containsKey("px")) {
            JRImageRenderer pxRenderer = JRImageRenderer.getInstance(JRImageLoader.loadImageDataFromLocation("net/sf/jasperreports/engine/images/pixel.GIF"));
            this.rendererToImageNameMap.put(pxRenderer, "px");
            this.imageNameToImageDataMap.put("px", pxRenderer.getImageData());
        }
    }

    protected static interface StringProvider {
        public String getStringForCollapsedTD(Object var1);

        public String getStringForEmptyTD(Object var1);
    }
}

