/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class JRGraphics2DExporter
extends JRAbstractExporter {
    protected Graphics2D grx = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected float zoom = 1.0f;
    protected JRFont defaultFont = null;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();

    public JRGraphics2DExporter() throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
    }

    protected JRFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRBaseFont();
            }
        }
        return this.defaultFont;
    }

    public void exportReport() throws JRException {
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setInput();
        this.setPageRange();
        this.grx = (Graphics2D)this.parameters.get(JRGraphics2DExporterParameter.GRAPHICS_2D);
        if (this.grx == null) {
            throw new JRException("No output specified for the exporter. java.awt.Graphics2D object expected.");
        }
        Float zoomRatio = (Float)this.parameters.get(JRGraphics2DExporterParameter.ZOOM_RATIO);
        if (zoomRatio != null) {
            this.zoom = zoomRatio.floatValue();
            if (this.zoom <= 0.0f) {
                throw new JRException("Invalid zoom ratio : " + this.zoom);
            }
        }
        this.exportReportToGraphics2D();
    }

    public void exportReportToGraphics2D() {
        this.grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.grx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        AffineTransform atrans = new AffineTransform();
        atrans.scale(this.zoom, this.zoom);
        this.grx.transform(atrans);
        List pages = this.jasperPrint.getPages();
        if (pages != null) {
            JRPrintPage page = (JRPrintPage)pages.get(this.startPageIndex);
            this.exportPage(page);
        }
    }

    protected void exportPage(JRPrintPage page) {
        this.grx.setColor(Color.white);
        this.grx.fillRect(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
        this.grx.setColor(Color.black);
        this.grx.setStroke(new BasicStroke(1.0f));
        JRPrintElement element = null;
        List elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (!(element instanceof JRPrintText)) continue;
                this.exportText((JRPrintText)element);
            }
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportLine(JRPrintLine line) {
        this.grx.setColor(line.getForecolor());
        BasicStroke stroke = null;
        switch (line.getPen()) {
            case 4: {
                stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
                break;
            }
            case 3: {
                stroke = new BasicStroke(4.0f);
                break;
            }
            case 2: {
                stroke = new BasicStroke(2.0f);
                break;
            }
            case 5: {
                stroke = new BasicStroke(0.5f);
                break;
            }
            case 0: {
                break;
            }
            default: {
                stroke = new BasicStroke(1.0f);
            }
        }
        if (stroke != null) {
            this.grx.setStroke(stroke);
            if (line.getDirection() == 1) {
                this.grx.drawLine(line.getX(), line.getY(), line.getX() + line.getWidth() - 1, line.getY() + line.getHeight() - 1);
            } else {
                this.grx.drawLine(line.getX(), line.getY() + line.getHeight() - 1, line.getX() + line.getWidth() - 1, line.getY());
            }
        }
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        if (rectangle.getMode() == 1) {
            this.grx.setColor(rectangle.getBackcolor());
            this.grx.fillRoundRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
        }
        this.grx.setColor(rectangle.getForecolor());
        BasicStroke stroke = null;
        switch (rectangle.getPen()) {
            case 4: {
                stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
                break;
            }
            case 3: {
                stroke = new BasicStroke(4.0f);
                break;
            }
            case 2: {
                stroke = new BasicStroke(2.0f);
                break;
            }
            case 5: {
                stroke = new BasicStroke(0.5f);
                break;
            }
            case 0: {
                break;
            }
            default: {
                stroke = new BasicStroke(1.0f);
            }
        }
        if (stroke != null) {
            this.grx.setStroke(stroke);
            this.grx.drawRoundRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth() - 1, rectangle.getHeight() - 1, 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
        }
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        if (ellipse.getMode() == 1) {
            this.grx.setColor(ellipse.getBackcolor());
            this.grx.fillOval(ellipse.getX(), ellipse.getY(), ellipse.getWidth(), ellipse.getHeight());
        }
        this.grx.setColor(ellipse.getForecolor());
        BasicStroke stroke = null;
        switch (ellipse.getPen()) {
            case 4: {
                stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
                break;
            }
            case 3: {
                stroke = new BasicStroke(4.0f);
                break;
            }
            case 2: {
                stroke = new BasicStroke(2.0f);
                break;
            }
            case 5: {
                stroke = new BasicStroke(0.5f);
                break;
            }
            case 0: {
                break;
            }
            default: {
                stroke = new BasicStroke(1.0f);
            }
        }
        if (stroke != null) {
            this.grx.setStroke(stroke);
            this.grx.drawOval(ellipse.getX(), ellipse.getY(), ellipse.getWidth() - 1, ellipse.getHeight() - 1);
        }
    }

    protected void exportImage(JRPrintImage printImage) {
        if (printImage.getMode() == 1) {
            this.grx.setColor(printImage.getBackcolor());
            this.grx.fillRect(printImage.getX(), printImage.getY(), printImage.getWidth(), printImage.getHeight());
        }
        int borderOffset = 0;
        BasicStroke stroke = null;
        switch (printImage.getPen()) {
            case 4: {
                borderOffset = 0;
                stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
                break;
            }
            case 3: {
                borderOffset = 2;
                stroke = new BasicStroke(4.0f);
                break;
            }
            case 2: {
                borderOffset = 1;
                stroke = new BasicStroke(2.0f);
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                borderOffset = 0;
                stroke = new BasicStroke(0.5f);
                break;
            }
            default: {
                borderOffset = 0;
                stroke = new BasicStroke(1.0f);
            }
        }
        int availableImageWidth = printImage.getWidth() - 2 * borderOffset;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - 2 * borderOffset;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        JRRenderable renderer = printImage.getRenderer();
        if (availableImageWidth > 0 && availableImageHeight > 0 && renderer != null) {
            int normalWidth = availableImageWidth;
            int normalHeight = availableImageHeight;
            Dimension2D dimension = renderer.getDimension();
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            float xalignFactor = 0.0f;
            switch (printImage.getHorizontalAlignment()) {
                case 3: {
                    xalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    xalignFactor = 0.5f;
                    break;
                }
                default: {
                    xalignFactor = 0.0f;
                }
            }
            float yalignFactor = 0.0f;
            switch (printImage.getVerticalAlignment()) {
                case 3: {
                    yalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    yalignFactor = 0.5f;
                    break;
                }
                default: {
                    yalignFactor = 0.0f;
                }
            }
            switch (printImage.getScaleImage()) {
                case 1: {
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    this.grx.setClip(printImage.getX() + borderOffset, printImage.getY() + borderOffset, availableImageWidth, availableImageHeight);
                    renderer.render(this.grx, new Rectangle(printImage.getX() + xoffset + borderOffset, printImage.getY() + yoffset + borderOffset, normalWidth, normalHeight));
                    this.grx.setClip(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
                    break;
                }
                case 2: {
                    renderer.render(this.grx, new Rectangle(printImage.getX() + borderOffset, printImage.getY() + borderOffset, availableImageWidth, availableImageHeight));
                    break;
                }
                default: {
                    if (printImage.getHeight() <= 0) break;
                    double ratio = (double)normalWidth / (double)normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        normalWidth = availableImageWidth;
                        normalHeight = (int)((double)availableImageWidth / ratio);
                    } else {
                        normalWidth = (int)((double)availableImageHeight * ratio);
                        normalHeight = availableImageHeight;
                    }
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    renderer.render(this.grx, new Rectangle(printImage.getX() + xoffset + borderOffset, printImage.getY() + yoffset + borderOffset, normalWidth, normalHeight));
                }
            }
        }
        if (stroke != null) {
            this.grx.setColor(printImage.getForecolor());
            this.grx.setStroke(stroke);
            this.grx.drawRect(printImage.getX(), printImage.getY(), printImage.getWidth() - 1, printImage.getHeight() - 1);
        }
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            text = JRStringUtil.treatNewLineChars(text);
            JRFont font = textElement.getFont();
            if (font == null) {
                font = this.getDefaultFont();
            }
            HashMap<TextAttribute, Color> attributes = new HashMap<TextAttribute, Color>();
            attributes.putAll(font.getAttributes());
            attributes.put(TextAttribute.FOREGROUND, textElement.getForecolor());
            if (textElement.getMode() == 1) {
                attributes.put(TextAttribute.BACKGROUND, textElement.getBackcolor());
            }
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(attributes, text);
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(attributes, 0, text.length()));
            }
        }
        return styledText;
    }

    protected void exportText(JRPrintText text) {
        JRStyledText styledText = this.getStyledText(text);
        if (styledText == null) {
            return;
        }
        String allText = styledText.getText();
        int x = text.getX();
        int y = text.getY();
        int width = text.getWidth();
        int height = text.getHeight();
        double angle = 0.0;
        switch (text.getRotation()) {
            case 1: {
                y = text.getY() + text.getHeight();
                width = text.getHeight();
                height = text.getWidth();
                angle = -1.5707963267948966;
                break;
            }
            case 2: {
                x = text.getX() + text.getWidth();
                width = text.getHeight();
                height = text.getWidth();
                angle = 1.5707963267948966;
                break;
            }
        }
        this.grx.rotate(angle, x, y);
        if (text.getMode() == 1) {
            this.grx.setColor(text.getBackcolor());
            this.grx.fillRect(x, y, width, height);
        }
        if (allText.length() == 0) {
            return;
        }
        float formatWidth = width;
        float verticalOffset = 0.0f;
        switch (text.getVerticalAlignment()) {
            case 1: {
                verticalOffset = 0.0f;
                break;
            }
            case 2: {
                verticalOffset = ((float)height - text.getTextHeight()) / 2.0f;
                break;
            }
            case 3: {
                verticalOffset = (float)height - text.getTextHeight();
                break;
            }
            default: {
                verticalOffset = 0.0f;
            }
        }
        float lineSpacing = 1.0f;
        switch (text.getLineSpacing()) {
            case 0: {
                lineSpacing = 1.0f;
                break;
            }
            case 1: {
                lineSpacing = 1.5f;
                break;
            }
            case 2: {
                lineSpacing = 2.0f;
                break;
            }
            default: {
                lineSpacing = 1.0f;
            }
        }
        int maxHeight = height;
        FontRenderContext fontRenderContext = this.grx.getFontRenderContext();
        float drawPosY = 0.0f;
        float drawPosX = 0.0f;
        boolean isMaxHeightReached = false;
        int paragraphStart = 0;
        int paragraphEnd = 0;
        AttributedCharacterIterator allParagraphs = styledText.getAttributedString().getIterator();
        StringTokenizer tkzer = new StringTokenizer(allText, "\n", true);
        while (tkzer.hasMoreTokens() && !isMaxHeightReached) {
            String paragraphText = tkzer.nextToken();
            paragraphStart = paragraphEnd;
            paragraphEnd = paragraphStart + paragraphText.length();
            if ("\n".equals(paragraphText)) continue;
            AttributedCharacterIterator paragraph = new AttributedString(allParagraphs, paragraphStart, paragraphEnd).getIterator();
            LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, fontRenderContext);
            while (lineMeasurer.getPosition() < paragraphText.length() && !isMaxHeightReached) {
                int startIndex = lineMeasurer.getPosition();
                TextLayout layout = lineMeasurer.nextLayout(formatWidth);
                AttributedString tmpText = new AttributedString(paragraph, startIndex, startIndex + layout.getCharacterCount());
                if ((drawPosY += (layout = new TextLayout(tmpText.getIterator(), fontRenderContext)).getLeading() + lineSpacing * layout.getAscent()) + layout.getDescent() <= (float)maxHeight) {
                    switch (text.getTextAlignment()) {
                        case 4: {
                            drawPosX = layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance();
                            if (lineMeasurer.getPosition() >= paragraphEnd) break;
                            layout = layout.getJustifiedLayout(formatWidth);
                            break;
                        }
                        case 3: {
                            if (layout.isLeftToRight()) {
                                drawPosX = formatWidth - layout.getAdvance();
                                break;
                            }
                            drawPosX = formatWidth;
                            break;
                        }
                        case 2: {
                            drawPosX = (formatWidth - layout.getAdvance()) / 2.0f;
                            break;
                        }
                        default: {
                            drawPosX = layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance();
                        }
                    }
                    layout.draw(this.grx, drawPosX + (float)x, drawPosY + (float)y + verticalOffset);
                    drawPosY += layout.getDescent();
                    continue;
                }
                drawPosY -= layout.getLeading() + lineSpacing * layout.getAscent();
                isMaxHeightReached = true;
            }
        }
        this.grx.rotate(-angle, x, y);
    }
}

