/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.beanutils.PropertyUtils;

public class JRBeanArrayDataSource
implements JRRewindableDataSource {
    private Object[] data = null;
    private int index = -1;

    public JRBeanArrayDataSource(Object[] beanArray) {
        this.data = beanArray;
    }

    public boolean next() throws JRException {
        ++this.index;
        if (this.data != null) {
            return this.index < this.data.length;
        }
        return false;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Object value = null;
        Object bean = this.data[this.index];
        if (bean != null) {
            try {
                value = PropertyUtils.getProperty((Object)bean, (String)jrField.getName());
            }
            catch (IllegalAccessException e) {
                throw new JRException("Error retrieving field value from bean : " + jrField.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new JRException("Error retrieving field value from bean : " + jrField.getName(), e);
            }
            catch (NoSuchMethodException e) {
                throw new JRException("Error retrieving field value from bean : " + jrField.getName(), e);
            }
        }
        return value;
    }

    public void moveFirst() throws JRException {
        this.index = -1;
    }
}

