/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignField;

public abstract class JRAbstractBeanDataSourceProvider
implements JRDataSourceProvider {
    private Class beanClass;
    private static String[] fieldClassNames;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;

    public JRAbstractBeanDataSourceProvider(Class beanClass) {
        if (beanClass == null) {
            throw new NullPointerException("beanClass must not be null");
        }
        this.beanClass = beanClass;
    }

    public boolean supportsGetFieldsOperation() {
        return true;
    }

    public JRField[] getFields(JasperReport report) throws JRException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.beanClass);
        }
        catch (IntrospectionException e) {
            throw new JRException(e);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors != null) {
            ArrayList<JRDesignField> fields = new ArrayList<JRDesignField>(descriptors.length);
            int i = 0;
            while (i < descriptors.length) {
                PropertyDescriptor descriptor = descriptors[i];
                if (!(descriptor instanceof IndexedPropertyDescriptor) && descriptor.getReadMethod() != null) {
                    JRDesignField field = new JRDesignField();
                    String valueClassName = JRAbstractBeanDataSourceProvider.normalizeClass(descriptor.getPropertyType()).getName();
                    if (!JRAbstractBeanDataSourceProvider.isValidFieldClass(valueClassName)) {
                        valueClassName = (class$java$lang$Object == null ? JRAbstractBeanDataSourceProvider.class$("java.lang.Object") : class$java$lang$Object).getName();
                    }
                    field.setValueClassName(valueClassName);
                    field.setName(descriptor.getName());
                    fields.add(field);
                }
                ++i;
            }
            return fields.toArray(new JRField[fields.size()]);
        }
        return new JRField[0];
    }

    private static Class normalizeClass(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRAbstractBeanDataSourceProvider.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (clazz == Byte.TYPE) {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = JRAbstractBeanDataSourceProvider.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            if (clazz == Character.TYPE) {
                return class$java$lang$Character == null ? (class$java$lang$Character = JRAbstractBeanDataSourceProvider.class$("java.lang.Character")) : class$java$lang$Character;
            }
            if (clazz == Short.TYPE) {
                return class$java$lang$Short == null ? (class$java$lang$Short = JRAbstractBeanDataSourceProvider.class$("java.lang.Short")) : class$java$lang$Short;
            }
            if (clazz == Integer.TYPE) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = JRAbstractBeanDataSourceProvider.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (clazz == Long.TYPE) {
                return class$java$lang$Long == null ? (class$java$lang$Long = JRAbstractBeanDataSourceProvider.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (clazz == Float.TYPE) {
                return class$java$lang$Float == null ? (class$java$lang$Float = JRAbstractBeanDataSourceProvider.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (clazz == Double.TYPE) {
                return class$java$lang$Double == null ? (class$java$lang$Double = JRAbstractBeanDataSourceProvider.class$("java.lang.Double")) : class$java$lang$Double;
            }
        }
        return clazz;
    }

    private static boolean isValidFieldClass(String className) {
        return Arrays.binarySearch(fieldClassNames, className) >= 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (fieldClassNames == null) {
            fieldClassNames = new String[]{(class$java$lang$Object == null ? (class$java$lang$Object = JRAbstractBeanDataSourceProvider.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRAbstractBeanDataSourceProvider.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), (class$java$lang$Byte == null ? (class$java$lang$Byte = JRAbstractBeanDataSourceProvider.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), (class$java$util$Date == null ? (class$java$util$Date = JRAbstractBeanDataSourceProvider.class$("java.util.Date")) : class$java$util$Date).getName(), (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRAbstractBeanDataSourceProvider.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName(), (class$java$sql$Time == null ? (class$java$sql$Time = JRAbstractBeanDataSourceProvider.class$("java.sql.Time")) : class$java$sql$Time).getName(), (class$java$lang$Double == null ? (class$java$lang$Double = JRAbstractBeanDataSourceProvider.class$("java.lang.Double")) : class$java$lang$Double).getName(), (class$java$lang$Float == null ? (class$java$lang$Float = JRAbstractBeanDataSourceProvider.class$("java.lang.Float")) : class$java$lang$Float).getName(), (class$java$lang$Integer == null ? (class$java$lang$Integer = JRAbstractBeanDataSourceProvider.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), (class$java$io$InputStream == null ? (class$java$io$InputStream = JRAbstractBeanDataSourceProvider.class$("java.io.InputStream")) : class$java$io$InputStream).getName(), (class$java$lang$Long == null ? (class$java$lang$Long = JRAbstractBeanDataSourceProvider.class$("java.lang.Long")) : class$java$lang$Long).getName(), (class$java$lang$Short == null ? (class$java$lang$Short = JRAbstractBeanDataSourceProvider.class$("java.lang.Short")) : class$java$lang$Short).getName(), (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRAbstractBeanDataSourceProvider.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName(), (class$java$lang$String == null ? (class$java$lang$String = JRAbstractBeanDataSourceProvider.class$("java.lang.String")) : class$java$lang$String).getName()};
            Arrays.sort(fieldClassNames);
        }
    }
}

