/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRFiller;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;

public class JasperFillManager {
    public static String fillReportToFile(String sourceFileName, Map parameters, Connection conn) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperReport.getName() + ".jrprint");
        String destFileName = destFile.toString();
        JasperFillManager.fillReportToFile(jasperReport, destFileName, parameters, conn);
        return destFileName;
    }

    public static void fillReportToFile(String sourceFileName, String destFileName, Map parameters, Connection conn) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFileName);
        JasperFillManager.fillReportToFile(jasperReport, destFileName, parameters, conn);
    }

    public static void fillReportToFile(JasperReport jasperReport, String destFileName, Map parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, conn);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
    }

    public static JasperPrint fillReport(String sourceFileName, Map parameters, Connection conn) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        return JasperFillManager.fillReport(jasperReport, parameters, conn);
    }

    public static void fillReportToStream(InputStream inputStream, OutputStream outputStream, Map parameters, Connection conn) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        JasperFillManager.fillReportToStream(jasperReport, outputStream, parameters, conn);
    }

    public static void fillReportToStream(JasperReport jasperReport, OutputStream outputStream, Map parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, conn);
        JRSaver.saveObject((Object)jasperPrint, outputStream);
    }

    public static JasperPrint fillReport(InputStream inputStream, Map parameters, Connection conn) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        return JasperFillManager.fillReport(jasperReport, parameters, conn);
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map parameters, Connection conn) throws JRException {
        return JRFiller.fillReport(jasperReport, parameters, conn);
    }

    public static String fillReportToFile(String sourceFileName, Map parameters, JRDataSource jrDataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperReport.getName() + ".jrprint");
        String destFileName = destFile.toString();
        JasperFillManager.fillReportToFile(jasperReport, destFileName, parameters, jrDataSource);
        return destFileName;
    }

    public static void fillReportToFile(String sourceFileName, String destFileName, Map parameters, JRDataSource jrDataSource) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFileName);
        JasperFillManager.fillReportToFile(jasperReport, destFileName, parameters, jrDataSource);
    }

    public static void fillReportToFile(JasperReport jasperReport, String destFileName, Map parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, jrDataSource);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
    }

    public static JasperPrint fillReport(String sourceFileName, Map parameters, JRDataSource jrDataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        return JasperFillManager.fillReport(jasperReport, parameters, jrDataSource);
    }

    public static void fillReportToStream(InputStream inputStream, OutputStream outputStream, Map parameters, JRDataSource jrDataSource) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        JasperFillManager.fillReportToStream(jasperReport, outputStream, parameters, jrDataSource);
    }

    public static void fillReportToStream(JasperReport jasperReport, OutputStream outputStream, Map parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, jrDataSource);
        JRSaver.saveObject((Object)jasperPrint, outputStream);
    }

    public static JasperPrint fillReport(InputStream inputStream, Map parameters, JRDataSource jrDataSource) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        return JasperFillManager.fillReport(jasperReport, parameters, jrDataSource);
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map parameters, JRDataSource jrDataSource) throws JRException {
        return JRFiller.fillReport(jasperReport, parameters, jrDataSource);
    }
}

