/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.util.Collection;
import jcmdline.AbstractHandlerDecorator;
import jcmdline.BooleanParam;
import jcmdline.CmdLineHandler;
import jcmdline.CmdLineParser;
import jcmdline.DefaultCmdLineHandler;
import jcmdline.Parameter;
import jcmdline.StringFormatHelper;
import jcmdline.Strings;

public class HelpCmdLineHandler
extends AbstractHandlerDecorator {
    private BooleanParam helpOpt;
    private BooleanParam hiddenHelpOpt;
    private String help;
    private String hiddenHelp;

    public HelpCmdLineHandler(String help, String hiddenHelp, CmdLineHandler handler) {
        super(handler);
        if (help == null || help.length() == 0) {
            throw new IllegalArgumentException(Strings.get("HelpCmdLineHandler.helpEmptyError"));
        }
        this.help = help;
        this.hiddenHelp = hiddenHelp == null || hiddenHelp.length() == 0 ? null : hiddenHelp;
        this.helpOpt = new BooleanParam(Strings.get("HelpCmdLineHandler.help.tag"), Strings.get("HelpCmdLineHandler.help.desc"));
        this.helpOpt.setIgnoreRequired(true);
        this.hiddenHelpOpt = new BooleanParam(Strings.get("HelpCmdLineHandler.helpHidden.tag"), Strings.get("HelpCmdLineHandler.helpHidden.desc"), true);
        this.hiddenHelpOpt.setIgnoreRequired(true);
        this.setCustomOptions(new Parameter[]{this.helpOpt, this.hiddenHelpOpt});
    }

    public HelpCmdLineHandler(String help, CmdLineHandler handler) {
        this(help, null, handler);
    }

    public HelpCmdLineHandler(String help, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args, CmdLineParser parser) {
        this(help, null, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args, parser));
    }

    public HelpCmdLineHandler(String help, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args) {
        this(help, null, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    public HelpCmdLineHandler(String help, String cmdName, String cmdDesc, Collection options, Collection args) {
        this(help, null, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    public HelpCmdLineHandler(String help, String hiddenHelp, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args, CmdLineParser parser) {
        this(help, hiddenHelp, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args, parser));
    }

    public HelpCmdLineHandler(String help, String hiddenHelp, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args) {
        this(help, hiddenHelp, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    public HelpCmdLineHandler(String help, String hiddenHelp, String cmdName, String cmdDesc, Collection options, Collection args) {
        this(help, hiddenHelp, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    protected boolean processParsedOptions(boolean parseOk) {
        if (this.helpOpt.isTrue() || this.hiddenHelpOpt.isTrue()) {
            System.out.println(this.getUsage(this.hiddenHelpOpt.isTrue()));
            int lineLen = this.getParser().getUsageFormatter().getLineLength();
            StringFormatHelper sHelper = StringFormatHelper.getHelper();
            System.out.println("\n" + sHelper.formatBlockedText(this.help, 0, lineLen));
            if (this.hiddenHelpOpt.isTrue() && this.hiddenHelp != null) {
                System.out.println("\n" + sHelper.formatBlockedText(this.hiddenHelp, 0, lineLen));
            }
            System.exit(0);
        }
        return parseOk;
    }
}

