/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.chart.IReportAbstractChartFactory;
import it.businesslogic.ireport.chart.IReportChartProperties;
import it.businesslogic.ireport.chart.IReportChartTypeDescription;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.util.Hashtable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.JFreeChartConstants;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.PieDataset;

public final class IReportJFreeChartFactory
extends IReportAbstractChartFactory
implements IReportChartTypeDescription {
    public static final int CHART_TYPE_PIE = 1;
    public static final int CHART_TYPE_BAR = 2;
    public static final int CHART_TYPE_PIE_3D = 3;
    public static final int CHART_TYPE_BAR_3D = 4;
    public static final int CHART_TYPE_LINE = 5;

    private static Number[][] generateDataset(IReportChartProperties chartProperties, Hashtable dataSources, int index) throws Exception {
        return null;
    }

    private Plot generatePlot(Plot plot, IReportChartProperties chartProperties, Hashtable dataSources, int index) throws Exception {
        JFreeChart chart = null;
        int tipo = chartProperties.getType(index);
        PlotOrientation plotOrientation = "horizontal".equals(chartProperties.getChartTypeOrientation(index)) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        String title = chartProperties.getTitle(index);
        boolean legend = chartProperties.isLegendVisible(index);
        String categoryAxisLabel = null;
        String valueAxisLabel = null;
        CategoryDataset categoryDataset = null;
        PieDataset pieDataset = null;
        Number[][] values = IReportJFreeChartFactory.generateDataset(chartProperties, dataSources, index);
        categoryDataset = DatasetUtilities.createCategoryDataset((String)"Series ", (String)"Category ", (Number[][])values);
        if (!this.hasYAxis(index) && !this.hasZAxis(index)) {
            pieDataset = DatasetUtilities.createPieDatasetForColumn((CategoryDataset)categoryDataset, (int)0);
        }
        switch (tipo) {
            case 2: {
                chart = ChartFactory.createBarChart((String)title, categoryAxisLabel, valueAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
                break;
            }
            case 4: {
                chart = ChartFactory.createBarChart3D((String)title, categoryAxisLabel, valueAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
                break;
            }
            case 1: {
                chart = ChartFactory.createPieChart((String)title, (PieDataset)pieDataset, (boolean)legend, (boolean)false, (boolean)false);
                break;
            }
            case 3: {
                chart = ChartFactory.createPieChart3D((String)title, (PieDataset)pieDataset, (boolean)legend, (boolean)false, (boolean)false);
                break;
            }
            case 5: {
                chart = ChartFactory.createLineChart((String)title, categoryAxisLabel, valueAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
            }
        }
        if (chart != null) {
            plot = chart.getPlot();
        }
        return plot;
    }

    protected Image engineGenerateChartImage(IReportChartProperties chartProperties, Hashtable datasources) throws Exception {
        int chartCount = chartProperties.getCount();
        Plot plot = null;
        for (int i = 1; i <= chartCount; ++i) {
            plot = this.generatePlot(plot, chartProperties, datasources, i);
        }
        JFreeChart chart = new JFreeChart(null, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        int chartWidth = chartProperties.getWidth();
        int chartHeight = chartProperties.getHeight();
        return chart.createBufferedImage(chartWidth, chartHeight);
    }

    public int getDataSetType(int chartType) {
        int dsType = 0;
        switch (chartType) {
            case 2: {
                dsType = 1;
                break;
            }
            case 4: {
                dsType = 1;
                break;
            }
            case 1: {
                dsType = 2;
                break;
            }
            case 3: {
                dsType = 2;
                break;
            }
            case 5: {
                dsType = 1;
            }
        }
        return dsType;
    }

    public String getDescription(int chartType) {
        return this.getName(chartType);
    }

    public String getName(int chartType) {
        String text = "";
        switch (chartType) {
            case 2: {
                text = "Bar Chart";
                break;
            }
            case 4: {
                text = "Bar Chart 3D";
                break;
            }
            case 1: {
                text = "Pie Chart";
                break;
            }
            case 3: {
                text = "Pie Chart 3D";
                break;
            }
            case 5: {
                text = "Line Chart";
            }
        }
        return text;
    }

    public Image getThumbImage(int chartType) {
        return null;
    }

    public boolean hasXAxis(int chartType) {
        return true;
    }

    public boolean hasYAxis(int chartType) {
        switch (chartType) {
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean hasZAxis(int chartType) {
        return false;
    }

    protected int engineGetChartTypeCount() {
        return 5;
    }

    protected boolean allowMultipleChart() {
        return true;
    }
}

