/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.ChartReportElement;
import it.businesslogic.ireport.chart.IReportChartProperties;
import it.businesslogic.ireport.chart.gui.IReportChartWizardDialog;
import it.businesslogic.ireport.util.I18nOptionPane;
import it.businesslogic.ireport.util.Misc;
import java.awt.Frame;

public class IReportChartWizard {
    private IReportChartWizardDialog wizardDialog = null;
    private Frame parent = null;
    private IReportChartProperties chartProperties = null;
    private ChartReportElement chartReportElement = null;
    private static IReportChartWizard CHART_WIZARD = null;

    public IReportChartWizard(Frame parent) {
        this.parent = parent;
    }

    public void showWizard(ChartReportElement chartReportElement) {
        if (chartReportElement.getChartProperties().getFactory() == null || chartReportElement.getChartProperties().getFactory().trim().length() == 0) {
            I18nOptionPane.showMessageDialog(this.parent, "chartFactoryRequired", "error", 0);
            return;
        }
        if (this.wizardDialog == null) {
            this.wizardDialog = new IReportChartWizardDialog(this.parent, true);
            this.wizardDialog.setTitle("Chart Properties");
        }
        this.chartReportElement = chartReportElement;
        this.setChartProperties(chartReportElement.getChartProperties());
        this.wizardDialog.setSize(400, 400);
        Misc.centerFrame(this.wizardDialog);
        this.wizardDialog.show();
    }

    public static IReportChartWizard getInstance(Frame parent) {
        if (CHART_WIZARD == null) {
            CHART_WIZARD = new IReportChartWizard(parent);
        } else if (IReportChartWizard.CHART_WIZARD.wizardDialog == null || parent != null && IReportChartWizard.CHART_WIZARD.wizardDialog.getParent() != parent) {
            IReportChartWizard.CHART_WIZARD.wizardDialog = null;
            IReportChartWizard.CHART_WIZARD.parent = parent;
        }
        return CHART_WIZARD;
    }

    public void setChartProperties(IReportChartProperties chartProperties) {
        this.chartProperties = chartProperties;
    }
}

