/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.util.Misc;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Vector;

public class ReportElement {
    static int id_gen = 1;
    public String name;
    public Point position;
    public int width;
    public int height;
    Rectangle bounds;
    public static BufferedImage hached = null;
    public Band band;
    public String transparent;
    public String printWhenExpression = "";
    public String positionType = "FixRelativeToTop";
    public boolean isPrintRepeatedValues = true;
    public boolean isRemoveLineWhenBlank = false;
    public boolean isPrintInFirstWholeBand = false;
    public boolean isPrintWhenDetailOverflows = false;
    public static Color lightcolor;
    public String printWhenGroupChanges = "";
    double zoom_factor = 1.0;
    public Color bgcolor = null;
    public Color fgcolor = null;
    protected String stretchType;
    public Vector intersections = new Vector();

    public ReportElement(int x, int y, int width, int height) {
        if (hached == null) {
            hached = Misc.loadBufferedImageFromResources(new Panel(), "it/businesslogic/ireport/icons/layout/hached.gif");
        }
        this.position = new Point(x, y);
        this.width = width;
        this.height = height;
        this.bounds = new Rectangle(this.position.x, this.position.y, width, height);
        this.name = "element-" + id_gen;
        ++id_gen;
        this.bgcolor = Color.WHITE;
        this.fgcolor = Color.BLACK;
        if (lightcolor == null) {
            lightcolor = Color.LIGHT_GRAY;
        }
        this.transparent = "Opaque";
        this.stretchType = "NoStretch";
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.position.x -= 10;
        this.position.y -= 10;
        this.zoom_factor = zoom_factor;
        g.fillRect(this.getZoomedDim(this.position.x) - (x_shift_origin -= 10), this.getZoomedDim(this.position.y) - (y_shift_origin -= 10), this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        this.position.x += 10;
        this.position.y += 10;
        this.drawGraphicsElement(g, "2Point", zoom_factor, x_shift_origin += 10, y_shift_origin += 10);
        this.drawBorder(g, zoom_factor, x_shift_origin, y_shift_origin);
    }

    public void drawGraphicsElement(Graphics2D g, String pen, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.drawGraphicsElement(g, pen, zoom_factor, x_shift_origin, y_shift_origin, 0);
    }

    public void drawGraphicsElement(Graphics2D g, String pen, double zoom_factor, int x_shift_origin, int y_shift_origin, int radius) {
        int correction = zoom_factor <= 1.0 && (pen.equals("Thin") || pen.equals("1Point") || pen.equals("Dotted")) ? -1 : 0;
        int xy_correction = zoom_factor <= 1.0 && pen.equals("Dotted") ? 1 : 0;
        Stroke stroke = this.getPenStroke(pen, zoom_factor);
        g.setColor(this.fgcolor);
        this.zoom_factor = zoom_factor;
        if (stroke == null || pen.equalsIgnoreCase("None")) {
            return;
        }
        this.position.x -= 10;
        this.position.y -= 10;
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        Stroke oldStroke = g.getStroke();
        g.setStroke(stroke);
        if (radius != 0) {
            g.drawRoundRect(this.getZoomedDim(this.position.x) - x_shift_origin + xy_correction, this.getZoomedDim(this.position.y) - y_shift_origin + xy_correction, this.getZoomedDim(this.width) + correction, this.getZoomedDim(this.height) + correction, radius, radius);
        } else {
            g.drawRect(this.getZoomedDim(this.position.x) - x_shift_origin + xy_correction, this.getZoomedDim(this.position.y) - y_shift_origin + xy_correction, this.getZoomedDim(this.width) + correction, this.getZoomedDim(this.height) + correction);
        }
        this.position.x += 10;
        this.position.y += 10;
        g.setStroke(oldStroke);
    }

    public void drawBorder(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.zoom_factor = zoom_factor;
        int correction = zoom_factor <= 1.0 ? -1 : 0;
        this.position.x -= 10;
        this.position.y -= 10;
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        if (this.insideBand()) {
            g.setColor(lightcolor);
        } else {
            g.setColor(Color.RED);
        }
        g.drawRect(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width) + correction, this.getZoomedDim(this.height) + correction);
        this.position.x += 10;
        this.position.y += 10;
        x_shift_origin += 10;
        y_shift_origin += 10;
    }

    public void drawCorona(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin, boolean selected) {
        this.zoom_factor = zoom_factor;
        this.position.x -= 10;
        this.position.y -= 10;
        Rectangle2D.Double r = new Rectangle2D.Double(this.getZoomedDim(this.position.x) - 5 - (x_shift_origin -= 10), this.getZoomedDim(this.position.y) - 5 - (y_shift_origin -= 10), this.getZoomedDim(this.width) + 10, this.getZoomedDim(this.height) + 10);
        Rectangle2D.Double r2 = new Rectangle2D.Double(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        Area area = new Area(r);
        area.exclusiveOr(new Area(r2));
        if (hached == null) {
            g.fill(area);
        } else {
            g.setPaint(new TexturePaint(hached, new Rectangle2D.Double(0.0, 0.0, 2.0, 2.0)));
            g.fill(area);
        }
        g.setPaint(Color.BLUE);
        if (!selected) {
            g.setPaint(Color.GRAY);
        }
        if (this.intersectsElements()) {
            if (this.enclosesOtherElement()) {
                g.setPaint(Color.PINK);
            } else {
                g.setPaint(Color.GREEN);
            }
        }
        if (!this.insideBand()) {
            g.setPaint(Color.RED);
        }
        g.fillRect(this.getZoomedDim(this.position.x) - 5 - x_shift_origin, this.getZoomedDim(this.position.y) - 5 - y_shift_origin, 5, 5);
        g.fillRect(this.getZoomedDim(this.position.x + this.width + 1) - x_shift_origin, this.getZoomedDim(this.position.y) - 5 - y_shift_origin, 5, 5);
        g.fillRect(this.getZoomedDim(this.position.x + this.width) - x_shift_origin, this.getZoomedDim(this.position.y + this.height) - y_shift_origin, 5, 5);
        g.fillRect(this.getZoomedDim(this.position.x) - 5 - x_shift_origin, this.getZoomedDim(this.position.y + this.height) - y_shift_origin, 5, 5);
        g.fillRect(this.getZoomedDim(this.position.x + this.width / 2) - 2 - x_shift_origin, this.getZoomedDim(this.position.y) - 5 - y_shift_origin, 5, 5);
        g.fillRect(this.getZoomedDim(this.position.x + this.width / 2) - 2 - x_shift_origin, this.getZoomedDim(this.position.y + this.height) - y_shift_origin, 5, 5);
        g.fillRect(this.getZoomedDim(this.position.x) - 5 - x_shift_origin, this.getZoomedDim(this.position.y + this.height / 2) - 2 - y_shift_origin, 5, 5);
        g.fillRect(this.getZoomedDim(this.position.x + this.width) - x_shift_origin, this.getZoomedDim(this.position.y + this.height / 2) - 2 - y_shift_origin, 5, 5);
        this.position.x += 10;
        this.position.y += 10;
    }

    public boolean enclosesOtherElement() {
        Iterator i = this.intersections.iterator();
        while (i.hasNext()) {
            ReportElement e = (ReportElement)i.next();
            if (!this.bounds.contains(e.bounds)) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsElements() {
        int oldHeight = 0;
        boolean result = false;
        Iterator i = this.band.getParent().getElements().iterator();
        while (i.hasNext()) {
            ReportElement e = (ReportElement)i.next();
            if (this.equals(e)) continue;
            oldHeight = e.height;
            if (e.height == 0) {
                e.height = 10;
            }
            if (e.bounds.intersects(this.bounds)) {
                this.intersections.add(e);
                result = true;
            }
            e.height = oldHeight;
        }
        return result;
    }

    public boolean intersects(Point p) {
        Rectangle r = new Rectangle(this.bounds);
        if (this.height == 0) {
            r.height = 10;
            r.y -= 5;
        }
        if (this.width == 0) {
            r.width = 10;
            r.x -= 5;
        }
        return r.intersects(p.x, p.y, 1.0, 1.0);
    }

    public boolean insideBandReal() {
        this.position.x -= 10;
        this.position.y -= 10;
        boolean result = this.insideBand();
        this.position.x += 10;
        this.position.y += 10;
        return result;
    }

    public boolean insideBand() {
        if (this.band == null) {
            return false;
        }
        int yband = this.band.getBandYLocation();
        if (this.position.y - yband < 0) {
            return false;
        }
        if (this.position.x - this.band.getParent().getLeftMargin() < 0) {
            return false;
        }
        if (this.position.y - yband + this.height > this.band.getHeight()) {
            return false;
        }
        return this.position.x - this.band.getParent().getLeftMargin() + this.width <= this.band.getUsableWidth();
    }

    public boolean intersects(Rectangle r2) {
        Rectangle r = new Rectangle(this.bounds);
        if (this.height == 0) {
            r.height = 10;
            r.y -= 5;
        }
        if (this.width == 0) {
            r.width = 10;
            r.x -= 5;
        }
        return r.intersects(r2);
    }

    public void setPosition(Point p) {
        if (p == null) {
            return;
        }
        if (p.x == this.position.x && p.y == this.position.y) {
            return;
        }
        this.position.x = p.x;
        this.position.y = p.y;
        this.bounds = new Rectangle(this.position.x, this.position.y, this.width, this.height);
    }

    public Point trasform(Point delta, int type) {
        if (delta == null) {
            return null;
        }
        Point result = new Point(delta);
        int old_x = 0;
        int old_y = 0;
        if (type == TransformationType.TRANSFORMATION_MOVE) {
            this.position.x += delta.x;
            this.position.y += delta.y;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_E) {
            old_x = this.width;
            this.width += delta.x;
            if (this.width < 0) {
                this.width = 0;
            }
            result.x = this.width - old_x;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_W) {
            old_x = this.width;
            int d = Math.min(delta.x, this.width);
            this.width -= d;
            this.position.x += d;
            result.x = d;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_N) {
            int d = Math.min(delta.y, this.height);
            this.height -= d;
            this.position.y += d;
            result.y = d;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_S) {
            old_y = this.height;
            this.height += delta.y;
            if (this.height < 0) {
                this.height = 0;
            }
            result.y = this.height - old_y;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_SE) {
            old_y = this.height;
            old_x = this.width;
            this.height += delta.y;
            if (this.height < 0) {
                this.height = 0;
            }
            this.width += delta.x;
            if (this.width < 0) {
                this.width = 0;
            }
            result.x = this.width - old_x;
            result.y = this.height - old_y;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_SW) {
            old_y = this.height;
            this.height += delta.y;
            if (this.height < 0) {
                this.height = 0;
            }
            int d = Math.min(delta.x, this.width);
            this.width -= d;
            this.position.x += d;
            result.x = d;
            result.y = this.height - old_y;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_NE) {
            old_x = this.width;
            int d = Math.min(delta.y, this.height);
            this.height -= d;
            this.position.y += d;
            this.width += delta.x;
            if (this.width < 0) {
                this.width = 0;
            }
            result.x = this.width - old_x;
            result.y = d;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_NW) {
            int d = Math.min(delta.y, this.height);
            this.height -= d;
            this.position.y += d;
            result.y = d;
            d = Math.min(delta.x, this.width);
            this.width -= d;
            this.position.x += d;
            result.x = d;
        }
        this.bounds = new Rectangle(this.position.x, this.position.y, this.width, this.height);
        return result;
    }

    public void adjustBand() {
        this.position.x -= 10;
        this.position.y -= 10;
        Iterator i = this.band.getParent().getBands().iterator();
        while (i.hasNext()) {
            Band b = (Band)i.next();
            if (this.position.y - this.band.getParent().getBandYLocation(b) < 0 || this.position.y - this.band.getParent().getBandYLocation(b) + this.height > b.getHeight()) continue;
            this.band = b;
            break;
        }
        this.position.x += 10;
        this.position.y += 10;
    }

    public void updateBounds() {
        this.bounds = new Rectangle(this.position.x, this.position.y, this.width, this.height);
    }

    public Point trasformTest(Point delta, int type) {
        if (delta == null) {
            return null;
        }
        Point result = new Point(delta);
        int old_x = 0;
        int old_y = 0;
        if (type != TransformationType.TRANSFORMATION_MOVE) {
            if (type == TransformationType.TRANSFORMATION_RESIZE_E) {
                old_x = this.width;
                if ((old_x += delta.x) < 0) {
                    old_x = 0;
                }
                result.x = old_x - this.width;
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_W) {
                result.x = Math.min(delta.x, this.width);
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_N) {
                result.y = Math.min(delta.y, this.height);
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_S) {
                old_y = this.height;
                if ((old_y += delta.y) < 0) {
                    old_y = 0;
                }
                result.y = old_y - this.height;
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_SE) {
                old_y = this.height;
                old_x = this.width;
                if ((old_y += delta.y) < 0) {
                    old_y = 0;
                }
                if ((old_x += delta.x) < 0) {
                    old_x = 0;
                }
                result.x = old_x - this.width;
                result.y = old_y - this.height;
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_SW) {
                old_y = this.height;
                if ((old_y += delta.y) < 0) {
                    old_y = 0;
                }
                result.x = Math.min(delta.x, this.width);
                result.y = old_y - this.height;
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_NE) {
                old_x = this.width;
                result.y = Math.min(delta.y, this.height);
                if ((old_x += delta.x) < 0) {
                    old_x = 0;
                }
                result.x = old_x - this.width;
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_NW) {
                result.y = Math.min(delta.y, this.height);
                result.x = Math.min(delta.x, this.width);
            }
        }
        return result;
    }

    public String toString() {
        return this.name + " [" + (this.position.x - this.band.getParent().getRightMargin() - 10) + "," + (this.position.y - this.band.getBandYLocation() - 10) + "]";
    }

    public int getZoomedDim(int dim) {
        if (this.zoom_factor == 1.0) {
            return dim;
        }
        return (int)((double)dim * this.zoom_factor);
    }

    public double getZoomedDim(double dim) {
        if (this.zoom_factor == 1.0) {
            return dim;
        }
        return dim * this.zoom_factor;
    }

    public int getLogicalDim(int dim) {
        if (this.zoom_factor == 1.0) {
            return dim;
        }
        return (int)((double)dim / this.zoom_factor);
    }

    public ReportElement cloneMe() {
        ReportElement newReportElement = new ReportElement(this.position.x, this.position.y, this.width, this.height);
        newReportElement.name = new String(this.name);
        newReportElement.band = this.band;
        newReportElement.transparent = this.transparent;
        this.copyElementPropertiesTo(newReportElement);
        return newReportElement;
    }

    public void copyElementPropertiesTo(ReportElement newReportElement) {
        newReportElement.printWhenExpression = this.printWhenExpression;
        newReportElement.positionType = this.positionType;
        newReportElement.isPrintRepeatedValues = this.isPrintRepeatedValues;
        newReportElement.isRemoveLineWhenBlank = this.isRemoveLineWhenBlank;
        newReportElement.isPrintInFirstWholeBand = this.isPrintInFirstWholeBand;
        newReportElement.isPrintWhenDetailOverflows = this.isPrintWhenDetailOverflows;
    }

    public static String string_replace(String s1, String s2, String s3) {
        String string = "";
        string = "";
        if (s2 == null || s3 == null || s2.length() == 0) {
            return s3;
        }
        int pos_i = 0;
        int pos_f = 0;
        int len = s2.length();
        while ((pos_f = s3.indexOf(s2, pos_i)) >= 0) {
            string = string + s3.substring(pos_i, pos_f) + s1;
            pos_f = pos_i = pos_f + len;
        }
        string = string + s3.substring(pos_i);
        return string;
    }

    public Stroke getPenStroke(String pen, double zoom_factor) {
        if (pen == null || pen.equals("None")) {
            return null;
        }
        if (pen.equals("Dotted")) {
            return new BasicStroke((float)(1.0 * zoom_factor), 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
        }
        if (pen.equals("2Point")) {
            return new BasicStroke((float)(2.0 * zoom_factor));
        }
        if (pen.equals("3Point")) {
            return new BasicStroke((float)(3.0 * zoom_factor));
        }
        if (pen.equals("4Point")) {
            return new BasicStroke((float)(4.0 * zoom_factor));
        }
        if (pen.equals("Thin")) {
            return new BasicStroke((float)(1.0 * zoom_factor));
        }
        return new BasicStroke((float)(1.0 * zoom_factor));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Point getPosition() {
        return this.position;
    }

    public Band getBand() {
        return this.band;
    }

    public void setBand(Band band) {
        this.band = band;
    }

    public String getTransparent() {
        return this.transparent;
    }

    public void setTransparent(String transparent) {
        this.transparent = transparent;
    }

    public String getPositionType() {
        return this.positionType;
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType;
    }

    public boolean isIsPrintInFirstWholeBand() {
        return this.isPrintInFirstWholeBand;
    }

    public void setIsPrintInFirstWholeBand(boolean isPrintInFirstWholeBand) {
        this.isPrintInFirstWholeBand = isPrintInFirstWholeBand;
    }

    public String getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    public void setPrintWhenExpression(String printWhenExpression) {
        this.printWhenExpression = printWhenExpression;
    }

    public boolean isIsPrintRepeatedValues() {
        return this.isPrintRepeatedValues;
    }

    public void setIsPrintRepeatedValues(boolean isPrintRepeatedValues) {
        this.isPrintRepeatedValues = isPrintRepeatedValues;
    }

    public Color getFgcolor() {
        return this.fgcolor;
    }

    public void setFgcolor(Color fgcolor) {
        this.fgcolor = fgcolor;
    }

    public Color getBgcolor() {
        return this.bgcolor;
    }

    public void setBgcolor(Color bgcolor) {
        this.bgcolor = bgcolor;
    }

    public boolean isIsRemoveLineWhenBlank() {
        return this.isRemoveLineWhenBlank;
    }

    public void setIsRemoveLineWhenBlank(boolean isRemoveLineWhenBlank) {
        this.isRemoveLineWhenBlank = isRemoveLineWhenBlank;
    }

    public String getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    public void setPrintWhenGroupChanges(String printWhenGroupChanges) {
        this.printWhenGroupChanges = printWhenGroupChanges;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isIsPrintWhenDetailOverflows() {
        return this.isPrintWhenDetailOverflows;
    }

    public void setIsPrintWhenDetailOverflows(boolean isPrintWhenDetailOverflows) {
        this.isPrintWhenDetailOverflows = isPrintWhenDetailOverflows;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        destination.setName(new String(source.getName()));
        destination.setBgcolor(source.getBgcolor());
        destination.setFgcolor(source.getFgcolor());
        destination.setBand(source.getBand());
        destination.setPositionType(new String(source.getPositionType()));
        destination.setIsPrintRepeatedValues(source.isIsPrintRepeatedValues());
        destination.setIsPrintWhenDetailOverflows(source.isIsPrintWhenDetailOverflows());
        destination.setIsRemoveLineWhenBlank(source.isIsRemoveLineWhenBlank());
        destination.setPrintWhenExpression(new String(source.getPrintWhenExpression()));
        destination.setPrintWhenGroupChanges(new String(source.getPrintWhenGroupChanges()));
        destination.setTransparent(new String(source.getTransparent()));
        destination.setIsPrintInFirstWholeBand(source.isIsPrintInFirstWholeBand());
    }

    public String getKey() {
        return this.name;
    }

    public void setKey(String key) {
        this.name = key;
    }

    public String getStretchType() {
        return this.stretchType;
    }

    public void setStretchType(String stretchType) {
        this.stretchType = stretchType;
    }
}

