/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jfree.text.TextUtilities;
import org.jfree.ui.NumberCellRenderer;
import org.jfree.ui.TextAnchor;

public class RefineryUtilities {
    private static boolean useDrawRotatedStringWorkaround = true;
    static Logger logger = Logger.getLogger((Class)(class$org$jfree$ui$RefineryUtilities == null ? (class$org$jfree$ui$RefineryUtilities = RefineryUtilities.class$("org.jfree.ui.RefineryUtilities")) : class$org$jfree$ui$RefineryUtilities));
    static /* synthetic */ Class class$org$jfree$ui$RefineryUtilities;
    static /* synthetic */ Class class$java$lang$Number;

    public static void setUseDrawRotatedStringWorkaround(boolean use) {
        useDrawRotatedStringWorkaround = use;
    }

    public static void centerFrameOnScreen(Window frame) {
        RefineryUtilities.positionFrameOnScreen(frame, 0.5, 0.5);
    }

    public static void positionFrameOnScreen(Window frame, double horizontalPercent, double verticalPercent) {
        Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension f = frame.getSize();
        int w = Math.max(s.width - f.width, 0);
        int h = Math.max(s.height - f.height, 0);
        int x = (int)(horizontalPercent * (double)w);
        int y = (int)(verticalPercent * (double)h);
        frame.setBounds(x, y, f.width, f.height);
    }

    public static void positionFrameRandomly(Window frame) {
        RefineryUtilities.positionFrameOnScreen(frame, Math.random(), Math.random());
    }

    public static void centerDialogInParent(Dialog dialog) {
        RefineryUtilities.positionDialogRelativeToParent(dialog, 0.5, 0.5);
    }

    public static void positionDialogRelativeToParent(Dialog dialog, double horizontalPercent, double verticalPercent) {
        Dimension d = dialog.getSize();
        Container parent = dialog.getParent();
        Dimension p = parent.getSize();
        int baseX = parent.getX() - d.width;
        int baseY = parent.getY() - d.height;
        int w = d.width + p.width;
        int h = d.height + p.height;
        int x = baseX + (int)(horizontalPercent * (double)w);
        int y = baseY + (int)(verticalPercent * (double)h);
        Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
        x = Math.min(x, s.width - d.width);
        x = Math.max(x, 0);
        y = Math.min(y, s.height - d.height);
        y = Math.max(y, 0);
        dialog.setBounds(x, y, d.width, d.height);
    }

    public static JPanel createTablePanel(TableModel model) {
        JPanel panel = new JPanel(new BorderLayout());
        JTable table = new JTable(model);
        for (int columnIndex = 0; columnIndex < model.getColumnCount(); ++columnIndex) {
            TableColumn column = table.getColumnModel().getColumn(columnIndex);
            Class<?> c = model.getColumnClass(columnIndex);
            if (!c.equals(class$java$lang$Number == null ? RefineryUtilities.class$("java.lang.Number") : class$java$lang$Number)) continue;
            column.setCellRenderer(new NumberCellRenderer());
        }
        panel.add(new JScrollPane(table));
        return panel;
    }

    public static JLabel createJLabel(String text, Font font) {
        JLabel result = new JLabel(text);
        result.setFont(font);
        return result;
    }

    public static JLabel createJLabel(String text, Font font, Color color) {
        JLabel result = new JLabel(text);
        result.setFont(font);
        result.setForeground(color);
        return result;
    }

    public static JButton createJButton(String label, Font font) {
        JButton result = new JButton(label);
        result.setFont(font);
        return result;
    }

    public static void drawAlignedString(String text, Graphics2D g2, float x, float y, TextAnchor anchor) {
        float[] adjust = RefineryUtilities.deriveTextBoundsAnchorOffsets(g2, text, anchor);
        g2.drawString(text, (int)(x + adjust[0]), (int)(y + adjust[1]));
    }

    public static Shape calculateRotatedStringBounds(String text, Graphics2D g2, float x, float y, TextAnchor textAnchor, TextAnchor rotationAnchor, double angle) {
        if (text == null || text.equals("")) {
            return null;
        }
        float[] textAdj = RefineryUtilities.deriveTextBoundsAnchorOffsets(g2, text, textAnchor);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TextBoundsAnchorOffsets = " + textAdj[0] + ", " + textAdj[1]));
        }
        float[] rotateAdj = RefineryUtilities.deriveRotationAnchorOffsets(g2, text, rotationAnchor);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RotationAnchorOffsets = " + rotateAdj[0] + ", " + rotateAdj[1]));
        }
        Shape result = RefineryUtilities.calculateRotatedStringBounds(text, g2, x + textAdj[0], y + textAdj[1], angle, x + textAdj[0] + rotateAdj[0], y + textAdj[1] + rotateAdj[1]);
        return result;
    }

    public static void drawRotatedString(String text, Graphics2D g2, float x, float y, double angle) {
        RefineryUtilities.drawRotatedString(text, g2, x, y, angle, x, y);
    }

    public static void drawRotatedString(String text, Graphics2D g2, float x, float y, TextAnchor textAnchor, float rotationX, float rotationY, double angle) {
        if (text == null || text.equals("")) {
            return;
        }
        float[] textAdj = RefineryUtilities.deriveTextBoundsAnchorOffsets(g2, text, textAnchor);
        RefineryUtilities.drawRotatedString(text, g2, x + textAdj[0], y + textAdj[1], angle, rotationX, rotationY);
    }

    public static void drawRotatedString(String text, Graphics2D g2, float x, float y, TextAnchor textAnchor, TextAnchor rotationAnchor, double angle) {
        if (text == null || text.equals("")) {
            return;
        }
        float[] textAdj = RefineryUtilities.deriveTextBoundsAnchorOffsets(g2, text, textAnchor);
        float[] rotateAdj = RefineryUtilities.deriveRotationAnchorOffsets(g2, text, rotationAnchor);
        RefineryUtilities.drawRotatedString(text, g2, x + textAdj[0], y + textAdj[1], angle, x + textAdj[0] + rotateAdj[0], y + textAdj[1] + rotateAdj[1]);
    }

    public static void drawRotatedString(String text, Graphics2D g2, float textX, float textY, double angle, float rotateX, float rotateY) {
        if (text == null || text.equals("")) {
            return;
        }
        AffineTransform saved = g2.getTransform();
        AffineTransform rotate = AffineTransform.getRotateInstance(angle, rotateX, rotateY);
        g2.transform(rotate);
        if (useDrawRotatedStringWorkaround) {
            TextLayout tl = new TextLayout(text, g2.getFont(), g2.getFontRenderContext());
            tl.draw(g2, textX, textY);
        } else {
            g2.drawString(text, textX, textY);
        }
        g2.setTransform(saved);
    }

    public static Shape calculateRotatedStringBounds(String text, Graphics2D g2, float textX, float textY, double angle, float rotateX, float rotateY) {
        if (text == null || text.equals("")) {
            return null;
        }
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D bounds = TextUtilities.getTextBounds(text, g2, fm);
        AffineTransform translate = AffineTransform.getTranslateInstance(textX, textY);
        Shape translatedBounds = translate.createTransformedShape(bounds);
        AffineTransform rotate = AffineTransform.getRotateInstance(angle, rotateX, rotateY);
        Shape result = rotate.createTransformedShape(translatedBounds);
        return result;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D g2, String text, TextAnchor anchor) {
        float[] result = new float[2];
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = g2.getFont();
        FontMetrics fm = g2.getFontMetrics(f);
        Rectangle2D bounds = TextUtilities.getTextBounds(text, g2, fm);
        LineMetrics metrics = f.getLineMetrics(text, frc);
        float ascent = metrics.getAscent();
        float halfAscent = ascent / 2.0f;
        float descent = metrics.getDescent();
        float leading = metrics.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.CENTER || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.HALF_ASCENT_CENTER) {
            xAdj = (float)(-bounds.getWidth()) / 2.0f;
        } else if (anchor == TextAnchor.TOP_RIGHT || anchor == TextAnchor.CENTER_RIGHT || anchor == TextAnchor.BOTTOM_RIGHT || anchor == TextAnchor.BASELINE_RIGHT || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            xAdj = (float)(-bounds.getWidth());
        }
        if (anchor == TextAnchor.TOP_LEFT || anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.TOP_RIGHT) {
            yAdj = -descent - leading + (float)bounds.getHeight();
        } else if (anchor == TextAnchor.HALF_ASCENT_LEFT || anchor == TextAnchor.HALF_ASCENT_CENTER || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            yAdj = halfAscent;
        } else if (anchor == TextAnchor.CENTER_LEFT || anchor == TextAnchor.CENTER || anchor == TextAnchor.CENTER_RIGHT) {
            yAdj = -descent - leading + (float)(bounds.getHeight() / 2.0);
        } else if (anchor == TextAnchor.BASELINE_LEFT || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.BASELINE_RIGHT) {
            yAdj = 0.0f;
        } else if (anchor == TextAnchor.BOTTOM_LEFT || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BOTTOM_RIGHT) {
            yAdj = -metrics.getDescent() - metrics.getLeading();
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    private static float[] deriveRotationAnchorOffsets(Graphics2D g2, String text, TextAnchor anchor) {
        float[] result = new float[2];
        FontRenderContext frc = g2.getFontRenderContext();
        LineMetrics metrics = g2.getFont().getLineMetrics(text, frc);
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D bounds = TextUtilities.getTextBounds(text, g2, fm);
        float ascent = metrics.getAscent();
        float halfAscent = ascent / 2.0f;
        float descent = metrics.getDescent();
        float leading = metrics.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor == TextAnchor.TOP_LEFT || anchor == TextAnchor.CENTER_LEFT || anchor == TextAnchor.BOTTOM_LEFT || anchor == TextAnchor.BASELINE_LEFT || anchor == TextAnchor.HALF_ASCENT_LEFT) {
            xAdj = 0.0f;
        } else if (anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.CENTER || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.HALF_ASCENT_CENTER) {
            xAdj = (float)bounds.getWidth() / 2.0f;
        } else if (anchor == TextAnchor.TOP_RIGHT || anchor == TextAnchor.CENTER_RIGHT || anchor == TextAnchor.BOTTOM_RIGHT || anchor == TextAnchor.BASELINE_RIGHT || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            xAdj = (float)bounds.getWidth();
        }
        if (anchor == TextAnchor.TOP_LEFT || anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.TOP_RIGHT) {
            yAdj = descent + leading - (float)bounds.getHeight();
        } else if (anchor == TextAnchor.CENTER_LEFT || anchor == TextAnchor.CENTER || anchor == TextAnchor.CENTER_RIGHT) {
            yAdj = descent + leading - (float)(bounds.getHeight() / 2.0);
        } else if (anchor == TextAnchor.HALF_ASCENT_LEFT || anchor == TextAnchor.HALF_ASCENT_CENTER || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            yAdj = -halfAscent;
        } else if (anchor == TextAnchor.BASELINE_LEFT || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.BASELINE_RIGHT) {
            yAdj = 0.0f;
        } else if (anchor == TextAnchor.BOTTOM_LEFT || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BOTTOM_RIGHT) {
            yAdj = metrics.getDescent() + metrics.getLeading();
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    public static void drawRotatedShape(Shape shape, Graphics2D g2, float x, float y, double angle) {
        AffineTransform saved = g2.getTransform();
        AffineTransform rotate = AffineTransform.getRotateInstance(angle, x, y);
        g2.transform(rotate);
        g2.draw(shape);
        g2.setTransform(saved);
    }

    public static Point2D getPointInRectangle(double x, double y, Rectangle2D area) {
        x = Math.max(area.getMinX(), Math.min(x, area.getMaxX()));
        y = Math.max(area.getMinY(), Math.min(y, area.getMaxY()));
        return new Point2D.Double(x, y);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

