/*
 * ValuesDialog.java
 *
 * iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 7 maggio 2003, 23.43
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.*;

import javax.swing.table.*;
import javax.swing.*;
import javax.swing.event.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.util.*;

import java.util.*;
/**
 *
 * @author  Administrator
 */
public class ValuesDialog extends javax.swing.JDialog {
    
    /** Creates new form ValuesDialog */
    public ValuesDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.setSize(420, 250);
        //DefaultTableColumnModel dtcm = (DefaultTableColumnModel)jTableParameters.getColumnModel();
        //DefaultTableCellRenderer tcr = (DefaultTableCellRenderer)dtcm.getColumn(0).getHeaderRenderer();
        
        //new DefaultTableCellRenderer();
        //tcr.setFont(jTableParameters.getFont());
        //tcr.setBackground(this.getBackground());
        //tcr.setBorder( new javax.swing.border.BevelBorder( javax.swing.border.BevelBorder.RAISED));
        //dtcm.getColumn(0).setHeaderRenderer(tcr);
        
               
        
        DefaultListSelectionModel dlsm =  (DefaultListSelectionModel)this.jTableParameters.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e)  {
                jTableParametersListSelectionValueChanged(e);
            }
        });
        
        dlsm =  (DefaultListSelectionModel)this.jTableVariables.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e)  {
                jTableVariablesListSelectionValueChanged(e);
            }
        });
        
        dlsm =  (DefaultListSelectionModel)this.jTableFields.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e)  {
                jTableFieldsListSelectionValueChanged(e);
            }
        });
        
	applyI18n();

        // Open in center...
        it.businesslogic.ireport.util.Misc.centerFrame(this);
    }
    
    
    public void jTableParametersListSelectionValueChanged(javax.swing.event.ListSelectionEvent e)
    {
         if (this.jTableParameters.getSelectedRowCount() > 0) {
            this.jButtonModifyParameter.setEnabled(true);
            this.jButtonDeleteParameter.setEnabled(true);
        }
        else {
            this.jButtonModifyParameter.setEnabled(false);
            this.jButtonDeleteParameter.setEnabled(false);
        }
    }
    
    public void jTableVariablesListSelectionValueChanged(javax.swing.event.ListSelectionEvent e)
    {
         if (this.jTableVariables.getSelectedRowCount() > 0) {
            this.jButtonModifyVariable.setEnabled(true);
            this.jButtonDeleteVariable.setEnabled(true);
        }
        else {
            this.jButtonModifyVariable.setEnabled(false);
            this.jButtonDeleteVariable.setEnabled(false);
        }
    }
    
    public void jTableFieldsListSelectionValueChanged(javax.swing.event.ListSelectionEvent e)
    {
         if (this.jTableFields.getSelectedRowCount() > 0) {
            this.jButtonModifyField.setEnabled(true);
            this.jButtonDeleteField.setEnabled(true);
        }
        else {
            this.jButtonModifyField.setEnabled(false);
            this.jButtonDeleteField.setEnabled(false);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
        private void initComponents() {//GEN-BEGIN:initComponents
                jTabbedPane = new javax.swing.JTabbedPane();
                jPanelFields = new javax.swing.JPanel();
                jScrollPane3 = new javax.swing.JScrollPane();
                jTableFields = new it.businesslogic.ireport.gui.JDragTable();
                jPanelButtons2 = new javax.swing.JPanel();
                jButtonNewField = new javax.swing.JButton();
                jButtonModifyField = new javax.swing.JButton();
                jButtonDeleteField = new javax.swing.JButton();
                jPanelVariables = new javax.swing.JPanel();
                jScrollPane2 = new javax.swing.JScrollPane();
                jTableVariables = new it.businesslogic.ireport.gui.JDragTable();
                jPanelButtons1 = new javax.swing.JPanel();
                jButtonNewVariable = new javax.swing.JButton();
                jButtonModifyVariable = new javax.swing.JButton();
                jButtonDeleteVariable = new javax.swing.JButton();
                jPanelParameters = new javax.swing.JPanel();
                jScrollPane1 = new javax.swing.JScrollPane();
                jTableParameters = new it.businesslogic.ireport.gui.JDragTable();
                jPanelButtons = new javax.swing.JPanel();
                jButtonNewParameter = new javax.swing.JButton();
                jButtonModifyParameter = new javax.swing.JButton();
                jButtonDeleteParameter = new javax.swing.JButton();

                setTitle("Values");
                addWindowListener(new java.awt.event.WindowAdapter() {
                        public void windowClosing(java.awt.event.WindowEvent evt) {
                                closeDialog(evt);
                        }
                });

                jTabbedPane.setName("");
                jPanelFields.setLayout(new java.awt.BorderLayout());

                jScrollPane3.setBackground(new java.awt.Color(255, 255, 255));
                jScrollPane3.setFont(new java.awt.Font("Dialog", 0, 11));
                jTableFields.setModel(new javax.swing.table.DefaultTableModel(
                        new Object [][] {

                        },
                        new String [] {
                                "Field name", "Class type"
                        }
                ) {
                        boolean[] canEdit = new boolean [] {
                                false, false
                        };

                        public boolean isCellEditable(int rowIndex, int columnIndex) {
                                return canEdit [columnIndex];
                        }
                });
                jTableFields.addMouseListener(new java.awt.event.MouseAdapter() {
                        public void mouseClicked(java.awt.event.MouseEvent evt) {
                                jTableFieldsMouseClicked(evt);
                        }
                });

                jScrollPane3.setViewportView(jTableFields);

                jPanelFields.add(jScrollPane3, java.awt.BorderLayout.CENTER);

                jPanelButtons2.setLayout(null);

                jPanelButtons2.setMinimumSize(new java.awt.Dimension(100, 10));
                jPanelButtons2.setPreferredSize(new java.awt.Dimension(100, 10));
                jButtonNewField.setText("New");
                jButtonNewField.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonNewFieldActionPerformed(evt);
                        }
                });

                jPanelButtons2.add(jButtonNewField);
                jButtonNewField.setBounds(4, 5, 92, 22);

                jButtonModifyField.setText("Modify");
                jButtonModifyField.setEnabled(false);
                jButtonModifyField.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonModifyFieldActionPerformed(evt);
                        }
                });

                jPanelButtons2.add(jButtonModifyField);
                jButtonModifyField.setBounds(4, 30, 92, 22);

                jButtonDeleteField.setText("Delete");
                jButtonDeleteField.setEnabled(false);
                jButtonDeleteField.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonDeleteFieldActionPerformed(evt);
                        }
                });

                jPanelButtons2.add(jButtonDeleteField);
                jButtonDeleteField.setBounds(4, 56, 92, 22);

                jPanelFields.add(jPanelButtons2, java.awt.BorderLayout.EAST);

                jTabbedPane.addTab("Fields", jPanelFields);

                jPanelVariables.setLayout(new java.awt.BorderLayout());

                jScrollPane2.setBackground(new java.awt.Color(255, 255, 255));
                jScrollPane2.setFont(new java.awt.Font("Dialog", 0, 11));
                jTableVariables.setModel(new javax.swing.table.DefaultTableModel(
                        new Object [][] {

                        },
                        new String [] {
                                "Variable name", "Builtin"
                        }
                ) {
                        boolean[] canEdit = new boolean [] {
                                false, false
                        };

                        public boolean isCellEditable(int rowIndex, int columnIndex) {
                                return canEdit [columnIndex];
                        }
                });
                jTableVariables.addMouseListener(new java.awt.event.MouseAdapter() {
                        public void mouseClicked(java.awt.event.MouseEvent evt) {
                                jTableVariablesMouseClicked(evt);
                        }
                });

                jScrollPane2.setViewportView(jTableVariables);

                jPanelVariables.add(jScrollPane2, java.awt.BorderLayout.CENTER);

                jPanelButtons1.setLayout(null);

                jPanelButtons1.setMinimumSize(new java.awt.Dimension(100, 10));
                jPanelButtons1.setPreferredSize(new java.awt.Dimension(100, 10));
                jButtonNewVariable.setFont(new java.awt.Font("Dialog", 0, 11));
                jButtonNewVariable.setText("New");
                jButtonNewVariable.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonNewVariableActionPerformed(evt);
                        }
                });

                jPanelButtons1.add(jButtonNewVariable);
                jButtonNewVariable.setBounds(4, 5, 92, 22);

                jButtonModifyVariable.setFont(new java.awt.Font("Dialog", 0, 11));
                jButtonModifyVariable.setText("Modify");
                jButtonModifyVariable.setEnabled(false);
                jButtonModifyVariable.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonModifyVariableActionPerformed(evt);
                        }
                });

                jPanelButtons1.add(jButtonModifyVariable);
                jButtonModifyVariable.setBounds(4, 30, 92, 22);

                jButtonDeleteVariable.setFont(new java.awt.Font("Dialog", 0, 11));
                jButtonDeleteVariable.setText("Delete");
                jButtonDeleteVariable.setEnabled(false);
                jButtonDeleteVariable.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonDeleteVariableActionPerformed(evt);
                        }
                });

                jPanelButtons1.add(jButtonDeleteVariable);
                jButtonDeleteVariable.setBounds(4, 56, 92, 22);

                jPanelVariables.add(jPanelButtons1, java.awt.BorderLayout.EAST);

                jTabbedPane.addTab("Variables", jPanelVariables);

                jPanelParameters.setLayout(new java.awt.BorderLayout(2, 2));

                jScrollPane1.setBackground(new java.awt.Color(255, 255, 255));
                jScrollPane1.setFont(new java.awt.Font("Dialog", 0, 11));
                jTableParameters.setModel(new javax.swing.table.DefaultTableModel(
                        new Object [][] {

                        },
                        new String [] {
                                "Parameter name", "Class type", "Is for prompting"
                        }
                ) {
                        boolean[] canEdit = new boolean [] {
                                false, false, false
                        };

                        public boolean isCellEditable(int rowIndex, int columnIndex) {
                                return canEdit [columnIndex];
                        }
                });
                jTableParameters.addMouseListener(new java.awt.event.MouseAdapter() {
                        public void mouseClicked(java.awt.event.MouseEvent evt) {
                                jTableParametersMouseClicked(evt);
                        }
                });

                jScrollPane1.setViewportView(jTableParameters);

                jPanelParameters.add(jScrollPane1, java.awt.BorderLayout.CENTER);

                jPanelButtons.setLayout(null);

                jPanelButtons.setMinimumSize(new java.awt.Dimension(100, 10));
                jPanelButtons.setPreferredSize(new java.awt.Dimension(100, 10));
                jButtonNewParameter.setFont(new java.awt.Font("Dialog", 0, 11));
                jButtonNewParameter.setText("New");
                jButtonNewParameter.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonNewParameterActionPerformed(evt);
                        }
                });

                jPanelButtons.add(jButtonNewParameter);
                jButtonNewParameter.setBounds(4, 5, 92, 22);

                jButtonModifyParameter.setFont(new java.awt.Font("Dialog", 0, 11));
                jButtonModifyParameter.setText("Modify");
                jButtonModifyParameter.setEnabled(false);
                jButtonModifyParameter.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonModifyParameterActionPerformed(evt);
                        }
                });

                jPanelButtons.add(jButtonModifyParameter);
                jButtonModifyParameter.setBounds(4, 30, 92, 22);

                jButtonDeleteParameter.setFont(new java.awt.Font("Dialog", 0, 11));
                jButtonDeleteParameter.setText("Delete");
                jButtonDeleteParameter.setEnabled(false);
                jButtonDeleteParameter.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonDeleteParameterActionPerformed(evt);
                        }
                });

                jPanelButtons.add(jButtonDeleteParameter);
                jButtonDeleteParameter.setBounds(4, 56, 92, 22);

                jPanelParameters.add(jPanelButtons, java.awt.BorderLayout.EAST);

                jTabbedPane.addTab("Parameters", jPanelParameters);

                getContentPane().add(jTabbedPane, java.awt.BorderLayout.CENTER);

                pack();
        }//GEN-END:initComponents

    private void jTableParametersMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTableParametersMouseClicked
        if (evt.getClickCount() == 2 && evt.getButton() == evt.BUTTON1 &&  jTableParameters.getSelectedRow() >=0 )
        {
            jButtonModifyParameterActionPerformed(new java.awt.event.ActionEvent( jButtonModifyParameter,0, ""));
        }
    }//GEN-LAST:event_jTableParametersMouseClicked

    private void jTableVariablesMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTableVariablesMouseClicked
       if (evt.getClickCount() == 2 && evt.getButton() == evt.BUTTON1 &&  jTableVariables.getSelectedRow() >=0 )
        {
            jButtonModifyVariableActionPerformed(new java.awt.event.ActionEvent( jButtonModifyVariable,0, ""));
        }
    }//GEN-LAST:event_jTableVariablesMouseClicked

    private void jTableFieldsMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTableFieldsMouseClicked
        if (evt.getClickCount() == 2 && evt.getButton() == evt.BUTTON1 &&  jTableFields.getSelectedRow() >=0 )
        {
            jButtonModifyFieldActionPerformed(new java.awt.event.ActionEvent( jButtonModifyField,0, ""));
        }
    }//GEN-LAST:event_jTableFieldsMouseClicked

    private void jButtonDeleteFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteFieldActionPerformed
        jTableFields.getSelectedRows();
        int[]  rows= jTableFields.getSelectedRows();
        for (int i=rows.length-1; i>=0; --i)
        {
            this.getJReportFrame().getReport().removeField( (JRField) jTableFields.getValueAt( rows[i], 0) );
            //this.jTableParameters.removeRowSelectionInterval( rows[i],rows[i]);
        }
        updateFields();
    }//GEN-LAST:event_jButtonDeleteFieldActionPerformed

    private void jButtonModifyFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModifyFieldActionPerformed
         JRField field = (JRField)jTableFields.getValueAt( jTableFields.getSelectedRow(), 0);
        java.awt.Frame parent = Misc.frameFromComponent(this);     
        JRFieldDialog jrpd = new JRFieldDialog(parent, true);
        jrpd.setField( field );
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            field.setName( jrpd.getField().getName() );
            field.setClassType( jrpd.getField().getClassType() );
  
            field.setDescription( jrpd.getField().getDescription() );
            
            this.updateFields();
        }        
    }//GEN-LAST:event_jButtonModifyFieldActionPerformed

    private void jButtonNewFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewFieldActionPerformed
        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRFieldDialog jrpd = new JRFieldDialog( parent, true);
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            JRField field = jrpd.getField();
            this.getJReportFrame().getReport().addField( field );
            this.updateFields();
        }
    }//GEN-LAST:event_jButtonNewFieldActionPerformed

    private void jButtonDeleteVariableActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteVariableActionPerformed
        jTableVariables.getSelectedRows();
        int[]  rows= jTableVariables.getSelectedRows();
        for (int i=rows.length-1; i>=0; --i)
        {
            if (  !((JRVariable)jTableVariables.getValueAt( rows[i], 0)).isBuiltin())
            {
                this.getJReportFrame().getReport().removeVariable( (JRVariable) jTableVariables.getValueAt( rows[i], 0) );
            }
            //this.jTableParameters.removeRowSelectionInterval( rows[i],rows[i]);
        }
        updateVariables();
    }//GEN-LAST:event_jButtonDeleteVariableActionPerformed

    private void jButtonModifyVariableActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModifyVariableActionPerformed
        JRVariable variable = (JRVariable)jTableVariables.getValueAt( jTableVariables.getSelectedRow(), 0);
        
        if (variable.isBuiltin())
        {
             javax.swing.JOptionPane.showMessageDialog(this,"You can't modify or delete builtin variables!","Invalid operation!",javax.swing.JOptionPane.WARNING_MESSAGE );
                return;
        }
        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRVariableDialog jrpd = new JRVariableDialog(getJReportFrame().getReport(),  parent, true);
        jrpd.setVariable( variable );
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            variable.setName( jrpd.getVariable().getName() );
            variable.setClassType( jrpd.getVariable().getClassType() );
            variable.setCalculation( jrpd.getVariable().getCalculation() );
            variable.setResetType( jrpd.getVariable().getResetType() );
            variable.setResetGroup( jrpd.getVariable().getResetGroup() );
            variable.setExpression( jrpd.getVariable().getExpression() );
            variable.setInitialValueExpression( jrpd.getVariable().getInitialValueExpression() );
            variable.setIncrementerFactoryClass( jrpd.getVariable().getIncrementerFactoryClass() );
            
            this.updateVariables();
        }        
    }//GEN-LAST:event_jButtonModifyVariableActionPerformed

    private void jButtonNewVariableActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewVariableActionPerformed
        
        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRVariableDialog jrpd = new JRVariableDialog(this.getJReportFrame().getReport(), parent, true);
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            JRVariable variable = jrpd.getVariable();
            this.getJReportFrame().getReport().addVariable( variable );
            this.updateVariables();
        }
    }//GEN-LAST:event_jButtonNewVariableActionPerformed

    private void jButtonDeleteParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteParameterActionPerformed
        
        jTableParameters.getSelectedRows();
        int[]  rows= jTableParameters.getSelectedRows();
        for (int i=rows.length-1; i>=0; --i)
        {
            this.getJReportFrame().getReport().removeParameter( (JRParameter) jTableParameters.getValueAt( rows[i], 0) );
            //this.jTableParameters.removeRowSelectionInterval( rows[i],rows[i]);
        }
        updateParameters();
        
    }//GEN-LAST:event_jButtonDeleteParameterActionPerformed

    private void jButtonModifyParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModifyParameterActionPerformed
         
        JRParameter parameter = (JRParameter)jTableParameters.getValueAt( jTableParameters.getSelectedRow(), 0);
        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRParameterDialog jrpd = new JRParameterDialog(parent, true);
        jrpd.setParameter( parameter );
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            parameter.setName( jrpd.getParameter().getName() );
            parameter.setClassType( jrpd.getParameter().getClassType() );
            parameter.setDescription( jrpd.getParameter().getDescription() );
            parameter.setDefaultValueExpression( jrpd.getParameter().getDefaultValueExpression() );
            parameter.setIsForPrompting( jrpd.getParameter().isIsForPrompting() );
            this.updateParameters();
        }
    }//GEN-LAST:event_jButtonModifyParameterActionPerformed

    private void jButtonNewParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewParameterActionPerformed
        // create a new parameter....
        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRParameterDialog jrpd = new JRParameterDialog(parent, true);
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            JRParameter parameter = jrpd.getParameter();
            this.getJReportFrame().getReport().addParameter( parameter );
            this.updateParameters();
        }
        
    }//GEN-LAST:event_jButtonNewParameterActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new ValuesDialog(new javax.swing.JFrame(), true).show();
    }
    
    /** Getter for property jReportFrame.
     * @return Value of property jReportFrame.
     *
     */
    public it.businesslogic.ireport.gui.JReportFrame getJReportFrame() {
        return jReportFrame;
    }
    
    /** Setter for property jReportFrame.
     * @param jReportFrame New value of property jReportFrame.
     *
     */
    public void setJReportFrame(it.businesslogic.ireport.gui.JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        
        // Update all...
        if (jReportFrame == null) 
        {
            setVisible(false);
            return;
        }
        
        if (isVisible())
        {
            this.setTitle(jReportFrame.getReport().getName()+" values...");
            updateParameters();
            updateFields();
            updateVariables();
        }
    }
    
    public void updateParameters() {
        
        DefaultTableModel dtm = (DefaultTableModel)jTableParameters.getModel();
        dtm.setRowCount(0);
    
        Enumeration e = jReportFrame.getReport().getParameters().elements();
        while (e.hasMoreElements())
        {
            it.businesslogic.ireport.JRParameter parameter = (it.businesslogic.ireport.JRParameter)e.nextElement();
            Vector row = new Vector();
            row.addElement( parameter);
            row.addElement( parameter.getClassType());
            row.addElement( parameter.isIsForPrompting()+"");
            
            dtm.addRow(row);           
        }    
    }
    public void updateFields() {
    
        DefaultTableModel dtm = (DefaultTableModel)jTableFields.getModel();
        dtm.setRowCount(0);
    
        Enumeration e = jReportFrame.getReport().getFields().elements();
        while (e.hasMoreElements())
        {
            it.businesslogic.ireport.JRField field = (it.businesslogic.ireport.JRField)e.nextElement();
            Vector row = new Vector();
            row.addElement( field );
            row.addElement( field.getClassType()  );
            
            dtm.addRow(row);           
        }    
    
    
    }
    public void updateVariables() {
        DefaultTableModel dtm = (DefaultTableModel)jTableVariables.getModel();
        dtm.setRowCount(0);
    
        Enumeration e = jReportFrame.getReport().getVariables().elements();
        while (e.hasMoreElements())
        {
            it.businesslogic.ireport.JRVariable variable = (it.businesslogic.ireport.JRVariable)e.nextElement();
            Vector row = new Vector();
            row.addElement( variable);
            row.addElement( (variable.isBuiltin() ? "yes" : "no"));
            
            dtm.addRow(row);           
        }    
    }

    public void applyI18n(){
        jButtonNewField.setText(it.businesslogic.ireport.util.I18n.getString("new","New"));
        jButtonModifyField.setText(it.businesslogic.ireport.util.I18n.getString("modify","Modify"));
        jButtonDeleteField.setText(it.businesslogic.ireport.util.I18n.getString("delete","Delete"));
        jButtonNewVariable.setText(it.businesslogic.ireport.util.I18n.getString("new","New"));
        jButtonModifyVariable.setText(it.businesslogic.ireport.util.I18n.getString("modify","Modify"));
        jButtonDeleteVariable.setText(it.businesslogic.ireport.util.I18n.getString("delete","Delete"));
        jButtonNewParameter.setText(it.businesslogic.ireport.util.I18n.getString("new","New"));
        jButtonModifyParameter.setText(it.businesslogic.ireport.util.I18n.getString("modify","Modify"));
        jButtonDeleteParameter.setText(it.businesslogic.ireport.util.I18n.getString("delete","Delete"));
    }    
    public void languageChanged(LanguageChangedEvent evt) {
            
        this.applyI18n();
    }
       
        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.JButton jButtonDeleteField;
        private javax.swing.JButton jButtonDeleteParameter;
        private javax.swing.JButton jButtonDeleteVariable;
        private javax.swing.JButton jButtonModifyField;
        private javax.swing.JButton jButtonModifyParameter;
        private javax.swing.JButton jButtonModifyVariable;
        private javax.swing.JButton jButtonNewField;
        private javax.swing.JButton jButtonNewParameter;
        private javax.swing.JButton jButtonNewVariable;
        private javax.swing.JPanel jPanelButtons;
        private javax.swing.JPanel jPanelButtons1;
        private javax.swing.JPanel jPanelButtons2;
        private javax.swing.JPanel jPanelFields;
        private javax.swing.JPanel jPanelParameters;
        private javax.swing.JPanel jPanelVariables;
        private javax.swing.JScrollPane jScrollPane1;
        private javax.swing.JScrollPane jScrollPane2;
        private javax.swing.JScrollPane jScrollPane3;
        private javax.swing.JTabbedPane jTabbedPane;
        private it.businesslogic.ireport.gui.JDragTable jTableFields;
        private it.businesslogic.ireport.gui.JDragTable jTableParameters;
        private it.businesslogic.ireport.gui.JDragTable jTableVariables;
        // End of variables declaration//GEN-END:variables

    private JReportFrame jReportFrame;    

    public void setVisible(boolean visible)
    {
        if (visible == isVisible()) return;
        super.setVisible(visible);
        if (visible == true) 
        {
            this.setJReportFrame(jReportFrame);
        }
    }
    
    public void modifyParameter(it.businesslogic.ireport.JRParameter p)
    {
        // 1. Switch to parameters panel.
        this.jTabbedPane.setSelectedComponent( jPanelParameters );
        // 2. Fine the parameter and select it
        DefaultTableModel dtm = (DefaultTableModel)jTableParameters.getModel();
        for (int i=0; i<dtm.getRowCount(); ++i)
        {
            if (dtm.getValueAt(i, 0) == p)
            {
                jTableParameters.setRowSelectionInterval(i,i);
                this.jButtonModifyParameterActionPerformed(new java.awt.event.ActionEvent(jButtonModifyParameter,0,jButtonModifyParameter.getName()));
                return;
            }
        }
    }
    
    
    public void gotoTab(String tab)
    {
        if (tab.equals("Parameters"))
        {
            this.jTabbedPane.setSelectedIndex(2);
        }
        else if (tab.equals("Fields"))
        {
            this.jTabbedPane.setSelectedIndex(0);
        }
        else if (tab.equals("Variables"))
        {
            this.jTabbedPane.setSelectedIndex(1);
        }
    }
}
