/*
 * JRParameterDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 9 maggio 2003, 17.25
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.*;
/**
 *
 * @author  Administrator
 */
public class JRParameterDialog extends javax.swing.JDialog {
    /** Creates new form JRParameterDialog */
    JRParameter tmpParameter = null;
    
    public JRParameterDialog(java.awt.Frame parent, boolean modal) {
        
        super(parent, modal);
        initComponents();
        this.jRTextExpressionAreaDefaultExpression.setText("");
        setClassTypes();               
        this.jComboBoxType.setSelectedItem("java.lang.String");
        jComboBoxType.setEditable(true);
    }
    
    public void setClassTypes()
    {
        this.jComboBoxType.addItem("java.lang.String");
        this.jComboBoxType.addItem("java.lang.Object");
        this.jComboBoxType.addItem("java.lang.Boolean");
        this.jComboBoxType.addItem("java.lang.Byte");
        this.jComboBoxType.addItem("java.util.Date");
        this.jComboBoxType.addItem("java.sql.Timestamp");
        this.jComboBoxType.addItem("java.sql.Time");
        this.jComboBoxType.addItem("java.lang.Double");
        this.jComboBoxType.addItem("java.lang.Float");
        this.jComboBoxType.addItem("java.lang.Integer");
        this.jComboBoxType.addItem("java.io.InputStream");
        this.jComboBoxType.addItem("java.lang.Long");
        this.jComboBoxType.addItem("java.lang.Short");
        this.jComboBoxType.addItem("java.math.BigDecimal");
        this.jComboBoxType.addItem("dori.jasper.engine.JREmptyDataSource");
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
        private void initComponents() {//GEN-BEGIN:initComponents
                java.awt.GridBagConstraints gridBagConstraints;

                jLabel1 = new javax.swing.JLabel();
                jTextFieldName = new javax.swing.JTextField();
                jLabel2 = new javax.swing.JLabel();
                jComboBoxType = new javax.swing.JComboBox();
                jCheckBoxIsForPrompting = new javax.swing.JCheckBox();
                jLabel3 = new javax.swing.JLabel();
                jLabel4 = new javax.swing.JLabel();
                jScrollPane1 = new javax.swing.JScrollPane();
                jTextAreaDescription = new javax.swing.JTextArea();
                jRTextExpressionAreaDefaultExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
                jPanel1 = new javax.swing.JPanel();
                jButtonOK = new javax.swing.JButton();
                jButtonCancel = new javax.swing.JButton();

                getContentPane().setLayout(new java.awt.GridBagLayout());

                setTitle("Add/modify parameter");
                setResizable(false);
                setModal(true);
                addWindowListener(new java.awt.event.WindowAdapter() {
                        public void windowClosing(java.awt.event.WindowEvent evt) {
                                closeDialog(evt);
                        }
                });

                jLabel1.setText("Parameter name");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                getContentPane().add(jLabel1, gridBagConstraints);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                getContentPane().add(jTextFieldName, gridBagConstraints);

                jLabel2.setText("Parameter class type");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                getContentPane().add(jLabel2, gridBagConstraints);

                jComboBoxType.setEditable(true);
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                getContentPane().add(jComboBoxType, gridBagConstraints);

                jCheckBoxIsForPrompting.setText("Is for prompting");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                getContentPane().add(jCheckBoxIsForPrompting, gridBagConstraints);

                jLabel3.setText("Default value expression");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                getContentPane().add(jLabel3, gridBagConstraints);

                jLabel4.setText("Parameter description");
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 7;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                getContentPane().add(jLabel4, gridBagConstraints);

                jScrollPane1.setViewportView(jTextAreaDescription);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 8;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                getContentPane().add(jScrollPane1, gridBagConstraints);

                jRTextExpressionAreaDefaultExpression.setBorder(new javax.swing.border.EtchedBorder());
                jRTextExpressionAreaDefaultExpression.setPreferredSize(new java.awt.Dimension(310, 60));
                jRTextExpressionAreaDefaultExpression.setMinimumSize(new java.awt.Dimension(0, 0));
                jRTextExpressionAreaDefaultExpression.setElectricScroll(0);
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
                gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                getContentPane().add(jRTextExpressionAreaDefaultExpression, gridBagConstraints);

                jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

                jButtonOK.setText("OK");
                jButtonOK.setMnemonic('o');
                jButtonOK.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonOKActionPerformed(evt);
                        }
                });

                jPanel1.add(jButtonOK);

                jButtonCancel.setText("Cancel");
                jButtonCancel.setMnemonic('c');
                jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonCancelActionPerformed(evt);
                        }
                });

                jPanel1.add(jButtonCancel);

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 9;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
                getContentPane().add(jPanel1, gridBagConstraints);

                pack();
                java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
                java.awt.Dimension dialogSize = getSize();
                setLocation((screenSize.width-dialogSize.width)/2,(screenSize.height-dialogSize.height)/2);
        }//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
         if (this.jTextFieldName.getText().trim().length() <= 0)
        {
            javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid parameter name!","Invalid parameter!",javax.swing.JOptionPane.WARNING_MESSAGE );
            return;
        }
        
        tmpParameter = new JRParameter( this.jTextFieldName.getText(), "java.lang.String",
                                        this.jCheckBoxIsForPrompting.isSelected(),
                                        this.jTextAreaDescription.getText());
        if (this.jComboBoxType.getSelectedItem().toString().trim().length() != 0)
        {
            tmpParameter.setClassType( this.jComboBoxType.getSelectedItem().toString().trim() );
        }
        tmpParameter.setDefaultValueExpression( jRTextExpressionAreaDefaultExpression.getText());

        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /** Getter for property tmpParameter.
     * @return Value of property tmpParameter.
     *
     */
    public it.businesslogic.ireport.JRParameter getParameter() {
        return tmpParameter;
    }    
    
    /** Setter for property tmpParameter.
     * @param tmpParameter New value of property tmpParameter.
     *
     */
    public void setParameter(it.businesslogic.ireport.JRParameter tmpParameter) {
        this.jTextFieldName.setText( new String(tmpParameter.getName()));
        this.jComboBoxType.setSelectedItem( new String(tmpParameter.getClassType()));
        this.jCheckBoxIsForPrompting.setSelected( tmpParameter.isIsForPrompting() );
        this.jTextAreaDescription.setText( new String(tmpParameter.getDescription()));
        this.jRTextExpressionAreaDefaultExpression.setText( new String(tmpParameter.getDefaultValueExpression()));                       
    }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
        return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.JButton jButtonCancel;
        private javax.swing.JButton jButtonOK;
        private javax.swing.JCheckBox jCheckBoxIsForPrompting;
        private javax.swing.JComboBox jComboBoxType;
        private javax.swing.JLabel jLabel1;
        private javax.swing.JLabel jLabel2;
        private javax.swing.JLabel jLabel3;
        private javax.swing.JLabel jLabel4;
        private javax.swing.JPanel jPanel1;
        private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaDefaultExpression;
        private javax.swing.JScrollPane jScrollPane1;
        private javax.swing.JTextArea jTextAreaDescription;
        private javax.swing.JTextField jTextFieldName;
        // End of variables declaration//GEN-END:variables

    private int dialogResult;    
    
}
