package it.businesslogic.ireport.examples;

import it.businesslogic.ireport.connection.JRXMLDataSource;
import dori.jasper.engine.export.JRPdfExporter;

import dori.jasper.engine.*;
import java.util.HashMap;


public class XMLDataSourceExample {

    public static void main(String[] args) throws Exception {

      		String reportFileName = "/addressbook.jasper";
		String outFileName = "/addressbook.pdf";
                String xmlFileName = "/addressbook.xml";
                String recordPath = "/addressbook/category/person";
                
                JRXMLDataSource jrxmlds = new JRXMLDataSource(xmlFileName,recordPath);
                
		HashMap hm = new HashMap();
		
		try
		{
			JasperPrint print = JasperFillManager.fillReport(
						reportFileName, 
						hm, 
						jrxmlds);
			
			JRExporter exporter = new dori.jasper.engine.export.JRPdfExporter();
			
			exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME,outFileName);
                  	exporter.setParameter(JRExporterParameter.JASPER_PRINT,print);
                  	
                  	exporter.exportReport();
                  	System.out.println("Created file: " + outFileName);				
		}
		catch (JRException e)
		{
			e.printStackTrace();
			System.exit(1);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.exit(1);
		}

    }

}


