/*
 * JDBCConnection.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 4 giugno 2003, 18.15
 */

package it.businesslogic.ireport.connection;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.util.*;
import java.sql.*;
import javax.swing.*;
/**
 *
 * @author  Administrator
 */
public class JDBCConnection extends it.businesslogic.ireport.IReportConnection {
    
    private String JDBCDriver;
    
    private String username;
    
    private String password = null;
    
    private String url;
    
    private String database;
    
    private boolean savePassword;
    
    private String name;
    
    /**
     * Holds value of property serverAddress.
     */
    private String serverAddress;
    
    /** Creates a new instance of JDBCConnection */
    
    
    public JDBCConnection() {
    }
    
    /**  This method return an instanced connection to the database.
     *  If isJDBCConnection() return false => getConnection() return null
     *
     */
    public java.sql.Connection getConnection() {
        
            // Try the java connection...
            try {
                
                    it.businesslogic.ireport.gui.MainFrame.getMainInstance().getReportClassLoader().rescanLibDirectory();
                    DriverPool.registerDriver( this.getJDBCDriver(), it.businesslogic.ireport.gui.MainFrame.getMainInstance().getReportClassLoader() );
                    java.sql.Driver driver = DriverPool.getDriver( url );
                    
                    java.util.Properties connectProps = new java.util.Properties();
                    
                    if ((password == null || password.equals("") ) && !isSavePassword())
                    {
                        password = getPassword();
                    }
                    
                    connectProps.setProperty("user", username);
                    connectProps.setProperty("password", password);
                    
                    Connection conn = driver.connect( url, connectProps); 
                    
                    return conn;
			
            }catch (NoClassDefFoundError ex)
		{
			JOptionPane.showMessageDialog(null,this.getName() + "\nNoClassDefFoundError!!\nCheck your classpath!\n"+ex.getMessage() ,"Error",JOptionPane.ERROR_MESSAGE);
			return null;					
		} 
		catch (ClassNotFoundException ex)
		{
			JOptionPane.showMessageDialog(null,this.getName() + "\nClassNotFoundError!\nMsg:"+ ex.getMessage() +"\nPossible not found class:"+ this.getJDBCDriver()+"\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
			return null;				
		} 
		catch (java.sql.SQLException ex)
		{
			JOptionPane.showMessageDialog(null,this.getName() + "\nSQL problems:\n"+ex.getMessage()+"\n"+url ,"Error",JOptionPane.ERROR_MESSAGE);
			return null;					
		} 
		catch (Exception ex)
			{
			JOptionPane.showMessageDialog(null,this.getName() + "\nGeneral problem:\n"+ex.getMessage()+"\n\nPlease check your username and password. The DBMS is running?!","Error",JOptionPane.ERROR_MESSAGE);
			return null;					
		}
    }    
    /*  This method return an instanced JRDataDource to the database.
     *  If isJDBCConnection() return true => getJRDataSource() return false
     *
     */
    public dori.jasper.engine.JRDataSource getJRDataSource() {
        return  new dori.jasper.engine.JREmptyDataSource();
    }
    
    public boolean isJDBCConnection() {
        return true;
    }
    
    /** Getter for property database.
     * @return Value of property database.
     *
     */
    public java.lang.String getDatabase() {
        return database;
    }
    
    /** Setter for property database.
     * @param database New value of property database.
     *
     */
    public void setDatabase(java.lang.String database) {
        this.database = database;
    }
    
    /** Getter for property JDBCDriver.
     * @return Value of property JDBCDriver.
     *
     */
    public java.lang.String getJDBCDriver() {
        return JDBCDriver;
    }
    
    /** Setter for property JDBCDriver.
     * @param JDBCDriver New value of property JDBCDriver.
     *
     */
    public void setJDBCDriver(java.lang.String JDBCDriver) {
        this.JDBCDriver = JDBCDriver;
    }
    
    /** Getter for property password.
     * @return Value of property password.
     *
     */
    public java.lang.String getPassword() {
        
        if (isSavePassword()) return password;
        else
        {
            // Ask for password...
            try {
            it.businesslogic.ireport.gui.PasswordDialog pd = new it.businesslogic.ireport.gui.PasswordDialog( it.businesslogic.ireport.gui.MainFrame.getMainInstance(), true);
            pd.show();
            return Misc.nvl(pd.getPassword(),"");
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }
    
    /** Setter for property password.
     * @param password New value of property password.
     *
     */
    public void setPassword(java.lang.String password) {
        this.password = password;
    }
    
    /** Getter for property savePassword.
     * @return Value of property savePassword.
     *
     */
    public boolean isSavePassword() {
        return savePassword;
    }
    
    /** Setter for property savePassword.
     * @param savePassword New value of property savePassword.
     *
     */
    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }
    
    /** Getter for property url.
     * @return Value of property url.
     *
     */
    public java.lang.String getUrl() {
        return url;
    }
    
    /** Setter for property url.
     * @param url New value of property url.
     *
     */
    public void setUrl(java.lang.String url) {
        this.url = url;
    }
    
    /** Getter for property username.
     * @return Value of property username.
     *
     */
    public java.lang.String getUsername() {
        return username;
    }
    
    /** Setter for property username.
     * @param username New value of property username.
     *
     */
    public void setUsername(java.lang.String username) {
        this.username = username;
    }
    
    /*
     *  This method return all properties used by this connection
     */
    public java.util.HashMap getProperties()
    {    
        java.util.HashMap map = new java.util.HashMap();
        map.put("JDBCDriver", Misc.nvl(this.getJDBCDriver(),"") );
        map.put("Url", Misc.nvl(this.getUrl(),""));
        map.put("Database", Misc.nvl(this.getDatabase(),""));
        map.put("Username", Misc.nvl(this.getUsername(),""));
        if (this.isSavePassword())
            map.put("Password", Misc.nvl(this.getPassword(),""));
        else map.put("Password","");
        map.put("SavePassword", ""+this.isSavePassword());
        map.put("ServerAddress", Misc.nvl(this.getServerAddress(),"") );
        
        return map;
    }
    
    public void loadProperties(java.util.HashMap map)
    {
        this.setJDBCDriver( (String)map.get("JDBCDriver"));
        this.setUrl( (String)map.get("Url"));
        this.setDatabase( (String)map.get("Database"));
        this.setUsername( (String)map.get("Username"));
        this.setSavePassword(  (""+map.get("SavePassword")).equals("true") );
        if (this.isSavePassword())
            this.setPassword( Misc.nvl((String)map.get("Password"),""));
        this.setServerAddress( Misc.nvl((String)map.get("ServerAddress"),"") );
        
    }
    
    public String getDescription(){ return "Database JDBC Connection ("+ this.getUrl() +")"; }
    
    /**
     * Getter for property serverAddress.
     * @return Value of property serverAddress.
     */
    public String getServerAddress() {
        return this.serverAddress;
    }
    
    /**
     * Setter for property serverAddress.
     * @param serverAddress New value of property serverAddress.
     */
    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }
    
}
